package com.example.demo.util;

import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;

/**
 * The type File upload util.
 */
public class FileUploadUtil {

    private static final String UPLOADS = "uploads";

    /**
     * Save file string.
     *
     * @param fileName      the file name
     * @param multipartFile the multipart file
     * @return the string
     * @throws IOException the io exception
     */
    public static String saveFile(String fileName, MultipartFile multipartFile)
            throws IOException {
        Path uploadPath = Paths.get(UPLOADS);

        if (!Files.exists(uploadPath)) {
            Files.createDirectories(uploadPath);
        }

        String fileCode = RandomStringUtils.randomAlphanumeric(8);
        try (InputStream inputStream = multipartFile.getInputStream()) {
            Path filePath = uploadPath.resolve(fileCode + "-" + fileName);
            Files.copy(inputStream, filePath, StandardCopyOption.REPLACE_EXISTING);
        } catch (IOException ioe) {
            throw new IOException("COULD_NOT_SAVE_FILE: " + fileName, ioe);
        }
        return fileCode;
    }
}
