package com.jcg.example;

import java.util.HashSet;

public class HashSetUniqueCharChecker {

    public static boolean hasAllUniqueCharacters(String str) {
        HashSet<Character> charSet = new HashSet<>();

        for (char c : str.toCharArray()) {
            if (charSet.contains(c)) {
                return false; // Found a duplicate character
            }
            charSet.add(c); // Add character to the set
        }
        return true; // No duplicates found
    }

    public static void main(String[] args) {
        String testStr1 = "abcdef";
        String testStr2 = "hello";

        System.out.println(testStr1 + " has all unique characters: " + hasAllUniqueCharacters(testStr1));
        System.out.println(testStr2 + " has all unique characters: " + hasAllUniqueCharacters(testStr2));
    }
}
