package com.jcg.example;

class Order {
    private Customer customer;

    public Order(Customer customer) {
        this.customer = customer;
    }

    public Customer getCustomer() {
        return customer;
    }
}

class Customer {
    private String name;

    public Customer(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }
}

public class Main {
    public static void main(String[] args) {
        Customer customer = new Customer("Alice");
        Order order = new Order(customer);

        // Following the Law of Demeter:
        String customerName = order.getCustomer().getName();
        System.out.println("Customer name: " + customerName);
    }
}
