package com.example.controller;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/users")
public class UserController {

    // curl -X GET "http://localhost:9300/users/<user_id>"
    @GetMapping("/{userId}")
    public ResponseEntity<String> getUserById(@PathVariable Long userId) {
        // Fetch user information using userId
        return ResponseEntity.ok("User information for ID: " + userId);
    }

    // curl -X GET "http://localhost:9300/users/search?query=<query_string>"
    // curl -X GET "http://localhost:9300/users/search"
    @GetMapping("/search")
    public ResponseEntity<String> searchUser(@RequestParam(required = false, defaultValue = "default") String query) {
        // Check if a specific query was provided
        if ("default".equals(query)) {
            // If no specific query provided, perform default search
            return ResponseEntity.ok("No specific query provided. Performing default search.");
        } else {
            // Perform search operation using the provided query
            return ResponseEntity.ok("Searching for: " + query);
        }
    }
}
