package com.example.chatgptapi.controller;

import com.example.chatgptapi.dto.ChatGptRequest;
import com.example.chatgptapi.dto.ChatGptResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@RestController
@RequestMapping("/api/chatgpt")
public class ApiController {

    @Autowired
    private RestTemplate template;

    /*
    curl 'http://localhost:4433/api/chatgpt/chat?prompt=What%20is%20spring%20framework' -H 'Content-Type: application/json'
     */
    @GetMapping("/chat")
    public String chat(@RequestParam("prompt") String prompt) {
        ChatGptRequest request = new ChatGptRequest("gpt-3.5-turbo", prompt);
        try {
            ChatGptResponse response = template.postForObject(
                    "https://api.openai.com/v1/completions", request, ChatGptResponse.class);
            return response.getChoices().get(0).getMessage().getContent();
        } catch (Exception e) {
            return e.getMessage();
        }
    }
}
