package com.example.springwebclientdemo.controller;

import com.example.springwebclientdemo.service.Apiservice;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value = "/api")
public class Apicontroller {

    private final Apiservice apiservice;

    @Autowired
    public Apicontroller(Apiservice service) {
        this.apiservice = service;
    }

    // curl -X POST -H "Content-Type: application/json" -d '{"name":"hello-world"}' http://localhost:8500/api/send-data
    @PostMapping(value = "/send-data")
    public String postData(@RequestBody String request) {
        String apiUrl = "https://jsonplaceholder.typicode.com/posts";   // Sample API endpoint. You're free to change it as per your wish.
        return apiservice.postDataToApi(apiUrl, request);
    }

    // curl -X POST -H "Content-Type: multipart/form-data" -F "file=@/path/to/your/file.txt" -F "fileName=file.txt" http://localhost:8500/api/files/upload
    @PostMapping("/upload")
    public Mono<String> uploadFile(@RequestParam("file") byte[] fileBytes,
                                   @RequestParam("fileName") String fileName) {
        String apiUrl = "http://example.com/upload";    // Sample API endpoint. You're free to change it as per your wish.
        return apiservice.uploadFile(apiUrl, fileBytes, fileName);
    }

    // curl -X POST "http://localhost:8080/api/data?param1=value1&param2=value2"
    @PostMapping("/api/data")
    public Mono<String> getDataWithParameters(@RequestParam("param1") String param1,
                                              @RequestParam("param2") String param2) {
        String apiUrl = "https://example.com";          // Sample API endpoint. You're free to change it as per your wish.
        return apiservice.postDataWithParameters(apiUrl, param1, param2);
    }
}
