package com.example.springwebclientdemo.service;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.client.MultipartBodyBuilder;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

@Service
public class Apiservice {

    private final WebClient.Builder webBuilder;

    @Autowired
    public Apiservice(WebClient.Builder builder) {
        this.webBuilder = builder;
    }

    public String postDataToApi(String apiUrl, String request) {
        return webBuilder.build()
                .post()
                .uri(apiUrl)
                .body(BodyInserters.fromValue(request))
                .retrieve()
                .bodyToMono(String.class)
                .block();
    }

    public Mono<String> uploadFile(String apiUrl, byte[] fileBytes, String fileName) {
        // Build the multipart request body
        MultipartBodyBuilder bodyBuilder = new MultipartBodyBuilder();
        bodyBuilder.part("file", fileBytes)
                .header("Content-Disposition", "form-data; name=file; filename=" + fileName);

        // Make the multipart file upload request using WebClient
        return webBuilder.build()
                .post()
                .uri(apiUrl)
                .body(BodyInserters.fromMultipartData(bodyBuilder.build()))
                .retrieve()
                .bodyToMono(String.class);
    }

    public Mono<String> postDataWithParameters(String apiUrl, String param1, String param2) {
        return webBuilder
                .baseUrl(apiUrl)
                .build()
                .post()
                .uri(uriBuilder -> uriBuilder
                        .path("/endpoint") // Specify the endpoint path
                        .queryParam("param1", param1) // Add query parameters
                        .queryParam("param2", param2)
                        .build())
                .retrieve()
                .bodyToMono(String.class);
    }
}
