/*
 * Click nbfs://nbhost/SystemFileSystem/Templates/Licenses/license-default.txt to change this license
 */
package com.jcg.executesqlscriptwithmybatis;

import java.io.Reader;
import java.sql.Connection;
import java.sql.DriverManager;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.jdbc.ScriptRunner;

/**
 *
 * @author omozegieaziegbe
 */
public class ExecuteSQLScriptWithMyBatis {

    public static void main(String[] args) throws Exception {

        //Register the Driver
        Class.forName("com.mysql.cj.jdbc.Driver");

        // Establish a MySQL database connection
        String jdbcUrl = "jdbc:mysql://localhost:3306/studentDatabase";
        String username = "username";
        String password = "password";
        Connection connection = DriverManager.getConnection(jdbcUrl, username, password);
        System.out.println("Connection Established......");

        // Create a ScriptRunner instance
        ScriptRunner scriptRunner = new ScriptRunner(connection);

        // Set the delimiter to define the end of a statement (default is ';')
        scriptRunner.setDelimiter(";");

        // Read and execute the SQL script
        Reader scriptReader = Resources.getResourceAsReader("students-script.sql");
        scriptRunner.runScript(scriptReader);

        // Close the resources
        scriptReader.close();
        connection.close();

    }
}
