package com.jcg.rotationexample;

import javafx.util.Duration;
import javafx.animation.RotateTransition;
import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.stage.Stage;


/**
 * JavaFX RotationExample
 */
public class RotationExample extends Application {

    @Override
    public void start(Stage stage) {
        Rectangle rectangle = new Rectangle(300, 150, Color.GREEN);
        Rectangle rotated_rectangle = new Rectangle(300, 150, Color.BLUE);

        // Applying rotation
        RotateTransition rotateTransition = new RotateTransition(Duration.seconds(2), rotated_rectangle);
        rotateTransition.setByAngle(360);
        rotateTransition.setCycleCount(RotateTransition.INDEFINITE);
        rotateTransition.play();

        StackPane root = new StackPane();
        root.getChildren().add(rectangle);
        root.getChildren().add(rotated_rectangle);
        Scene scene = new Scene(root, 600, 400);

        stage.setTitle("Rotation Example");
        stage.setScene(scene);
        stage.show();
    }

    public static void main(String[] args) {
        launch(args);
    }
}