package com.jcg.scalingexample;

import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.stage.Stage;


/**
 * JavaFX ScalingExample
 */
public class ScalingExample extends Application {

    @Override
    public void start(Stage stage) {
        Rectangle rectangle = new Rectangle(200, 100, Color.RED);
        Rectangle scaled_rectangle = new Rectangle(200, 100, Color.BLUE);

        // Applying scaling
        scaled_rectangle.setScaleX(2);
        scaled_rectangle.setScaleY(2);

        StackPane root = new StackPane();
        root.getChildren().add(scaled_rectangle);
        root.getChildren().add(rectangle);
        Scene scene = new Scene(root, 600, 400);

        stage.setTitle("Scaling Example");
        stage.setScene(scene);
        stage.show();
    }

    public static void main(String[] args) {
        launch(args);
    }
}