package com.jcg.shearingexample;

import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.stage.Stage;
import javafx.scene.transform.Shear;


/**
 * JavaFX ShearingExample
 */
public class ShearingExample extends Application {

    @Override
    public void start(Stage stage) {
        Rectangle rectangle = new Rectangle(300, 150, Color.ORANGE);
        Rectangle sheared_rectangle = new Rectangle(300, 150, Color.DEEPSKYBLUE);

        // Applying shearing
        Shear shear = new Shear(0.5, -0.2);
        sheared_rectangle.getTransforms().addAll(shear);

        StackPane root = new StackPane();
        root.getChildren().add(rectangle);
        root.getChildren().add(sheared_rectangle);
        Scene scene = new Scene(root, 600, 400);

        stage.setTitle("Shearing Example");
        stage.setScene(scene);
        stage.show();
    }

    public static void main(String[] args) {
        launch(args);
    }
}