package com.jcg.translationexample;

import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.stage.Stage;


/**
 * JavaFX TranslationExample
 */
public class TranslationExample extends Application {

    @Override
    public void start(Stage stage) {
        Rectangle nontranslated_rectangle = new Rectangle(300, 150, Color.RED);
        Rectangle translated_rectangle = new Rectangle(300, 150, Color.BLUE);

        // Applying translation
        translated_rectangle.setTranslateX(100);
        translated_rectangle.setTranslateY(50);

        StackPane root = new StackPane();
        root.getChildren().add(nontranslated_rectangle);
        root.getChildren().add(translated_rectangle);
        Scene scene = new Scene(root, 600, 400);

        stage.setTitle("Translation Example");
        stage.setScene(scene);
        stage.show();
    }

    public static void main(String[] args) {
        launch(args);
    }
}