/*
 * Click nbfs://nbhost/SystemFileSystem/Templates/Licenses/license-default.txt to change this license
 * Click nbfs://nbhost/SystemFileSystem/Templates/Classes/Class.java to edit this template
 */
package com.jcg.parameterservletexample;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 *
 * @author omozegieaziegbe
 */
@WebServlet(name = "DisplayParametersServlet", urlPatterns = {"/displayparams"})
public class DisplayParametersServlet extends HttpServlet {

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {

        // Creating an instance of EnhancedRequestWrapper to sanitize and modify parameters
        EnhancedRequestWrapper enhancedRequest = new EnhancedRequestWrapper(req);

        // Retrieve parameters
        String newParamValue = enhancedRequest.getParameter("newParameter");
        String removedParamValue = enhancedRequest.getParameter("userInput");

        // Output the parameters
        resp.setContentType("text/plain");
        resp.getWriter().println("");
        resp.getWriter().println("Enhanced Request Parameters Example");
        resp.getWriter().write("New Parameter Value: " + newParamValue);
        resp.getWriter().println("");
        resp.getWriter().write("Removed Parameter Value: " + removedParamValue);
        resp.getWriter().println("");
    }
}
