/*
 * Click nbfs://nbhost/SystemFileSystem/Templates/Licenses/license-default.txt to change this license
 * Click nbfs://nbhost/SystemFileSystem/Templates/Classes/Class.java to edit this template
 */
package com.jcg.parameterservletexample;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

/**
 *
 * @author omozegieaziegbe
 */
public class EnhancedRequestWrapper extends HttpServletRequestWrapper {

    private final Map<String, String[]> modifiedParameters;

    public EnhancedRequestWrapper(HttpServletRequest request) {

        super(request);
        this.modifiedParameters = new HashMap<>(request.getParameterMap());

        // Adding a new parameter
        this.modifiedParameters.put("newParameter", new String[]{"javacodegeeks"});

        // Removing an existing parameter
        this.modifiedParameters.remove("userInput");

    }

    @Override
    public String getParameter(String name) {
        // Retrieve the parameter from the modified parameters
        String[] values = modifiedParameters.get(name);
        return (values != null && values.length > 0) ? values[0] : null;
    }

    @Override
    public Map<String, String[]> getParameterMap() {
        // Return an unmodifiable map to prevent modification
        return Collections.unmodifiableMap(modifiedParameters);
    }

    @Override
    public Enumeration<String> getParameterNames() {
        // Return enumeration of parameter names
        return Collections.enumeration(modifiedParameters.keySet());
    }

    @Override
    public String[] getParameterValues(String name) {
        // Retrieve the parameter values from the modified parameters
        return modifiedParameters.get(name);
    }
}
