/*
 * Click nbfs://nbhost/SystemFileSystem/Templates/Licenses/license-default.txt to change this license
 * Click nbfs://nbhost/SystemFileSystem/Templates/JSP_Servlet/Filter.java to edit this template
 */
package com.jcg.parameterservletexample;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;

/**
 *
 * @author omozegieaziegbe
 */
@WebFilter(filterName = "ParameterSettingFilter", urlPatterns = {"/*"})
public class ParameterSettingFilter implements Filter {

    private static final boolean debug = true;

    private FilterConfig filterConfig = null;

    public ParameterSettingFilter() {
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain)
            throws IOException, ServletException {

        
        HttpServletRequest enhancedRequest = new EnhancedRequestWrapper((HttpServletRequest) request);

        // Continue with the sanitized request chain
        chain.doFilter(enhancedRequest, response);
    }

    /**
     * Init method for this filter
     *
     * @param filterConfig
     */
    @Override
    public void init(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
        if (filterConfig != null) {
            if (debug) {
                log("ParameterSettingFilter:Initializing filter");
            }
        }
    }

    public void log(String msg) {
        filterConfig.getServletContext().log(msg);
    }
    
    @Override
    public void destroy(){
    
    }

}
