/*
 * Click nbfs://nbhost/SystemFileSystem/Templates/Licenses/license-default.txt to change this license
 * Click nbfs://nbhost/SystemFileSystem/Templates/Classes/Class.java to edit this template
 */
package com.jcg.parameterservletexample;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

/**
 *
 * @author omozegieaziegbe
 */
public class SanitizedRequestWrapper extends HttpServletRequestWrapper {

    public SanitizedRequestWrapper(HttpServletRequest request) {
        super(request);
    }

    @Override
    public String getParameter(String name) {
        // Override the getParameter method to sanitize parameter values
        String originalValue = super.getParameter(name);
        return sanitize(originalValue);
    }

    @Override
    public Map<String, String[]> getParameterMap() {
        // Override getParameterMap to sanitize all parameter values
        return super.getParameterMap().entrySet().stream()
                .collect(Collectors.toMap(Map.Entry::getKey, entry -> sanitize(entry.getValue())));
    }

    private String[] sanitize(String[] values) {
        // Sanitize each value in the array
        return Arrays.stream(values).map(this::sanitize).toArray(String[]::new);
    }

    private String sanitize(String value) {
        // Implement your sanitization logic here
        // For simplicity, let's say we're removing any digits from the parameter values
        return value.replaceAll("\\d", "");
    }
}
