package com.jcg.stringcomparisonexample;

import java.util.List;

/**
 *
 * @author omozegieaziegbe
 */
public class StringComparisonExample {

//    public static boolean containsIgnoreCase(List<String> list, String searchString) {
//        for (String str : list) {
//            if (str.equalsIgnoreCase(searchString)) {
//                return true;
//            }
//        }
//        return false;
//    }
//    public static boolean containsIgnoreCase(List<String> list, String searchString) {
//        for (String str : list) {
//            if (str.toLowerCase().equals(searchString.toLowerCase())) {
//                return true;
//            }
//        }
//        return false;
//    }
    public static boolean containsIgnoreCase(List<String> list, String element) {
        return list.stream()
                .anyMatch(str -> str.equalsIgnoreCase(element));
    }

    public static void main(String[] args) {

        List<String> list = List.of("Avocado", "Pumpkin", "Spinach", "Asparagus");

        String searchString = "PussmPKin";

        if (containsIgnoreCase(list, searchString)) {
            System.out.println("List contains the string \"" + searchString + "\" ignoring case.");
        } else {
            System.out.println("List does not contain the string \"" + searchString + "\" ignoring case.");
        }
    }
}
