package com.jcg.codesnippetexamples;

import java.util.ArrayList;


/**
 * This code demonstrates the usage of the @replace tag in Java documentation.
 *
 * {@snippet :
 * 
 *      ArrayList<String> list = new ArrayList<>(); 
 *      list.add("pumpkin"); // @highlight @replace regex='".*"' replacement='"avocados"'
 *      list.add("cucumber"); 
 *      list.add("lettuce"); 
 * 
 *      list.remove("cucumber"); 
 * 
 *      for (String item : list) {
            System.out.println(item); // @link substring="System.out" target="System#out"
        }
 * }
 * 
 */
public class ArrayListExample {

    /**
     * Adds elements to an ArrayList.
     * {@snippet :
     * public static void addElement() {
     * 
     *       ArrayList<String> list = new ArrayList<>();
     * 
     *       list.add("lettuce");
     *       list.add("cucumber");
     *       list.add("pumpkin");
     * }
     * }
     */
    public static void addElements() {
        // Create a new ArrayList
        ArrayList<String> list = new ArrayList<>();

        // Add elements
        list.add("pumpkin");
        list.add("cucumber");
        list.add("lettuce");

        // Print elements
        for (String item : list) {
            System.out.println(item); 
        }
    }

    /**
     * Removes an element from the ArrayList.
     * {@snippet :
     * public static void removeElement() {
     * 
     *       ArrayList<String> list = new ArrayList<>();
     * 
     *       list.add("lettuce");
     *       list.add("cucumber");
     *       list.add("pumpkin");
     * 
     *       list.remove("cucumber"); // @link substring="list.remove" target="ArrayList#remove(Object)"
     * }
     * }
     */
    public static void removeElement() {
        // Create a new ArrayList
        ArrayList<String> list = new ArrayList<>();

        // Add elements
        list.add("lettuce");
        list.add("cucumber");
        list.add("pumpkin");

        // Remove an element
        list.remove("cucumber");

        // Print elements
        for (String item : list) {
            System.out.println(item);
        }
    }
}
