/*
 * Click nbfs://nbhost/SystemFileSystem/Templates/Licenses/license-default.txt to change this license
 */
package com.jcg.stringtoletters;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 *
 * @author omozegieaziegbe
 */
public class StringToLetters {

    public static String unicodeToString(String unicodeString) {

        Pattern pattern = Pattern.compile("\\\\u[0-9a-fA-F]{4}");
        Matcher matcher = pattern.matcher(unicodeString);
        StringBuilder builder = new StringBuilder();
        while (matcher.find()) {
            String unicodeSequence = matcher.group();
            char unicode = (char) Integer.parseInt(unicodeSequence.substring(2), 16);
            matcher.appendReplacement(builder, Character.toString(unicode));
        }
        matcher.appendTail(builder);
        return builder.toString();
    }

    public static String unicodeToStrings(String unicodeString) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < unicodeString.length(); i++) {
            char c = unicodeString.charAt(i);
            if (Character.isLetter(c)) {
                builder.append(c);
            } else if (Character.isWhitespace(c)) {
                builder.append(' ');
            }
        }
        return builder.toString();
    }


    public static void main(String[] args) {

        String unicodeString = "\u0048\u0065\u006C\u006C\u006F \u0057\u006F\u0072\u006C\u0064"; // Unicode encoded string: "Hello World"

        String letters = unicodeToString(unicodeString);

        String letter = unicodeToStrings(unicodeString);

        System.out.println(letters);
        System.out.println(letter);
    }

}
