---
name: Containers
title: Containers
description: Containers are a fundamental building block of CoreUI for Vue.js that contain, pad, and align your content within a given device or viewport.
---

## How they work

Containers are the most basic layout element in CoreUI for Vue.js and are **required when using our default grid system**. Containers are used to contain, pad, and (sometimes) center the content within them. While containers *can* be nested, most layouts do not require a nested container.

CoreUI for Vue.js comes with three different containers:

- `<CContainer>`, which sets a `max-width` at each responsive breakpoint
- `<CContainer fluid>`, which is `width: 100%` at all breakpoints
- `<CContainer {sm|md|lg|xl|xxl}>`, which is `width: 100%` until the specified breakpoint

The table below illustrates how each container's `max-width` compares to the original `<CContainer>` and `<CContainer fluid>` across each breakpoint.

<table class="table">
  <thead>
    <tr>
      <td class="border-dark"></td>
      <th scope="col">
        Extra small<br/>
        <span class="fw-normal">&lt;576px</span>
      </th>
      <th scope="col">
        Small<br/>
        <span class="fw-normal">&ge;576px</span>
      </th>
      <th scope="col">
        Medium<br/>
        <span class="fw-normal">&ge;768px</span>
      </th>
      <th scope="col">
        Large<br/>
        <span class="fw-normal">&ge;992px</span>
      </th>
      <th scope="col">
        X-Large<br/>
        <span class="fw-normal">&ge;1200px</span>
      </th>
      <th scope="col">
        XX-Large<br/>
        <span class="fw-normal">&ge;1400px</span>
      </th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <th scope="row" class="fw-normal"><code>&lt;CContainer&gt;</code></th>
      <td class="text-body-secondary">100%</td>
      <td>540px</td>
      <td>720px</td>
      <td>960px</td>
      <td>1140px</td>
      <td>1320px</td>
    </tr>
    <tr>
      <th scope="row" class="fw-normal"><code>&lt;CContainer sm&gt;</code></th>
      <td class="text-body-secondary">100%</td>
      <td>540px</td>
      <td>720px</td>
      <td>960px</td>
      <td>1140px</td>
      <td>1320px</td>
    </tr>
    <tr>
      <th scope="row" class="fw-normal"><code>&lt;CContainer md&gt;</code></th>
      <td class="text-body-secondary">100%</td>
      <td class="text-body-secondary">100%</td>
      <td>720px</td>
      <td>960px</td>
      <td>1140px</td>
      <td>1320px</td>
    </tr>
    <tr>
      <th scope="row" class="fw-normal"><code>&lt;CContainer lg&gt;</code></th>
      <td class="text-body-secondary">100%</td>
      <td class="text-body-secondary">100%</td>
      <td class="text-body-secondary">100%</td>
      <td>960px</td>
      <td>1140px</td>
      <td>1320px</td>
    </tr>
    <tr>
      <th scope="row" class="fw-normal"><code>&lt;CContainer xl&gt;</code></th>
      <td class="text-body-secondary">100%</td>
      <td class="text-body-secondary">100%</td>
      <td class="text-body-secondary">100%</td>
      <td class="text-body-secondary">100%</td>
      <td>1140px</td>
      <td>1320px</td>
    </tr>
    <tr>
      <th scope="row" class="fw-normal"><code>&lt;CContainer xxl&gt;</code></th>
      <td class="text-body-secondary">100%</td>
      <td class="text-body-secondary">100%</td>
      <td class="text-body-secondary">100%</td>
      <td class="text-body-secondary">100%</td>
      <td class="text-body-secondary">100%</td>
      <td>1320px</td>
    </tr>
    <tr>
      <th scope="row" class="fw-normal"><code>&lt;CContainer fluid&gt;</code></th>
      <td class="text-body-secondary">100%</td>
      <td class="text-body-secondary">100%</td>
      <td class="text-body-secondary">100%</td>
      <td class="text-body-secondary">100%</td>
      <td class="text-body-secondary">100%</td>
      <td class="text-body-secondary">100%</td>
    </tr>
  </tbody>
</table>

## Default container

Our default `<CContainer>` class is a responsive, fixed-width container, meaning its `max-width` changes at each breakpoint.

::: demo
<CContainer>
  Content here
</CContainer>
:::
```vue
<CContainer>
  Content here
</CContainer>
```

## Responsive containers

Responsive containers allow you to specify a class that is 100% wide until the specified breakpoint is reached, after which we apply `max-width`s for each of the higher breakpoints. For example, `<CContainer sm>` is 100% wide to start until the `sm` breakpoint is reached, where it will scale up with `md`, `lg`, `xl`, and `xxl`.

::: demo
<CContainer sm>100% wide until small breakpoint</CContainer>
<CContainer md>100% wide until medium breakpoint</CContainer>
<CContainer lg>100% wide until large breakpoint</CContainer>
<CContainer xl>100% wide until extra large breakpoint</CContainer>
<CContainer xxl>100% wide until extra extra large breakpoint</CContainer>
:::
```vue
<CContainer sm>100% wide until small breakpoint</CContainer>
<CContainer md>100% wide until medium breakpoint</CContainer>
<CContainer lg>100% wide until large breakpoint</CContainer>
<CContainer xl>100% wide until extra large breakpoint</CContainer>
<CContainer xxl>100% wide until extra extra large breakpoint</CContainer>
```

## Fluid containers

Use `<CContainer fluid>` for a full width container, spanning the entire width of the viewport.

::: demo
<CContainer fluid>
  Content here
</CContainer>
:::
```vue
<CContainer fluid>
  Content here
</CContainer>
```
## API

!!!include(./api/grid/CContainer.api.md)!!!