#!/bin/bash
# Bash helper functions for adding SSH keys

function add_ssh_keys {
    local key_string="${1}"
    mkdir -p ~/.ssh
    chmod 700 ~/.ssh
    echo -n "${key_string}" >~/.ssh/id_rsa_base64
    base64 --decode --ignore-garbage ~/.ssh/id_rsa_base64 >~/.ssh/id_rsa
    chmod 600 ~/.ssh/id_rsa
}

function add_doc_server_ssh_keys {
    local key_string="${1}"
    local server_url="${2}"
    local server_user="${3}"
    add_ssh_keys "${key_string}"
    echo -e "Host ${server_url}\n\tStrictHostKeyChecking no\n\tUser ${server_user}\n" >>~/.ssh/config
}
