![Contributors](https://img.shields.io/github/contributors/googlemaps-samples/codelab-maps-platform-101-ios-swiftui?color=green)
[![License](https://img.shields.io/github/license/googlemaps-samples/codelab-maps-platform-101-ios-swiftui?color=blue)][license]
[![StackOverflow](https://img.shields.io/stackexchange/stackoverflow/t/google-maps?color=orange&label=google-maps&logo=stackoverflow)](https://stackoverflow.com/questions/tagged/google-maps)
[![Discord](https://img.shields.io/discord/676948200904589322?color=6A7EC2&logo=discord&logoColor=ffffff)][Discord server]

# Using Maps SDK for iOS with SwiftUI codelab

![App screenhsot](screenshot.png)

## Description

This repository provides the accompanying starter and solution code for the [Add a map to your iOS app with SwiftUI (Swift)][codelab], a codelab that teaches you how to integrate the [Maps SDK for iOS][maps-sdk] with SwiftUI.

## Requirements

To run the samples, you will need:

- To [sign up with Google Maps Platform]
- A Google Maps Platform [project] with the **Maps SDK for iOS** enabled
- An [API key] associated with the project above ... follow the [API key instructions] if you're new to the process
- Swift and Xcode 11+
- (Deployment target of) iOS 11+
- [Carthage][carthage]

## Contributing

Contributions are welcome and encouraged! If you'd like to contribute, send us a [pull request] and refer to our [code of conduct] and [contributing guide].

## Terms of Service

This sample uses Google Maps Platform services. Use of Google Maps Platform services through this sample is subject to the Google Maps Platform [Terms of Service].

**European Economic Area (EEA) developers**

If your billing address is in the European Economic Area, effective on 8 July 2025, the [Google Maps Platform EEA Terms of Service](https://cloud.google.com/terms/maps-platform/eea) will apply to your use of the Services. Functionality varies by region. [Learn more](https://developers.google.com/maps/comms/eea/faq).

This sample is not a Google Maps Platform Core Service. Therefore, the Google Maps Platform Terms of Service (e.g. Technical Support Services, Service Level Agreements, and Deprecation Policy) do not apply to the code in this sample.

## Support

This sample is offered via an open source [license]. It is not governed by the Google Maps Platform Support [Technical Support Services Guidelines], the [SLA], or the [Deprecation Policy]. However, any Google Maps Platform services used by the sample remain subject to the Google Maps Platform Terms of Service.

If you find a bug, or have a feature request, please [file an issue] on GitHub. If you would like to get answers to technical questions from other Google Maps Platform developers, ask through one of our [developer community channels]. If you'd like to contribute, please check the [contributing guide].

You can also discuss this sample on our [Discord server].

[carthage]: https://github.com/Carthage/Carthage
[codelab]: https://developers.google.com/codelabs/maps-platform/maps-platform-ios-swiftui
[maps-sdk]: https://developers.google.com/maps/documentation/ios-sdk
[API key]: https://developers.google.com/maps/documentation/ios-sdk/get-api-key
[API key instructions]: https://developers.google.com/maps/documentation/ios-sdk/config#get-key

[code of conduct]: ?tab=coc-ov-file#readme
[contributing guide]: CONTRIBUTING.md
[Deprecation Policy]: https://cloud.google.com/maps-platform/terms
[developer community channels]: https://developers.google.com/maps/developer-community
[Discord server]: https://discord.gg/hYsWbmk
[file an issue]: https://github.com/googlemaps-samples/codelab-maps-platform-101-ios-swiftui/issues/new/choose
[license]: LICENSE
[pull request]: https://github.com/googlemaps-samples/codelab-maps-platform-101-ios-swiftui/compare
[project]: https://developers.google.com/maps/documentation/ios-sdk/cloud-setup#enabling-apis
[Sign up with Google Maps Platform]: https://console.cloud.google.com/google/maps-apis/start
[SLA]: https://cloud.google.com/maps-platform/terms/sla
[Technical Support Services Guidelines]: https://cloud.google.com/maps-platform/terms/tssg
[Terms of Service]: https://cloud.google.com/maps-platform/terms
