define(['auth/module'], function (module) {
    "use strict";

    return module.registerDirective('facebookSignin', function ($rootScope, ezfb) {
        return {
            replace: true,
            restrict: 'E',
            template: '<a class="btn btn-block btn-social btn-facebook"><i class="fa fa-facebook"></i> Sign in with Facebook</a>',
            link: function(scope, element){
                element.on('click', function(){
                    ezfb.login(function (res) {
                        if (res.authResponse) {
                            $rootScope.$broadcast('event:facebook-signin-success', res.authResponse);
                        }
                    }, {scope: 'public_profile'});
                })

            }
        }
    });
});
