define(['modules/graphs/module', 'morris'], function(module){

    "use strict";

    return module.registerDirective('morrisBarGraph', function(){
        return {
            restrict: 'E',
            replace: true,
            template: '<div class="chart no-padding"></div>',
            link: function(scope, element){
                Morris.Bar({
                    element : element,
                    data : [{
                        x : '2011 Q1',
                        y : 0
                    }, {
                        x : '2011 Q2',
                        y : 1
                    }, {
                        x : '2011 Q3',
                        y : 2
                    }, {
                        x : '2011 Q4',
                        y : 3
                    }, {
                        x : '2012 Q1',
                        y : 4
                    }, {
                        x : '2012 Q2',
                        y : 5
                    }, {
                        x : '2012 Q3',
                        y : 6
                    }, {
                        x : '2012 Q4',
                        y : 7
                    }, {
                        x : '2013 Q1',
                        y : 8
                    }],
                    xkey : 'x',
                    ykeys : ['y'],
                    labels : ['Y'],
                    barColors : function(row, series, type) {
                        if (type === 'bar') {
                            var red = Math.ceil(150 * row.y / this.ymax);
                            return 'rgb(' + red + ',0,0)';
                        } else {
                            return '#000';
                        }
                    }
                });

            }
        }
    })



});
