



var appConfig = {};

appConfig.menu_speed = 200;


appConfig.smartSkin = "smart-style-0";

appConfig.skins = [
    {name: "smart-style-0",
        logo: "styles/img/logo.png",
        class: "btn btn-block btn-xs txt-color-white margin-right-5",
        style: "background-color:#4E463F;",
        label: "Smart Default"},

    {name: "smart-style-1",
        logo: "styles/img/logo-white.png",
        class: "btn btn-block btn-xs txt-color-white",
        style: "background:#3A4558;",
        label: "Dark Elegance"},

    {name: "smart-style-2",
        logo: "styles/img/logo-blue.png",
        class: "btn btn-xs btn-block txt-color-darken margin-top-5",
        style: "background:#fff;",
        label: "Ultra Light"},

    {name: "smart-style-3",
        logo: "styles/img/logo-pale.png",
        class: "btn btn-xs btn-block txt-color-white margin-top-5",
        style: "background:#f78c40",
        label: "Google Skin"},

    {name: "smart-style-4",
        logo: "styles/img/logo-pale.png",
        class: "btn btn-xs btn-block txt-color-white margin-top-5",
        style: "background: #bbc0cf; border: 1px solid #59779E; color: #17273D !important;",
        label: "PixelSmash"},

    {name: "smart-style-5",
        logo: "styles/img/logo-pale.png",
        class: "btn btn-xs btn-block txt-color-white margin-top-5",
        style: "background: rgba(153, 179, 204, 0.2); border: 1px solid rgba(121, 161, 221, 0.8); color: #17273D !important;",
        label: "Glass"}
];



appConfig.sound_path = "sound/";
appConfig.sound_on = true; 


/*
* DEBUGGING MODE
* debugState = true; will spit all debuging message inside browser console.
* The colors are best displayed in chrome browser.
*/


appConfig.debugState = false;	
appConfig.debugStyle = 'font-weight: bold; color: #00f;';
appConfig.debugStyle_green = 'font-weight: bold; font-style:italic; color: #46C246;';
appConfig.debugStyle_red = 'font-weight: bold; color: #ed1c24;';
appConfig.debugStyle_warning = 'background-color:yellow';
appConfig.debugStyle_success = 'background-color:green; font-weight:bold; color:#fff;';
appConfig.debugStyle_error = 'background-color:#ed1c24; font-weight:bold; color:#fff;';


appConfig.voice_command = true;
appConfig.voice_command_auto = false;

/*
 *  Sets the language to the default 'en-US'. (supports over 50 languages 
 *  by google)
 * 
 *  Afrikaans         ['af-ZA']
 *  Bahasa Indonesia  ['id-ID']
 *  Bahasa Melayu     ['ms-MY']
 *  CatalГ            ['ca-ES']
 *  ДЊeЕЎtina         ['cs-CZ']
 *  Deutsch           ['de-DE']
 *  English           ['en-AU', 'Australia']
 *                    ['en-CA', 'Canada']
 *                    ['en-IN', 'India']
 *                    ['en-NZ', 'New Zealand']
 *                    ['en-ZA', 'South Africa']
 *                    ['en-GB', 'United Kingdom']
 *                    ['en-US', 'United States']
 *  EspaГ±ol          ['es-AR', 'Argentina']
 *                    ['es-BO', 'Bolivia']
 *                    ['es-CL', 'Chile']
 *                    ['es-CO', 'Colombia']
 *                    ['es-CR', 'Costa Rica']
 *                    ['es-EC', 'Ecuador']
 *                    ['es-SV', 'El Salvador']
 *                    ['es-ES', 'EspaГ±a']
 *                    ['es-US', 'Estados Unidos']
 *                    ['es-GT', 'Guatemala']
 *                    ['es-HN', 'Honduras']
 *                    ['es-MX', 'MГ©xico']
 *                    ['es-NI', 'Nicaragua']
 *                    ['es-PA', 'PanamГЎ']
 *                    ['es-PY', 'Paraguay']
 *                    ['es-PE', 'PerГє']
 *                    ['es-PR', 'Puerto Rico']
 *                    ['es-DO', 'RepГєblica Dominicana']
 *                    ['es-UY', 'Uruguay']
 *                    ['es-VE', 'Venezuela']
 *  Euskara           ['eu-ES']
 *  FranГ§ais         ['fr-FR']
 *  Galego            ['gl-ES']
 *  Hrvatski          ['hr_HR']
 *  IsiZulu           ['zu-ZA']
 *  ГЌslenska         ['is-IS']
 *  Italiano          ['it-IT', 'Italia']
 *                    ['it-CH', 'Svizzera']
 *  Magyar            ['hu-HU']
 *  Nederlands        ['nl-NL']
 *  Norsk bokmГҐl     ['nb-NO']
 *  Polski            ['pl-PL']
 *  PortuguГЄs        ['pt-BR', 'Brasil']
 *                    ['pt-PT', 'Portugal']
 *  RomГўnДѓ          ['ro-RO']
 *  SlovenДЌina       ['sk-SK']
 *  Suomi             ['fi-FI']
 *  Svenska           ['sv-SE']
 *  TГјrkГ§e          ['tr-TR']
 *  Р±СЉР»РіР°СЂСЃРєРё['bg-BG']
 *  PСѓСЃСЃРєРёР№     ['ru-RU']
 *  РЎСЂРїСЃРєРё      ['sr-RS']
 *  н•њкµ­м–ґ         ['ko-KR']
 *  дё­ж–‡            ['cmn-Hans-CN', 'ж™®йЂљиЇќ (дё­е›Ѕе¤§й™†)']
 *                    ['cmn-Hans-HK', 'ж™®йЂљиЇќ (й¦™жёЇ)']
 *                    ['cmn-Hant-TW', 'дё­ж–‡ (еЏ°зЃЈ)']
 *                    ['yue-Hant-HK', 'зІµиЄћ (й¦™жёЇ)']
 *  ж—Ґжњ¬иЄћ         ['ja-JP']
 *  Lingua latД«na    ['la']
 */
appConfig.voice_command_lang = 'en-US';
/*
 *  Use localstorage to remember on/off (best used with HTML Version)
 */ 
appConfig.voice_localStorage = false;
/*
 * Voice Commands
 * Defines all voice command variables and functions
 */ 
if (appConfig.voice_command) {
        
     	appConfig.commands = {
                
        'show dashboard' : function() { window.location.hash = "dashboard" },
        'show inbox' : function() {  window.location.hash = "inbox/" },
        'show graphs' : function() {  window.location.hash = "graphs/flot" },
        'show flotchart' : function() { window.location.hash = "graphs/flot" },
        'show morris chart' : function() { window.location.hash = "graphs/morris" },
        'show inline chart' : function() { window.location.hash = "graphs/inline-charts" },
        'show dygraphs' : function() { window.location.hash = "graphs/dygraphs" },
        'show tables' : function() { window.location.hash = "tables/table" },
        'show data table' : function() { window.location.hash = "tables/datatable" },
        'show jquery grid' : function() { window.location.hash = "tables/jqgrid" },
        'show form' : function() { window.location.hash = "forms/form-elements" },
        'show form layouts' : function() { window.location.hash = "forms/form-templates" },
        'show form validation' : function() { window.location.hash = "forms/validation" },
        'show form elements' : function() { window.location.hash = "forms/bootstrap-forms" },
        'show form plugins' : function() { window.location.hash = "forms/plugins" },
        'show form wizards' : function() { window.location.hash = "forms/wizards" },
        'show bootstrap editor' : function() { window.location.hash = "forms/other-editors" },
        'show dropzone' : function() { window.location.hash = "forms/dropzone" },
        'show image cropping' : function() { window.location.hash = "forms/image-editor" },
        'show general elements' : function() { window.location.hash = "ui/general-elements" },
        'show buttons' : function() { window.location.hash = "ui/buttons" },
        'show fontawesome' : function() { window.location.hash = "ui/icons/fa" },
        'show glyph icons' : function() { window.location.hash = "ui/icons/glyph" },
        'show flags' : function() { window.location.hash = "ui/icons/flags" },
        'show grid' : function() { window.location.hash = "ui/grid" },
        'show tree view' : function() { window.location.hash = "ui/treeview" },
        'show nestable lists' : function() { window.location.hash = "ui/nestable-list" },
        'show jquery U I' : function() { window.location.hash = "ui/jqui" },
        'show typography' : function() { window.location.hash = "ui/typography" },
        'show calendar' : function() { window.location.hash = "calendar" },
        'show widgets' : function() { window.location.hash = "widgets" },
        'show gallery' : function() { window.location.hash = "gallery" },
        'show maps' : function() { window.location.hash = "gmap-xml" },
        'go back' :  function() { history.back(1); }, 
        'scroll up' : function () { $('html, body').animate({ scrollTop: 0 }, 100); },
        'scroll down' : function () { $('html, body').animate({ scrollTop: $(document).height() }, 100);},
        'hide navigation' : function() { 
            if ($( ":root" ).hasClass("container") && !$( ":root" ).hasClass("menu-on-top")){
                $('span.minifyme').trigger("click");
            } else {
                $('#hide-menu > span > a').trigger("click"); 
            }
        },
        'show navigation' : function() { 
            if ($( ":root" ).hasClass("container") && !$( ":root" ).hasClass("menu-on-top")){
                $('span.minifyme').trigger("click");
            } else {
                $('#hide-menu > span > a').trigger("click"); 
            }
        },
        'mute' : function() {
            appConfig.sound_on = false;
            $.smallBox({
                title : "MUTE",
                content : "All sounds have been muted!",
                color : "#a90329",
                timeout: 4000,
                icon : "fa fa-volume-off"
            });
        },
        'sound on' : function() {
            appConfig.sound_on = true;
            $.speechApp.playConfirmation();
            $.smallBox({
                title : "UNMUTE",
                content : "All sounds have been turned on!",
                color : "#40ac2b",
                sound_file: 'voice_alert',
                timeout: 5000,
                icon : "fa fa-volume-up"
            });
        },
        'stop' : function() {
            smartSpeechRecognition.abort();
            $( ":root" ).removeClass("voice-command-active");
            $.smallBox({
                title : "VOICE COMMAND OFF",
                content : "Your voice commands has been successfully turned off. Click on the <i class='fa fa-microphone fa-lg fa-fw'></i> icon to turn it back on.",
                color : "#40ac2b",
                sound_file: 'voice_off',
                timeout: 8000,
                icon : "fa fa-microphone-slash"
            });
            if ($('#speech-btn .popover').is(':visible')) {
                $('#speech-btn .popover').fadeOut(250);
            }
        },
        'help' : function() {

            $('#voiceModal').removeData('modal').modal( { remote: "app/layout/partials/voice-commands.tpl.html", show: true } );
            if ($('#speech-btn .popover').is(':visible')) {
                $('#speech-btn .popover').fadeOut(250);
            }

        },      
        'got it' : function() {
            $('#voiceModal').modal('hide');
        },  
        'logout' : function() {
            $.speechApp.stop();
            window.location = $('#logout > span > a').attr("href");
        }
    }; 
    
};


/*
* END APP.appConfig
*/;
define("appConfig", function(){});

define('app',["angular","angular-couch-potato","angular-ui-router","angular-animate","angular-bootstrap","smartwidgets","notification"],function(a,b){var c=a.module("app",["ngSanitize","scs.couch-potato","ngAnimate","ui.router","ui.bootstrap","app.auth","app.layout","app.chat","app.dashboard","app.calendar","app.inbox","app.graphs","app.tables","app.forms","app.ui","app.widgets","app.maps","app.appViews","app.misc","app.smartAdmin","smart-templates"]);return b.configureApp(c),c.config(["$provide","$httpProvider",function(a,b){a.factory("ErrorHttpInterceptor",["$q",function(a){function b(a){console.log(a),$.bigBox({title:a.status+" "+a.statusText,content:a.data,color:"#C46A69",icon:"fa fa-warning shake animated",number:++c,timeout:6e3})}var c=0;return{requestError:function(c){return b(c),a.reject(c)},responseError:function(c){return b(c),a.reject(c)}}}]),b.interceptors.push("ErrorHttpInterceptor")}]),c.run(["$couchPotato","$rootScope","$state","$stateParams",function(a,b,d,e){c.lazy=a,b.$state=d,b.$stateParams=e}]),c});
define('auth/module',["angular","angular-couch-potato","angular-ui-router","angular-google-plus","angular-easyfb"],function(a,b){var c=a.module("app.auth",["ui.router"]);b.configureApp(c);var d={googleClientId:"678402726462-ah1p6ug0klf9jm8cplefmphfupg3bg2h.apps.googleusercontent.com",facebookAppId:"620275558085318"};return c.config(["$stateProvider","$couchPotatoProvider",function(a,b){a.state("realLogin",{url:"/real-login",views:{root:{templateUrl:"build/auth/login/login.html",controller:"LoginCtrl",resolve:{deps:b.resolveDependencies(["auth/models/User","auth/directives/loginInfo","auth/login/LoginCtrl","auth/login/directives/facebookSignin","auth/login/directives/googleSignin"])}}},data:{title:"Login",rootId:"extra-page"}}).state("login",{url:"/login",views:{root:{templateUrl:"build/auth/views/login.html"}},data:{title:"Login",htmlId:"extr-page"},resolve:{deps:b.resolveDependencies(["modules/forms/directives/validate/smartValidateForm"])}}).state("register",{url:"/register",views:{root:{templateUrl:"build/auth/views/register.html"}},data:{title:"Register",htmlId:"extr-page"},resolve:{deps:b.resolveDependencies(["modules/forms/directives/validate/smartValidateForm"])}}).state("forgotPassword",{url:"/forgot-password",views:{root:{templateUrl:"build/auth/views/forgot-password.html"}},data:{title:"Forgot Password",htmlId:"extr-page"},resolve:{deps:b.resolveDependencies(["modules/forms/directives/validate/smartValidateForm"])}}).state("lock",{url:"/lock",views:{root:{templateUrl:"build/auth/views/lock.html"}},data:{title:"Locked Screen",htmlId:"lock-page"}})}]).constant("authKeys",d),c.run(["$couchPotato",function(a){c.lazy=a}]),c});
define('auth/models/User',["auth/module"],function(a){return a.registerFactory("User",["$http","$q",function(a,b){var c=b.defer(),d={initialized:c.promise,username:void 0,picture:void 0};return a.get("api/user.json").then(function(a){d.username=a.data.username,d.picture=a.data.picture,c.resolve(d)}),d}])});
define('layout/module',["angular","angular-couch-potato","angular-ui-router"],function(a,b){var c=a.module("app.layout",["ui.router"]);return b.configureApp(c),c.config(["$stateProvider","$couchPotatoProvider","$urlRouterProvider",function(a,b,c){a.state("app",{"abstract":!0,views:{root:{templateUrl:"build/layout/layout.tpl.html",resolve:{deps:b.resolveDependencies(["auth/directives/loginInfo","modules/graphs/directives/inline/sparklineContainer","components/inbox/directives/unreadMessagesCount","components/chat/api/ChatApi","components/chat/directives/asideChatWidget"])}}}}),c.otherwise("/dashboard")}]),c.run(["$couchPotato",function(a){c.lazy=a}]),c});
define('layout/actions/minifyMenu',["layout/module"],function(a){a.registerDirective("minifyMenu",function(){return{restrict:"A",link:function(a,b){var c=$("body"),d=function(){c.hasClass("menu-on-top")||(c.toggleClass("minified"),c.removeClass("hidden-menu"),$("html").removeClass("hidden-menu-mobile-lock"))};b.on("click",d)}}})});
define('layout/actions/toggleMenu',["layout/module"],function(a){a.registerDirective("toggleMenu",function(){return{restrict:"A",link:function(a,b){var c=$("body"),d=function(){c.hasClass("menu-on-top")?c.hasClass("menu-on-top")&&c.hasClass("mobile-view-activated")&&($("html").toggleClass("hidden-menu-mobile-lock"),c.toggleClass("hidden-menu"),c.removeClass("minified")):($("html").toggleClass("hidden-menu-mobile-lock"),c.toggleClass("hidden-menu"),c.removeClass("minified"))};b.on("click",d),a.$on("requestToggleMenu",function(){d()})}}})});
define('layout/actions/fullScreen',["layout/module"],function(a){a.registerDirective("fullScreen",function(){return{restrict:"A",link:function(a,b){var c=$("body"),d=function(){c.hasClass("full-screen")?(c.removeClass("full-screen"),document.exitFullscreen?document.exitFullscreen():document.mozCancelFullScreen?document.mozCancelFullScreen():document.webkitExitFullscreen&&document.webkitExitFullscreen()):(c.addClass("full-screen"),document.documentElement.requestFullscreen?document.documentElement.requestFullscreen():document.documentElement.mozRequestFullScreen?document.documentElement.mozRequestFullScreen():document.documentElement.webkitRequestFullscreen?document.documentElement.webkitRequestFullscreen():document.documentElement.msRequestFullscreen&&document.documentElement.msRequestFullscreen())};b.on("click",d)}}})});
define('layout/actions/resetWidgets',["layout/module"],function(a){a.registerDirective("resetWidgets",["$state",function(){return{restrict:"A",link:function(a,b){b.on("click",function(){$.SmartMessageBox({title:"<i class='fa fa-refresh' style='color:green'></i> Clear Local Storage",content:"Would you like to RESET all your saved widgets and clear LocalStorage?1",buttons:"[No][Yes]"},function(a){"Yes"==a&&localStorage&&(localStorage.clear(),location.reload())})})}}}])});
define('layout/actions/searchMobile',["layout/module"],function(a){a.registerDirective("searchMobile",function(){return{restrict:"A",compile:function(a){a.removeAttr("search-mobile data-search-mobile"),a.on("click",function(a){$("body").addClass("search-mobile"),a.preventDefault()}),$("#cancel-search-js").on("click",function(a){$("body").removeClass("search-mobile"),a.preventDefault()})}}})});
define('layout/directives/demo/demoStates',["layout/module","lodash","notification"],function(a,b){a.registerDirective("demoStates",["$rootScope",function(a){return{restrict:"E",replace:!0,templateUrl:"build/layout/directives/demo/demo-states.tpl.html",scope:!0,link:function(a,b){b.parent().css({position:"relative"}),b.on("click","#demo-setting",function(){b.toggleClass("activate")})},controller:["$scope",function(c){var d=$("body");c.$watch("fixedHeader",function(a){localStorage.setItem("sm-fixed-header",a),d.toggleClass("fixed-header",a),0==a&&(c.fixedRibbon=!1,c.fixedNavigation=!1)}),c.$watch("fixedNavigation",function(a){localStorage.setItem("sm-fixed-navigation",a),d.toggleClass("fixed-navigation",a),a?(c.insideContainer=!1,c.fixedHeader=!0):c.fixedRibbon=!1}),c.$watch("fixedRibbon",function(a){localStorage.setItem("sm-fixed-ribbon",a),d.toggleClass("fixed-ribbon",a),a&&(c.fixedHeader=!0,c.fixedNavigation=!0,c.insideContainer=!1)}),c.$watch("fixedPageFooter",function(a){localStorage.setItem("sm-fixed-page-footer",a),d.toggleClass("fixed-page-footer",a)}),c.$watch("insideContainer",function(a){localStorage.setItem("sm-inside-container",a),d.toggleClass("container",a),a&&(c.fixedRibbon=!1,c.fixedNavigation=!1)}),c.$watch("rtl",function(a){localStorage.setItem("sm-rtl",a),d.toggleClass("smart-rtl",a)}),c.$watch("menuOnTop",function(b){a.$broadcast("$smartLayoutMenuOnTop",b),localStorage.setItem("sm-menu-on-top",b),d.toggleClass("menu-on-top",b),b&&d.removeClass("minified")}),c.$watch("colorblindFriendly",function(a){localStorage.setItem("sm-colorblind-friendly",a),d.toggleClass("colorblind-friendly",a)}),c.fixedHeader="true"==localStorage.getItem("sm-fixed-header"),c.fixedNavigation="true"==localStorage.getItem("sm-fixed-navigation"),c.fixedRibbon="true"==localStorage.getItem("sm-fixed-ribbon"),c.fixedPageFooter="true"==localStorage.getItem("sm-fixed-page-footer"),c.insideContainer="true"==localStorage.getItem("sm-inside-container"),c.rtl="true"==localStorage.getItem("sm-rtl"),c.menuOnTop="true"==localStorage.getItem("sm-menu-on-top")||d.hasClass("menu-on-top"),c.colorblindFriendly="true"==localStorage.getItem("sm-colorblind-friendly"),c.skins=appConfig.skins,c.smartSkin=localStorage.getItem("sm-skin")||appConfig.smartSkin,c.setSkin=function(a){c.smartSkin=a.name,d.removeClass(b.pluck(c.skins,"name").join(" ")),d.addClass(a.name),localStorage.setItem("sm-skin",a.name),$("#logo img").attr("src",a.logo)},"smart-style-0"!=c.smartSkin&&c.setSkin(b.find(c.skins,{name:c.smartSkin})),c.factoryReset=function(){$.SmartMessageBox({title:"<i class='fa fa-refresh' style='color:green'></i> Clear Local Storage",content:"Would you like to RESET all your saved widgets and clear LocalStorage?1",buttons:"[No][Yes]"},function(a){"Yes"==a&&localStorage&&(localStorage.clear(),location.reload())})}}]}}])});
define('layout/directives/smartInclude',["layout/module"],function(a){return a.registerDirective("smartInclude",function(){return{replace:!0,restrict:"A",templateUrl:function(a,b){return b.smartInclude},compile:function(a){a[0].className=a[0].className.replace(/placeholder[^\s]+/g,"")}}})});
define('layout/directives/smartDeviceDetect',["layout/module"],function(a){a.registerDirective("smartDeviceDetect",function(){return{restrict:"A",compile:function(a){a.removeAttr("smart-device-detect data-smart-device-detect");var b=/iphone|ipad|ipod|android|blackberry|mini|windows\sce|palm/i.test(navigator.userAgent.toLowerCase());a.toggleClass("desktop-detected",!b),a.toggleClass("mobile-detected",b)}}})});
define('layout/directives/smartFastClick',["layout/module","require","fastclick"],function(a,b){a.registerDirective("smartFastClick",function(){var a=b("fastclick");return{restrict:"A",compile:function(b){b.removeAttr("smart-fast-click data-smart-fast-click"),a.attach(b),a.notNeeded()||b.addClass("needsclick")}}})});
define('layout/directives/smartLayout',["layout/module","lodash"],function(a,b){a.registerDirective("smartLayout",["$rootScope","$timeout","$interval","$q","SmartCss",function(a,c,d,e){var f=!1,g=e.defer();g.promise.then(function(){f=!0});var h,i,j,k,l=$(window),m=($(document),$("html")),n=$("body");return function o(){h=$("#header"),i=$("#left-panel"),j=$("#ribbon"),k=$(".page-footer"),b.every([h,i,j,k],function(a){return angular.isNumber(a.height())})?g.resolve():c(o,100)}(),{priority:2014,restrict:"A",compile:function(e){function o(){var b=n.hasClass("menu-on-top")&&i.is(":visible")?i.height():0,c=!n.hasClass("menu-on-top")&&i.is(":visible")?i.width()+i.offset().left:0,d=$("#content"),e=d.outerWidth(!0)-d.width(),f=d.outerHeight(!0)-d.height();u=l.width()-c-e,v=l.height()-b-f-h.height()-j.height()-k.height(),w=z-u,x=y-v,(Math.abs(w)||Math.abs(x)||A)&&(a.$broadcast("$smartContentResize",{width:u,height:v,deltaX:w,deltaY:x}),z=u,y=v,A=!1)}function p(a){g.promise.then(function(){r(a)})}function q(){B=!1}function r(a){c(function(){B=!0},a)}function s(){n.toggleClass("mobile-view-activated",l.width()<979),l.width()<979&&n.removeClass("minified"),o()}function t(a){a.data&&a.data.htmlId?m.attr("id",a.data.htmlId):m.removeAttr("id")}e.removeAttr("smart-layout data-smart-layout");var u,v,w,x,y=0,z=0,A=!1,B=!1;d(function(){B&&s()},300);var C=b.debounce(function(){p(300)},300);p(10),a.$on("$stateChangeStart",function(a,b){t(b),q()});var D=1;a.$on("$viewContentLoading",function(){D++}),a.$on("$stateChangeSuccess",function(){A=!0}),a.$on("$viewContentLoaded",function(){D--,0==D&&f&&C()})}}}])});
define('layout/directives/smartSpeech',["layout/module","jquery"],function(a,b){b.root_=b("body");var c=window;if(appConfig.voice_command)var d=appConfig.commands;var e=c.SpeechRecognition||c.webkitSpeechRecognition||c.mozSpeechRecognition||c.msSpeechRecognition||c.oSpeechRecognition;b.speechApp=function(a){return a.start=function(){smartSpeechRecognition.addCommands(d),smartSpeechRecognition?(smartSpeechRecognition.start(),b.root_.addClass("voice-command-active"),b.speechApp.playON(),appConfig.voice_localStorage&&localStorage.setItem("sm-setautovoice","true")):alert("speech plugin not loaded")},a.stop=function(){smartSpeechRecognition&&(smartSpeechRecognition.abort(),b.root_.removeClass("voice-command-active"),b.speechApp.playOFF(),appConfig.voice_localStorage&&localStorage.setItem("sm-setautovoice","false"),b("#speech-btn .popover").is(":visible")&&b("#speech-btn .popover").fadeOut(250))},a.playON=function(){var a=document.createElement("audio");navigator.userAgent.match("Firefox/")?a.setAttribute("src",appConfig.sound_path+"voice_on.ogg"):a.setAttribute("src",appConfig.sound_path+"voice_on.mp3"),a.addEventListener("load",function(){a.play()},!0),appConfig.sound_on&&(a.pause(),a.play())},a.playOFF=function(){var a=document.createElement("audio");navigator.userAgent.match("Firefox/")?a.setAttribute("src",appConfig.sound_path+"voice_off.ogg"):a.setAttribute("src",appConfig.sound_path+"voice_off.mp3"),b.get(),a.addEventListener("load",function(){a.play()},!0),appConfig.sound_on&&(a.pause(),a.play())},a.playConfirmation=function(){var a=document.createElement("audio");navigator.userAgent.match("Firefox/")?a.setAttribute("src",appConfig.sound_path+"voice_alert.ogg"):a.setAttribute("src",appConfig.sound_path+"voice_alert.mp3"),b.get(),a.addEventListener("load",function(){a.play()},!0),appConfig.sound_on&&(a.pause(),a.play())},a}({}),function(a){if(!e)return c.smartSpeechRecognition=null,a;var d,f,g=[],h={start:[],error:[],end:[],result:[],resultMatch:[],resultNoMatch:[],errorNetwork:[],errorPermissionBlocked:[],errorPermissionDenied:[]},i=0,j=/\s*\((.*?)\)\s*/g,k=/(\(\?:[^)]+\))\?/g,l=/(\(\?)?:\w+/g,m=/\*\w+/g,n=/[\-{}\[\]+?.,\\\^$|#]/g,o=function(a){return a=a.replace(n,"\\$&").replace(j,"(?:$1)?").replace(l,function(a,b){return b?a:"([^\\s]+)"}).replace(m,"(.*?)").replace(k,"\\s*$1?\\s*"),new RegExp("^"+a+"$","i")},p=function(a){a.forEach(function(a){a.callback.apply(a.context)})},q=function(){r()||c.smartSpeechRecognition.init({},!1)},r=function(){return d!==a};c.smartSpeechRecognition={init:function(j,k){k=k===a?!0:!!k,d&&d.abort&&d.abort(),d=new e,d.maxAlternatives=5,d.continuous=!0,d.lang=appConfig.voice_command_lang||"en-US",d.onstart=function(){p(h.start),appConfig.debugState&&(c.console.log("%c ✔ SUCCESS: User allowed access the microphone service to start ",appConfig.debugStyle_success),c.console.log("Language setting is set to: "+d.lang,appConfig.debugStyle)),b.root_.removeClass("service-not-allowed"),b.root_.addClass("service-allowed")},d.onerror=function(a){switch(p(h.error),a.error){case"network":p(h.errorNetwork);break;case"not-allowed":case"service-not-allowed":f=!1,b.root_.removeClass("service-allowed"),b.root_.addClass("service-not-allowed"),appConfig.debugState&&c.console.log("%c WARNING: Microphone was not detected (either user denied access or it is not installed properly) ",appConfig.debugStyle_warning),p((new Date).getTime()-i<200?h.errorPermissionBlocked:h.errorPermissionDenied)}},d.onend=function(){if(p(h.end),f){var a=(new Date).getTime()-i;1e3>a?setTimeout(c.smartSpeechRecognition.start,1e3-a):c.smartSpeechRecognition.start()}},d.onresult=function(a){p(h.result);for(var d,e=a.results[a.resultIndex],f=0;f<e.length;f++){d=e[f].transcript.trim(),appConfig.debugState&&c.console.log("Speech recognized: %c"+d,appConfig.debugStyle);for(var i=0,j=g.length;j>i;i++){var k=g[i].command.exec(d);if(k){var l=k.slice(1);appConfig.debugState&&(c.console.log("command matched: %c"+g[i].originalPhrase,appConfig.debugStyle),l.length&&c.console.log("with parameters",l)),g[i].callback.apply(this,l),p(h.resultMatch);var m=["sound on","mute","stop"];return m.indexOf(g[i].originalPhrase)<0&&(console.log(2),b.smallBox({title:g[i].originalPhrase,content:"loading...",color:"#333",sound_file:"voice_alert",timeout:2e3}),b("#speech-btn .popover").is(":visible")&&b("#speech-btn .popover").fadeOut(250)),!0}}}return p(h.resultNoMatch),b.smallBox({title:'Error: <strong> " '+d+' " </strong> no match found!',content:"Please speak clearly into the microphone",color:"#a90329",timeout:5e3,icon:"fa fa-microphone"}),b("#speech-btn .popover").is(":visible")&&b("#speech-btn .popover").fadeOut(250),!1},k&&(g=[]),j.length&&this.addCommands(j)},start:function(b){q(),b=b||{},f=b.autoRestart!==a?!!b.autoRestart:!0,i=(new Date).getTime(),d.start()},abort:function(){f=!1,r&&d.abort()},debug:function(a){appConfig.debugState=arguments.length>0?!!a:!0},setLanguage:function(a){q(),d.lang=a},addCommands:function(a){var b,d;q();for(var e in a)if(a.hasOwnProperty(e)){if(b=c[a[e]]||a[e],"function"!=typeof b)continue;d=o(e),g.push({command:d,callback:b,originalPhrase:e})}appConfig.debugState&&c.console.log("Commands successfully loaded: %c"+g.length,appConfig.debugStyle)},removeCommands:function(b){return b===a?void(g=[]):(b=Array.isArray(b)?b:[b],void(g=g.filter(function(a){for(var c=0;c<b.length;c++)if(b[c]===a.originalPhrase)return!1;return!0})))},addCallback:function(b,d,e){if(h[b]!==a){var f=c[d]||d;"function"==typeof f&&h[b].push({callback:f,context:e||this})}}}}.call(this);var f=function(){smartSpeechRecognition.addCommands(d),smartSpeechRecognition?(smartSpeechRecognition.start(),b.root_.addClass("voice-command-active"),appConfig.voice_localStorage&&localStorage.setItem("sm-setautovoice","true")):alert("speech plugin not loaded")};e&&appConfig.voice_command&&"true"==localStorage.getItem("sm-setautovoice")&&f(),e&&appConfig.voice_command_auto&&appConfig.voice_command&&f(),a.registerDirective("speechRecognition",["$log",function(){var a=function(a,c){if(e&&appConfig.voice_command){var f=b('<div class="modal fade" id="voiceModal" tabindex="-1" role="dialog" aria-labelledby="remoteModalLabel" aria-hidden="true"><div class="modal-dialog"><div class="modal-content"></div></div></div>');f.appendTo("body"),c.on("click",function(a){b.root_.hasClass("voice-command-active")?b.speechApp.stop():(b.speechApp.start(),b("#speech-btn .popover").fadeIn(350)),a.preventDefault()}),b(document).mouseup(function(a){b("#speech-btn .popover").is(a.target)||0!==b("#speech-btn .popover").has(a.target).length||b("#speech-btn .popover").fadeOut(250)}),b("#speech-help-btn").on("click",function(){d.help()})}else b("#speech-btn").addClass("display-none")};return{restrict:"AE",link:a}}])});
define('layout/directives/smartRouterAnimationWrap',["layout/module","lodash"],function(a,b){a.registerDirective("smartRouterAnimationWrap",["$rootScope","$timeout",function(a,c){return{restrict:"A",compile:function(d,e){function f(){j=!0,d.css({height:d.height()+"px",overflow:"hidden"}).addClass("active"),$(h).addClass("animated faster fadeOutDown")}function g(){j&&(d.css({height:"auto",overflow:"visible"}).removeClass("active"),$(h).addClass("animated faster fadeInUp"),j=!1,c(function(){$(h).removeClass("animated")},10))}d.removeAttr("smart-router-animation-wrap data-smart-router-animation-wrap wrap-for data-wrap-for"),d.addClass("router-animation-container"),$('<div class="router-animation-loader"><i class="fa fa-gear fa-4x fa-spin"></i></div>').appendTo(d);var h=e.wrapFor,i=e.smartRouterAnimationWrap.split(/\s/),j=!1,k=a.$on("$stateChangeStart",function(a,c,d,e){var g=b.any(i,function(a){return b.has(c.views,a)||b.has(e.views,a)});g&&f()}),l=a.$on("$viewContentLoaded",function(){g()});d.on("$destroy",function(){k(),l()})}}}])});
define('layout/directives/smartFitAppView',["layout/module","lodash"],function(a){a.registerDirective("smartFitAppView",["$rootScope","SmartCss",function(a,b){return{restrict:"A",compile:function(c,d){c.removeAttr("smart-fit-app-view data-smart-fit-app-view leading-y data-leading-y");var e=d.leadingY?parseInt(d.leadingY):0,f=d.smartFitAppView;if(b.appViewSize&&b.appViewSize.height){var g=b.appViewSize.height-e<252?252:b.appViewSize.height-e;b.add(f,"height",g+"px")}var h=a.$on("$smartContentResize",function(a,c){var d=c.height-e<252?252:c.height-e;b.add(f,"height",d+"px")});c.on("$destroy",function(){h(),b.remove(f,"height")})}}}])});
define('layout/directives/radioToggle',["layout/module"],function(a){a.registerDirective("radioToggle",["$log",function(){return{scope:{model:"=ngModel",value:"@value"},link:function(a,b){b.parent().on("click",function(){a.model=a.value,a.$apply()})}}}])});
define('layout/directives/dismisser',["layout/module"],function(a){a.registerDirective("dismisser",function(){return{restrict:"A",compile:function(a){a.removeAttr("dismisser data-dissmiser");var b='<button class="close">&times;</button>';a.prepend(b),a.on("click",">button.close",function(){a.fadeOut("fast",function(){$(this).remove()})})}}})});
define('layout/directives/smartMenu',["layout/module","jquery"],function(a){!function(a){a.fn.smartCollapseToggle=function(){return this.each(function(){var b=a("body"),c=a(this);b.hasClass("menu-on-top")||(b.hasClass("mobile-view-activated"),c.toggleClass("open"),b.hasClass("minified")?c.closest("nav ul ul").length&&(c.find(">a .collapse-sign .fa").toggleClass("fa-minus-square-o fa-plus-square-o"),c.find("ul:first").slideToggle(appConfig.menu_speed||200)):(c.find(">a .collapse-sign .fa").toggleClass("fa-minus-square-o fa-plus-square-o"),c.find("ul:first").slideToggle(appConfig.menu_speed||200)))})}}(jQuery),a.registerDirective("smartMenu",["$state","$rootScope",function(a,b){return{restrict:"A",link:function(a,c){var d=$("body"),e=c.find("li[data-menu-collapse]");e.each(function(a,b){var c=$(b);c.on("click",">a",function(a){c.siblings(".open").smartCollapseToggle(),c.smartCollapseToggle(),!c.hasClass("open")&&c.find("li.active").length>0&&c.addClass("active"),a.preventDefault()}).find(">a").append('<b class="collapse-sign"><em class="fa fa-plus-square-o"></em></b>'),c.find("li.active").length&&(c.smartCollapseToggle(),c.find("li.active").parents("li").addClass("active"))}),c.on("click","a[data-ui-sref]",function(){$(this).parents("li").addClass("active").each(function(){$(this).siblings("li.open").smartCollapseToggle(),$(this).siblings("li").removeClass("active")}),d.hasClass("mobile-view-activated")&&b.$broadcast("requestToggleMenu")}),a.$on("$smartLayoutMenuOnTop",function(a,b){b&&e.filter(".open").smartCollapseToggle()})}}}])});
define('layout/directives/bigBreadcrumbs',["layout/module","lodash"],function(a,b){a.registerDirective("bigBreadcrumbs",function(){return{restrict:"E",replace:!0,template:'<div><h1 class="page-title txt-color-blueDark"></h1></div>',scope:{items:"=",icon:"@"},link:function(a,c){var d=b.first(a.items),e=a.icon||"home";c.find("h1").append('<i class="fa-fw fa fa-'+e+'"></i> '+d),b.rest(a.items).forEach(function(a){c.find("h1").append(" <span>> "+a+"</span>")})}}})});
define('layout/directives/stateBreadcrumbs',["layout/module"],function(a){a.registerDirective("stateBreadcrumbs",["$rootScope","$state",function(a,b){return{restrict:"E",replace:!0,template:'<ol class="breadcrumb"><li>Home</li></ol>',link:function(c,d){function e(a){var b="<li>Home</li>";angular.forEach(a,function(a){b+="<li>"+a+"</li>"}),d.html(b)}function f(a,c){var d=b.get(a);d&&d.data&&d.data.title&&-1==c.indexOf(d.data.title)&&c.unshift(d.data.title);var e=a.replace(/.?\w+$/,"");return e?f(e,c):c}function g(a){var b;b=a.data&&a.data.breadcrumbs?a.data.breadcrumbs:f(a.name,[]),e(b)}g(b.current),a.$on("$stateChangeStart",function(a,b){g(b)})}}}])});
define('layout/directives/smartPageTitle',["layout/module"],function(a){a.registerDirective("smartPageTitle",["$rootScope","$timeout",function(a,b){return{restrict:"A",compile:function(c,d){c.removeAttr("smart-page-title data-smart-page-title");var e=d.smartPageTitle,f=function(a,c){var d=e;c.data&&c.data.title&&(d=c.data.title+" | "+d),b(function(){$("html head title").text(d)})};a.$on("$stateChangeStart",f)}}}])});
define('layout/directives/hrefVoid',["layout/module"],function(a){a.registerDirective("hrefVoid",function(){return{restrict:"A",link:function(a,b){b.attr("href","#"),b.on("click",function(a){a.preventDefault(),a.stopPropagation()})}}})});
define('layout/service/SmartCss',["layout/module","lodash"],function(a,b){a.registerFactory("SmartCss",["$rootScope","$timeout",function(a,c){var d=function(){var a=document.createElement("style");return a.appendChild(document.createTextNode("")),document.head.appendChild(a),a.sheet}(),e={},f={writeRule:function(a){if(f.deleteRuleFor(a),b.has(e,a)){var c=a+"{ "+b.map(e[a],function(a,b){return b+":"+a+";"}).join(" ")+"}";d.insertRule(c)}},add:function(a,d,g,h){b.has(e,a)||(e[a]={}),void 0==g||null==g||""==g?delete e[a][d]:e[a][d]=g,0==b.keys(e[a]).length&&delete e[a],h||(h=0),c(function(){f.writeRule(a)},h)},remove:function(a,b,c){f.add(a,b,null,c)},deleteRuleFor:function(a){b(d.rules).forEach(function(b,c){b.selectorText==a&&d.deleteRule(c)})},appViewSize:null};return a.$on("$smartContentResize",function(a,b){f.appViewSize=b}),f}])});
define('modules/widgets/module',["angular","angular-couch-potato","angular-ui-router"],function(a,b){var c=a.module("app.widgets",["ui.router"]);return b.configureApp(c),c.config(["$stateProvider","$couchPotatoProvider",function(a){a.state("app.widgets",{url:"/widgets",data:{title:"Widgets"},views:{"content@app":{templateUrl:"build/modules/widgets/views/widgets-demo.html"}}})}]),c.run(["$couchPotato",function(a){c.lazy=a}]),c});
define('modules/widgets/directives/widgetGrid',["modules/widgets/module","lodash"],function(a,b){a.registerDirective("widgetGrid",["$rootScope","$compile","$q","$state","$timeout",function(a,c,d,e,f){var g,h,i,j={grid:"article",widgets:".jarviswidget",localStorage:!0,deleteSettingsKey:"#deletesettingskey-options",settingsKeyLabel:"Reset settings?",deletePositionKey:"#deletepositionkey-options",positionKeyLabel:"Reset position?",sortable:!0,buttonsHidden:!1,toggleButton:!0,toggleClass:"fa fa-minus | fa fa-plus",toggleSpeed:200,onToggle:function(){},deleteButton:!0,deleteMsg:"Warning: This action cannot be undone!",deleteClass:"fa fa-times",deleteSpeed:200,onDelete:function(){},editButton:!0,editPlaceholder:".jarviswidget-editbox",editClass:"fa fa-cog | fa fa-save",editSpeed:200,onEdit:function(){},colorButton:!0,fullscreenButton:!0,fullscreenClass:"fa fa-expand | fa fa-compress",fullscreenDiff:3,onFullscreen:function(){},customButton:!1,customClass:"folder-10 | next-10",customStart:function(){alert("Hello you, this is a custom button...")},customEnd:function(){alert("bye, till next time...")},buttonOrder:"%refresh% %custom% %edit% %toggle% %fullscreen% %delete%",opacity:1,dragHandle:"> header",placeholderClass:"jarviswidget-placeholder",indicator:!0,indicatorTime:600,ajax:!0,timestampPlaceholder:".jarviswidget-timestamp",timestampFormat:"Last update: %m%/%d%/%y% %h%:%i%:%s%",refreshButton:!0,refreshButtonClass:"fa fa-refresh",labelError:"Sorry but there was a error:",labelUpdated:"Last Update:",labelRefresh:"Refresh",labelDelete:"Delete widget:",afterLoad:function(){},rtl:!1,onChange:function(){},onSave:function(){},ajaxnav:!0},k=[],l=!1,m=function(a,c){l?l||(l=!0,f(function(){l=!1,m(a,c)},200)):b.intersection(c,k).length!=c.length&&(k=b.union(c,k),a.data("jarvisWidgets")&&a.data("jarvisWidgets").destroy(),a.jarvisWidgets(j),o(c))},n=function(a,c){a.data("jarvisWidgets")&&a.data("jarvisWidgets").destroy(),k=b.xor(k,c)},o=function(a){angular.forEach(a,function(a){$("#"+a+' [data-toggle="dropdown"]').each(function(){var a=$(this).parent();if($(this).removeAttr("data-toggle"),!a.attr("dropdown")){$(this).removeAttr("href"),a.attr("dropdown","");var b=c(a)(a.scope());a.replaceWith(b)}})})};return{restrict:"A",compile:function(b){b.removeAttr("widget-grid data-widget-grid");var c=[];h=a.$on("$viewContentLoaded",function(){f(function(){m(b,c)},100)}),i=a.$on("$stateChangeStart",function(){g(),h(),i(),n(b,c)}),g=a.$on("jarvisWidgetAdded",function(a,d){-1==c.indexOf(d.attr("id"))&&(c.push(d.attr("id")),f(function(){m(b,c)},100))})}}}])});
define('modules/widgets/directives/jarvisWidget',["modules/widgets/module"],function(a){a.registerDirective("jarvisWidget",["$rootScope",function(a){return{restrict:"A",compile:function(b){b.data("widget-color")&&b.addClass("jarviswidget-color-"+b.data("widget-color")),b.find(".widget-body").prepend('<div class="jarviswidget-editbox"><input class="form-control" type="text"></div>'),b.addClass("jarviswidget jarviswidget-sortable"),a.$emit("jarvisWidgetAdded",b)}}}])});
define('dashboard/module',["angular","angular-couch-potato","angular-ui-router","angular-resource"],function(a,b){var c=a.module("app.dashboard",["ui.router","ngResource"]);return c.config(["$stateProvider","$couchPotatoProvider",function(a,b){a.state("app.dashboard",{url:"/dashboard",views:{"content@app":{controller:"DashboardCtrl",templateUrl:"build/dashboard/dashboard.html",resolve:{deps:b.resolveDependencies(["dashboard/DashboardCtrl","modules/graphs/directives/inline/sparklineContainer","modules/graphs/directives/inline/easyPieChartContainer","components/chat/directives/chatWidget","components/chat/directives/chatUsers","modules/graphs/directives/vectormap/vectorMap","modules/graphs/directives/flot/flotBasic"])}}},data:{title:"Dashboard"}})}]),b.configureApp(c),c.run(["$couchPotato",function(a){c.lazy=a}]),c});
define('components/language/Language',["app"],function(a){return a.factory("Language",["$http",function(a){function b(b,c){a.get("api/langs/"+b+".json").success(function(a){c(a)}).error(function(){$log.log("Error"),c([])})}function c(b){a.get("api/languages.json").success(function(a){b(a)}).error(function(){$log.log("Error"),b([])})}return{getLang:function(a,c){b(a,c)},getLanguages:function(a){c(a)}}}])});
define('components/language/languageSelector',["app"],function(a){a.registerDirective("languageSelector",["Language",function(){return{restrict:"EA",replace:!0,templateUrl:"build/components/language/language-selector.tpl.html",scope:!0}}])});
define('components/language/language-controller',["app"],function(a){function b(a,b,c,d){b.lang={},d.getLanguages(function(a){b.currentLanguage=a[0],b.languages=a,d.getLang(a[0].key,function(a){b.lang=a})}),a.selectLanguage=function(a){b.currentLanguage=a,d.getLang(a.key,function(a){b.lang=a})},b.getWord=function(a){return angular.isDefined(b.lang[a])?b.lang[a]:a}}return b.$inject=["$scope","$rootScope","$log","Language"],a.controller("LanguagesCtrl",b)});
define('components/projects/Project',["app"],function(a){return a.factory("Project",["$http",function(a){return{list:a.get("api/projects.json")}}])});
define('components/projects/recentProjects',["app"],function(a){return a.directive("recentProjects",["Project",function(a){return{restrict:"EA",replace:!0,templateUrl:"build/components/projects/recent-projects.tpl.html",scope:!0,link:function(b){a.list.then(function(a){b.projects=a.data}),b.clearProjects=function(){b.projects=[]}}}}])});
define('components/activities/activities-controller',["app"],function(a){function b(a,b,c){a.activeTab="default",a.currentActivityItems=[],c.get(function(b){a.activities=b.activities}),a.isActive=function(b){return a.activeTab===b},a.setTab=function(b){a.activeTab=b,c.getbytype(b,function(b){a.currentActivityItems=b.data})}}return b.$inject=["$scope","$log","activityService"],a.controller("ActivitiesCtrl",b)});
define('components/activities/activities-dropdown-toggle-directive',["app"],function(a){return a.directive("activitiesDropdownToggle",["$log",function(){var a=function(a,b){var c=null;b.on("click",function(){var a=$(this).find(".badge");a.hasClass("bg-color-red")&&a.removeClass("bg-color-red").text(0),c=$(this).next(".ajax-dropdown"),c.is(":visible")?(c.fadeOut(150),$(this).removeClass("active")):(c.fadeIn(150),$(this).addClass("active"))}),$(document).mouseup(function(a){c&&!c.is(a.target)&&0===c.has(a.target).length&&(c.fadeOut(150),b.removeClass("active"))})};return{restrict:"EA",link:a}}])});
define('components/activities/activities-service',["app"],function(a){return a.factory("activityService",["$http","$log",function(a,b){function c(c){a.get("api/activities/activity.json").success(function(a){c(a)}).error(function(){b.log("Error"),c([])})}function d(c,d){a.get("api/activities/activity-"+c+".json").success(function(a){d(a)}).error(function(){b.log("Error"),d([])})}return{get:function(a){c(a)},getbytype:function(a,b){d(a,b)}}}])});
define('components/shortcut/shortcut-directive',["app"],function(a){return a.directive("toggleShortcut",["$log","$timeout",function(a,b){var c=function(a){function b(){d.animate({height:"hide"},300,"easeOutCirc"),$("body").removeClass("shortcut-on")}function c(){d.animate({height:"show"},200,"easeOutCirc"),$("body").addClass("shortcut-on")}var d=$("#shortcut");a.on("click",function(){d.is(":visible")?b():c()}),d.find("a").click(function(a){a.preventDefault(),window.location=$(this).attr("href"),setTimeout(b,300)}),$(document).mouseup(function(a){d&&!d.is(a.target)&&0===d.has(a.target).length&&b()})},d=function(a,d){b(function(){c(d)})};return{restrict:"EA",link:d}}])});
define('components/calendar/module',["angular","angular-couch-potato","angular-ui-router"],function(a,b){var c=a.module("app.calendar",["ngResource","ui.router"]);return b.configureApp(c),c.config(["$stateProvider","$couchPotatoProvider",function(a){a.state("app.calendar",{url:"/calendar",views:{content:{templateUrl:"build/components/calendar/views/calendar.tpl.html"}},data:{title:"Calendar"}})}]),c.run(["$couchPotato",function(a){c.lazy=a}]),c});
define('components/calendar/models/CalendarEvent',["components/calendar/module"],function(a){a.factory("CalendarEvent",["$resource",function(a){return a("api/events.json",{_id:"@id"})}])});
define('components/calendar/directives/fullCalendar',["components/calendar/module","fullcalendar"],function(a){a.registerDirective("fullCalendar",["CalendarEvent","$log","$timeout",function(){return{restrict:"E",replace:!0,templateUrl:"build/components/calendar/directives/full-calendar.tpl.html",scope:{events:"=events"},link:function(a){function b(){d=c.fullCalendar({editable:!0,draggable:!0,selectable:!1,selectHelper:!0,unselectAuto:!1,disableResizing:!1,droppable:!0,header:{left:"title",center:"prev, next, today",right:"month, agendaWeek, agendaDay"},drop:function(a,b){var c=$(this).data("eventObject"),d=$.extend({},c);if(d.start=a,d.allDay=b,$("#calendar").fullCalendar("renderEvent",d,!0),$("#drop-remove").is(":checked")){var e=$(this).scope().$index;$("#external-events").scope().eventsExternal.splice(e,1),$(this).remove()}},select:function(a,b,c){var e=prompt("Event Title:");e&&d.fullCalendar("renderEvent",{title:e,start:a,end:b,allDay:c},!0),d.fullCalendar("unselect")},events:function(b,c,d,e){e(a.events)},eventRender:function(a,b){""==!a.description&&b.find(".fc-event-title").append("<br/><span class='ultra-light'>"+a.description+"</span>"),""==!a.icon&&b.find(".fc-event-title").append("<i class='air air-top-right fa "+a.icon+" '></i>")}}),$(".fc-header-right, .fc-header-center",c).hide()}var c=$("#calendar"),d=null;b(),a.$watch("events",function(){c.fullCalendar("refetchEvents")},!0),a.next=function(){$(".fc-button-next",c).click()},a.prev=function(){$(".fc-button-prev",c).click()},a.today=function(){$(".fc-button-today",c).click()},a.changeView=function(a){c.fullCalendar("changeView",a)}}}}])});
define('components/calendar/directives/dragableEvent',["components/calendar/module"],function(a){a.registerDirective("dragableEvent",["$log",function(){return{restrict:"A",link:function(a,b){var c=b.scope().event;b.data("eventObject",c),b.draggable({zIndex:999,revert:!0,revertDuration:0})}}}])});
define('components/calendar/controllers/CalendarCtrl',["components/calendar/module"],function(a){a.registerController("CalendarCtrl",["$scope","$log","CalendarEvent",function(a,b,c){a.events=[],a.eventsExternal=[{title:"Office Meeting",description:"Currently busy",className:"bg-color-darken txt-color-white",icon:"fa-time"},{title:"Lunch Break",description:"No Description",className:"bg-color-blue txt-color-white",icon:"fa-pie"},{title:"URGENT",description:"urgent tasks",className:"bg-color-red txt-color-white",icon:"fa-alert"}],c.query().$promise.then(function(b){a.events=b}),a.newEvent={},a.addEvent=function(){b.log("Adding new event:",a.newEvent);var c={title:"Untitled Event",description:"no description",className:"bg-color-darken txt-color-white",icon:"fa-info"};a.newEvent=angular.extend(c,a.newEvent),a.eventsExternal.unshift(a.newEvent),a.newEvent={}}}])});
define('components/inbox/module',["angular","angular-couch-potato","lodash","angular-ui-router","angular-resource"],function(a,b,c){var d=a.module("app.inbox",["ui.router","ngResource"]);return b.configureApp(d),d.config(["$stateProvider","$couchPotatoProvider",function(a,b){a.state("app.inbox",{url:"/inbox",data:{title:"Inbox"},views:{content:{templateUrl:"build/components/inbox/views/inbox-layout.html",controller:["$scope","config",function(a,b){a.config=b.data,a.deleteSelected=function(){a.$broadcast("$inboxDeleteMessages")}}],controllerAs:"inboxCtrl",resolve:{deps:b.resolveDependencies(["components/inbox/directives/messageLabels"]),config:["InboxConfig",function(a){return a}]}}}}).state("app.inbox.folder",{url:"/:folder",views:{inbox:{templateUrl:"build/components/inbox/views/inbox-folder.html",controller:["$scope","messages","$stateParams",function(a,b,d){a.$parent.selectedFolder=c.find(a.$parent.config.folders,{key:d.folder}),a.messages=b,a.$on("$inboxDeleteMessages",function(){angular.forEach(a.messages,function(b,c){b.selected&&b.$delete(function(){a.messages.splice(c,1)})})})}],resolve:{messages:["InboxMessage","$stateParams",function(a,b){return a.query({folder:b.folder})}]}}}}).state("app.inbox.folder.detail",{url:"/detail/:message",views:{"inbox@app.inbox":{templateUrl:"build/components/inbox/views/inbox-detail.html",controller:["$scope","message",function(a,b){a.message=b}],resolve:{message:["InboxMessage","$stateParams",function(a,b){return a.get({id:b.message})}]}}}}).state("app.inbox.folder.replay",{url:"/replay/:message",views:{"inbox@app.inbox":{templateUrl:"build/components/inbox/views/inbox-replay.html",controller:["$scope","$timeout","$state","replayTo",function(a,b,c,d){a.replayTo=d,a.sending=!1,a.send=function(){a.sending=!0,b(function(){c.go("app.inbox.folder")},1e3)}}],controllerAs:"replayCtrl",resolve:{deps:b.resolveDependencies(["modules/forms/directives/input/smartSelect2","modules/forms/directives/editors/smartSummernoteEditor"]),replayTo:["InboxMessage","$stateParams",function(a,b){return a.get({id:b.message})}]}}}}).state("app.inbox.folder.compose",{url:"/compose",views:{"inbox@app.inbox":{templateUrl:"build/components/inbox/views/inbox-compose.html",controller:["$scope","$timeout","$state",function(a,b,c){a.sending=!1,a.send=function(){a.sending=!0,b(function(){c.go("app.inbox.folder")},1e3)}}],controllerAs:"composeCtrl",resolve:{deps:b.resolveDependencies(["modules/forms/directives/input/smartSelect2","modules/forms/directives/editors/smartSummernoteEditor"])}}}})}]),d.run(["$couchPotato",function(a){d.lazy=a}]),d});
define('components/inbox/models/InboxConfig',["components/inbox/module"],function(a){return a.registerFactory("InboxConfig",["$http",function(a){return a.get("api/inbox.json")}])});
define('components/inbox/models/InboxMessage',["components/inbox/module","lodash"],function(a,b){return a.registerFactory("InboxMessage",["$resource",function(a){var c=a("api/messages.json/:id",{id:"@_id"},{get:{url:"api/message.json",isArray:!1}});return b.extend(c.prototype,{selected:!1,hasAttachments:function(){return b.isArray(this.attachments)&&this.attachments.length},fullAttachmentsTootlip:function(){return"FILES: "+b.pluck(this.attachments,"name").join(", ")},getBodyTeaser:function(){var a=this.body.replace(/<[^<>]+?>/gm," ").replace(/(\s{2}|\n)/gm," "),b=55-this.subject.length;return a.length>b?a.substring(0,b)+"...":a}}),c}])});
define('components/todo/TodoCtrl',["app"],function(a){a.registerController("TodoCtrl",["$scope","$timeout","Todo",function(a,b,c){a.newTodo=void 0,a.states=["Critical","Important","Completed"],a.todos=c.query({}),a.toggleCompleted=function(a){a.completedAt?(a.state="Critical",a.completedAt=null):(a.state="Completed",a.completedAt=new Date),a.$update()},a.updateTodoState=function(a,b){a.state=b,a.completedAt="Completed"==b?JSON.stringify(new Date):null,a.$update()},a.toggleAdd=function(){a.newTodo=a.newTodo?void 0:new c({state:"Important"})},a.createTodo=function(){a.newTodo.$save(function(b){a.todos.push(b),a.newTodo=void 0})},a.deleteTodo=function(b){b.$delete(function(){a.todos.splice(a.todos.indexOf(b),1)})}}])});
define('components/todo/models/Todo',["app"],function(a){return a.factory("Todo",["$resource",function(a){return a("api/todos.json",{id:"@_id"})}])});
define('components/todo/directives/todoList',["app","lodash","jquery-ui"],function(a){a.registerDirective("todoList",["$timeout","Todo",function(){return{restrict:"E",replace:!0,templateUrl:"build/components/todo/directives/todo-list.tpl.html",scope:{title:"@",icon:"@",state:"@"},controller:["$scope",function(a){a.updateTodoState=a.$parent.updateTodoState,a.toggleCompleted=a.$parent.toggleCompleted,a.deleteTodo=a.$parent.deleteTodo,a.$parent.todos.$promise.then(function(b){a.todos=b}),a.filter={state:a.state}}],link:function(a,b){b.find(".todo").sortable({handle:".handle",connectWith:".todo",receive:function(b,c){var d=c.item.scope().todo,e=c.item.closest("[state]").attr("state");d&&e?a.updateTodoState(d,e):console.log("Wat",d,e),c.sender.sortable("cancel")}}).disableSelection()}}}])});
define('components/chat/module',["angular","angular-couch-potato","angular-sanitize"],function(a,b){var c=a.module("app.chat",["ngSanitize"]);return b.configureApp(c),c.run(["$couchPotato","$templateCache",function(a,b){c.lazy=a,b.put("template/popover/popover.html",'<div class="popover {{placement}}" ng-class="{ in: isOpen(), fade: animation() }">\n  <div class="arrow"></div>\n\n  <div class="popover-inner">\n      <h3 class="popover-title" ng-bind-html="title | unsafe" ng-show="title"></h3>\n      <div class="popover-content"ng-bind-html="content | unsafe"></div>\n  </div>\n</div>\n')}]).filter("unsafe",["$sce",function(a){return function(b){return a.trustAsHtml(b)}}]),c});
define('modules/graphs/module',["angular","angular-couch-potato","angular-ui-router"],function(a,b){var c=a.module("app.graphs",["ui.router"]);return b.configureApp(c),c.config(["$stateProvider","$couchPotatoProvider",function(a,b){a.state("app.graphs",{"abstract":!0,data:{title:"Graphs"}}).state("app.graphs.flot",{url:"/graphs/flot",data:{title:"Flot Charts"},views:{"content@app":{controller:"FlotCtrl",templateUrl:"build/modules/graphs/views/flot-charts.html",resolve:{deps:b.resolveDependencies(["modules/graphs/controllers/FlotCtrl","modules/graphs/directives/flot/flotBarChart","modules/graphs/directives/flot/flotSinChart","modules/graphs/directives/flot/flotHorizontalBarChart","modules/graphs/directives/flot/flotSalesChart","modules/graphs/directives/flot/flotFillChart","modules/graphs/directives/flot/flotPieChart","modules/graphs/directives/flot/flotSiteStatsChart","modules/graphs/directives/flot/flotAutoUpdatingChart"])}}}}).state("app.graphs.morris",{url:"/graphs/morris",data:{title:"Morris Charts"},views:{"content@app":{templateUrl:"build/modules/graphs/views/morris-charts.html",resolve:{deps:b.resolveDependencies(["modules/graphs/directives/morris/morrisSalesGraph","modules/graphs/directives/morris/morrisAreaGraph","modules/graphs/directives/morris/morrisBarGraph","modules/graphs/directives/morris/morrisNormalBarGraph","modules/graphs/directives/morris/morrisStackedBarGraph","modules/graphs/directives/morris/morrisYearGraph","modules/graphs/directives/morris/morrisDonutGraph","modules/graphs/directives/morris/morrisTimeGraph","modules/graphs/directives/morris/morrisLineGraphA","modules/graphs/directives/morris/morrisLineGraphB","modules/graphs/directives/morris/morrisLineGraphC","modules/graphs/directives/morris/morrisNoGridGraph"])}}}}).state("app.graphs.inline",{url:"/graphs/inline",data:{title:"Inline Charts"},views:{"content@app":{templateUrl:"build/modules/graphs/views/inline-charts.html",resolve:{deps:b.resolveDependencies(["modules/graphs/directives/inline/sparklineContainer","modules/graphs/directives/inline/easyPieChartContainer"])}}}}).state("app.graphs.dygraphs",{url:"/graphs/dygraphs",data:{title:"Dygraphs Charts"},views:{"content@app":{templateUrl:"build/modules/graphs/views/dygraphs-charts.html",resolve:{deps:b.resolveDependencies(["modules/graphs/directives/dygraphs/dygraphsNoRollPeriod","modules/graphs/directives/dygraphs/dygraphsNoRollTimestamp"])}}}}).state("app.graphs.chartjs",{url:"/graphs/chartjs",data:{title:"Chartjs"},views:{"content@app":{templateUrl:"build/modules/graphs/views/chartjs-charts.html",resolve:{deps:b.resolveDependencies(["modules/graphs/directives/chartjs/chartjsLineChart","modules/graphs/directives/chartjs/chartjsBarChart","modules/graphs/directives/chartjs/chartjsPolarChart","modules/graphs/directives/chartjs/chartjsDoughnutChart","modules/graphs/directives/chartjs/chartjsRadarChart","modules/graphs/directives/chartjs/chartjsPieChart"])}}}})}]),c.run(["$couchPotato",function(a){c.lazy=a}]),c});
define('modules/tables/module',["angular","angular-couch-potato","angular-ui-router"],function(a,b){var c=a.module("app.tables",["ui.router"]);return b.configureApp(c),c.config(["$stateProvider","$couchPotatoProvider",function(a,b){a.state("app.tables",{"abstract":!0,data:{title:"Tables"}}).state("app.tables.normal",{url:"/tables/normal",data:{title:"Normal Tables"},views:{"content@app":{templateUrl:"build/modules/tables/views/normal.html"}}}).state("app.tables.datatables",{url:"/tables/datatables",data:{title:"Data Tables"},views:{"content@app":{templateUrl:"build/modules/tables/views/datatables.html",resolve:{deps:b.resolveDependencies(["modules/tables/directives/datatables/datatableBasic","modules/tables/directives/datatables/datatableColumnFilter","modules/tables/directives/datatables/datatableColumnReorder","modules/tables/directives/datatables/datatableTableTools"])}}}}).state("app.tables.jqgrid",{url:"/tables/jqgrid",data:{title:"Jquery Grid"},views:{"content@app":{controller:"JqGridCtrl",templateUrl:"build/modules/tables/views/jqgrid.html",resolve:{deps:b.resolveDependencies(["modules/tables/controllers/JqGridCtrl","modules/tables/directives/jqgrid/jqGrid"])}}}})}]),c.run(["$couchPotato",function(a){c.lazy=a}]),c});
define('modules/forms/module',["angular","angular-couch-potato","angular-ui-router"],function(a,b){var c=a.module("app.forms",["ui.router"]);return b.configureApp(c),c.config(["$stateProvider","$couchPotatoProvider",function(a,b){a.state("app.form",{"abstract":!0,data:{title:"Forms"}}).state("app.form.elements",{url:"/form/elements",data:{title:"Form Elements"},views:{"content@app":{templateUrl:"build/modules/forms/views/form-elements.html"}}}).state("app.form.layouts",{url:"/form/layouts",data:{title:"Form Layouts"},views:{"content@app":{controller:"FormLayoutsCtrl",templateUrl:"build/modules/forms/views/form-layouts.html",resolve:{deps:b.resolveDependencies(["modules/forms/controllers/FormLayoutsCtrl","modules/forms/directives/form-layouts/smartCheckoutForm","modules/forms/directives/form-layouts/smartOrderForm","modules/forms/directives/form-layouts/smartReviewForm","modules/forms/directives/form-layouts/smartRegistrationForm","modules/forms/directives/form-layouts/smartCommentForm","modules/forms/directives/form-layouts/smartContactsForm","modules/forms/directives/input/smartMaskedInput","modules/forms/directives/input/smartDatepicker"])}}}}).state("app.form.validation",{url:"/form/validation",data:{title:"Form Validation"},views:{"content@app":{templateUrl:"build/modules/forms/views/form-validation.html"}}}).state("app.form.bootstrapForms",{url:"/form/bootstrap-forms",data:{title:"Bootstrap Forms"},views:{"content@app":{templateUrl:"build/modules/forms/views/bootstrap-forms.html"}}}).state("app.form.bootstrapValidation",{url:"/form/bootstrap-validation",data:{title:"Bootstrap Validation"},views:{"content@app":{templateUrl:"build/modules/forms/views/bootstrap-validation.html",resolve:{deps:b.resolveDependencies(["modules/forms/directives/bootstrap-validation/bootstrapMovieForm","modules/forms/directives/bootstrap-validation/bootstrapTogglingForm","modules/forms/directives/bootstrap-validation/bootstrapAttributeForm","modules/forms/directives/bootstrap-validation/bootstrapButtonGroupForm","modules/forms/directives/bootstrap-validation/bootstrapProductForm","modules/forms/directives/bootstrap-validation/bootstrapProfileForm","modules/forms/directives/bootstrap-validation/bootstrapContactForm"])}}}}).state("app.form.plugins",{url:"/form/plugins",data:{title:"Form Plugins"},views:{"content@app":{templateUrl:"build/modules/forms/views/form-plugins.html",controller:"FormPluginsCtrl",resolve:{deps:b.resolveDependencies(["modules/forms/directives/input/smartSpinner","modules/forms/directives/input/smartDatepicker","modules/forms/directives/input/smartTimepicker","modules/forms/directives/input/smartClockpicker","modules/forms/directives/input/smartNouislider","modules/forms/directives/input/smartIonslider","modules/forms/directives/input/smartDuallistbox","modules/forms/directives/input/smartColorpicker","modules/forms/directives/input/smartKnob","modules/forms/directives/input/smartUislider","modules/forms/directives/input/smartSelect2","modules/forms/directives/input/smartMaskedInput","modules/forms/directives/input/smartTagsinput","modules/forms/directives/input/smartXEditable","modules/forms/controllers/FormXeditableCtrl","modules/forms/controllers/FormPluginsCtrl"])}}}}).state("app.form.wizards",{url:"/form/wizards",data:{title:"Wizards"},views:{"content@app":{templateUrl:"build/modules/forms/views/form-wizards.html",controller:"FormWizardCtrl",resolve:{deps:b.resolveDependencies(["modules/forms/directives/validate/smartValidateForm","modules/forms/directives/wizard/smartWizard","modules/forms/directives/wizard/smartFueluxWizard","modules/forms/directives/input/smartMaskedInput","modules/forms/controllers/FormWizardCtrl"])}}}}).state("app.form.editors",{url:"/form/editors",data:{title:"Editors"},views:{"content@app":{templateUrl:"build/modules/forms/views/form-editors.html",resolve:{deps:b.resolveDependencies(["modules/forms/directives/editors/smartMarkdownEditor","modules/forms/directives/editors/smartSummernoteEditor","modules/forms/directives/editors/smartEditSummernote","modules/forms/directives/editors/smartDestroySummernote"])}}}}).state("app.form.dropzone",{url:"/form/dropzone",data:{title:"Dropzone"},views:{"content@app":{templateUrl:"build/modules/forms/views/dropzone.html",resolve:{deps:b.resolveDependencies(["modules/forms/directives/upload/smartDropzone"])}}}}).state("app.form.imageEditor",{url:"/form/image-editor",data:{title:"Image Editor"},views:{"content@app":{templateUrl:"build/modules/forms/views/image-editor.html",controller:"ImageEditorCtrl",resolve:{deps:b.resolveDependencies(["modules/forms/controllers/ImageEditorCtrl","modules/forms/directives/image-editor/smartJcrop"])}}}})}]),c.run(["$couchPotato",function(a){c.lazy=a}]),c});
define('modules/ui/module',["angular","angular-couch-potato","angular-ui-router"],function(a,b){var c=angular.module("app.ui",["ui.router"]);return b.configureApp(c),c.config(["$stateProvider","$couchPotatoProvider",function(a,b){a.state("app.ui",{"abstract":!0,data:{title:"UI Elements"}}).state("app.ui.general",{url:"/ui/general",data:{title:"General Elements"},views:{"content@app":{templateUrl:"build/modules/ui/views/general-elements.html",controller:"GeneralElementsCtrl",resolve:{deps:b.resolveDependencies(["modules/ui/controllers/GeneralElementsCtrl","modules/ui/directives/smartHtmlPopover","modules/ui/directives/smartProgressbar","modules/ui/directives/smartRideCarousel"])}}}}).state("app.ui.buttons",{url:"/ui/buttons",data:{title:"Buttons"},views:{"content@app":{templateUrl:"build/modules/ui/views/buttons.html",controller:"GeneralElementsCtrl",resolve:{deps:b.resolveDependencies(["modules/ui/controllers/GeneralElementsCtrl","modules/ui/directives/smartHtmlPopover","modules/ui/directives/smartProgressbar","modules/ui/directives/smartRideCarousel"])}}}}).state("app.ui.iconsFa",{url:"/ui/icons-font-awesome",data:{title:"Font Awesome"},views:{"content@app":{templateUrl:"build/modules/ui/views/icons-fa.html",resolve:{deps:b.resolveDependencies(["modules/ui/directives/smartClassFilter"])}}}}).state("app.ui.iconsGlyph",{url:"/ui/icons-glyph",data:{title:"Glyph Icons"},views:{"content@app":{templateUrl:"build/modules/ui/views/icons-glyph.html",resolve:{deps:b.resolveDependencies(["modules/ui/directives/smartClassFilter"])}}}}).state("app.ui.iconsFlags",{url:"/ui/icons-flags",data:{title:"Flags"},views:{"content@app":{templateUrl:"build/modules/ui/views/icons-flags.html",resolve:{deps:b.resolveDependencies(["modules/ui/directives/smartClassFilter"])}}}}).state("app.ui.grid",{url:"/ui/grid",data:{title:"Grid"},views:{"content@app":{templateUrl:"build/modules/ui/views/grid.html"}}}).state("app.ui.treeView",{url:"/ui/tree-view",data:{title:"Tree View"},views:{"content@app":{templateUrl:"build/modules/ui/views/tree-view.html",controller:"TreeviewCtrl",resolve:{deps:b.resolveDependencies(["modules/ui/controllers/TreeviewCtrl","modules/ui/directives/smartTreeview"])}}}}).state("app.ui.nestableLists",{url:"/ui/nestable-lists",data:{title:"Nestable Lists"},views:{"content@app":{templateUrl:"build/modules/ui/views/nestable-lists.html",resolve:{deps:b.resolveDependencies(["modules/graphs/directives/inline/easyPieChartContainer","modules/ui/directives/smartNestable"])}}}}).state("app.ui.jqueryUi",{url:"/ui/jquery-ui",data:{title:"JQuery UI"},views:{"content@app":{templateUrl:"build/modules/ui/views/jquery-ui.html",controller:"JquiCtrl",resolve:{deps:b.resolveDependencies(["modules/ui/controllers/JquiCtrl","modules/forms/directives/input/smartUislider","modules/forms/directives/input/smartSpinner","modules/ui/directives/smartJquiDialog","modules/ui/directives/smartJquiDialogLauncher","modules/ui/directives/smartProgressbar","modules/ui/directives/smartJquiAccordion","modules/ui/directives/smartJquiAutocomplete","modules/ui/directives/smartJquiAjaxAutocomplete","modules/ui/directives/smartJquiMenu","modules/ui/directives/smartJquiTabs","modules/ui/directives/smartJquiDynamicTabs"])}}}}).state("app.ui.typography",{url:"/ui/typography",data:{title:"JQuery UI"},views:{"content@app":{templateUrl:"build/modules/ui/views/typography.html"}}})}]),c.run(["$couchPotato",function(a){c.lazy=a}]),c});
define('modules/maps/module',["angular","angular-couch-potato","angular-google-maps","angular-ui-router"],function(a,b){var c=a.module("app.maps",["ui.router","google-maps".ns()]);return b.configureApp(c),c.config(["$stateProvider","$couchPotatoProvider","uiGmapGoogleMapApiProvider",function(a,b,c){c.configure({key:"AIzaSyD5Ybgnvx6jbYGpq7IncsWFc6rkUNrzUzw",v:"3.17"}),a.state("app.maps",{url:"/maps",data:{title:"Maps"},views:{"content@app":{controller:"MapsDemoCtrl",templateUrl:"build/modules/maps/views/maps-demo.html",resolve:{deps:b.resolveDependencies(["layout/directives/smartFitAppView","modules/maps/controllers/MapsDemoCtrl","modules/maps/directives/smartMapInstance","modules/maps/models/SmartMapInstances","modules/maps/models/SmartMapStyle"]),api:["uiGmapGoogleMapApi",function(a){return a}]}}}})}]),c.run(["$couchPotato",function(a){c.lazy=a}]),c});
define('modules/app-views/module',["angular","angular-couch-potato","angular-ui-router"],function(a,b){var c=a.module("app.appViews",["ui.router"]);return b.configureApp(c),c.config(["$stateProvider","$couchPotatoProvider",function(a,b){a.state("app.appViews",{"abstract":!0,data:{title:"App views"}}).state("app.appViews.projects",{url:"/projects",data:{title:"Projects"},views:{"content@app":{templateUrl:"build/modules/app-views/views/project-list.html",controller:"ProjectsDemoCtrl",resolve:{projects:["$http",function(a){return a.get("api/project-list.json")}],deps:b.resolveDependencies(["modules/graphs/directives/inline/sparklineContainer","modules/app-views/controllers/ProjectsDemoCtrl","modules/tables/directives/datatables/datatableBasic"])}}}}).state("app.appViews.blogDemo",{url:"/blog",data:{title:"Blog"},views:{"content@app":{templateUrl:"build/modules/app-views/views/blog-demo.html"}}}).state("app.appViews.galleryDemo",{url:"/gallery",data:{title:"Gallery"},views:{"content@app":{templateUrl:"build/modules/app-views/views/gallery-demo.html",resolve:{deps:b.resolveDependencies(["modules/ui/directives/smartSuperBox"])}}}}).state("app.appViews.forumDemo",{url:"/forum",data:{title:"Forum"},views:{"content@app":{templateUrl:"build/modules/app-views/views/forum-demo.html"}}}).state("app.appViews.forumTopicDemo",{url:"/forum-topic",data:{title:"Forum Topic"},views:{"content@app":{templateUrl:"build/modules/app-views/views/forum-topic-demo.html"}}}).state("app.appViews.forumPostDemo",{url:"/forum-post",data:{title:"Forum Post"},views:{"content@app":{templateUrl:"build/modules/app-views/views/forum-post-demo.html",resolve:{deps:b.resolveDependencies(["modules/graphs/directives/inline/sparklineContainer","modules/graphs/directives/inline/easyPieChartContainer","modules/forms/directives/editors/smartSummernoteEditor"])}}}}).state("app.appViews.profileDemo",{url:"/profile",data:{title:"Profile"},views:{"content@app":{templateUrl:"build/modules/app-views/views/profile-demo.html"}}}).state("app.appViews.timelineDemo",{url:"/timeline",data:{title:"Timeline"},views:{"content@app":{templateUrl:"build/modules/app-views/views/timeline-demo.html",resolve:{deps:b.resolveDependencies(["modules/graphs/directives/inline/sparklineContainer","modules/graphs/directives/inline/easyPieChartContainer"])}}}})}]),c.run(["$couchPotato",function(a){c.lazy=a}]),c});
define('modules/misc/module',["angular","angular-couch-potato","angular-ui-router"],function(a,b){var c=a.module("app.misc",["ui.router"]);return b.configureApp(c),c.config(["$stateProvider","$couchPotatoProvider",function(a,b){a.state("app.misc",{"abstract":!0,data:{title:"Miscellaneous"}}).state("app.misc.pricingTable",{url:"/pricing-table",data:{title:"Pricing Table"},views:{"content@app":{templateUrl:"build/modules/misc/views/pricing-table.html"}}}).state("app.misc.invoice",{url:"/invoice",data:{title:"Invoice"},views:{"content@app":{templateUrl:"build/modules/misc/views/invoice.html"}}}).state("app.misc.error404",{url:"/404",data:{title:"Error 404"},views:{"content@app":{templateUrl:"build/modules/misc/views/error404.html"}}}).state("app.misc.error500",{url:"/500",data:{title:"Error 500"},views:{"content@app":{templateUrl:"build/modules/misc/views/error500.html"}}}).state("app.misc.blank",{url:"/blank",data:{title:"Blank"},views:{"content@app":{templateUrl:"build/modules/misc/views/blank.html"}}}).state("app.misc.emailTemplate",{url:"/email-template",data:{title:"Email Template"},views:{"content@app":{templateUrl:"build/modules/misc/views/email-template.html"}}}).state("app.misc.search",{url:"/search",data:{title:"Search"},views:{"content@app":{templateUrl:"build/modules/misc/views/search.html"}}}).state("app.misc.ckeditor",{url:"/ckeditor",data:{title:"CK Editor"},views:{"content@app":{templateUrl:"build/modules/misc/views/ckeditor.html",resolve:{deps:b.resolveDependencies(["modules/forms/directives/editors/smartCkEditor"])}}}})}]),c.run(["$couchPotato",function(a){c.lazy=a}]),c});
define('modules/smart-admin/module',["angular","angular-couch-potato","angular-ui-router"],function(a,b){var c=a.module("app.smartAdmin",["ui.router"]);return b.configureApp(c),c.config(["$stateProvider","$couchPotatoProvider",function(a){a.state("app.smartAdmin",{"abstract":!0,data:{title:"SmartAdmin Intel"}}).state("app.smartAdmin.appLayout",{url:"/app-layout",data:{title:"App Layout"},views:{"content@app":{templateUrl:"build/modules/smart-admin/views/app-layout.html"}}}).state("app.smartAdmin.diffVer",{url:"/different-versions",data:{title:"Different Versions"},views:{"content@app":{templateUrl:"build/modules/smart-admin/views/different-versions.html"}}})}]),c.run(["$couchPotato",function(a){c.lazy=a}]),c});
define('smart-templates',["angular"],function(){angular.module("smart-templates",[]).run(["$templateCache",function(a){a.put("build/auth/directives/login-info.tpl.html",'<div class="login-info ng-cloak">\n    <span> <!-- User image size is adjusted inside CSS, it should stay as it -->\n        <a  href="" toggle-shortcut>\n            <img ng-src="{{user.picture}}" alt="me" class="online">\n                <span>{{user.username}}\n                </span>\n            <i class="fa fa-angle-down"></i>\n        </a>\n     </span>\n</div>'),a.put("build/components/calendar/directives/full-calendar.tpl.html",'<div jarvis-widget data-widget-color="blueDark">\n    <header>\n        <span class="widget-icon"> <i class="fa fa-calendar"></i> </span>\n\n        <h2> My Events </h2>\n\n        <div class="widget-toolbar">\n            <!-- add: non-hidden - to disable auto hide -->\n            <div class="btn-group" dropdown >\n                <button class="btn dropdown-toggle btn-xs btn-default">\n                    Showing <i class="fa fa-caret-down"></i>\n                </button>\n                <ul class="dropdown-menu js-status-update pull-right">\n                    <li>\n                        <a ng-click="changeView(\'month\')">Month</a>\n                    </li>\n                    <li>\n                        <a ng-click="changeView(\'agendaWeek\')">Agenda</a>\n                    </li>\n                    <li>\n                        <a ng-click="changeView(\'agendaDay\')">Today</a>\n                    </li>\n                </ul>\n            </div>\n        </div>\n    </header>\n\n    <!-- widget div-->\n    <div>\n        <div class="widget-body no-padding">\n            <!-- content goes here -->\n            <div class="widget-body-toolbar">\n\n                <div id="calendar-buttons">\n\n                    <div class="btn-group">\n                        <a ng-click="prev()" class="btn btn-default btn-xs"><i\n                                class="fa fa-chevron-left"></i></a>\n                        <a ng-click="next()" class="btn btn-default btn-xs"><i\n                                class="fa fa-chevron-right"></i></a>\n                    </div>\n                </div>\n            </div>\n            <div id="calendar"></div>\n\n            <!-- end content -->\n        </div>\n\n    </div>\n    <!-- end widget div -->\n</div>\n'),a.put("build/components/calendar/views/calendar.tpl.html",'<!-- MAIN CONTENT -->\n<div id="content">\n\n    <div class="row">\n        <big-breadcrumbs items="[\'Home\', \'Calendar\']" class="col-xs-12 col-sm-7 col-md-7 col-lg-4"></big-breadcrumbs>\n        <div smart-include="build/layout/partials/sub-header.tpl.html"></div>\n    </div>\n    <!-- widget grid -->\n    <section id="widget-grid" widget-grid>\n        <!-- row -->\n        <div class="row" ng-controller="CalendarCtrl" >\n\n\n            <div class="col-sm-12 col-md-12 col-lg-3">\n                <!-- new widget -->\n                <div class="jarviswidget jarviswidget-color-blueDark">\n                    <header>\n                        <h2> Add Events </h2>\n                    </header>\n\n                    <!-- widget div-->\n                    <div>\n\n                        <div class="widget-body">\n                            <!-- content goes here -->\n\n                            <form id="add-event-form">\n                                <fieldset>\n\n                                    <div class="form-group">\n                                        <label>Select Event Icon</label>\n                                        <div class="btn-group btn-group-sm btn-group-justified" data-toggle="buttons" > <!--  -->\n                                            <label class="btn btn-default active">\n                                                <input type="radio" name="iconselect" id="icon-1" value="fa-info" radio-toggle ng-model="newEvent.icon">\n                                                <i class="fa fa-info text-muted"></i> </label>\n                                            <label class="btn btn-default">\n                                                <input type="radio" name="iconselect" id="icon-2" value="fa-warning" radio-toggle  ng-model="newEvent.icon">\n                                                <i class="fa fa-warning text-muted"></i> </label>\n                                            <label class="btn btn-default">\n                                                <input type="radio" name="iconselect" id="icon-3" value="fa-check" radio-toggle  ng-model="newEvent.icon">\n                                                <i class="fa fa-check text-muted"></i> </label>\n                                            <label class="btn btn-default">\n                                                <input type="radio" name="iconselect" id="icon-4" value="fa-user" radio-toggle  ng-model="newEvent.icon">\n                                                <i class="fa fa-user text-muted"></i> </label>\n                                            <label class="btn btn-default">\n                                                <input type="radio" name="iconselect" id="icon-5" value="fa-lock" radio-toggle  ng-model="newEvent.icon">\n                                                <i class="fa fa-lock text-muted"></i> </label>\n                                            <label class="btn btn-default">\n                                                <input type="radio" name="iconselect" id="icon-6" value="fa-clock-o" radio-toggle  ng-model="newEvent.icon">\n                                                <i class="fa fa-clock-o text-muted"></i> </label>\n                                        </div>\n                                    </div>\n\n                                    <div class="form-group">\n                                        <label>Event Title</label>\n                                        <input ng-model="newEvent.title" class="form-control"  id="title" name="title" maxlength="40" type="text" placeholder="Event Title">\n                                    </div>\n                                    <div class="form-group">\n                                        <label>Event Description</label>\n                                        <textarea  ng-model="newEvent.description" class="form-control" placeholder="Please be brief" rows="3" maxlength="40" id="description"></textarea>\n                                        <p class="note">Maxlength is set to 40 characters</p>\n                                    </div>\n\n                                    <div class="form-group">\n                                        <label>Select Event Color</label>\n                                        <div class="btn-group btn-group-justified btn-select-tick" data-toggle="buttons" >\n                                            <label class="btn bg-color-darken active">\n                                                <input   ng-model="newEvent.className" radio-toggle   type="radio" name="priority" id="option1" value="bg-color-darken txt-color-white" >\n                                                <i class="fa fa-check txt-color-white"></i> </label>\n                                            <label class="btn bg-color-blue">\n                                                <input  ng-model="newEvent.className" radio-toggle   type="radio" name="priority" id="option2" value="bg-color-blue txt-color-white">\n                                                <i class="fa fa-check txt-color-white"></i> </label>\n                                            <label class="btn bg-color-orange">\n                                                <input  ng-model="newEvent.className" radio-toggle   type="radio" name="priority" id="option3" value="bg-color-orange txt-color-white">\n                                                <i class="fa fa-check txt-color-white"></i> </label>\n                                            <label class="btn bg-color-greenLight">\n                                                <input  ng-model="newEvent.className" radio-toggle   type="radio" name="priority" id="option4" value="bg-color-greenLight txt-color-white">\n                                                <i class="fa fa-check txt-color-white"></i> </label>\n                                            <label class="btn bg-color-blueLight">\n                                                <input  ng-model="newEvent.className" radio-toggle   type="radio" name="priority" id="option5" value="bg-color-blueLight txt-color-white">\n                                                <i class="fa fa-check txt-color-white"></i> </label>\n                                            <label class="btn bg-color-red">\n                                                <input  ng-model="newEvent.className" radio-toggle   type="radio" name="priority" id="option6" value="bg-color-red txt-color-white">\n                                                <i class="fa fa-check txt-color-white"></i> </label>\n                                        </div>\n                                    </div>\n\n                                </fieldset>\n                                <div class="form-actions">\n                                    <div class="row">\n                                        <div class="col-md-12">\n                                            <button class="btn btn-default" type="button" id="add-event" ng-click="addEvent()" >\n                                                Add Event\n                                            </button>\n                                        </div>\n                                    </div>\n                                </div>\n                            </form>\n\n                            <!-- end content -->\n                        </div>\n\n                    </div>\n                    <!-- end widget div -->\n                </div>\n                <!-- end widget -->\n\n                <div class="well well-sm" id="event-container">\n                    <form>\n                        <legend>\n                            Draggable Events\n                        </legend>\n                        <ul id=\'external-events\' class="list-unstyled">\n\n                            <li ng-repeat="event in eventsExternal" dragable-event>\n                                <span class="{{event.className}}" \n                                    data-description="{{event.description}}"\n                                    data-icon="{{event.icon}}"\n                                >\n                                {{event.title}}</span>\n                            </li>\n                            \n                        </ul>\n\n                        <!-- <ul id=\'external-events\' class="list-unstyled">\n                            <li>\n                                <span class="bg-color-darken txt-color-white" data-description="Currently busy" data-icon="fa-time">Office Meeting</span>\n                            </li>\n                            <li>\n                                <span class="bg-color-blue txt-color-white" data-description="No Description" data-icon="fa-pie">Lunch Break</span>\n                            </li>\n                            <li>\n                                <span class="bg-color-red txt-color-white" data-description="Urgent Tasks" data-icon="fa-alert">URGENT</span>\n                            </li>\n                        </ul> -->\n\n                        <div class="checkbox">\n                            <label>\n                                <input type="checkbox" id="drop-remove" class="checkbox style-0" checked="checked">\n                                <span>remove after drop</span> </label>\n\n                        </div>\n                    </form>\n\n                </div>\n            </div>\n\n\n            <article class="col-sm-12 col-md-12 col-lg-9">\n                <full-calendar id="main-calendar-widget" data-events="events"></full-calendar>\n            </article>\n        </div>\n    </section>\n</div>'),a.put("build/components/chat/directives/aside-chat-widget.tpl.html",'<ul>\n    <li>\n        <div class="display-users">\n            <input class="form-control chat-user-filter" placeholder="Filter" type="text">\n            <dl>\n                <dt>\n                    <a href="#" class="usr"\n                       data-chat-id="cha1"\n                       data-chat-fname="Sadi"\n                       data-chat-lname="Orlaf"\n                       data-chat-status="busy"\n                       data-chat-alertmsg="Sadi Orlaf is in a meeting. Please do not disturb!"\n                       data-chat-alertshow="true"\n                       popover-trigger="mouseenter"\n                       popover-placement="right"\n                       popover="\n										<div class=\'usr-card\'>\n											<img src=\'styles/img/avatars/5.png\' alt=\'Sadi Orlaf\'>\n											<div class=\'usr-card-content\'>\n												<h3>Sadi Orlaf</h3>\n												<p>Marketing Executive</p>\n											</div>\n										</div>\n									">\n                        <i></i>Sadi Orlaf\n                    </a>\n                </dt>\n                <dt>\n                    <a href="#" class="usr"\n                       data-chat-id="cha2"\n                       data-chat-fname="Jessica"\n                       data-chat-lname="Dolof"\n                       data-chat-status="online"\n                       data-chat-alertmsg=""\n                       data-chat-alertshow="false"\n                       popover-trigger="mouseenter"\n                       popover-placement="right"\n                       popover="\n										<div class=\'usr-card\'>\n											<img src=\'styles/img/avatars/1.png\' alt=\'Jessica Dolof\'>\n											<div class=\'usr-card-content\'>\n												<h3>Jessica Dolof</h3>\n												<p>Sales Administrator</p>\n											</div>\n										</div>\n									">\n                        <i></i>Jessica Dolof\n                    </a>\n                </dt>\n                <dt>\n                    <a href="#" class="usr"\n                       data-chat-id="cha3"\n                       data-chat-fname="Zekarburg"\n                       data-chat-lname="Almandalie"\n                       data-chat-status="online"\n                       popover-trigger="mouseenter"\n                       popover-placement="right"\n                       popover="\n										<div class=\'usr-card\'>\n											<img src=\'styles/img/avatars/3.png\' alt=\'Zekarburg Almandalie\'>\n											<div class=\'usr-card-content\'>\n												<h3>Zekarburg Almandalie</h3>\n												<p>Sales Admin</p>\n											</div>\n										</div>\n									">\n                        <i></i>Zekarburg Almandalie\n                    </a>\n                </dt>\n                <dt>\n                    <a href="#" class="usr"\n                       data-chat-id="cha4"\n                       data-chat-fname="Barley"\n                       data-chat-lname="Krazurkth"\n                       data-chat-status="away"\n                       popover-trigger="mouseenter"\n                       popover-placement="right"\n                       popover="\n										<div class=\'usr-card\'>\n											<img src=\'styles/img/avatars/4.png\' alt=\'Barley Krazurkth\'>\n											<div class=\'usr-card-content\'>\n												<h3>Barley Krazurkth</h3>\n												<p>Sales Director</p>\n											</div>\n										</div>\n									">\n                        <i></i>Barley Krazurkth\n                    </a>\n                </dt>\n                <dt>\n                    <a href="#" class="usr offline"\n                       data-chat-id="cha5"\n                       data-chat-fname="Farhana"\n                       data-chat-lname="Amrin"\n                       data-chat-status="incognito"\n                       popover-trigger="mouseenter"\n                       popover-placement="right"\n                       popover="\n										<div class=\'usr-card\'>\n											<img src=\'styles/img/avatars/female.png\' alt=\'Farhana Amrin\'>\n											<div class=\'usr-card-content\'>\n												<h3>Farhana Amrin</h3>\n												<p>Support Admin <small><i class=\'fa fa-music\'></i> Playing Beethoven Classics</small></p>\n											</div>\n										</div>\n									">\n                        <i></i>Farhana Amrin (offline)\n                    </a>\n                </dt>\n                <dt>\n                    <a href="#" class="usr offline"\n                       data-chat-id="cha6"\n                       data-chat-fname="Lezley"\n                       data-chat-lname="Jacob"\n                       data-chat-status="incognito"\n                       popover-trigger="mouseenter"\n                       popover-placement="right"\n                       popover="\n										<div class=\'usr-card\'>\n											<img src=\'styles/img/avatars/male.png\' alt=\'Lezley Jacob\'>\n											<div class=\'usr-card-content\'>\n												<h3>Lezley Jacob</h3>\n												<p>Sales Director</p>\n											</div>\n										</div>\n									">\n                        <i></i>Lezley Jacob (offline)\n                    </a>\n                </dt>\n            </dl>\n\n\n            <!--<a href="chat.html" class="btn btn-xs btn-default btn-block sa-chat-learnmore-btn">About the API</a>-->\n        </div>\n    </li>\n</ul>'),a.put("build/components/chat/directives/chat-users.tpl.html",'<div id="chat-container" ng-class="{open: open}">\n    <span class="chat-list-open-close" ng-click="openToggle()"><i class="fa fa-user"></i><b>!</b></span>\n\n    <div class="chat-list-body custom-scroll">\n        <ul id="chat-users">\n            <li ng-repeat="chatUser in chatUsers | filter: chatUserFilter">\n                <a ng-click="messageTo(chatUser)"><img ng-src="{{chatUser.picture}}">{{chatUser.username}} <span\n                        class="badge badge-inverse">{{chatUser.username.length}}</span><span class="state"><i\n                        class="fa fa-circle txt-color-green pull-right"></i></span></a>\n            </li>\n        </ul>\n    </div>\n    <div class="chat-list-footer">\n        <div class="control-group">\n            <form class="smart-form">\n                <section>\n                    <label class="input" >\n                        <input type="text" ng-model="chatUserFilter" id="filter-chat-list" placeholder="Filter">\n                    </label>\n                </section>\n            </form>\n        </div>\n    </div>\n</div>'),a.put("build/components/chat/directives/chat-widget.tpl.html",'<div id="chat-widget" jarvis-widget data-widget-color="blueDark" data-widget-editbutton="false"\n     data-widget-fullscreenbutton="false">\n\n\n    <header>\n        <span class="widget-icon"> <i class="fa fa-comments txt-color-white"></i> </span>\n\n        <h2> SmartMessage </h2>\n\n        <div class="widget-toolbar">\n            <!-- add: non-hidden - to disable auto hide -->\n\n            <div class="btn-group" data-dropdown>\n                <button class="btn dropdown-toggle btn-xs btn-success">\n                    Status <i class="fa fa-caret-down"></i>\n                </button>\n                <ul class="dropdown-menu pull-right js-status-update">\n                    <li>\n                        <a href-void><i class="fa fa-circle txt-color-green"></i> Online</a>\n                    </li>\n                    <li>\n                        <a href-void><i class="fa fa-circle txt-color-red"></i> Busy</a>\n                    </li>\n                    <li>\n                        <a href-void><i class="fa fa-circle txt-color-orange"></i> Away</a>\n                    </li>\n                    <li class="divider"></li>\n                    <li>\n                        <a href-void><i class="fa fa-power-off"></i> Log Off</a>\n                    </li>\n                </ul>\n            </div>\n        </div>\n    </header>\n\n    <!-- widget div-->\n    <div>\n        <div class="widget-body widget-hide-overflow no-padding">\n            <!-- content goes here -->\n\n            <chat-users></chat-users>\n\n            <!-- CHAT BODY -->\n            <div id="chat-body" class="chat-body custom-scroll">\n                <ul>\n                    <li class="message" ng-repeat="message in chatMessages">\n                        <img class="message-picture online" ng-src="{{message.user.picture}}">\n\n                        <div class="message-text">\n                            <time>\n                                {{message.date | date }}\n                            </time>\n                            <a ng-click="messageTo(message.user)" class="username">{{message.user.username}}</a>\n                            <div ng-bind-html="message.body"></div>\n\n                        </div>\n                    </li>\n                </ul>\n            </div>\n\n            <!-- CHAT FOOTER -->\n            <div class="chat-footer">\n\n                <!-- CHAT TEXTAREA -->\n                <div class="textarea-div">\n\n                    <div class="typearea">\n                        <textarea placeholder="Write a reply..." id="textarea-expand"\n                                  class="custom-scroll" ng-model="newMessage"></textarea>\n                    </div>\n\n                </div>\n\n                <!-- CHAT REPLY/SEND -->\n											<span class="textarea-controls">\n												<button class="btn btn-sm btn-primary pull-right" ng-click="sendMessage()">\n                                                    Reply\n                                                </button> <span class="pull-right smart-form"\n                                                                style="margin-top: 3px; margin-right: 10px;"> <label\n                                                    class="checkbox pull-right">\n                                                <input type="checkbox" name="subscription" id="subscription">\n                                                <i></i>Press <strong> ENTER </strong> to send </label> </span> <a\n                                                    href-void class="pull-left"><i\n                                                    class="fa fa-camera fa-fw fa-lg"></i></a> </span>\n\n            </div>\n\n            <!-- end content -->\n        </div>\n\n    </div>\n    <!-- end widget div -->\n</div>'),a.put("build/components/language/language-selector.tpl.html",'<ul class="header-dropdown-list hidden-xs ng-cloak" ng-controller="LanguagesCtrl">\n    <li class="dropdown">\n        <a class="dropdown-toggle" href> <img src="styles/img/blank.gif" class="flag flag-{{currentLanguage.key}}" alt="{{currentLanguage.alt}}"> <span> {{currentLanguage.title}} </span>\n            <i class="fa fa-angle-down"></i> </a>\n        <ul class="dropdown-menu pull-right">\n            <li ng-class="{active: language==currentLanguage}" ng-repeat="language in languages">\n                <a ng-click="selectLanguage(language)" ><img src="styles/img/blank.gif" class="flag flag-{{language.key}}"\n                                                   alt="{{language.alt}}"> {{language.title}}</a>\n            </li>\n        </ul>\n    </li>\n</ul>'),a.put("build/components/projects/recent-projects.tpl.html",'<div class="project-context hidden-xs dropdown">\n\n    <span class="label">{{getWord(\'Projects\')}}:</span>\n    <span class="project-selector dropdown-toggle">{{getWord(\'Recent projects\')}} <i ng-if="projects.length"\n            class="fa fa-angle-down"></i></span>\n\n    <ul class="dropdown-menu" ng-if="projects.length">\n        <li ng-repeat="project in projects">\n            <a href="{{project.href}}">{{project.title}}</a>\n        </li>\n        <li class="divider"></li>\n        <li>\n            <a ng-click="clearProjects()"><i class="fa fa-power-off"></i> Clear</a>\n        </li>\n    </ul>\n\n</div>'),a.put("build/components/shortcut/shortcut.tpl.html",'<div id="shortcut">\n	<ul>\n		<li>\n			<a href="#/inbox/" class="jarvismetro-tile big-cubes bg-color-blue"> <span class="iconbox"> <i class="fa fa-envelope fa-4x"></i> <span>Mail <span class="label pull-right bg-color-darken">14</span></span> </span> </a>\n		</li>\n		<li>\n			<a href="#/calendar" class="jarvismetro-tile big-cubes bg-color-orangeDark"> <span class="iconbox"> <i class="fa fa-calendar fa-4x"></i> <span>Calendar</span> </span> </a>\n		</li>\n		<li>\n			<a href="#/maps" class="jarvismetro-tile big-cubes bg-color-purple"> <span class="iconbox"> <i class="fa fa-map-marker fa-4x"></i> <span>Maps</span> </span> </a>\n		</li>\n		<li>\n			<a href="#/invoice" class="jarvismetro-tile big-cubes bg-color-blueDark"> <span class="iconbox"> <i class="fa fa-book fa-4x"></i> <span>Invoice <span class="label pull-right bg-color-darken">99</span></span> </span> </a>\n		</li>\n		<li>\n			<a href="#/gallery" class="jarvismetro-tile big-cubes bg-color-greenLight"> <span class="iconbox"> <i class="fa fa-picture-o fa-4x"></i> <span>Gallery </span> </span> </a>\n		</li>\n		<li>\n			<a href="#/profile" class="jarvismetro-tile big-cubes selected bg-color-pinkDark"> <span class="iconbox"> <i class="fa fa-user fa-4x"></i> <span>My Profile </span> </span> </a>\n		</li>\n	</ul>\n</div>'),a.put("build/components/todo/directives/todo-list.tpl.html",'<div>\n    <h5 class="todo-group-title"><i class="fa fa-{{icon}}"></i> {{title}} (\n        <small class="num-of-tasks">{{scopeItems.length}}</small>\n        )\n    </h5>\n    <ul class="todo">\n        <li ng-class="{complete: todo.completedAt}" ng-repeat="todo in todos | filter: filter track by todo._id" >\n    	<span class="handle"> <label class="checkbox">\n            <input type="checkbox" ng-click="toggleCompleted(todo)" ng-checked="todo.completedAt"\n                   name="checkbox-inline">\n            <i></i> </label> </span>\n\n            <p>\n                <strong>Ticket #{{$index + 1}}</strong> - {{todo.title}}\n                <span class="text-muted" ng-if="todo.description">{{todo.description}}</span>\n                <span class="date">{{todo.createdAt | date}} &dash; <a ng-click="deleteTodo(todo)" class="text-muted"><i\n                        class="fa fa-trash"></i></a></span>\n\n            </p>\n        </li>\n    </ul>\n</div>'),a.put("build/components/todo/todo-widget.tpl.html",'<div id="todo-widget" jarvis-widget data-widget-editbutton="false" data-widget-color="blue"\n     ng-controller="TodoCtrl">\n    <header>\n        <span class="widget-icon"> <i class="fa fa-check txt-color-white"></i> </span>\n\n        <h2> ToDo\'s </h2>\n\n        <div class="widget-toolbar">\n            <!-- add: non-hidden - to disable auto hide -->\n            <button class="btn btn-xs btn-default" ng-class="{active: newTodo}" ng-click="toggleAdd()"><i ng-class="{ \'fa fa-plus\': !newTodo, \'fa fa-times\': newTodo}"></i> Add</button>\n\n        </div>\n    </header>\n    <!-- widget div-->\n    <div>\n        <div class="widget-body no-padding smart-form">\n            <!-- content goes here -->\n            <div ng-show="newTodo">\n                <h5 class="todo-group-title"><i class="fa fa-plus-circle"></i> New Todo</h5>\n\n                <form name="newTodoForm" class="smart-form">\n                    <fieldset>\n                        <section>\n                            <label class="input">\n                                <input type="text" required class="input-lg" ng-model="newTodo.title"\n                                       placeholder="What needs to be done?">\n                            </label>\n                        </section>\n                        <section>\n                            <div class="col-xs-6">\n                                <label class="select">\n                                    <select class="input-sm" ng-model="newTodo.state"\n                                            ng-options="state as state for state in states"></select> <i></i> </label>\n                            </div>\n                        </section>\n                    </fieldset>\n                    <footer>\n                        <button ng-disabled="newTodoForm.$invalid" type="button" class="btn btn-primary"\n                                ng-click="createTodo()">\n                            Add\n                        </button>\n                        <button type="button" class="btn btn-default" ng-click="toggleAdd()">\n                            Cancel\n                        </button>\n                    </footer>\n                </form>\n            </div>\n\n            <todo-list state="Critical"  title="Critical Tasks" icon="warning"></todo-list>\n\n            <todo-list state="Important" title="Important Tasks" icon="exclamation"></todo-list>\n\n            <todo-list state="Completed" title="Completed Tasks" icon="check"></todo-list>\n\n            <!-- end content -->\n        </div>\n\n    </div>\n    <!-- end widget div -->\n</div>'),a.put("build/dashboard/live-feeds.tpl.html",'<div jarvis-widget id="live-feeds-widget" data-widget-togglebutton="false" data-widget-editbutton="false"\n     data-widget-fullscreenbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">\n<!-- widget options:\nusage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false">\n\ndata-widget-colorbutton="false"\ndata-widget-editbutton="false"\ndata-widget-togglebutton="false"\ndata-widget-deletebutton="false"\ndata-widget-fullscreenbutton="false"\ndata-widget-custombutton="false"\ndata-widget-collapsed="true"\ndata-widget-sortable="false"\n\n-->\n<header>\n    <span class="widget-icon"> <i class="glyphicon glyphicon-stats txt-color-darken"></i> </span>\n\n    <h2>Live Feeds </h2>\n\n    <ul class="nav nav-tabs pull-right in" id="myTab">\n        <li class="active">\n            <a data-toggle="tab" href="#s1"><i class="fa fa-clock-o"></i> <span class="hidden-mobile hidden-tablet">Live Stats</span></a>\n        </li>\n\n        <li>\n            <a data-toggle="tab" href="#s2"><i class="fa fa-facebook"></i> <span class="hidden-mobile hidden-tablet">Social Network</span></a>\n        </li>\n\n        <li>\n            <a data-toggle="tab" href="#s3"><i class="fa fa-dollar"></i> <span class="hidden-mobile hidden-tablet">Revenue</span></a>\n        </li>\n    </ul>\n\n</header>\n\n<!-- widget div-->\n<div class="no-padding">\n\n    <div class="widget-body">\n        <!-- content -->\n        <div id="myTabContent" class="tab-content">\n            <div class="tab-pane fade active in padding-10 no-padding-bottom" id="s1">\n                <div class="row no-space">\n                    <div class="col-xs-12 col-sm-12 col-md-8 col-lg-8">\n														<span class="demo-liveupdate-1"> <span\n                                                                class="onoffswitch-title">Live switch</span> <span\n                                                                class="onoffswitch">\n																<input type="checkbox" name="start_interval" ng-model="autoUpdate"\n                                                                       class="onoffswitch-checkbox" id="start_interval">\n																<label class="onoffswitch-label" for="start_interval">\n                                                                    <span class="onoffswitch-inner"\n                                                                          data-swchon-text="ON"\n                                                                          data-swchoff-text="OFF"></span>\n                                                                    <span class="onoffswitch-switch"></span>\n                                                                </label> </span> </span>\n\n                        <div id="updating-chart" class="chart-large txt-color-blue" flot-basic flot-data="liveStats" flot-options="liveStatsOptions"></div>\n\n                    </div>\n                    <div class="col-xs-12 col-sm-12 col-md-4 col-lg-4 show-stats">\n\n                        <div class="row">\n                            <div class="col-xs-6 col-sm-6 col-md-12 col-lg-12"><span class="text"> My Tasks <span\n                                    class="pull-right">130/200</span> </span>\n\n                                <div class="progress">\n                                    <div class="progress-bar bg-color-blueDark" style="width: 65%;"></div>\n                                </div>\n                            </div>\n                            <div class="col-xs-6 col-sm-6 col-md-12 col-lg-12"><span class="text"> Transfered <span\n                                    class="pull-right">440 GB</span> </span>\n\n                                <div class="progress">\n                                    <div class="progress-bar bg-color-blue" style="width: 34%;"></div>\n                                </div>\n                            </div>\n                            <div class="col-xs-6 col-sm-6 col-md-12 col-lg-12"><span class="text"> Bugs Squashed<span\n                                    class="pull-right">77%</span> </span>\n\n                                <div class="progress">\n                                    <div class="progress-bar bg-color-blue" style="width: 77%;"></div>\n                                </div>\n                            </div>\n                            <div class="col-xs-6 col-sm-6 col-md-12 col-lg-12"><span class="text"> User Testing <span\n                                    class="pull-right">7 Days</span> </span>\n\n                                <div class="progress">\n                                    <div class="progress-bar bg-color-greenLight" style="width: 84%;"></div>\n                                </div>\n                            </div>\n\n                            <span class="show-stat-buttons"> <span class="col-xs-12 col-sm-6 col-md-6 col-lg-6"> <a\n                                    href-void class="btn btn-default btn-block hidden-xs">Generate PDF</a> </span> <span\n                                    class="col-xs-12 col-sm-6 col-md-6 col-lg-6"> <a href-void\n                                                                                     class="btn btn-default btn-block hidden-xs">Report\n                                a bug</a> </span> </span>\n\n                        </div>\n\n                    </div>\n                </div>\n\n                <div class="show-stat-microcharts" data-sparkline-container data-easy-pie-chart-container>\n                    <div class="col-xs-12 col-sm-3 col-md-3 col-lg-3">\n\n                        <div class="easy-pie-chart txt-color-orangeDark" data-percent="33" data-pie-size="50">\n                            <span class="percent percent-sign">35</span>\n                        </div>\n                        <span class="easy-pie-title"> Server Load <i class="fa fa-caret-up icon-color-bad"></i> </span>\n                        <ul class="smaller-stat hidden-sm pull-right">\n                            <li>\n                                <span class="label bg-color-greenLight"><i class="fa fa-caret-up"></i> 97%</span>\n                            </li>\n                            <li>\n                                <span class="label bg-color-blueLight"><i class="fa fa-caret-down"></i> 44%</span>\n                            </li>\n                        </ul>\n                        <div class="sparkline txt-color-greenLight hidden-sm hidden-md pull-right"\n                             data-sparkline-type="line" data-sparkline-height="33px" data-sparkline-width="70px"\n                             data-fill-color="transparent">\n                            130, 187, 250, 257, 200, 210, 300, 270, 363, 247, 270, 363, 247\n                        </div>\n                    </div>\n                    <div class="col-xs-12 col-sm-3 col-md-3 col-lg-3">\n                        <div class="easy-pie-chart txt-color-greenLight" data-percent="78.9" data-pie-size="50">\n                            <span class="percent percent-sign">78.9 </span>\n                        </div>\n                        <span class="easy-pie-title"> Disk Space <i class="fa fa-caret-down icon-color-good"></i></span>\n                        <ul class="smaller-stat hidden-sm pull-right">\n                            <li>\n                                <span class="label bg-color-blueDark"><i class="fa fa-caret-up"></i> 76%</span>\n                            </li>\n                            <li>\n                                <span class="label bg-color-blue"><i class="fa fa-caret-down"></i> 3%</span>\n                            </li>\n                        </ul>\n                        <div class="sparkline txt-color-blue hidden-sm hidden-md pull-right" data-sparkline-type="line"\n                             data-sparkline-height="33px" data-sparkline-width="70px" data-fill-color="transparent">\n                            257, 200, 210, 300, 270, 363, 130, 187, 250, 247, 270, 363, 247\n                        </div>\n                    </div>\n                    <div class="col-xs-12 col-sm-3 col-md-3 col-lg-3">\n                        <div class="easy-pie-chart txt-color-blue" data-percent="23" data-pie-size="50">\n                            <span class="percent percent-sign">23 </span>\n                        </div>\n                        <span class="easy-pie-title"> Transfered <i class="fa fa-caret-up icon-color-good"></i></span>\n                        <ul class="smaller-stat hidden-sm pull-right">\n                            <li>\n                                <span class="label bg-color-darken">10GB</span>\n                            </li>\n                            <li>\n                                <span class="label bg-color-blueDark"><i class="fa fa-caret-up"></i> 10%</span>\n                            </li>\n                        </ul>\n                        <div class="sparkline txt-color-darken hidden-sm hidden-md pull-right"\n                             data-sparkline-type="line" data-sparkline-height="33px" data-sparkline-width="70px"\n                             data-fill-color="transparent">\n                            200, 210, 363, 247, 300, 270, 130, 187, 250, 257, 363, 247, 270\n                        </div>\n                    </div>\n                    <div class="col-xs-12 col-sm-3 col-md-3 col-lg-3">\n                        <div class="easy-pie-chart txt-color-darken" data-percent="36" data-pie-size="50">\n                            <span class="percent degree-sign">36 <i class="fa fa-caret-up"></i></span>\n                        </div>\n                        <span class="easy-pie-title"> Temperature <i\n                                class="fa fa-caret-down icon-color-good"></i></span>\n                        <ul class="smaller-stat hidden-sm pull-right">\n                            <li>\n                                <span class="label bg-color-red"><i class="fa fa-caret-up"></i> 124</span>\n                            </li>\n                            <li>\n                                <span class="label bg-color-blue"><i class="fa fa-caret-down"></i> 40 F</span>\n                            </li>\n                        </ul>\n                        <div class="sparkline txt-color-red hidden-sm hidden-md pull-right" data-sparkline-type="line"\n                             data-sparkline-height="33px" data-sparkline-width="70px" data-fill-color="transparent">\n                            2700, 3631, 2471, 2700, 3631, 2471, 1300, 1877, 2500, 2577, 2000, 2100, 3000\n                        </div>\n                    </div>\n                </div>\n\n            </div>\n            <!-- end s1 tab pane -->\n\n            <div class="tab-pane fade" id="s2">\n                <div class="widget-body-toolbar bg-color-white">\n\n                    <form class="form-inline" role="form">\n\n                        <div class="form-group">\n                            <label class="sr-only" for="s123">Show From</label>\n                            <input type="email" class="form-control input-sm" id="s123" placeholder="Show From">\n                        </div>\n                        <div class="form-group">\n                            <input type="email" class="form-control input-sm" id="s124" placeholder="To">\n                        </div>\n\n                        <div class="btn-group hidden-phone pull-right">\n                            <a class="btn dropdown-toggle btn-xs btn-default" data-toggle="dropdown"><i\n                                    class="fa fa-cog"></i> More <span class="caret"> </span> </a>\n                            <ul class="dropdown-menu pull-right">\n                                <li>\n                                    <a href-void><i class="fa fa-file-text-alt"></i> Export to PDF</a>\n                                </li>\n                                <li>\n                                    <a href-void><i class="fa fa-question-sign"></i> Help</a>\n                                </li>\n                            </ul>\n                        </div>\n\n                    </form>\n\n                </div>\n                <div class="padding-10">\n                    <div id="statsChart" class="chart-large has-legend-unique" flot-basic flot-data="statsData" flot-options="statsDisplayOptions"></div>\n                </div>\n\n            </div>\n            <!-- end s2 tab pane -->\n\n            <div class="tab-pane fade" id="s3">\n\n                <div class="widget-body-toolbar bg-color-white smart-form" id="rev-toggles">\n\n                    <div class="inline-group">\n\n                        <label for="gra-0" class="checkbox">\n                            <input type="checkbox" id="gra-0" ng-model="targetsShow">\n                            <i></i> Target </label>\n                        <label for="gra-1" class="checkbox">\n                            <input type="checkbox" id="gra-1" ng-model="actualsShow">\n                            <i></i> Actual </label>\n                        <label for="gra-2" class="checkbox">\n                            <input type="checkbox" id="gra-2" ng-model="signupsShow">\n                            <i></i> Signups </label>\n                    </div>\n\n                    <div class="btn-group hidden-phone pull-right">\n                        <a class="btn dropdown-toggle btn-xs btn-default" data-toggle="dropdown"><i\n                                class="fa fa-cog"></i> More <span class="caret"> </span> </a>\n                        <ul class="dropdown-menu pull-right">\n                            <li>\n                                <a href-void><i class="fa fa-file-text-alt"></i> Export to PDF</a>\n                            </li>\n                            <li>\n                                <a href-void><i class="fa fa-question-sign"></i> Help</a>\n                            </li>\n                        </ul>\n                    </div>\n\n                </div>\n\n                <div class="padding-10">\n                    <div id="flotcontainer" class="chart-large has-legend-unique" flot-basic flot-data="revenewData" flot-options="revenewDisplayOptions"></div>\n                </div>\n            </div>\n            <!-- end s3 tab pane -->\n        </div>\n\n        <!-- end content -->\n    </div>\n\n</div>\n<!-- end widget div -->\n</div>\n'),a.put("build/layout/directives/demo/demo-states.tpl.html",'<div class="demo"><span id="demo-setting"><i class="fa fa-cog txt-color-blueDark"></i></span>\n\n    <form>\n        <legend class="no-padding margin-bottom-10">Layout Options</legend>\n        <section>\n            <label><input type="checkbox" ng-model="fixedHeader"\n                          class="checkbox style-0"><span>Fixed Header</span></label>\n            <label><input type="checkbox"\n                          ng-model="fixedNavigation"\n                          class="checkbox style-0"><span>Fixed Navigation</span></label>\n            <label><input type="checkbox"\n                          ng-model="fixedRibbon"\n                          class="checkbox style-0"><span>Fixed Ribbon</span></label>\n            <label><input type="checkbox"\n                          ng-model="fixedPageFooter"\n                          class="checkbox style-0"><span>Fixed Footer</span></label>\n            <label><input type="checkbox"\n                          ng-model="insideContainer"\n                          class="checkbox style-0"><span>Inside <b>.container</b></span></label>\n            <label><input type="checkbox"\n                          ng-model="rtl"\n                          class="checkbox style-0"><span>RTL</span></label>\n            <label><input type="checkbox"\n                          ng-model="menuOnTop"\n                          class="checkbox style-0"><span>Menu on <b>top</b></span></label>\n            <label><input type="checkbox"\n                          ng-model="colorblindFriendly"\n                          class="checkbox style-0"><span>For Colorblind <div\n                    class="font-xs text-right">(experimental)\n            </div></span>\n            </label><span id="smart-bgimages"></span></section>\n        <section><h6 class="margin-top-10 semi-bold margin-bottom-5">Clear Localstorage</h6><a\n                ng-click="factoryReset()" class="btn btn-xs btn-block btn-primary" id="reset-smart-widget"><i\n                class="fa fa-refresh"></i> Factory Reset</a></section>\n\n        <h6 class="margin-top-10 semi-bold margin-bottom-5">SmartAdmin Skins</h6>\n\n\n        <section id="smart-styles">\n            <a ng-repeat="skin in skins" ng-click="setSkin(skin)" class="{{skin.class}}" style="{{skin.style}}"><i ng-if="skin.name == $parent.smartSkin" class="fa fa-check fa-fw"></i> {{skin.label}}</a>\n        </section>\n    </form>\n</div>'),a.put("build/layout/layout.tpl.html",'<!-- HEADER -->\n<div data-smart-include="build/layout/partials/header.tpl.html" class="placeholder-header"></div>\n<!-- END HEADER -->\n\n\n<!-- Left panel : Navigation area -->\n<!-- Note: This width of the aside area can be adjusted through LESS variables -->\n<div data-smart-include="build/layout/partials/navigation.tpl.html" class="placeholder-left-panel"></div>\n\n<!-- END NAVIGATION -->\n\n<!-- MAIN PANEL -->\n<div id="main" role="main">\n\n    <demo-states></demo-states>\n\n    <!-- RIBBON -->\n    <div id="ribbon">\n\n				<span class="ribbon-button-alignment">\n					<span id="refresh" class="btn btn-ribbon" reset-widgets\n                          tooltip-placement="bottom"\n                          tooltip-html-unsafe="<i class=\'text-warning fa fa-warning\'></i> Warning! This will reset all your widget settings.">\n						<i class="fa fa-refresh"></i>\n					</span>\n				</span>\n\n        <!-- breadcrumb -->\n        <state-breadcrumbs></state-breadcrumbs>\n        <!-- end breadcrumb -->\n\n\n    </div>\n    <!-- END RIBBON -->\n\n\n    <div data-smart-router-animation-wrap="content content@app" data-wrap-for="#content">\n        <div data-ui-view="content" data-autoscroll="false"></div>\n    </div>\n\n</div>\n<!-- END MAIN PANEL -->\n\n<!-- PAGE FOOTER -->\n<div data-smart-include="build/layout/partials/footer.tpl.html"></div>\n\n<div data-smart-include="build/components/shortcut/shortcut.tpl.html"></div>\n\n<!-- END PAGE FOOTER -->\n\n\n'),a.put("build/layout/partials/footer.tpl.html",'<div class="page-footer">\n    <div class="row">\n        <div class="col-xs-12 col-sm-6">\n            <span class="txt-color-white">SmartAdmin WebApp © 2013-2014</span>\n        </div>\n\n        <div class="col-xs-6 col-sm-6 text-right hidden-xs">\n            <div class="txt-color-white inline-block">\n                <i class="txt-color-blueLight hidden-mobile">Last account activity <i class="fa fa-clock-o"></i>\n                    <strong>52 mins ago &nbsp;</strong> </i>\n\n                <div class="btn-group dropup">\n                    <button class="btn btn-xs dropdown-toggle bg-color-blue txt-color-white" data-toggle="dropdown">\n                        <i class="fa fa-link"></i> <span class="caret"></span>\n                    </button>\n                    <ul class="dropdown-menu pull-right text-left">\n                        <li>\n                            <div class="padding-5">\n                                <p class="txt-color-darken font-sm no-margin">Download Progress</p>\n\n                                <div class="progress progress-micro no-margin">\n                                    <div class="progress-bar progress-bar-success" style="width: 50%;"></div>\n                                </div>\n                            </div>\n                        </li>\n                        <li class="divider"></li>\n                        <li>\n                            <div class="padding-5">\n                                <p class="txt-color-darken font-sm no-margin">Server Load</p>\n\n                                <div class="progress progress-micro no-margin">\n                                    <div class="progress-bar progress-bar-success" style="width: 20%;"></div>\n                                </div>\n                            </div>\n                        </li>\n                        <li class="divider"></li>\n                        <li>\n                            <div class="padding-5">\n                                <p class="txt-color-darken font-sm no-margin">Memory Load <span class="text-danger">*critical*</span>\n                                </p>\n\n                                <div class="progress progress-micro no-margin">\n                                    <div class="progress-bar progress-bar-danger" style="width: 70%;"></div>\n                                </div>\n                            </div>\n                        </li>\n                        <li class="divider"></li>\n                        <li>\n                            <div class="padding-5">\n                                <button class="btn btn-block btn-default">refresh</button>\n                            </div>\n                        </li>\n                    </ul>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>'),a.put("build/layout/partials/header.tpl.html",'<header id="header">\n<div id="logo-group">\n\n    <!-- PLACE YOUR LOGO HERE -->\n    <span id="logo"> <img src="styles/img/logo.png" alt="SmartAdmin"> </span>\n    <!-- END LOGO PLACEHOLDER -->\n\n    <!-- Note: The activity badge color changes when clicked and resets the number to 0\n    Suggestion: You may want to set a flag when this happens to tick off all checked messages / notifications -->\n    <span id="activity" class="activity-dropdown" activities-dropdown-toggle> \n        <i class="fa fa-user"></i> \n        <b class="badge bg-color-red">21</b> \n    </span>\n    <div smart-include="build/components/activities/activities.html"></div>\n</div>\n\n\n<recent-projects></recent-projects>\n\n\n\n<!-- pulled right: nav area -->\n<div class="pull-right">\n\n    <!-- collapse menu button -->\n    <div id="hide-menu" class="btn-header pull-right">\n        <span> <a toggle-menu title="Collapse Menu"><i\n                class="fa fa-reorder"></i></a> </span>\n    </div>\n    <!-- end collapse menu -->\n\n    <!-- #MOBILE -->\n    <!-- Top menu profile link : this shows only when top menu is active -->\n    <ul id="mobile-profile-img" class="header-dropdown-list hidden-xs padding-5">\n        <li class="">\n            <a href="#" class="dropdown-toggle no-margin userdropdown" data-toggle="dropdown">\n                <img src="styles/img/avatars/sunny.png" alt="John Doe" class="online"/>\n            </a>\n            <ul class="dropdown-menu pull-right">\n                <li>\n                    <a href-void class="padding-10 padding-top-0 padding-bottom-0"><i\n                            class="fa fa-cog"></i> Setting</a>\n                </li>\n                <li class="divider"></li>\n                <li>\n                    <a ui-sref="app.appViews.profileDemo" class="padding-10 padding-top-0 padding-bottom-0"> <i class="fa fa-user"></i>\n                        <u>P</u>rofile</a>\n                </li>\n                <li class="divider"></li>\n                <li>\n                    <a href-void class="padding-10 padding-top-0 padding-bottom-0"\n                       data-action="toggleShortcut"><i class="fa fa-arrow-down"></i> <u>S</u>hortcut</a>\n                </li>\n                <li class="divider"></li>\n                <li>\n                    <a href-void class="padding-10 padding-top-0 padding-bottom-0"\n                       data-action="launchFullscreen"><i class="fa fa-arrows-alt"></i> Full <u>S</u>creen</a>\n                </li>\n                <li class="divider"></li>\n                <li>\n                    <a href="#/login" class="padding-10 padding-top-5 padding-bottom-5" data-action="userLogout"><i\n                            class="fa fa-sign-out fa-lg"></i> <strong><u>L</u>ogout</strong></a>\n                </li>\n            </ul>\n        </li>\n    </ul>\n\n    <!-- logout button -->\n    <div id="logout" class="btn-header transparent pull-right">\n        <span> <a ui-sref="login" title="Sign Out" data-action="userLogout"\n                  data-logout-msg="You can improve your security further after logging out by closing this opened browser"><i\n                class="fa fa-sign-out"></i></a> </span>\n    </div>\n    <!-- end logout button -->\n\n    <!-- search mobile button (this is hidden till mobile view port) -->\n    <div id="search-mobile" class="btn-header transparent pull-right" data-search-mobile>\n        <span> <a href="#" title="Search"><i class="fa fa-search"></i></a> </span>\n    </div>\n    <!-- end search mobile button -->\n\n    <!-- input: search field -->\n    <form action="#/search" class="header-search pull-right">\n        <input id="search-fld" type="text" name="param" placeholder="Find reports and more" data-autocomplete=\'[\n					"ActionScript",\n					"AppleScript",\n					"Asp",\n					"BASIC",\n					"C",\n					"C++",\n					"Clojure",\n					"COBOL",\n					"ColdFusion",\n					"Erlang",\n					"Fortran",\n					"Groovy",\n					"Haskell",\n					"Java",\n					"JavaScript",\n					"Lisp",\n					"Perl",\n					"PHP",\n					"Python",\n					"Ruby",\n					"Scala",\n					"Scheme"]\'>\n        <button type="submit">\n            <i class="fa fa-search"></i>\n        </button>\n        <a href="$" id="cancel-search-js" title="Cancel Search"><i class="fa fa-times"></i></a>\n    </form>\n    <!-- end input: search field -->\n\n    <!-- fullscreen button -->\n    <div id="fullscreen" class="btn-header transparent pull-right">\n        <span> <a full-screen title="Full Screen"><i\n                class="fa fa-arrows-alt"></i></a> </span>\n    </div>\n    <!-- end fullscreen button -->\n\n    <!-- #Voice Command: Start Speech -->\n    <div id="speech-btn" class="btn-header transparent pull-right hidden-sm hidden-xs">\n        <div>\n            <a title="Voice Command" id="voice-command-btn" speech-recognition><i class="fa fa-microphone"></i></a>\n\n            <div class="popover bottom">\n                <div class="arrow"></div>\n                <div class="popover-content">\n                    <h4 class="vc-title">Voice command activated <br>\n                        <small>Please speak clearly into the mic</small>\n                    </h4>\n                    <h4 class="vc-title-error text-center">\n                        <i class="fa fa-microphone-slash"></i> Voice command failed\n                        <br>\n                        <small class="txt-color-red">Must <strong>"Allow"</strong> Microphone</small>\n                        <br>\n                        <small class="txt-color-red">Must have <strong>Internet Connection</strong></small>\n                    </h4>\n                    <a href-void class="btn btn-success" id="speech-help-btn">See Commands</a>\n                    <a href-void class="btn bg-color-purple txt-color-white"\n                       onclick="$(\'#speech-btn .popover\').fadeOut(50);">Close Popup</a>\n                </div>\n            </div>\n        </div>\n    </div>\n    <!-- end voice command -->\n\n\n\n    <!-- multiple lang dropdown : find all flags in the flags page -->\n    <language-selector></language-selector>\n    <!-- end multiple lang -->\n\n</div>\n<!-- end pulled right: nav area -->\n\n</header>'),a.put("build/layout/partials/navigation.tpl.html",'<aside id="left-panel">\n\n    <!-- User info -->\n    <div login-info></div>\n    <!-- end user info -->\n\n    <!-- NAVIGATION : This navigation is also responsive\n\n    To make this navigation dynamic please make sure to link the node\n    (the reference to the nav > ul) after page load. Or the navigation\n    will not initialize.\n    -->\n    <nav>\n        <!-- NOTE: Notice the gaps after each icon usage <i></i>..\n        Please note that these links work a bit different than\n        traditional href="" links. See documentation for details.\n        -->\n\n        <ul data-smart-menu>\n            <li data-ui-sref-active="active">\n                <a data-ui-sref="app.dashboard" title="Dashboard"><i class="fa fa-lg fa-fw fa-home"></i> <span\n                        class="menu-item-parent">{{getWord(\'Dashboard\')}}</span></a>\n            </li>\n            <li data-ui-sref-active="active">\n                <a data-ui-sref="app.inbox.folder" title="Inbox">\n                    <i class="fa fa-lg fa-fw fa-inbox"></i> <span class="menu-item-parent">{{getWord(\'Inbox\')}}</span><span\n                        unread-messages-count class="badge pull-right inbox-badge"></span></a>\n            </li>\n            <li data-menu-collapse>\n                <a href="#"><i class="fa fa-lg fa-fw fa-bar-chart-o"></i> <span class="menu-item-parent">{{getWord(\'Graphs\')}}</span></a>\n                <ul>\n                    <li data-ui-sref-active="active">\n                        <a data-ui-sref="app.graphs.flot">{{getWord(\'Flot Chart\')}}</a>\n                    </li>\n                    <li data-ui-sref-active="active">\n                        <a data-ui-sref="app.graphs.morris">{{getWord(\'Morris Charts\')}}</a>\n                    </li>\n                    <li data-ui-sref-active="active">\n                        <a data-ui-sref="app.graphs.inline">{{getWord(\'Inline Charts\')}}</a>\n                    </li>\n                    <li data-ui-sref-active="active">\n                        <a data-ui-sref="app.graphs.dygraphs">{{getWord(\'Dygraphs\')}}</a>\n                    </li>\n                    <li data-ui-sref-active="active">\n                        <a data-ui-sref="app.graphs.chartjs">Chart.js <span\n                                class="badge pull-right inbox-badge bg-color-yellow">new</span></a>\n                    </li>\n                </ul>\n            </li>\n\n            <li data-menu-collapse>\n                <a href="#"><i class="fa fa-lg fa-fw fa-table"></i> <span class="menu-item-parent">{{getWord(\'Tables\')}}</span></a>\n                <ul>\n                    <li data-ui-sref-active="active">\n                        <a data-ui-sref="app.tables.normal">{{getWord(\'Normal Tables\')}}</a>\n                    </li>\n                    <li data-ui-sref-active="active">\n                        <a data-ui-sref="app.tables.datatables">{{getWord(\'Data Tables\')}} <span\n                                class="badge inbox-badge bg-color-greenLight">v1.10</span></a>\n                    </li>\n                    <li data-ui-sref-active="active">\n                        <a data-ui-sref="app.tables.jqgrid">{{getWord(\'Jquery Grid\')}}</a>\n                    </li>\n                </ul>\n            </li>\n\n            <li data-menu-collapse>\n                <a href="#"><i class="fa fa-lg fa-fw fa-pencil-square-o"></i> <span class="menu-item-parent">{{getWord(\'Forms\')}}</span></a>\n                <ul>\n                    <li data-ui-sref-active="active">\n                        <a data-ui-sref="app.form.elements">{{getWord(\'Smart Form Elements\')}}</a>\n                    </li>\n                    <li data-ui-sref-active="active">\n                        <a data-ui-sref="app.form.layouts">{{getWord(\'Smart Form Layouts\')}}</a>\n                    </li>\n                    <li data-ui-sref-active="active">\n                        <a data-ui-sref="app.form.validation">{{getWord(\'Smart Form Validation\')}}</a>\n                    </li>\n                    <li data-ui-sref-active="active">\n                        <a data-ui-sref="app.form.bootstrapForms">{{getWord(\'Bootstrap Form Elements\')}}</a>\n                    </li>\n                    <li data-ui-sref-active="active">\n                        <a data-ui-sref="app.form.bootstrapValidation">{{getWord(\'Bootstrap Form Validation\')}}</a>\n                    </li>\n                    <li data-ui-sref-active="active">\n                        <a data-ui-sref="app.form.plugins">{{getWord(\'Form Plugins\')}}</a>\n                    </li>\n                    <li data-ui-sref-active="active">\n                        <a data-ui-sref="app.form.wizards">{{getWord(\'Wizards\')}}</a>\n                    </li>\n                    <li data-ui-sref-active="active">\n                        <a data-ui-sref="app.form.editors">{{getWord(\'Bootstrap Editors\')}}</a>\n                    </li>\n                    <li data-ui-sref-active="active">\n                        <a data-ui-sref="app.form.dropzone">{{getWord(\'Dropzone\')}}</a>\n                    </li>\n                    <li data-ui-sref-active="active">\n                        <a data-ui-sref="app.form.imageEditor">{{getWord(\'Image Cropping\')}} <span class="badge pull-right inbox-badge bg-color-yellow">new</span></a>\n                    </li>\n                </ul>\n            </li>\n            <li data-menu-collapse>\n                <a href="#"><i class="fa fa-lg fa-fw fa-desktop"></i> <span class="menu-item-parent">{{getWord(\'UI Elements\')}}</span></a>\n                <ul>\n                    <li data-ui-sref-active="active">\n                        <a data-ui-sref="app.ui.general">{{getWord(\'General Elements\')}}</a>\n                    </li>\n                    <li data-ui-sref-active="active">\n                        <a data-ui-sref="app.ui.buttons">{{getWord(\'Buttons\')}}</a>\n                    </li>\n                    <li data-menu-collapse>\n                        <a href="#">{{getWord(\'Icons\')}}</a>\n                        <ul>\n                            <li data-ui-sref-active="active">\n                                <a data-ui-sref="app.ui.iconsFa"><i class="fa fa-plane"></i> {{getWord(\'Font Awesome\')}}</a>\n                            </li>\n                            <li data-ui-sref-active="active">\n                                <a data-ui-sref="app.ui.iconsGlyph" ><i class="glyphicon glyphicon-plane"></i> {{getWord(\'Glyph Icons\')}}</a>\n                            </li>\n                            <li data-ui-sref-active="active">\n                                <a data-ui-sref="app.ui.iconsFlags" ><i class="fa fa-flag"></i> {{getWord(\'Flags\')}}</a>\n                            </li>\n                        </ul>\n                    </li>\n                    <li data-ui-sref-active="active">\n                        <a data-ui-sref="app.ui.grid" >{{getWord(\'Grid\')}}</a>\n                    </li>\n                    <li data-ui-sref-active="active">\n                        <a data-ui-sref="app.ui.treeView">{{getWord(\'Tree View\')}}</a>\n                    </li>\n                    <li data-ui-sref-active="active">\n                        <a data-ui-sref="app.ui.nestableLists">{{getWord(\'Nestable Lists\')}}</a>\n                    </li>\n                    <li data-ui-sref-active="active">\n                        <a data-ui-sref="app.ui.jqueryUi">{{getWord(\'JQuery UI\')}}</a>\n                    </li>\n                    <li data-ui-sref-active="active">\n                        <a data-ui-sref="app.ui.typography">{{getWord(\'Typography\')}}</a>\n                    </li>\n                    <li data-menu-collapse>\n                        <a href="#">{{getWord(\'Six Level Menu\')}}</a>\n                        <ul>\n                            <li data-menu-collapse>\n                                <a href="#"><i class="fa fa-fw fa-folder-open"></i> {{getWord(\'Item #2\')}}</a>\n                                <ul>\n                                    <li data-menu-collapse>\n                                        <a href="#"><i class="fa fa-fw fa-folder-open"></i> {{getWord(\'Sub #2.1\')}} </a>\n                                        <ul>\n                                            <li>\n                                                <a href="#"><i class="fa fa-fw fa-file-text"></i> {{getWord(\'Item #2.1.1\')}}</a>\n                                            </li>\n                                            <li data-menu-collapse>\n                                                <a href="#"><i class="fa fa-fw fa-plus"></i>{{getWord(\'Expand\')}}</a>\n                                                <ul>\n                                                    <li>\n                                                        <a href="#"><i class="fa fa-fw fa-file-text"></i> {{getWord(\'File\')}}</a>\n                                                    </li>\n                                                    <li>\n                                                        <a href="#"><i class="fa fa-fw fa-trash-o"></i> {{getWord(\'Delete\')}}</a></li>\n                                                </ul>\n                                            </li>\n                                        </ul>\n                                    </li>\n                                </ul>\n                            </li>\n                            <li data-menu-collapse>\n                                <a href="#"><i class="fa fa-fw fa-folder-open"></i> {{getWord(\'Item #3\')}}</a>\n\n                                <ul>\n                                    <li data-menu-collapse>\n                                        <a href="#"><i class="fa fa-fw fa-folder-open"></i> {{getWord(\'3ed Level\')}} </a>\n                                        <ul>\n                                            <li>\n                                                <a href="#"><i class="fa fa-fw fa-file-text"></i> {{getWord(\'File\')}}</a>\n                                            </li>\n                                            <li>\n                                                <a href="#"><i class="fa fa-fw fa-file-text"></i> {{getWord(\'File\')}}</a>\n                                            </li>\n                                        </ul>\n                                    </li>\n                                </ul>\n\n                            </li>\n                        </ul>\n                    </li>\n                </ul>\n            </li>\n\n            <li data-ui-sref-active="active">\n                <a data-ui-sref="app.calendar" title="Calendar"><i class="fa fa-lg fa-fw fa-calendar"><em>3</em></i> <span\n                        class="menu-item-parent">{{getWord(\'Calendar\')}}</span></a>\n            </li>\n            <li data-ui-sref-active="active">\n                <a data-ui-sref="app.widgets" title="Widgets"><i class="fa fa-lg fa-fw fa-list-alt"></i><span\n                        class="menu-item-parent">{{getWord(\'Widgets\')}}</span></a>\n            </li>\n\n            <li data-menu-collapse>\n                <a  href="#" >\n                    <i class="fa fa-lg fa-fw fa-puzzle-piece"></i> <span class="menu-item-parent">{{getWord(\'App Views\')}}</span></a>\n                <ul>\n                    <li data-ui-sref-active="active">\n                        <a data-ui-sref="app.appViews.projects"><i class="fa fa-file-text-o"></i> {{getWord(\'Projects\')}}</a>\n                    </li>\n                    <li data-ui-sref-active="active">\n                        <a data-ui-sref="app.appViews.blogDemo"><i class="fa fa-paragraph"></i> {{getWord(\'Blog\')}}</a>\n                    </li>\n                    <li data-ui-sref-active="active">\n                        <a data-ui-sref="app.appViews.galleryDemo"><i class="fa fa-picture-o"></i> {{getWord(\'Gallery\')}}</a>\n                    </li>\n\n                    <li data-menu-collapse>\n                        <a href="#"><i class="fa fa-comments"></i> {{getWord(\'Forum Layout\')}}</a>\n                        <ul>\n                            <li data-ui-sref-active="active">\n                                <a data-ui-sref="app.appViews.forumDemo"><i class="fa fa-picture-o"></i> {{getWord(\'General View\')}}</a>\n                            </li>\n                            <li data-ui-sref-active="active">\n                                <a data-ui-sref="app.appViews.forumTopicDemo"><i class="fa fa-picture-o"></i> {{getWord(\'Topic View\')}}</a>\n                            </li>\n                            <li data-ui-sref-active="active">\n                                <a data-ui-sref="app.appViews.forumPostDemo"><i class="fa fa-picture-o"></i> {{getWord(\'Post View\')}}</a>\n                            </li>\n                        </ul>\n                    </li>\n                    <li data-ui-sref-active="active">\n                        <a data-ui-sref="app.appViews.profileDemo"><i class="fa fa-group"></i> {{getWord(\'Profile\')}}</a>\n                    </li>\n                    <li data-ui-sref-active="active">\n                        <a data-ui-sref="app.appViews.timelineDemo"><i class="fa fa-clock-o"></i> {{getWord(\'Timeline\')}}</a>\n                    </li>\n                </ul>\n            </li>\n\n            <li data-ui-sref-active="active">\n                <a data-ui-sref="app.maps"><i class="fa fa-lg fa-fw fa-map-marker"></i> <span class="menu-item-parent">{{getWord(\'GMap Skins\')}}</span><span class="badge bg-color-greenLight pull-right inbox-badge">9</span></a>\n            </li>\n\n            <li data-menu-collapse>\n                <a href="#"><i class="fa fa-lg fa-fw fa-windows"></i> <span class="menu-item-parent">{{getWord(\'Miscellaneous\')}}</span></a>\n                <ul >\n                    <li>\n                        <a href="http://bootstraphunter.com/smartadmin-landing/" target="_blank">{{getWord(\'Landing Page\')}} <i class="fa fa-external-link"></i></a>\n                    </li>\n                    <li data-ui-sref-active="active">\n                        <a data-ui-sref="app.misc.pricingTable">{{getWord(\'Pricing Tables\')}}</a>\n                    </li>\n                    <li data-ui-sref-active="active">\n                        <a data-ui-sref="app.misc.invoice">{{getWord(\'Invoice\')}}</a>\n                    </li>\n                    <li data-ui-sref-active="active">\n                        <a data-ui-sref="login">{{getWord(\'Login\')}}</a>\n                    </li>\n                    <li data-ui-sref-active="active">\n                        <a data-ui-sref="register">{{getWord(\'Register\')}}</a>\n                    </li>\n                    <li data-ui-sref-active="active">\n                        <a data-ui-sref="lock">{{getWord(\'Locked Screen\')}}</a>\n                    </li>\n                    <li data-ui-sref-active="active">\n                        <a data-ui-sref="app.misc.error404">{{getWord(\'Error 404\')}}</a>\n                    </li>\n                    <li data-ui-sref-active="active">\n                        <a data-ui-sref="app.misc.error500">{{getWord(\'Error 500\')}}</a>\n                    </li>\n                    <li data-ui-sref-active="active">\n                        <a data-ui-sref="app.misc.blank">{{getWord(\'Blank Page\')}}</a>\n                    </li>\n                    <li data-ui-sref-active="active">\n                        <a data-ui-sref="app.misc.emailTemplate">{{getWord(\'Email Template\')}}</a>\n                    </li>\n                    <li data-ui-sref-active="active">\n                        <a data-ui-sref="app.misc.search">{{getWord(\'Search Page\')}}</a>\n                    </li>\n                    <li data-ui-sref-active="active">\n                        <a data-ui-sref="app.misc.ckeditor">{{getWord(\'CK Editor\')}}</a>\n                    </li>\n                </ul>\n            </li>\n\n          <li data-menu-collapse class="top-menu-invisible">\n                <a href="#"><i class="fa fa-lg fa-fw fa-cube txt-color-blue"></i> <span class="menu-item-parent">{{getWord(\'SmartAdmin Intel\')}}</span></a>\n                <ul>\n                    <li data-ui-sref-active="active">\n                        <a data-ui-sref="app.smartAdmin.diffVer"><i class="fa fa-stack-overflow"></i> {{getWord(\'Different Versions\')}}</a>\n                    </li>\n                    <!--<li data-ui-sref-active="active">\n                        <a data-ui-sref="app.smartAdmin.appLayout"><i class="fa fa-cube"></i> {{getWord(\'App Settings\')}}</a>\n                    </li>-->\n                    <li>\n                        <a href="http://bootstraphunter.com/smartadmin/BUGTRACK/track_/documentation/index.html" target="_blank"><i class="fa fa-book"></i> {{getWord(\'Documentation\')}}</a>\n                    </li>\n                    <li>\n                        <a href="http://bootstraphunter.com/smartadmin/BUGTRACK/track_/" target="_blank"><i class="fa fa-bug"></i> {{getWord(\'Bug Tracker\')}}</a>\n                    </li>\n                </ul>\n            </li>\n            <li data-menu-collapse class="chat-users top-menu-invisible">\n                <a href="#"><i class="fa fa-lg fa-fw fa-comment-o"><em class="bg-color-pink flash animated">!</em></i> <span class="menu-item-parent">{{getWord(\'Smart Chat API\')}} <sup>{{getWord(\'beta\')}}</sup></span></a>\n                <div aside-chat-widget></div>\n            </li>\n        </ul>\n    </nav>\n\n  <span class="minifyme" data-action="minifyMenu" minify-menu>\n    <i class="fa fa-arrow-circle-left hit"></i>\n  </span>\n\n</aside>'),a.put("build/layout/partials/sub-header.tpl.html",'<div class="col-xs-12 col-sm-5 col-md-5 col-lg-8" data-sparkline-container>\n    <ul id="sparks" class="">\n        <li class="sparks-info">\n            <h5> My Income <span class="txt-color-blue">$47,171</span></h5>\n            <div class="sparkline txt-color-blue hidden-mobile hidden-md hidden-sm">\n                1300, 1877, 2500, 2577, 2000, 2100, 3000, 2700, 3631, 2471, 2700, 3631, 2471\n            </div>\n        </li>\n        <li class="sparks-info">\n            <h5> Site Traffic <span class="txt-color-purple"><i class="fa fa-arrow-circle-up"></i>&nbsp;45%</span></h5>\n            <div class="sparkline txt-color-purple hidden-mobile hidden-md hidden-sm">\n                110,150,300,130,400,240,220,310,220,300, 270, 210\n            </div>\n        </li>\n        <li class="sparks-info">\n            <h5> Site Orders <span class="txt-color-greenDark"><i class="fa fa-shopping-cart"></i>&nbsp;2447</span></h5>\n            <div class="sparkline txt-color-greenDark hidden-mobile hidden-md hidden-sm">\n                110,150,300,130,400,240,220,310,220,300, 270, 210\n            </div>\n        </li>\n    </ul>\n</div>\n			'),a.put("build/layout/partials/voice-commands.tpl.html",'<!-- TRIGGER BUTTON:\n<a href="/my-ajax-page.html" data-toggle="modal" data-target="#remoteModal" class="btn btn-default">Open Modal</a>  -->\n\n<!-- MODAL PLACE HOLDER\n<div class="modal fade" id="remoteModal" tabindex="-1" role="dialog" aria-labelledby="remoteModalLabel" aria-hidden="true">\n<div class="modal-dialog">\n<div class="modal-content"></div>\n</div>\n</div>   -->\n<!--////////////////////////////////////-->\n\n<!--<div class="modal-header">\n<button type="button" class="close" data-dismiss="modal" aria-hidden="true">\n&times;\n</button>\n<h4 class="modal-title" id="myModalLabel">Command List</h4>\n</div>-->\n<div class="modal-body">\n\n	<h1><i class="fa fa-microphone text-muted"></i>&nbsp;&nbsp; SmartAdmin Voice Command</h1>\n	<hr class="simple">\n	<h5>Instruction</h5>\n\n	Click <span class="text-success">"Allow"</span> to access your microphone and activate Voice Command.\n	You will notice a <span class="text-primary"><strong>BLUE</strong> Flash</span> on the microphone icon indicating activation.\n	The icon will appear <span class="text-danger"><strong>RED</strong></span> <span class="label label-danger"><i class="fa fa-microphone fa-lg"></i></span> if you <span class="text-danger">"Deny"</span> access or don\'t have any microphone installed.\n	<br>\n	<br>\n	As a security precaution, your browser will disconnect the microphone every 60 to 120 seconds (sooner if not being used). In which case Voice Command will prompt you again to <span class="text-success">"Allow"</span> or <span class="text-danger">"Deny"</span> access to your microphone.\n	<br>\n	<br>\n	If you host your page over <strong>http<span class="text-success">s</span></strong> (secure socket layer) protocol you can wave this security measure and have an unintrupted Voice Command.\n	<br>\n	<br>\n	<h5>Commands</h5>\n	<ul>\n		<li>\n			<strong>\'show\' </strong> then say the <strong>*page*</strong> you want to go to. For example <strong>"show inbox"</strong> or <strong>"show calendar"</strong>\n		</li>\n		<li>\n			<strong>\'mute\' </strong> - mutes all sound effects for the theme.\n		</li>\n		<li>\n			<strong>\'sound on\'</strong> - unmutes all sound effects for the theme.\n		</li>\n		<li>\n			<span class="text-danger"><strong>\'stop\'</strong></span> - deactivates voice command.\n		</li>\n		<li>\n			<span class="text-primary"><strong>\'help\'</strong></span> - brings up the command list\n		</li>\n		<li>\n			<span class="text-danger"><strong>\'got it\'</strong></span> - closes help modal\n		</li>\n		<li>\n			<strong>\'hide navigation\'</strong> - toggle navigation collapse\n		</li>\n		<li>\n			<strong>\'show navigation\'</strong> - toggle navigation to open (can be used again to close)\n		</li>\n		<li>\n			<strong>\'scroll up\'</strong> - scrolls to the top of the page\n		</li>\n		<li>\n			<strong>\'scroll down\'</strong> - scrollts to the bottom of the page\n		</li>\n		<li>\n			<strong>\'go back\' </strong> - goes back in history (history -1 click)\n		</li>\n		<li>\n			<strong>\'logout\'</strong> - logs you out\n		</li>\n	</ul>\n	<br>\n	<h5>Adding your own commands</h5>\n	Voice Command supports up to 80 languages. Adding your own commands is extreamly easy. All commands are stored inside <strong>app.config.js</strong> file under the <code>var commands = {...}</code>. \n\n	<hr class="simple">\n	<div class="text-right">\n		<button type="button" class="btn btn-success btn-lg" data-dismiss="modal">\n			Got it!\n		</button>\n	</div>\n\n</div>\n<!--<div class="modal-footer">\n<button type="button" class="btn btn-primary" data-dismiss="modal">Got it!</button>\n</div> -->'),a.put("build/modules/forms/directives/bootstrap-validation/bootstrap-attribute-form.tpl.html",'<form id="attributeForm" class="form-horizontal"\n      data-bv-message="This value is not valid"\n      data-bv-feedbackicons-valid="glyphicon glyphicon-ok"\n      data-bv-feedbackicons-invalid="glyphicon glyphicon-remove"\n      data-bv-feedbackicons-validating="glyphicon glyphicon-refresh">\n\n    <fieldset>\n        <legend>\n            Set validator options via HTML attributes\n        </legend>\n\n        <div class="alert alert-warning">\n            <code>&lt; input\n                data-bv-validatorname\n                data-bv-validatorname-validatoroption="..." / &gt;</code>\n\n            <br>\n            <br>\n            More validator options can be found here:\n            <a href="http://bootstrapvalidator.com/validators/" target="_blank">http://bootstrapvalidator.com/validators/</a>\n        </div>\n\n        <div class="form-group">\n            <label class="col-lg-3 control-label">Full name</label>\n            <div class="col-lg-4">\n                <input type="text" class="form-control" name="firstName" placeholder="First name"\n                       data-bv-notempty="true"\n                       data-bv-notempty-message="The first name is required and cannot be empty" />\n            </div>\n            <div class="col-lg-4">\n                <input type="text" class="form-control" name="lastName" placeholder="Last name"\n                       data-bv-notempty="true"\n                       data-bv-notempty-message="The last name is required and cannot be empty" />\n            </div>\n        </div>\n    </fieldset>\n\n    <fieldset>\n        <div class="form-group">\n            <label class="col-lg-3 control-label">Username</label>\n            <div class="col-lg-5">\n                <input type="text" class="form-control" name="username"\n                       data-bv-message="The username is not valid"\n\n                       data-bv-notempty="true"\n                       data-bv-notempty-message="The username is required and cannot be empty"\n\n                       data-bv-regexp="true"\n                       data-bv-regexp-regexp="^[a-zA-Z0-9_\\.]+$"\n                       data-bv-regexp-message="The username can only consist of alphabetical, number, dot and underscore"\n\n                       data-bv-stringlength="true"\n                       data-bv-stringlength-min="6"\n                       data-bv-stringlength-max="30"\n                       data-bv-stringlength-message="The username must be more than 6 and less than 30 characters long"\n\n                       data-bv-different="true"\n                       data-bv-different-field="password"\n                       data-bv-different-message="The username and password cannot be the same as each other" />\n            </div>\n        </div>\n    </fieldset>\n\n    <fieldset>\n        <div class="form-group">\n            <label class="col-lg-3 control-label">Email address</label>\n            <div class="col-lg-5">\n                <input class="form-control" name="email" type="email"\n                       data-bv-emailaddress="true"\n                       data-bv-emailaddress-message="The input is not a valid email address" />\n            </div>\n        </div>\n    </fieldset>\n\n    <fieldset>\n        <div class="form-group">\n            <label class="col-lg-3 control-label">Password</label>\n            <div class="col-lg-5">\n                <input type="password" class="form-control" name="password"\n                       data-bv-notempty="true"\n                       data-bv-notempty-message="The password is required and cannot be empty"\n\n                       data-bv-identical="true"\n                       data-bv-identical-field="confirmPassword"\n                       data-bv-identical-message="The password and its confirm are not the same"\n\n                       data-bv-different="true"\n                       data-bv-different-field="username"\n                       data-bv-different-message="The password cannot be the same as username" />\n            </div>\n        </div>\n    </fieldset>\n\n    <fieldset>\n        <div class="form-group">\n            <label class="col-lg-3 control-label">Retype password</label>\n            <div class="col-lg-5">\n                <input type="password" class="form-control" name="confirmPassword"\n                       data-bv-notempty="true"\n                       data-bv-notempty-message="The confirm password is required and cannot be empty"\n\n                       data-bv-identical="true"\n                       data-bv-identical-field="password"\n                       data-bv-identical-message="The password and its confirm are not the same"\n\n                       data-bv-different="true"\n                       data-bv-different-field="username"\n                       data-bv-different-message="The password cannot be the same as username" />\n            </div>\n        </div>\n    </fieldset>\n\n    <fieldset>\n        <div class="form-group">\n            <label class="col-lg-3 control-label">Languages</label>\n            <div class="col-lg-5">\n                <div class="checkbox">\n                    <label>\n                        <input type="checkbox" name="languages[]" value="english"\n                               data-bv-message="Please specify at least one language you can speak"\n                               data-bv-notempty="true" />\n                        English </label>\n                </div>\n                <div class="checkbox">\n                    <label>\n                        <input type="checkbox" name="languages[]" value="french" />\n                        French </label>\n                </div>\n                <div class="checkbox">\n                    <label>\n                        <input type="checkbox" name="languages[]" value="german" />\n                        German </label>\n                </div>\n                <div class="checkbox">\n                    <label>\n                        <input type="checkbox" name="languages[]" value="russian" />\n                        Russian </label>\n                </div>\n                <div class="checkbox">\n                    <label>\n                        <input type="checkbox" name="languages[]" value="other" />\n                        Other </label>\n                </div>\n            </div>\n        </div>\n    </fieldset>\n\n    <div class="form-actions">\n        <div class="row">\n            <div class="col-md-12">\n                <button class="btn btn-default" type="submit">\n                    <i class="fa fa-eye"></i>\n                    Validate\n                </button>\n            </div>\n        </div>\n    </div>\n\n</form>\n     '),a.put("build/modules/forms/directives/bootstrap-validation/bootstrap-button-group-form.tpl.html",'<form id="buttonGroupForm" method="post" class="form-horizontal">\n\n    <fieldset>\n        <legend>\n            Default Form Elements\n        </legend>\n        <div class="form-group">\n            <label class="col-lg-3 control-label">Gender</label>\n            <div class="col-lg-9">\n                <div class="btn-group" data-toggle="buttons">\n                    <label class="btn btn-default">\n                        <input type="radio" name="gender" value="male" />\n                        Male </label>\n                    <label class="btn btn-default">\n                        <input type="radio" name="gender" value="female" />\n                        Female </label>\n                    <label class="btn btn-default">\n                        <input type="radio" name="gender" value="other" />\n                        Other </label>\n                </div>\n            </div>\n        </div>\n    </fieldset>\n\n    <fieldset>\n        <div class="form-group">\n            <label class="col-lg-3 control-label">Languages</label>\n            <div class="col-lg-9">\n                <div class="btn-group" data-toggle="buttons">\n                    <label class="btn btn-default">\n                        <input type="checkbox" name="languages[]" value="english" />\n                        English </label>\n                    <label class="btn btn-default">\n                        <input type="checkbox" name="languages[]" value="german" />\n                        German </label>\n                    <label class="btn btn-default">\n                        <input type="checkbox" name="languages[]" value="french" />\n                        French </label>\n                    <label class="btn btn-default">\n                        <input type="checkbox" name="languages[]" value="russian" />\n                        Russian </label>\n                    <label class="btn btn-default">\n                        <input type="checkbox" name="languages[]" value="italian">\n                        Italian </label>\n                </div>\n            </div>\n        </div>\n    </fieldset>\n\n    <div class="form-actions">\n        <div class="row">\n            <div class="col-md-12">\n                <button class="btn btn-default" type="submit">\n                    <i class="fa fa-eye"></i>\n                    Validate\n                </button>\n            </div>\n        </div>\n    </div>\n\n</form>\n'),a.put("build/modules/forms/directives/bootstrap-validation/bootstrap-contact-form.tpl.html",'<form id="contactForm" method="post" class="form-horizontal">\n\n    <fieldset>\n        <legend>Showing messages in custom area</legend>\n        <div class="form-group">\n            <label class="col-md-3 control-label">Full name</label>\n            <div class="col-md-6">\n                <input type="text" class="form-control" name="fullName" />\n            </div>\n        </div>\n    </fieldset>\n\n    <fieldset>\n        <div class="form-group">\n            <label class="col-md-3 control-label">Email</label>\n            <div class="col-md-6">\n                <input type="text" class="form-control" name="email" />\n            </div>\n        </div>\n    </fieldset>\n\n    <fieldset>\n        <div class="form-group">\n            <label class="col-md-3 control-label">Title</label>\n            <div class="col-md-6">\n                <input type="text" class="form-control" name="title" />\n            </div>\n        </div>\n    </fieldset>\n\n    <fieldset>\n        <div class="form-group">\n            <label class="col-md-3 control-label">Content</label>\n            <div class="col-md-6">\n                <textarea class="form-control" name="content" rows="5"></textarea>\n            </div>\n        </div>\n    </fieldset>\n\n    <fieldset>\n        <!-- #messages is where the messages are placed inside -->\n        <div class="form-group">\n            <div class="col-md-9 col-md-offset-3">\n                <div id="messages"></div>\n            </div>\n        </div>\n    </fieldset>\n\n    <div class="form-actions">\n        <div class="row">\n            <div class="col-md-12">\n                <button class="btn btn-default" type="submit">\n                    <i class="fa fa-eye"></i>\n                    Validate\n                </button>\n            </div>\n        </div>\n    </div>\n\n</form>\n'),a.put("build/modules/forms/directives/bootstrap-validation/bootstrap-movie-form.tpl.html",'<form id="movieForm" method="post">\n\n    <fieldset>\n        <legend>\n            Default Form Elements\n        </legend>\n        <div class="form-group">\n            <div class="row">\n                <div class="col-md-8">\n                    <label class="control-label">Movie title</label>\n                    <input type="text" class="form-control" name="title" />\n                </div>\n\n                <div class="col-md-4 selectContainer">\n                    <label class="control-label">Genre</label>\n                    <select class="form-control" name="genre">\n                        <option value="">Choose a genre</option>\n                        <option value="action">Action</option>\n                        <option value="comedy">Comedy</option>\n                        <option value="horror">Horror</option>\n                        <option value="romance">Romance</option>\n                    </select>\n                </div>\n            </div>\n        </div>\n    </fieldset>\n\n    <fieldset>\n        <div class="form-group">\n            <div class="row">\n                <div class="col-sm-12 col-md-4">\n                    <label class="control-label">Director</label>\n                    <input type="text" class="form-control" name="director" />\n                </div>\n\n                <div class="col-sm-12 col-md-4">\n                    <label class="control-label">Writer</label>\n                    <input type="text" class="form-control" name="writer" />\n                </div>\n\n                <div class="col-sm-12 col-md-4">\n                    <label class="control-label">Producer</label>\n                    <input type="text" class="form-control" name="producer" />\n                </div>\n            </div>\n        </div>\n    </fieldset>\n\n    <fieldset>\n        <div class="form-group">\n            <div class="row">\n                <div class="col-sm-12 col-md-6">\n                    <label class="control-label">Website</label>\n                    <input type="text" class="form-control" name="website" />\n                </div>\n\n                <div class="col-sm-12 col-md-6">\n                    <label class="control-label">Youtube trailer</label>\n                    <input type="text" class="form-control" name="trailer" />\n                </div>\n            </div>\n        </div>\n    </fieldset>\n\n    <fieldset>\n        <div class="form-group">\n            <label class="control-label">Review</label>\n            <textarea class="form-control" name="review" rows="8"></textarea>\n        </div>\n    </fieldset>\n\n    <fieldset>\n        <div class="form-group">\n\n            <div class="row">\n                <div class="col-sm-12 col-md-12">\n                    <label class="control-label">Rating</label>\n                </div>\n\n                <div class="col-sm-12 col-md-10">\n\n                    <label class="radio radio-inline no-margin">\n                        <input type="radio" name="rating" value="terrible" class="radiobox style-2" />\n                        <span>Terrible</span> </label>\n\n                    <label class="radio radio-inline">\n                        <input type="radio" name="rating" value="watchable" class="radiobox style-2" />\n                        <span>Watchable</span> </label>\n                    <label class="radio radio-inline">\n                        <input type="radio" name="rating" value="best" class="radiobox style-2" />\n                        <span>Best ever</span> </label>\n\n                </div>\n\n            </div>\n\n        </div>\n    </fieldset>\n\n    <div class="form-actions">\n        <div class="row">\n            <div class="col-md-12">\n                <button class="btn btn-default" type="submit">\n                    <i class="fa fa-eye"></i>\n                    Validate\n                </button>\n            </div>\n        </div>\n    </div>\n\n</form>\n\n '),a.put("build/modules/forms/directives/bootstrap-validation/bootstrap-product-form.tpl.html",'<form id="productForm" class="form-horizontal">\n\n    <fieldset>\n        <legend>\n            Default Form Elements\n        </legend>\n        <div class="form-group">\n            <label class="col-xs-2 col-lg-3 control-label">Price</label>\n            <div class="col-xs-9 col-lg-6 inputGroupContainer">\n                <div class="input-group">\n                    <input type="text" class="form-control" name="price" />\n                    <span class="input-group-addon">$</span>\n                </div>\n            </div>\n        </div>\n    </fieldset>\n\n    <fieldset>\n        <div class="form-group">\n            <label class="col-xs-2 col-lg-3 control-label">Amount</label>\n            <div class="col-xs-9 col-lg-6 inputGroupContainer">\n                <div class="input-group">\n                    <span class="input-group-addon">&#8364;</span>\n                    <input type="text" class="form-control" name="amount" />\n                </div>\n            </div>\n        </div>\n    </fieldset>\n\n    <fieldset>\n        <div class="form-group">\n            <label class="col-xs-2 col-lg-3 control-label">Color</label>\n            <div class="col-xs-9 col-lg-6 selectContainer">\n                <select class="form-control" name="color">\n                    <option value="">Choose a color</option>\n                    <option value="blue">Blue</option>\n                    <option value="green">Green</option>\n                    <option value="red">Red</option>\n                    <option value="yellow">Yellow</option>\n                    <option value="white">White</option>\n                </select>\n            </div>\n        </div>\n    </fieldset>\n\n    <fieldset>\n        <div class="form-group">\n            <label class="col-xs-2 col-lg-3 control-label">Size</label>\n            <div class="col-xs-9 col-lg-6 selectContainer">\n                <select class="form-control" name="size">\n                    <option value="">Choose a size</option>\n                    <option value="S">S</option>\n                    <option value="M">M</option>\n                    <option value="L">L</option>\n                    <option value="XL">XL</option>\n                </select>\n            </div>\n        </div>\n    </fieldset>\n\n    <div class="form-actions">\n        <div class="row">\n            <div class="col-md-12">\n                <button class="btn btn-default" type="submit">\n                    <i class="fa fa-eye"></i>\n                    Validate\n                </button>\n            </div>\n        </div>\n    </div>\n</form>\n\n'),a.put("build/modules/forms/directives/bootstrap-validation/bootstrap-profile-form.tpl.html",'<form id="profileForm">\n\n    <fieldset>\n        <legend>\n            Default Form Elements\n        </legend>\n        <div class="form-group">\n            <label>Email address</label>\n            <input type="text" class="form-control" name="email" />\n        </div>\n    </fieldset>\n    <fieldset>\n        <div class="form-group">\n            <label>Password</label>\n            <input type="password" class="form-control" name="password" />\n        </div>\n    </fieldset>\n\n    <div class="form-actions">\n        <div class="row">\n            <div class="col-md-12">\n                <button class="btn btn-default" type="submit">\n                    <i class="fa fa-eye"></i>\n                    Validate\n                </button>\n            </div>\n        </div>\n    </div>\n</form>\n'),a.put("build/modules/forms/directives/bootstrap-validation/bootstrap-toggling-form.tpl.html",'<form id="togglingForm" method="post" class="form-horizontal">\n\n    <fieldset>\n        <legend>\n            Default Form Elements\n        </legend>\n        <div class="form-group">\n            <label class="col-lg-3 control-label">Full name <sup>*</sup></label>\n            <div class="col-lg-4">\n                <input type="text" class="form-control" name="firstName" placeholder="First name" />\n            </div>\n            <div class="col-lg-4">\n                <input type="text" class="form-control" name="lastName" placeholder="Last name" />\n            </div>\n        </div>\n    </fieldset>\n\n    <fieldset>\n        <div class="form-group">\n            <label class="col-lg-3 control-label">Company <sup>*</sup></label>\n            <div class="col-lg-5">\n                <input type="text" class="form-control" name="company"\n                       required data-bv-notempty-message="The company name is required" />\n            </div>\n            <div class="col-lg-2">\n                <button type="button" class="btn btn-info btn-sm" data-toggle="#jobInfo">\n                    Add more info\n                </button>\n            </div>\n        </div>\n    </fieldset>\n\n    <!-- These fields will not be validated as long as they are not visible -->\n    <div id="jobInfo" style="display: none;">\n        <fieldset>\n            <div class="form-group">\n                <label class="col-lg-3 control-label">Job title <sup>*</sup></label>\n                <div class="col-lg-5">\n                    <input type="text" class="form-control" name="job" />\n                </div>\n            </div>\n        </fieldset>\n\n        <fieldset>\n            <div class="form-group">\n                <label class="col-lg-3 control-label">Department <sup>*</sup></label>\n                <div class="col-lg-5">\n                    <input type="text" class="form-control" name="department" />\n                </div>\n            </div>\n        </fieldset>\n    </div>\n\n    <fieldset>\n        <div class="form-group">\n            <label class="col-lg-3 control-label">Mobile phone <sup>*</sup></label>\n            <div class="col-lg-5">\n                <input type="text" class="form-control" name="mobilePhone" />\n            </div>\n            <div class="col-lg-2">\n                <button type="button" class="btn btn-info btn-sm" data-toggle="#phoneInfo">\n                    Add more phone numbers\n                </button>\n            </div>\n        </div>\n    </fieldset>\n    <!-- These fields will not be validated as long as they are not visible -->\n    <div id="phoneInfo" style="display: none;">\n\n        <fieldset>\n            <div class="form-group">\n                <label class="col-lg-3 control-label">Home phone</label>\n                <div class="col-lg-5">\n                    <input type="text" class="form-control" name="homePhone" />\n                </div>\n            </div>\n        </fieldset>\n        <fieldset>\n            <div class="form-group">\n                <label class="col-lg-3 control-label">Office phone</label>\n                <div class="col-lg-5">\n                    <input type="text" class="form-control" name="officePhone" />\n                </div>\n            </div>\n        </fieldset>\n    </div>\n\n    <div class="form-actions">\n        <div class="row">\n            <div class="col-md-12">\n                <button class="btn btn-default" type="submit">\n                    <i class="fa fa-eye"></i>\n                    Validate\n                </button>\n            </div>\n        </div>\n    </div>\n</form>'),a.put("build/modules/forms/directives/form-layouts/smart-checkout-form.tpl.html",'<form id="checkout-form" class="smart-form" novalidate="novalidate">\n\n<fieldset>\n    <div class="row">\n        <section class="col col-6">\n            <label class="input"> <i class="icon-prepend fa fa-user"></i>\n                <input type="text" name="fname" placeholder="First name">\n            </label>\n        </section>\n        <section class="col col-6">\n            <label class="input"> <i class="icon-prepend fa fa-user"></i>\n                <input type="text" name="lname" placeholder="Last name">\n            </label>\n        </section>\n    </div>\n\n    <div class="row">\n        <section class="col col-6">\n            <label class="input"> <i class="icon-prepend fa fa-envelope-o"></i>\n                <input type="email" name="email" placeholder="E-mail">\n            </label>\n        </section>\n        <section class="col col-6">\n            <label class="input"> <i class="icon-prepend fa fa-phone"></i>\n                <input type="tel" name="phone" placeholder="Phone" data-smart-masked-input="(999) 999-9999">\n            </label>\n        </section>\n    </div>\n</fieldset>\n\n<fieldset>\n<div class="row">\n<section class="col col-5">\n<label class="select">\n<select name="country">\n<option value="0" selected="" disabled="">Country</option>\n    <option value="{{country.key}}" ng-repeat="country in countries" >{{country.value}}</option>\n</select> <i></i> </label>\n</section>\n\n<section class="col col-4">\n    <label class="input">\n        <input type="text" name="city" placeholder="City">\n    </label>\n</section>\n\n<section class="col col-3">\n    <label class="input">\n        <input type="text" name="code" placeholder="Post code">\n    </label>\n</section>\n</div>\n\n<section>\n    <label for="address2" class="input">\n        <input type="text" name="address2" id="address2" placeholder="Address">\n    </label>\n</section>\n\n<section>\n    <label class="textarea">\n        <textarea rows="3" name="info" placeholder="Additional info"></textarea>\n    </label>\n</section>\n</fieldset>\n\n<fieldset>\n    <section>\n        <div class="inline-group">\n            <label class="radio">\n                <input type="radio" name="radio-inline" checked="">\n                <i></i>Visa</label>\n            <label class="radio">\n                <input type="radio" name="radio-inline">\n                <i></i>MasterCard</label>\n            <label class="radio">\n                <input type="radio" name="radio-inline">\n                <i></i>American Express</label>\n        </div>\n    </section>\n\n    <section>\n        <label class="input">\n            <input type="text" name="name" placeholder="Name on card">\n        </label>\n    </section>\n\n    <div class="row">\n        <section class="col col-10">\n            <label class="input">\n                <input type="text" name="card" placeholder="Card number" data-mask="9999-9999-9999-9999">\n            </label>\n        </section>\n        <section class="col col-2">\n            <label class="input">\n                <input type="text" name="cvv" placeholder="CVV2" data-mask="999">\n            </label>\n        </section>\n    </div>\n\n    <div class="row">\n        <label class="label col col-4">Expiration date</label>\n        <section class="col col-5">\n            <label class="select">\n                <select name="month">\n                    <option value="0" selected="" disabled="">Month</option>\n                    <option value="1">January</option>\n                    <option value="1">February</option>\n                    <option value="3">March</option>\n                    <option value="4">April</option>\n                    <option value="5">May</option>\n                    <option value="6">June</option>\n                    <option value="7">July</option>\n                    <option value="8">August</option>\n                    <option value="9">September</option>\n                    <option value="10">October</option>\n                    <option value="11">November</option>\n                    <option value="12">December</option>\n                </select> <i></i> </label>\n        </section>\n        <section class="col col-3">\n            <label class="input">\n                <input type="text" name="year" placeholder="Year" data-mask="2099">\n            </label>\n        </section>\n    </div>\n</fieldset>\n\n<footer>\n    <button type="submit" class="btn btn-primary">\n        Validate Form\n    </button>\n</footer>\n</form>\n'),a.put("build/modules/forms/directives/form-layouts/smart-comment-form.tpl.html",'<form action="/api/plug" method="post" id="comment-form" class="smart-form">\n    <header>\n        Comment form\n    </header>\n\n    <fieldset>\n        <div class="row">\n            <section class="col col-4">\n                <label class="label">Name</label>\n                <label class="input"> <i class="icon-append fa fa-user"></i>\n                    <input type="text" name="name">\n                </label>\n            </section>\n            <section class="col col-4">\n                <label class="label">E-mail</label>\n                <label class="input"> <i class="icon-append fa fa-envelope-o"></i>\n                    <input type="email" name="email">\n                </label>\n            </section>\n            <section class="col col-4">\n                <label class="label">Website</label>\n                <label class="input"> <i class="icon-append fa fa-globe"></i>\n                    <input type="url" name="url">\n                </label>\n            </section>\n        </div>\n\n        <section>\n            <label class="label">Comment</label>\n            <label class="textarea"> <i class="icon-append fa fa-comment"></i> <textarea rows="4"\n                                                                                         name="comment"></textarea>\n            </label>\n\n            <div class="note">\n                You may use these HTML tags and attributes: &lt;a href="" title=""&gt;, &lt;abbr title=""&gt;,\n                &lt;acronym title=""&gt;, &lt;b&gt;, &lt;blockquote cite=""&gt;, &lt;cite&gt;, &lt;code&gt;,\n                &lt;del datetime=""&gt;, &lt;em&gt;, &lt;i&gt;, &lt;q cite=""&gt;, &lt;strike&gt;, &lt;strong&gt;.\n            </div>\n        </section>\n    </fieldset>\n\n    <footer>\n        <button type="submit" name="submit" class="btn btn-primary">\n            Validate Form\n        </button>\n    </footer>\n\n    <div class="message">\n        <i class="fa fa-check fa-lg"></i>\n\n        <p>\n            Your comment was successfully added!\n        </p>\n    </div>\n</form>'),a.put("build/modules/forms/directives/form-layouts/smart-contacts-form.tpl.html",'<form action="/api/plug" method="post" id="contact-form" class="smart-form">\n    <header>Contacts form</header>\n\n    <fieldset>\n        <div class="row">\n            <section class="col col-6">\n                <label class="label">Name</label>\n                <label class="input">\n                    <i class="icon-append fa fa-user"></i>\n                    <input type="text" name="name" id="named">\n                </label>\n            </section>\n            <section class="col col-6">\n                <label class="label">E-mail</label>\n                <label class="input">\n                    <i class="icon-append fa fa-envelope-o"></i>\n                    <input type="email" name="email" id="emaild">\n                </label>\n            </section>\n        </div>\n\n        <section>\n            <label class="label">Subject</label>\n            <label class="input">\n                <i class="icon-append fa fa-tag"></i>\n                <input type="text" name="subject" id="subject">\n            </label>\n        </section>\n\n        <section>\n            <label class="label">Message</label>\n            <label class="textarea">\n                <i class="icon-append fa fa-comment"></i>\n                <textarea rows="4" name="message" id="message"></textarea>\n            </label>\n        </section>\n\n        <section>\n            <label class="checkbox"><input type="checkbox" name="copy" id="copy"><i></i>Send a copy to my\n                e-mail address</label>\n        </section>\n    </fieldset>\n\n    <footer>\n        <button type="submit" class="btn btn-primary">Validate Form</button>\n    </footer>\n\n    <div class="message">\n        <i class="fa fa-thumbs-up"></i>\n\n        <p>Your message was successfully sent!</p>\n    </div>\n</form>'),a.put("build/modules/forms/directives/form-layouts/smart-order-form.tpl.html",'<form id="order-form" class="smart-form" novalidate="novalidate">\n    <header>\n        Order services\n    </header>\n\n    <fieldset>\n        <div class="row">\n            <section class="col col-6">\n                <label class="input"> <i class="icon-append fa fa-user"></i>\n                    <input type="text" name="name" placeholder="Name">\n                </label>\n            </section>\n            <section class="col col-6">\n                <label class="input"> <i class="icon-append fa fa-briefcase"></i>\n                    <input type="text" name="company" placeholder="Company">\n                </label>\n            </section>\n        </div>\n\n        <div class="row">\n            <section class="col col-6">\n                <label class="input"> <i class="icon-append fa fa-envelope-o"></i>\n                    <input type="email" name="email" placeholder="E-mail">\n                </label>\n            </section>\n            <section class="col col-6">\n                <label class="input"> <i class="icon-append fa fa-phone"></i>\n                    <input type="tel" name="phone" placeholder="Phone" data-smart-masked-input="(999) 999-9999">\n                </label>\n            </section>\n        </div>\n    </fieldset>\n\n    <fieldset>\n        <div class="row">\n            <section class="col col-6">\n                <label class="select">\n                    <select name="interested">\n                        <option value="0" selected="" disabled="">Interested in</option>\n                        <option value="1">design</option>\n                        <option value="1">development</option>\n                        <option value="2">illustration</option>\n                        <option value="2">branding</option>\n                        <option value="3">video</option>\n                    </select> <i></i> </label>\n            </section>\n            <section class="col col-6">\n                <label class="select">\n                    <select name="budget">\n                        <option value="0" selected="" disabled="">Budget</option>\n                        <option value="1">less than 5000$</option>\n                        <option value="2">5000$ - 10000$</option>\n                        <option value="3">10000$ - 20000$</option>\n                        <option value="4">more than 20000$</option>\n                    </select> <i></i> </label>\n            </section>\n        </div>\n\n        <div class="row">\n            <section class="col col-6">\n                <label class="input"> <i class="icon-append fa fa-calendar"></i>\n                    <input type="text" name="startdate" id="startdate" data-smart-datepicker data-min-restrict="#finishdate" placeholder="Expected start date">\n                </label>\n            </section>\n            <section class="col col-6">\n                <label class="input"> <i class="icon-append fa fa-calendar"></i>\n                    <input type="text" name="finishdate" id="finishdate" data-smart-datepicker data-max-restrict="#startdate" placeholder="Expected finish date">\n                </label>\n            </section>\n        </div>\n\n        <section>\n            <div class="input input-file">\n                            <span class="button"><input id="file2" type="file" name="file2"\n                                                        onchange="this.parentNode.nextSibling.value = this.value">Browse</span><input\n                    type="text" placeholder="Include some files" readonly="">\n            </div>\n        </section>\n\n        <section>\n            <label class="textarea"> <i class="icon-append fa fa-comment"></i>\n                <textarea rows="5" name="comment" placeholder="Tell us about your project"></textarea>\n            </label>\n        </section>\n    </fieldset>\n    <footer>\n        <button type="submit" class="btn btn-primary">\n            Validate Form\n        </button>\n    </footer>\n</form>\n'),a.put("build/modules/forms/directives/form-layouts/smart-registration-form.tpl.html",'<form id="smart-form-register" class="smart-form">\n    <header>\n        Registration form\n    </header>\n\n    <fieldset>\n        <section>\n            <label class="input"> <i class="icon-append fa fa-user"></i>\n                <input type="text" name="username" placeholder="Username">\n                <b class="tooltip tooltip-bottom-right">Needed to enter the website</b> </label>\n        </section>\n\n\n        <section>\n            <label class="input"> <i class="icon-append fa fa-envelope-o"></i>\n                <input type="email" name="email" placeholder="Email address">\n                <b class="tooltip tooltip-bottom-right">Needed to verify your account</b> </label>\n        </section>\n\n        <section>\n            <label class="input"> <i class="icon-append fa fa-lock"></i>\n                <input type="password" name="password" placeholder="Password" id="password">\n                <b class="tooltip tooltip-bottom-right">Don\'t forget your password</b> </label>\n        </section>\n\n        <section>\n            <label class="input"> <i class="icon-append fa fa-lock"></i>\n                <input type="password" name="passwordConfirm" placeholder="Confirm password">\n                <b class="tooltip tooltip-bottom-right">Don\'t forget your password</b> </label>\n        </section>\n    </fieldset>\n\n    <fieldset>\n        <div class="row">\n            <section class="col col-6">\n                <label class="input">\n                    <input type="text" name="firstname" placeholder="First name">\n                </label>\n            </section>\n            <section class="col col-6">\n                <label class="input">\n                    <input type="text" name="lastname" placeholder="Last name">\n                </label>\n            </section>\n        </div>\n\n        <div class="row">\n            <section class="col col-6">\n                <label class="select">\n                    <select name="gender">\n                        <option value="0" selected="" disabled="">Gender</option>\n                        <option value="1">Male</option>\n                        <option value="2">Female</option>\n                        <option value="3">Prefer not to answer</option>\n                    </select> <i></i> </label>\n            </section>\n            <section class="col col-6">\n                <label class="input"> <i class="icon-append fa fa-calendar"></i>\n                    <input type="text" name="request" placeholder="Request activation on"\n                           data-smart-datepicker data-dateformat=\'dd/mm/yy\'>\n                </label>\n            </section>\n        </div>\n\n        <section>\n            <label class="checkbox">\n                <input type="checkbox" name="subscription" id="subscription">\n                <i></i>I want to receive news and special offers</label>\n            <label class="checkbox">\n                <input type="checkbox" name="terms" id="terms">\n                <i></i>I agree with the Terms and Conditions</label>\n        </section>\n    </fieldset>\n    <footer>\n        <button type="submit" class="btn btn-primary">\n            Validate Form\n        </button>\n    </footer>\n</form>'),a.put("build/modules/forms/directives/form-layouts/smart-review-form.tpl.html",'<form id="review-form" class="smart-form">\n    <header>\n        Review form\n    </header>\n\n    <fieldset>\n        <section>\n            <label class="input"> <i class="icon-append fa fa-user"></i>\n                <input type="text" name="name" id="name" placeholder="Your name">\n            </label>\n        </section>\n\n        <section>\n            <label class="input"> <i class="icon-append fa fa-envelope-o"></i>\n                <input type="email" name="email" id="email" placeholder="Your e-mail">\n            </label>\n        </section>\n\n        <section>\n            <label class="label"></label>\n            <label class="textarea"> <i class="icon-append fa fa-comment"></i>\n                <textarea rows="3" name="review" id="review" placeholder="Text of the review"></textarea>\n            </label>\n        </section>\n\n        <section>\n            <div class="rating">\n                <input type="radio" name="quality" id="quality-5">\n                <label for="quality-5"><i class="fa fa-star"></i></label>\n                <input type="radio" name="quality" id="quality-4">\n                <label for="quality-4"><i class="fa fa-star"></i></label>\n                <input type="radio" name="quality" id="quality-3">\n                <label for="quality-3"><i class="fa fa-star"></i></label>\n                <input type="radio" name="quality" id="quality-2">\n                <label for="quality-2"><i class="fa fa-star"></i></label>\n                <input type="radio" name="quality" id="quality-1">\n                <label for="quality-1"><i class="fa fa-star"></i></label>\n                Quality of the product\n            </div>\n\n            <div class="rating">\n                <input type="radio" name="reliability" id="reliability-5">\n                <label for="reliability-5"><i class="fa fa-star"></i></label>\n                <input type="radio" name="reliability" id="reliability-4">\n                <label for="reliability-4"><i class="fa fa-star"></i></label>\n                <input type="radio" name="reliability" id="reliability-3">\n                <label for="reliability-3"><i class="fa fa-star"></i></label>\n                <input type="radio" name="reliability" id="reliability-2">\n                <label for="reliability-2"><i class="fa fa-star"></i></label>\n                <input type="radio" name="reliability" id="reliability-1">\n                <label for="reliability-1"><i class="fa fa-star"></i></label>\n                Reliability of the product\n            </div>\n\n            <div class="rating">\n                <input type="radio" name="overall" id="overall-5">\n                <label for="overall-5"><i class="fa fa-star"></i></label>\n                <input type="radio" name="overall" id="overall-4">\n                <label for="overall-4"><i class="fa fa-star"></i></label>\n                <input type="radio" name="overall" id="overall-3">\n                <label for="overall-3"><i class="fa fa-star"></i></label>\n                <input type="radio" name="overall" id="overall-2">\n                <label for="overall-2"><i class="fa fa-star"></i></label>\n                <input type="radio" name="overall" id="overall-1">\n                <label for="overall-1"><i class="fa fa-star"></i></label>\n                Overall rating\n            </div>\n        </section>\n    </fieldset>\n    <footer>\n        <button type="submit" class="btn btn-primary">\n            Validate Form\n        </button>\n    </footer>\n</form>')
}])});
define('includes',["auth/module","auth/models/User","layout/module","layout/actions/minifyMenu","layout/actions/toggleMenu","layout/actions/fullScreen","layout/actions/resetWidgets","layout/actions/resetWidgets","layout/actions/searchMobile","layout/directives/demo/demoStates","layout/directives/smartInclude","layout/directives/smartDeviceDetect","layout/directives/smartFastClick","layout/directives/smartLayout","layout/directives/smartSpeech","layout/directives/smartRouterAnimationWrap","layout/directives/smartFitAppView","layout/directives/radioToggle","layout/directives/dismisser","layout/directives/smartMenu","layout/directives/bigBreadcrumbs","layout/directives/stateBreadcrumbs","layout/directives/smartPageTitle","layout/directives/hrefVoid","layout/service/SmartCss","modules/widgets/directives/widgetGrid","modules/widgets/directives/jarvisWidget","dashboard/module","components/language/Language","components/language/languageSelector","components/language/language-controller","components/projects/Project","components/projects/recentProjects","components/activities/activities-controller","components/activities/activities-dropdown-toggle-directive","components/activities/activities-service","components/shortcut/shortcut-directive","components/calendar/module","components/calendar/models/CalendarEvent","components/calendar/directives/fullCalendar","components/calendar/directives/dragableEvent","components/calendar/controllers/CalendarCtrl","components/inbox/module","components/inbox/models/InboxConfig","components/inbox/models/InboxMessage","components/todo/TodoCtrl","components/todo/models/Todo","components/todo/directives/todoList","components/chat/module","modules/graphs/module","modules/tables/module","modules/forms/module","modules/ui/module","modules/widgets/module","modules/maps/module","modules/app-views/module","modules/misc/module","modules/smart-admin/module","smart-templates"],function(){"use strict"});
window.name="NG_DEFER_BOOTSTRAP!",define('main',["require","jquery","angular","domReady","bootstrap","appConfig","app","includes"],function(a,b,c,d){b.sound_path=appConfig.sound_path,b.sound_on=appConfig.sound_on,d(function(a){c.bootstrap(a,["app"]),c.resumeBootstrap()})});
