<?php

//initilize the page
require_once("inc/init.php");

//require UI configuration (nav, ribbon, etc.)
require_once("inc/config.ui.php");

/*---------------- PHP Custom Scripts ---------

YOU CAN SET CONFIGURATION VARIABLES HERE BEFORE IT GOES TO NAV, RIBBON, ETC.
E.G. $page_title = "Custom Title" */

$page_title = "Different Versions";

/* ---------------- END PHP Custom Scripts ------------- */

//include header
//you can add your custom css in $page_css array.
//Note: all css files are inside css/ folder
$page_css[] = "your_style.css";
include("inc/header.php");

//include left panel (navigation)
//follow the tree in inc/config.ui.php
$page_nav["smartint"]["sub"]["difver"]["active"] = true;
include("inc/nav.php");

?>
<!-- ==========================CONTENT STARTS HERE ========================== -->
<!-- MAIN PANEL -->
<div id="main" role="main">
	<?php
		//configure ribbon (breadcrumbs) array("name"=>"url"), leave url empty if no url
		//$breadcrumbs["New Crumb"] => "http://url.com"
		$breadcrumbs["SmartAdmin Intel"] = "";
		include("inc/ribbon.php");
	?>

	<!-- MAIN CONTENT -->
	<div id="content">
		
		<!-- row -->
		<div class="row">
			
			<!-- col -->
			<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
				<h1 class="page-title txt-color-blueDark text-center">
					
					<!-- PAGE HEADER -->
						SmartAdmin Different Versions<br>
						<small class="text-success"><strong>When you buy SmartAdmin you will gain access to all the versions below!</strong></small>
				</h1>
				
			</div>
			<!-- end col -->
			
		</div>
		<!-- end row -->

		<!--
			The ID "widget-grid" will start to initialize all widgets below 
			You do not need to use widgets if you dont want to. Simply remove 
			the <section></section> and you can use wells or panels instead 
			-->

		<!-- widget grid -->
		<section id="widget-grid" class="">

			<!-- row -->

			<div class="row">

				<div class="col-xs-12 col-sm-6 col-md-6 col-lg-6">
					<!-- your contents here -->
						
					<div class="jumbotron padding-10 text-center bg-color-white">
						<img src="img/versions/ajaxversion.png" alt="Ajax Version" style="margin-left:-40px; width: 150px; margin-top:20px">
						<h1 style="font-size: 30px;">Jquery AJAX version</h1>
						<div class="text-left padding-5" style="min-height:250px">

							<h5>
								AJAX version uses robust scripts to lazyload pages, components and plugins - it acts a single page app. Never
								refresh your browser again!
								<br><br> 
								It's built to run smoothly in all devices. Highly recommended for small scale projects as it is easily manageable. 
								Comes with a built in auto <code>pageDestroy()</code> function to destroy objects and take care of those nasty memory leaks!
							</h5>
						</div>
						<a href="http://192.241.236.31/themes/preview/smartadmin/1.5/ajaxversion" class="btn btn-default btn-lg btn-block btn-primary disabled txt-color-white">Ajax Demo</a>
					</div>
					
				</div>

				<div class="col-xs-12 col-sm-6 col-md-6 col-lg-6">
					<!-- your contents here -->
					<div class="jumbotron padding-10 text-center bg-color-white">
						<img src="img/versions/angularversion.png" alt="AngularJS Version" style="margin-left:-40px; width: 150px; margin-top:20px">
						<h1 style="font-size: 30px;">AngularJS version (reloaded)</h1>
						<div class="text-left padding-5" style="min-height:250px">
							<h5>
								AngularJS (reloaded) brings you a brand new version built from ground up using Yeoman, Grunt and Bower package managers. 
								It is now packed with robust features, a RESTful API with JSON files and a file structure that is neat as a pin. 

								<br><br>
								It also comes with ready to use services, directives, controllers, routes, i18n, and other components.
								All scripts are loaded via requireJS (lazy loading) making it lighter, faster and smarter!
							</h5>
						</div>
						<a href="http://192.241.236.31/themes/preview/smartadmin/1.5/angularjs" target="_blank" class="btn btn-default btn-lg btn-block btn-danger">Angular Demo <i class="fa fa-long-arrow-right"></i></a>
					</div>
					
				</div>

				<div class="col-xs-12 col-sm-6 col-md-6 col-lg-6">
					<!-- your contents here -->
					<div class="jumbotron padding-10 text-center bg-color-white">
						<img src="img/versions/htmlversion.png" alt="HTML Version" style="margin-left:-40px; width: 150px; margin-top:20px">
						<h1 style="font-size: 30px;">HTML version</h1>
						<div class="text-left padding-5" style="min-height:250px">
							<h5>
								HTML version gives you the flexibility to select the platform of your desire. Features clean and pure HTML5 
								validated codes, with no loss of design or UI integrity from other verions. 
								<br><br>
								Over 56 HTML5 validated pages featuring rich and robust javascripts, CSS3 animations and custom plugins.

								Perfect for build an app from scratch. Whether you wish to build this in .Net,
								PHP, Django, Java or anyother platforms out there - the HTML version should be the ideal choise!
								<br><br>
								<strong>Please note</strong> : This demo is not currently available on our live site.
							</h5>
						</div>
						<button class="btn btn-default btn-lg btn-block btn-warning" disabled>Not Available for Demo</button>
					</div>
					
				</div>
				
				<div class="col-xs-12 col-sm-6 col-md-6 col-lg-6">
					<!-- your contents here -->
					<div class="jumbotron padding-10 text-center bg-color-white">
						<img src="img/versions/phpversion.png" alt="PHP Version" style="margin-left:-40px; width: 150px; margin-top:20px">
						<h1 style="font-size: 30px;">PHP/HTML version</h1>
						<div class="text-left padding-5" style="min-height:250px">
							<h5>							
							<span class="air air-top-right" style="padding:15px 30px 0 0">
								<i class="fa fa-check-circle fa-3x text-primary"></i>
							</span>
								We understand how frustrating and time consuming it can be writing your own classes. We are proud to introduce 
								SmartAdmin Php 5.5 version, brining you the tools you need to create your project with ease. <i>(Comes in two formats: HTML and AJAX)</i>
								<br>
								<br>	
								Just to name a few of the custom classes available off the bat: datatable, widgets, button, 
								accordion and multiple SmartUI Classes.
								<br>
								<br>
								Please click the link below to check out the list of our PHP classes. You will not be disappointed!
							</h5>
						</div>
						<a href="javascript:void(0);" target="_blank" class="btn btn-default btn-lg btn-block btn-primary">Currently viewing... <i class="fa fa-long-arrow-right"></i></a>
					</div>
					
				</div>		

				<div class="col-xs-12 col-sm-6 col-md-6 col-lg-6">
					<!-- your contents here -->
					<div class="jumbotron padding-10 text-center bg-color-white">
						<img src="img/versions/dotnetversion.png" alt="PHP Version" style="margin-left:-40px; width: 150px; margin-top:20px">
						<h1 style="font-size: 30px;">ASP.Net MVC5 version</h1>
						<div class="text-left padding-5" style="min-height:250px">
							<h5>
								The MVC version of SmartAdmin finally brings this wonderful theme into the world of .NET. It uses the very latest version of ASP.NET MVC 5 to showcase all of its great features. The MVC version comes complete with built-in ASP.NET Identity and bundling configured to ensure an even more streamlined user experience.
								<br>
								<br>
								You can use this project as the basis or extend on-top of it using the familiar MVC structure without any concessions whatsoever! The project comes with a built-in customizable setting manager to toggle functionality on and off without writing any additional code!
								<br><br>
								<strong>We welcome you to explore this brand new version and experience the theme hands-on!</strong>
							</h5>
						</div>
						<a href="http://mvc.myorange.ca/account/login" target="_blank" class="btn btn-default btn-lg btn-block bg-color-purple txt-color-white">MVC Demo <i class="fa fa-long-arrow-right"></i></a>
					</div>
					
				</div>	

				<div class="col-xs-12 col-sm-6 col-md-6 col-lg-6">
					<!-- your contents here -->
					<div class="jumbotron padding-10 text-center bg-color-white">
						<img src="img/versions/reactversion.png" alt="PHP Version" style="margin-left:-40px; width: 150px; margin-top:20px">
						<h1 style="font-size: 30px;">REACTJS version</h1>
						<div class="text-left padding-5" style="min-height:250px">
							<h5>This version is not yet available. Please follow us on twitter @bootstraphunt to be notified of future updates.</h5>
						</div>
						<a href="javascript:void(0);" target="_blank" class="btn btn-default disabled btn-lg btn-block bg-color-darken txt-color-white">Not yet available...</a>
					</div>
					
				</div>
					
			</div>

			<!-- end row -->

		</section>
		<!-- end widget grid -->
		

	</div>
	<!-- END MAIN CONTENT -->

</div>
<!-- END MAIN PANEL -->
<!-- ==========================CONTENT ENDS HERE ========================== -->

<!-- PAGE FOOTER -->
<?php
	// include page footer
	include("inc/footer.php");
?>
<!-- END PAGE FOOTER -->

<?php 
	//include required scripts
	include("inc/scripts.php"); 
?>

<!-- PAGE RELATED PLUGIN(S) 
<script src="<?php echo ASSETS_URL; ?>/js/plugin/YOURJS.js"></script>-->

<script>

	$(document).ready(function() {
		// PAGE RELATED SCRIPTS
	})

</script>

<?php 
	//include footer
	include("inc/google-analytics.php"); 
?>