use mac::mac_internal;

macro_rules! mac_with_ident {
    ($visibility:vis $item:ident) => {
        mac_internal!($visibility);
    };

    // reorder them (or comment out compile_error!)
    // to see the result of proc macro invocation
    ($item:ident) => {
        compile_error!("Ident-only branch chosen instead of branch with empty vis");
        mac_internal!();
    };

}

mac_with_ident!(pub foo);
// Proc macro invocation stream:
//
// TokenStream [Group { delimiter: None, stream: TokenStream [Ident { ident: "pub", span: #7 bytes(5155..5166) }], span: #7 bytes(5155..5166) }]
//
// Proc macro invocation result: ok.

#[cfg(none)]
mac_with_ident!(bar);
// Ok + Error
//
// Macro matching: ok. Matches first arm (with empty :vis)
//
// Proc macro invocation stream:
//
// TokenStream [Group { delimiter: None, stream: TokenStream [], span: #7 bytes(4461..4472) }]
//
// Proc macro invocation result:
//
// can not parse blank group which was generated by the compiler:
//
// error: proc macro panicked
// --> usage/src/with_ident.rs:5:9
// |
// 5  |         mac_internal!($visibility);
// |         ^^^^^^^^^^^^^^^^^^^^^^^^^^^
// ...
// 25 | mac_with_ident!(bar);
// | --------------------- in this macro invocation
// |
// = help: message: TAG_B: Error("unexpected token")
