SparkFun LED Array - 8x7 Arduino Library
===============================================

![SparkFun BME280 Breakout](https://cdn.sparkfun.com/r/188-188/assets/parts/1/1/3/6/9/13795-01.jpg)

[*SparkFun LED Array - 8x7*](https://www.sparkfun.com/products/13795)

Arduino Library for the charlieplexed 8x7 LED Array. 

To use the LED array with any ATmega 168 or 328-based Arduino, see the [SparkFun LED Array (8x7) Hookup Guide](https://learn.sparkfun.com/tutorials/sparkfun-led-array-8x7-hookup-guide).

A version of the LED array (called the "BadgerArray") also comes with the BadgerHack badges. Please check out the [BadgerHack Tutorial](https://learn.sparkfun.com/tutorials/badgerhack) for more information. The BadgerHack Demos are available [here](https://github.com/sparkfun/BadgerHack_Demos).

Repository Contents
-------------------

* **/examples** - Example sketches for the library (.ino). Run these from the Arduino IDE. 
* **/src** - Source files for the library (.cpp, .h).
* **library.properties** - General library properties for the Arduino package manager. 

Documentation
--------------

* **[Installing an Arduino Library Guide](https://learn.sparkfun.com/tutorials/installing-an-arduino-library)** - Basic information on how to install an Arduino library.
* **[Product Repository](https://github.com/sparkfun/LED_Array_8x7)** - Main repository (including hardware files) for the LED Array.
* **[Hookup Guide](https://learn.sparkfun.com/tutorials/sparkfun-led-array-8x7-hookup-guide)** - Basic hookup guide for the LED Array.

GitHub Version History
---------------
* [V1.3.1](https://github.com/sparkfun/SparkFun_LED_Array_8x7_Arduino_Library/tree/V_1.3.1) - Updated example licenses to MIT and moved curly braces to match SparkFun's coding standards
* [V1.3.0](https://github.com/sparkfun/SparkFun_LED_Array_8x7_Arduino_Library/tree/V_1.3.0) - Changed macro to real function and changed #define constants to static const global variables.
* [V1.2.0](https://github.com/sparkfun/SparkFun_LED_Array_8x7_Arduino_Library/tree/V_1.2.0) - Refresh rate based off frequency. Only works with ATmega 168/328-based Arduinos.
* [V1.1.0](https://github.com/sparkfun/SparkFun_LED_Array_8x7_Arduino_Library/tree/V_1.1.0) - The library has been updated to be compliant with the RedStick.
* [V1.0.0](https://github.com/sparkfun/SparkFun_LED_Array_8x7_Arduino_Library/tree/V_1.0.0) - This is the original BadgerStick release.

License Information
-------------------

This product is _**open source**_! 

Please review the LICENSE.md file for license information. 

If you have any questions or concerns on licensing, please contact techsupport@sparkfun.com.

Distributed as-is; no warranty is given.

- Your friends at SparkFun.


