SparkFun Qwiic Button Arduino Library [![Build Status](https://travis-ci.org/sparkfun/SparkFun_Qwiic_Button_Arduino_Library.svg?branch=master)](https://travis-ci.org/sparkfun/SparkFun_Qwiic_Button_Arduino_Library)
========================================
<table class="table table-hover table-striped table-bordered">
  <tr align="center">
   <td><a href="https://www.sparkfun.com/products/15932"><img src="https://cdn.sparkfun.com/assets/parts/1/4/5/7/3/15932-SparkFun_Qwiic_Button_-_Red-01.jpg"></a></td>
   <td><a href="https://www.sparkfun.com/products/15931"><img src="https://cdn.sparkfun.com/assets/parts/1/4/5/7/2/15931-SparkFun_Qwiic_Button_Breakout-01.jpg"></a></td>
   <td><a href="https://www.sparkfun.com/products/15591"><img src="https://cdn.sparkfun.com//assets/parts/1/4/1/9/8/15591-Qwiic_Arcade_-_Red-01a.jpg"></a></td>
   <td><a href="https://www.sparkfun.com/products/15592"><img src="https://cdn.sparkfun.com//assets/parts/1/4/1/9/9/15592-Qwiic_Arcade_-_Blue-01a.jpg"></a></td>
   <td><a href="https://www.sparkfun.com/products/15586"><img src="https://cdn.sparkfun.com//assets/parts/1/4/1/9/2/15586-Qwiic_Switch__without_microswitch_-01a.jpg"></a></td>
  </tr>
  <tr align="center">
    <td><a href="https://www.sparkfun.com/products/15932">SparkFun Qwiic Button - Red (BOB-15932)</a></td>
    <td><a href="https://www.sparkfun.com/products/15931">SparkFun Qwiic Button Breakout (BOB-15931)</a></td>
    <td><a href="https://www.sparkfun.com/products/15591">SparkFun Qwiic Arcade - Red (SPX-15591)</a></td>
    <td><a href="https://www.sparkfun.com/products/15592">SparkFun Qwiic Arcade - Blue (SPX-15592)</a></td>
    <td><a href="https://www.sparkfun.com/products/15586">SparkFun Qwiic Switch (SPX-15586)</a></td>
  </tr>
</table>


This library allows the user to:

* Determine whether or not the button/switch is pressed 
* Set the brightness of the onboard LED
* Configure the onboard LED's "breathing" effect
* Use button-based interrupts
* Adjust the device's I<sup>2</sup>C address


Repository Contents
-------------------

* **/examples** - Example sketches for the library (.ino). Run these from the Arduino IDE. 
* **/src** - Source files for the library (.cpp, .h).
* **keywords.txt** - Keywords from this library that will be highlighted in the Arduino IDE. 
* **library.properties** - General library properties for the Arduino package manager. 

Documentation
--------------

* **[Installing an Arduino Library Guide](https://learn.sparkfun.com/tutorials/installing-an-arduino-library)** - Basic information on how to install an Arduino library.
* **[Product Repository](https://github.com/sparkfun/Qwiic_Button)** - Main repository (including hardware files) for the SparkFun Qwiic Button Breakout Board.
* **[Product Repository](https://github.com/sparkfunX/Qwiic_Switch)** - Main repository (including hardware files) for the SparkFun Qwiic Switch.
* **[Product Repository](https://github.com/sparkfunX/Qwiic_Button)** - Main repository (including hardware files) for the SparkFun Qwiic Button.

Products that use this Library 
---------------------------------

* [*BOB-15932*](https://www.sparkfun.com/products/15932) - SparkFun Red Version with red LED pushbutton
* [*BOB-16842*](https://www.sparkfun.com/products/16842) - SparkFun Red Version with green LED pushbutton
* [*BOB-15931*](https://www.sparkfun.com/products/15931) - SparkFun Red Version without button
* [*SPX-15584*](https://www.sparkfun.com/products/15584) - Original SparkX version of the Qwiic Button (Red LED)
* [*SPX-15585*](https://www.sparkfun.com/products/15585) - Original SparkX version of the Qwiic Button (Blue LED)
* [*SPX-15591*](https://www.sparkfun.com/products/15591) - Original SparkX version of the Qwiic Button (Arcade Red Pushbutton)
* [*SPX-15592*](https://www.sparkfun.com/products/15592) - Original SparkX version of the Qwiic Button (Arcade Blue Pushbutton)
* [*SPX-15586*](https://www.sparkfun.com/products/15586) - Original SparkX version of the Qwiic Button

Version History
---------------

* [v1.0.1](https://github.com/sparkfun/SparkFun_Qwiic_Button_Arduino_Library/releases/tag/v1.0.1) - Arduino Library Specification Compliance
* [v1.0.0](https://github.com/sparkfun/SparkFun_Qwiic_Button_Arduino_Library/releases/tag/v1.0.0) - Initial Public release.

License Information
-------------------

This product is _**open source**_! 

Please review the LICENSE.md file for license information. 

If you have any questions or concerns on licensing, please contact techsupport@sparkfun.com.

Distributed as-is; no warranty is given.

- Your friends at SparkFun.
