package org.springframework.batch.sample;

import java.util.ArrayList;
import java.util.List;

import javax.sql.DataSource;

import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.configuration.annotation.EnableBatchProcessing;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseBuilder;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseType;
import org.springframework.util.StopWatch;

@Configuration
@EnableBatchProcessing
public class JobRepositoryBenchmark {
	
//	Uncomment this datasource bean to activate the JDBC based job repository
//	@Bean
//	public DataSource dataSource() {
//		return new EmbeddedDatabaseBuilder()
//				.setType(EmbeddedDatabaseType.H2)
//				.addScript("/org/springframework/batch/core/schema-drop-h2.sql")
//				.addScript("/org/springframework/batch/core/schema-h2.sql")
//				.build();
//	}

	/*
	   |Number of Partitions             | 1000 | 2000 | 5000                              |
	   |---------------------------------|------|------|-----------------------------------|
	   |Map repository                   | 22s  | 92s  | OOM after 20min (even with -Xmx8g)|
	   |JDBC repository with in-memory H2| 0.21s| 0.3s | 0.42s                             |
	 */
	public static void main(String[] args) throws Exception {
		ApplicationContext context = new AnnotationConfigApplicationContext(JobRepositoryBenchmark.class);
		JobRepository jobRepository = context.getBean(JobRepository.class);
		
		JobExecution jobExecution = jobRepository.createJobExecution("job", new JobParameters());
		List<StepExecution> stepExecutions = new ArrayList<>();
		for (int i = 0; i < 5000; i++) {
			stepExecutions.add(jobExecution.createStepExecution("step" + i));
		}
		StopWatch stopWatch = new StopWatch();
		stopWatch.start();
		jobRepository.addAll(stepExecutions);
		stopWatch.stop();
		System.out.println(stopWatch.getTotalTimeSeconds() + "s");
	}

}