﻿;
; draw rotated ellipses and boxes
;
; draw sheared boxes
;
XIncludeFile "gDrawing.pbi"

Procedure Draw()
    gDrawingMode( #PB_2DDrawing_Outlined )
    ;
    ; gEllipse rotieren
    ;
    For i = 0 To 90 Step 10
        gRotateAt(100,100,i) : gEllipse(100,100,100,30) : gResetTransform()
    Next i
    ;
    ; gEllipse rotieren ohne gResetTransform
    ;
    For i = 0 To 90 Step 10
        gRotateAt(300,100,i) : gEllipse(300,100,100,30) ; ohne gResetTransform() wird der winkel immer wieder hinzuaddiert
    Next i

    gResetTransform() ; Transformationen rücksetzen

    ;
    ; gBox rotieren um linke obere Ecke
    ;
    For i = 0 To 2 
        gRotateAt(100,300,i*20) : gBox(100,300,100,100) : gResetTransform()
    Next i

    ;
    ; gBox rotieren um mittelpunkt
    ;
    For i = 0 To 2
        gRotateAt(350,350,i*20) : gBox(300,300,100,100) : gResetTransform()
    Next i
    ;
    ; gBox rotieren um rechte untere Ecke
    ;
    For i = 0 To 2
        gRotateAt(600,400,i*20) : gBox(500,300,100,100) : gResetTransform()
    Next i

    gShearAt(100,480,0.5, 0 ) : gBox(100,480,100,50) : gResetTransform() ; shear X   um linke obere Ecke
    gShearAt(250,480, 0 ,0.5) : gBox(250,480,100,50) : gResetTransform() ; shear Y   um linke obere Ecke
    gShearAt(400,480,0.5,0.5) : gBox(400,480,100,50) : gResetTransform() ; shear X+Y um linke obere Ecke
    gShearAt(600,505,0.5,0.5) : gBox(550,480,100,50) : gResetTransform() ; shear X+Y um mittelpunkt
EndProcedure

If gInit()
    mainWin = OpenWindow(#PB_Any,0,0,800,600,"gDrawing feature demo",#PB_Window_SystemMenu|#PB_Window_ScreenCentered)
    img = CreateImage(#PB_Any,800,600,24)
    If gStartDrawing( ImageOutput(img) )
        gClear( RGBA($AA,$AA,$AA,$FF) )
        Draw()
        gStopDrawing()
    EndIf
    imgWin  = ImageGadget(#PB_Any,0,0,800,600,ImageID(img))
    Repeat : Until WaitWindowEvent()=#PB_Event_CloseWindow
    gEnd()
EndIf

; IDE Options = PureBasic 4.51 (Windows - x86)
; CursorPosition = 4
; Folding = -
; EnableXP
; Executable = gdiplus.exe
; CPU = 5