﻿EnableExplicit

XIncludeFile "gDrawing.pbi"

Procedure MirrorImage(original,x,y)
    Protected copy, w, h
    copy = CreateImage(#PB_Any,ImageWidth(original),ImageHeight(original),32)
    ;copy = CopyImage(original,#PB_Any)
    If copy
        w = ImageWidth(original)
        h = ImageHeight(original)
        If gStartDrawing( ImageOutput(copy) )
            gSetPenImage( ImageID(original) ,#WrapModeTileFlipXY)
            If x : gSetPenOrigin(0,h) : EndIf
            If y : gSetPenOrigin(w,0) : EndIf
            gBox(0,0,w,h)
            gStopDrawing()
        EndIf
    EndIf
    ProcedureReturn copy
EndProcedure

Procedure FadeOutImage(original,horizontal=0)
    Protected copy
    copy = CopyImage(original,#PB_Any)
    If copy
        If gStartDrawing( ImageOutput(copy) )
            DrawingMode(#PB_2DDrawing_Gradient|#PB_2DDrawing_AlphaChannel)      
            BackColor ($FF000000)
            FrontColor($00000000)
            If horizontal
                LinearGradient(0,0,ImageWidth(copy),0)
            Else
                LinearGradient(0,0,0,ImageHeight(copy))
            EndIf
            Box(0,0,ImageWidth(copy),ImageHeight(copy))
            gStopDrawing()
        EndIf
    EndIf
    ProcedureReturn copy

EndProcedure

Procedure DrawShearedImage(img,x.f,y.f,ShearX.f,ShearY.f,widthScale.f,HeightScale.f)
    gStartTransform()
        gShearAt(x,y,ShearX,ShearY)
        gDrawImage(img,x,y,ImageWidth(img)*widthScale,ImageHeight(img)*HeightScale)
    gStopTransform()
EndProcedure

Define pbLogo, pbLogoMirror, pbLogoFaded, img

pbLogo = LoadImage(#PB_Any,#PB_Compiler_Home+"Examples\Sources\Data\PureBasicLogo.bmp")
If Not pbLogo : MessageRequester("ERROR","Unable to load PureBasic logo!") : End : EndIf


If gInit()

    pbLogoMirror = MirrorImage(pbLogo,1,0)
    pbLogoFaded  = FadeOutImage(pbLogoMirror)
    
    img = CreateImage(#PB_Any,800,600)
    If gStartDrawing( ImageOutput(img) )
        gClear($FF808080)
        gDrawImage(ImageID(pblogo),100,100)
        DrawShearedImage(pbLogoFaded,100,100+ImageHeight(pbLogo),1.8,0,1,0.8)
        gStopDrawing()
    EndIf

    OpenWindow(#PB_Any,0,0,800,600,"gDrawing gShear",#PB_Window_SystemMenu|#PB_Window_ScreenCentered)
    ImageGadget(#PB_Any,0,0,800,600,ImageID( img ),#PB_Image_Border ) ; normal
    Repeat : Until WaitWindowEvent()=#PB_Event_CloseWindow
    gEnd()
EndIf

; IDE Options = PureBasic 4.51 (Windows - x86)
; CursorPosition = 46
; FirstLine = 14
; Folding = -
; EnableXP
; Executable = Beispiel3.exe
; CPU = 5