﻿;
; gDrawClippedImage() demo
;
EnableExplicit

XIncludeFile "gDrawing.pbi"

Global pbLogo, pbLogoSrc, transparency.f=1.0
Define trackbar, picturebox, img

Procedure Draw(image)
    Protected height = ImageHeight(pbLogoSrc)
    Protected width  = ImageWidth (pbLogoSrc)
    Protected i, j

    If gStartDrawing( ImageOutput(image) )
        gClear(RGBA($80,$80,$80,$FF))
        For i = 0 To height-2
            ;gStartTransform()
                gRotateAt(50,50,i*0.3)
                gDrawClippedImage(pbLogo,50,50+i,-1,-1,0,i,width-1,1,transparency)
                gResetTransform()
            ;gStopTransform()
    
            ;gStartTransform()
                gRotateAt(500,50,i*0.4)
                For j = 0 To 4
                    gDrawClippedImage(pbLogo,500,50+i,-1,-1,0,i,width-1,1,transparency)
                    gRotateAt(500,50,0.1)
                Next j
                gResetTransform()
            ;gStopTransform()
    
            For j = 0 To 3
                gDrawClippedImage(pbLogo,50+Sin(i*0.1)*10,300+j+i*4,-1,-1,0,i,width-1,1,transparency)
            Next j
    
            ;gStartTransform()
                gRotateAt(500,300,i*0.4)
                For j = 0 To 5
                    gDrawClippedImage(pbLogo,500+Sin(i*0.1)*20,300+i,-1,-1,0,i,width-1,1,transparency)
                    gRotateAt(500,300,0.1)
                Next j
                gResetTransform()
            ;gStopTransform()
        Next i
        gStopDrawing()
    EndIf
EndProcedure

pbLogoSrc = LoadImage(#PB_Any,#PB_Compiler_Home+"Examples\Sources\Data\PureBasicLogo.bmp")
If Not pbLogoSrc : MessageRequester("ERROR","Unable to load PureBasic logo!") : End : EndIf

If gInit()

    pbLogo = gBufferImage(pbLogoSrc)

    img = CreateImage(#PB_Any,1024,600)
    Draw(img)

    OpenWindow(#PB_Any,0,0,1024,640,"gDrawing: gDrawClippedImage",#PB_Window_SystemMenu|#PB_Window_ScreenCentered)
    picturebox = ImageGadget(#PB_Any,0,0,1024,600,ImageID( img ))
    TextGadget(#PB_Any,0,600,1024,20,"Transparency:")
    trackbar = TrackBarGadget(#PB_Any,0,620,1024,20,0,1024)
    SetGadgetState(trackbar,1024)
    Repeat
        Select WaitWindowEvent()
            Case #PB_Event_CloseWindow
                Break
            Case #PB_Event_Gadget
                If EventGadget()=trackbar ;And EventType()=#PB_EventType_Change
                    transparency = GetGadgetState(trackbar)/1024.0
                    Draw(img)
                    SetGadgetState(picturebox,ImageID(img))
                EndIf
        EndSelect
    ForEver

    gEnd()
EndIf

; IDE Options = PureBasic 4.51 (Windows - x86)
; CursorPosition = 2
; Folding = -
; EnableXP
; Executable = Beispiel3.exe
; CPU = 5
; DisableDebugger