﻿;
; gRoundBox() demo
;
EnableExplicit

XIncludeFile "gDrawing.pbi"

Global size.f
Define trackbar, picturebox, img

#roundX = 60
#roundY = 20

Procedure Draw(image)
    If gStartDrawing( ImageOutput(image) )
        gClear(RGBA($80,$80,$80,$FF))
        gSetPen($80000000,1.5)
        gSetPenAlignment( #PenAlignmentInset )

        ;gSetPenStyle(#PenStyleDot)

        
         RoundBox(460,10,300+size,200+size,#roundX,#roundY)
        gRoundBox( 10,10,300+size,200+size,#roundX,#roundY)

        gDrawingMode(#PB_2DDrawing_Outlined)
         DrawingMode(#PB_2DDrawing_Outlined)

        gSetPenColor($FF000000)

         RoundBox(460,310,300+size,200+size,#roundX,#roundY)
        gRoundBox( 10,310,300+size,200+size,#roundX,#roundY)
        
        gStopDrawing()
    EndIf
EndProcedure

If gInit()

    img = CreateImage(#PB_Any,1024,600)
    Draw(img)

    OpenWindow(#PB_Any,0,0,1024,640,"gDrawing: gRoundBox",#PB_Window_SystemMenu|#PB_Window_ScreenCentered)
    picturebox = ImageGadget(#PB_Any,0,0,1024,600,ImageID( img ))
    TextGadget(#PB_Any,0,600,1024,20,"Size:")
    trackbar = TrackBarGadget(#PB_Any,0,620,1024,20,0,300)
    SetGadgetState(trackbar,0)
    Repeat
        Select WaitWindowEvent()
            Case #PB_Event_CloseWindow
                Break
            Case #PB_Event_Gadget
                If EventGadget()=trackbar ;And EventType()=#PB_EventType_Change
                    size = GetGadgetState(trackbar)
                    Draw(img)
                    SetGadgetState(picturebox,ImageID(img))
                EndIf
        EndSelect
    ForEver

    gEnd()
EndIf

; IDE Options = PureBasic 4.51 (Windows - x86)
; CursorPosition = 1
; Folding = -
; EnableXP
; Executable = Beispiel3.exe
; CPU = 5
; DisableDebugger