﻿;
; gSetClippingBox() demo 2 - combine clipping boxes by using #CombineModeUnion
;
EnableExplicit

XIncludeFile "gDrawing.pbi"

Procedure Draw(image)
    Protected i,j

    If gStartDrawing( ImageOutput(image) )
        gClear(RGBA($80,$80,$80,$FF))

        gClipBox(0,0,0,0)                                ; set clipping to nothing

        For j = 0 To 600 Step 100
            For i = 0 To 800 Step 100
                gClipBox(i,j,50,50,#CombineModeUnion)    ; add some clipping boxes
            Next i
        Next j

        For i = 0 To 600 Step 8
            gLineXY( 0 , 0 ,800,i,$FF0000FF)
            gLineXY(800,600, 0 ,i,$FFFF0000)
        Next i
        
        gResetClip()                                     ; reset clipping
        gLineXY(0,0,800,600)
        
        gStopDrawing()
    EndIf
EndProcedure

Define img

If gInit()

    img = CreateImage(#PB_Any,800,600)
    Draw(img)

    OpenWindow(#PB_Any,0,0,800,600,"gDrawing: gClipBox 2",#PB_Window_SystemMenu|#PB_Window_ScreenCentered)
    ImageGadget(#PB_Any,0,0,800,600,ImageID( img ))
    Repeat : Until WaitWindowEvent()=#PB_Event_CloseWindow

    gEnd()
EndIf

; IDE Options = PureBasic 4.51 (Windows - x86)
; CursorPosition = 26
; Folding = -
; EnableXP
; Executable = Beispiel3.exe
; CPU = 5
; DisableDebugger