﻿EnableExplicit

XIncludeFile "gDrawing.pbi"

Global pbLogoSrc

Procedure Draw(image)
    Protected i,j
    Dim paths.i(4)

    If gStartDrawing( ImageOutput(image) )
        gClear(RGBA($80,$80,$80,$FF))
        gSetPenSize(3)

        ;
        ; HEART with PB logo
        ;
        gDrawingMode(#PB_2DDrawing_Path)
            gArc(200,100,100,50,150,210)                   ; 2 arc's and 1 point make a heart
            gArc(400,100,100,50,180,210)
            gPlot(300,200)
            gClosePath()
        gDrawingMode(#PB_2DDrawing_Default)
            gDrawPath(#PB_Default,RGBA($FF,$FF,$00,$FF))   ; draw current path with yellow color
        gDrawingMode(#PB_2DDrawing_Outlined)
            gDrawPath(#PB_Default,RGBA($00,$00,$00,$FF))   ; draw current path outlined with black color

        gClipPath()                                        ; now set clipping to the same path
            gDrawImage(pbLogoSrc,100,75,400,70)            ; and draw the PB logo
        gResetClip()                                       ; reset clipping


        ;
        ; 4 figures, made with paths
        ;
        gClearPath()                                       ; clear the current path
        gDrawingMode(#PB_2DDrawing_Path)                   ; and draw some new paths:

        gArc(100,400,20,50, 90, 180)                       ; check this 4 paths:
        gArc(200,400,20,50, 90,-180)                       ;    - they are all 2 gArc's with size 20,50
        paths(1) = gGetPath()                              ;    - the x,y coordinates differ
        gClearPath()                                       ;    - but the main difference is the drawing direction! (last 2 args)
                                                           ;      
        gArc(250,400,20,50, 90, 180)                       ;    for paths the drawing order and drawing direction 
        gArc(350,400,20,50,-90,-180)                       ;    is very important.
        paths(2) = gGetPath()                              ;    the drawing order and direction make the direction of the path!
        gClearPath()

        gArc(400,400,20,50, 90, 180)
        gArc(500,400,20,50, 90, 180)
        paths(3) = gGetPath()
        gClearPath()

        gArc(550,400,20,50, 90,-180)
        gArc(650,400,20,50,-90,-180)
        paths(4) = gGetPath()
        gClearPath()

        ;
        ; draw 4 paths, draw 4 figures
        ;        
        For i = 1 To 4
            gClosePath( paths(i) )
            gDrawingMode(#PB_2DDrawing_Default)
            gDrawPath( paths(i) ,RGBA($FF,$FF,$00,$FF))  ; draw the path with yellow color
            gDrawingMode(#PB_2DDrawing_Outlined)
            gDrawPath( paths(i),RGBA($00,$00,$00,$FF))   ; draw the path outlined with black color

            gClipPath( paths(i) )                        ; now set clipping to the same path,
              gDrawImage(pbLogoSrc,i*150-50,380,100,30)  ; draw the PB logo,
            gResetClip()                                 ; and reset the clipping
        Next i

        gStopDrawing()
    EndIf
EndProcedure

Define img

pbLogoSrc = LoadImage(#PB_Any,#PB_Compiler_Home+"Examples\Sources\Data\PureBasicLogo.bmp")
If Not pbLogoSrc : MessageRequester("ERROR","Unable to load PureBasic logo!") : End : EndIf


If gInit()

    img = CreateImage(#PB_Any,800,600)
    Draw(img)

    OpenWindow(#PB_Any,0,0,800,600,"gDrawing: drawing with Path's",#PB_Window_SystemMenu|#PB_Window_ScreenCentered)
    ImageGadget(#PB_Any,0,0,800,600,ImageID( img ))
    Repeat : Until WaitWindowEvent()=#PB_Event_CloseWindow

    gEnd()
EndIf

; IDE Options = PureBasic 4.51 (Windows - x86)
; CursorPosition = 29
; FirstLine = 22
; Folding = -
; EnableXP
; Executable = Beispiel3.exe
; CPU = 5
; DisableDebugger