﻿;
; drawing with clipped text
;
EnableExplicit

XIncludeFile "gDrawing.pbi"

Global pbLogoSrc

Procedure Draw(image)
    Protected i,j
    Dim paths.i(4)

    If gStartDrawing( ImageOutput(image) )
        gClear(RGBA($80,$80,$80,$FF))
        ;gClear(RGBA($FF,$FF,$FF,$FF))
        gSetPen(RGBA($00,$00,$00,$FF),2)
        gSetFont("Courier New",80,#PB_Font_Bold)

        gDrawingMode(#PB_2DDrawing_Path)
            gDrawText(10,10,"Clipped Text 1")
            gDrawText(10,110,"Clipped Text 2")
            gDrawText(10,210,"Clipped Text 3")
            gDrawText(10,310,"Clipped Text 4")
        gDrawingMode(#PB_2DDrawing_Default)
        gDrawPath(#PB_Default,$FF00FFFF)

        gClipPath()
            gDrawingMode(#PB_2DDrawing_Default)
    
            For i = 0 To 100
                gLine(0,i+110,800,0,RGBA($00,$00,$00,i*2.5))
            Next i
            
            gSetPenPattern(5,RGBA($FF,$FF,$00,$FF),RGBA($00,$00,$00,$FF))
            gBox(0,210,800,100)
    
            gSetPen(RGBA($00,$00,$00,$FF),2)
    
            gBox(0,310,800,100)
            For i = 0 To 100 Step 4
                gLine(0,310,800,i,RGBA($FF,$FF,$00,i*2.5))
            Next i
        gResetClip()

        gDrawingMode(#PB_2DDrawing_Outlined)
        gDrawPath()

        gStopDrawing()
    EndIf
EndProcedure

Define img


If gInit()

    img = CreateImage(#PB_Any,800,600)
    Draw(img)

    OpenWindow(#PB_Any,0,0,800,600,"gDrawing: drawing with clipped text",#PB_Window_SystemMenu|#PB_Window_ScreenCentered)
    ImageGadget(#PB_Any,0,0,800,600,ImageID( img ))
    Repeat : Until WaitWindowEvent()=#PB_Event_CloseWindow

    gEnd()
EndIf

; IDE Options = PureBasic 4.51 (Windows - x86)
; CursorPosition = 2
; Folding = -
; EnableXP
; Executable = Beispiel3.exe
; CPU = 5
; DisableDebugger