﻿; Noch ein kleiner Trick mit gScale() / gScaleAt():
; Wenn man für die Skalierungswerte -1 verwendet, kann man die
; Zeichenbefehle spiegeln. 
;
; Am besten mal ausprobieren.

XIncludeFile "gDrawing.pbi"

Procedure ScaleDemo(scaleX.f, scaleY.f)
    img = CreateImage(#PB_Any,400,300,24)
    If gStartDrawing( ImageOutput(img) )
        gClear( RGBA($AA,$AA,$AA,$FF) )

        gScaleAt(200,150,scaleX,scaleY)
    
        gStartTransform()
            gDrawingMode( #PB_2DDrawing_Outlined )
            ;
            ; gEllipse rotieren
            ;
            For i = 0 To 90 Step 10
                gRotateAt(50,50,i) : gEllipse(50,50,50,15) : gResetTransform()
            Next i
        gStopTransform()

        gStopDrawing()
    EndIf
    ProcedureReturn img
EndProcedure

If gInit()
    mainWin = OpenWindow(#PB_Any,0,0,800,600,"gDrawing scale demo",#PB_Window_SystemMenu|#PB_Window_ScreenCentered)
    ImageGadget(#PB_Any,  0,  0,400,300,ImageID( ScaleDemo( 1, 1) )) ; normal
    ImageGadget(#PB_Any,400,  0,400,300,ImageID( ScaleDemo(-1, 1) )) ; gespiegelt um Y-Achse
    ImageGadget(#PB_Any,  0,300,400,300,ImageID( ScaleDemo( 1,-1) )) ; gespiegelt um X-Achse
    ImageGadget(#PB_Any,400,300,400,300,ImageID( ScaleDemo(-1,-1) )) ; gespiegelt um X- und Y-Achse
    Repeat : Until WaitWindowEvent()=#PB_Event_CloseWindow
    gEnd()
EndIf

; IDE Options = PureBasic 4.51 (Windows - x86)
; CursorPosition = 23
; Folding = -
; EnableXP
; Executable = Beispiel2.exe
; CPU = 5