﻿;>----- START INCLUDE "gDrawing.pbi" ------------------------
;
;-[ antialiased PB syntax compatible drawing functions using GDI+ ]-
;
; by Danilo, July 2011
;
; big thanks to all helpers in the german forum!
;
; Version 0.80
;
Prototype DebugEventProc(level, *message.Ascii)
Prototype NotificationHookProc(*token.Long)
Prototype NotificationUnhookProc(token.l)

;-------- structures

Structure GdiplusStartupInput
    GdiPlusVersion.l
    *DebugEventCallback.DebugEventProc
    SuppressBackgroundThread.l
    SuppressExternalCodecs.l
EndStructure

Structure GdiplusStartupOutput
    *NotificationHook.NotificationHookProc
    *NotificationUnhook.NotificationUnhookProc
EndStructure

Structure POINTF
    X.f
    Y.f
EndStructure

Structure RECTF
    X.f
    Y.f
    Width.f
    Height.f
EndStructure

Structure ColorMatrix
    m0.f[5]
    m1.f[5]
    m2.f[5]
    m3.f[5]
    m4.f[5]
EndStructure

;-------- enumerations

Enumeration ; CompositingMode
    #CompositingModeSourceOver = 0 ;   // 0
    #CompositingModeSourceCopy = 1 ;   // 1
EndEnumeration

Enumeration ; QualityMode
    #QualityModeInvalid   = -1
    #QualityModeDefault   =  0
    #QualityModeLow       =  1  ; Best performance
    #QualityModeHigh      =  2  ; Best rendering quality
EndEnumeration

Enumeration ; CompositingQuality
    #CompositingQualityInvalid          = #QualityModeInvalid
    #CompositingQualityDefault          = #QualityModeDefault
    #CompositingQualityHighSpeed        = #QualityModeLow
    #CompositingQualityHighQuality      = #QualityModeHigh
    #CompositingQualityGammaCorrected
    #CompositingQualityAssumeLinear
EndEnumeration

Enumeration ; SmoothingMode
    #SmoothingModeInvalid     = #QualityModeInvalid
    #SmoothingModeDefault     = #QualityModeDefault
    #SmoothingModeHighSpeed   = #QualityModeLow
    #SmoothingModeHighQuality = #QualityModeHigh
    #SmoothingModeNone
    #SmoothingModeAntiAlias
;#if (GDIPVER >= 0x0110)
    #SmoothingModeAntiAlias8x4 = #SmoothingModeAntiAlias
    #SmoothingModeAntiAlias8x8
;#endif //(GDIPVER >= 0x0110) 
EndEnumeration

Enumeration ; SmoothingMode
    ;#AntiAliasModeInvalid     = #QualityModeInvalid
    #AntialiasMode_Default     = #QualityModeDefault
    #AntialiasMode_HighSpeed   = #QualityModeLow
    #AntialiasMode_HighQuality = #QualityModeHigh
    #AntialiasMode_None
    #AntialiasMode_AntiAlias
;#if (GDIPVER >= 0x0110)
    #AntialiasMode_AntiAlias8x4 = #SmoothingModeAntiAlias
    #AntialiasMode_AntiAlias8x8
;#endif //(GDIPVER >= 0x0110) 
EndEnumeration

Enumeration ; TextRenderingHint
    #TextAntialiasMode_SystemDefault = 0            ; Glyph With system Default rendering hint
    #TextAntialiasMode_SingleBitPerPixelGridFit     ; Glyph bitmap With hinting
    #TextAntialiasMode_SingleBitPerPixel            ; Glyph bitmap without hinting
    #TextAntialiasMode_AntiAliasGridFit             ; Glyph anti-alias bitmap With hinting
    #TextAntialiasMode_AntiAlias                    ; Glyph anti-alias bitmap without hinting
    #TextAntialiasMode_ClearTypeGridFit             ; Glyph CT bitmap With hinting
EndEnumeration


Enumeration ; InterpolationMode
    #InterpolationModeInvalid          = #QualityModeInvalid
    #InterpolationModeDefault          = #QualityModeDefault
    #InterpolationModeLowQuality       = #QualityModeLow
    #InterpolationModeHighQuality      = #QualityModeHigh
    #InterpolationModeBilinear
    #InterpolationModeBicubic
    #InterpolationModeNearestNeighbor
    #InterpolationModeHighQualityBilinear
    #InterpolationModeHighQualityBicubic
EndEnumeration

Enumeration ; PixelOffsetMode
    #PixelOffsetModeInvalid     = #QualityModeInvalid
    #PixelOffsetModeDefault     = #QualityModeDefault
    #PixelOffsetModeHighSpeed   = #QualityModeLow
    #PixelOffsetModeHighQuality = #QualityModeHigh
    #PixelOffsetModeNone     ; No pixel offset
    #PixelOffsetModeHalf     ; Offset by -0.5, -0.5 For fast anti-alias perf
EndEnumeration

Enumeration ; PenStyle
    #PenStyleSolid
    #PenStyleDash
    #PenStyleDot
    #PenStyleDashDot
    #PenStyleDashDotDot
    #PenStyleCustom
EndEnumeration

Enumeration ; PenPattern
   #PenPatternHorizontal
   #PenPatternVertical
   #PenPatternForwardDiagonal
   #PenPatternBackwardDiagonal
   #PenPatternCross
   #PenPatternDiagonalCross
   #PenPattern05Percent
   #PenPattern10Percent
   #PenPattern20Percent
   #PenPattern25Percent
   #PenPattern30Percent
   #PenPattern40Percent
   #PenPattern50Percent
   #PenPattern60Percent
   #PenPattern70Percent
   #PenPattern75Percent
   #PenPattern80Percent
   #PenPattern90Percent
   #PenPatternLightDownwardDiagonal
   #PenPatternLightUpwardDiagonal
   #PenPatternDarkDownwardDiagonal
   #PenPatternDarkUpwardDiagonal
   #PenPatternWideDownwardDiagonal
   #PenPatternWideUpwardDiagonal
   #PenPatternLightVertical
   #PenPatternLightHorizontal
   #PenPatternNarrowVertical
   #PenPatternNarrowHorizontal
   #PenPatternDarkVertical
   #PenPatternDarkHorizontal
   #PenPatternDashedDownwardDiagonal
   #PenPatternDashedUpwardDiagonal
   #PenPatternDashedHorizontal
   #PenPatternDashedVertical
   #PenPatternSmallConfetti
   #PenPatternLargeConfetti
   #PenPatternZigZag
   #PenPatternWave
   #PenPatternDiagonalBrick
   #PenPatternHorizontalBrick
   #PenPatternWeave
   #PenPatternPlaid
   #PenPatternDivot
   #PenPatternDottedGrid
   #PenPatternDottedDiamond
   #PenPatternShingle
   #PenPatternTrellis
   #PenPatternSphere
   #PenPatternSmallGrid
   #PenPatternSmallCheckerBoard
   #PenPatternLargeCheckerBoard
   #PenPatternOutlinedDiamond
   #PenPatternSolidDiamond

   #PenPatternTotal

   #PenPatternLargeGrid = #PenPatternCross

   #PenPatternMin       = #PenPatternHorizontal
   #PenPatternMax       = #PenPatternTotal - 1
EndEnumeration

Enumeration ; LineCap
    #LineCapFlat             = 0
    #LineCapSquare           = 1
    #LineCapRound            = 2
    #LineCapTriangle         = 3

    #LineCapNoAnchor         = $10 ; corresponds To flat cap
    #LineCapSquareAnchor     = $11 ; corresponds To square cap
    #LineCapRoundAnchor      = $12 ; corresponds To round cap
    #LineCapDiamondAnchor    = $13 ; corresponds To triangle cap
    #LineCapArrowAnchor      = $14 ; no correspondence
    #LineCapOpenArrowAnchor  = $15 ; no correspondence

    #LineCapCustom           = $ff ; custom cap

    #LineCapAnchorMask       = $f0 ; mask To check For anchor Or Not.
EndEnumeration

Enumeration ; LineCap
    #PenCapFlat             = 0
    #PenCapSquare           = 1
    #PenCapRound            = 2
    #PenCapTriangle         = 3

    #PenCapNoAnchor         = $10 ; corresponds To flat cap
    #PenCapSquareAnchor     = $11 ; corresponds To square cap
    #PenCapRoundAnchor      = $12 ; corresponds To round cap
    #PenCapDiamondAnchor    = $13 ; corresponds To triangle cap
    #PenCapArrowAnchor      = $14 ; no correspondence
    #PenCapOpenArrowAnchor  = $15 ; no correspondence

    #PenCapCustom           = $ff ; custom cap

    #PenCapAnchorMask       = $f0 ; mask To check For anchor Or Not.
EndEnumeration

Enumeration ; WrapMode
    #WrapModeTile         ; 0
    #WrapModeTileFlipX    ; 1
    #WrapModeTileFlipY    ; 2
    #WrapModeTileFlipXY   ; 3
    #WrapModeClamp        ; 4
EndEnumeration

Enumeration ; Unit
    #UnitWorld       ; 0 -- World coordinate (non-physical unit)
    #UnitDisplay     ; 1 -- Variable -- For PageTransform only
    #UnitPixel       ; 2 -- Each unit is one device pixel.
    #UnitPoint       ; 3 -- Each unit is a printer's point, or 1/72 inch.
    #UnitInch        ; 4 -- Each unit is 1 inch.
    #UnitDocument    ; 5 -- Each unit is 1/300 inch.
    #UnitMillimeter  ; 6 -- Each unit is 1 millimeter.
EndEnumeration

Enumeration ; PenAlignment
    #PenAlignmentCenter       = 0
    #PenAlignmentInset        = 1
EndEnumeration

Enumeration ; CombineMode for Clipping
    #CombineModeReplace     ; 0 - Specifies that the existing clipping region is replaced by the new clipping region.
    #CombineModeIntersect   ; 1 - Specifies that the existing clipping region is replaced by the intersection of itself and the new clipping region. 
    #CombineModeUnion       ; 2 - Specifies that the existing clipping region is replaced by the union of itself and the new clipping region.
    #CombineModeXor         ; 3 - Specifies that the existing clipping region is replaced by the result of performing an XOR on the two clipping regions.
                            ;     A point is in the XOR of two clipping regions if it is in one clipping region or the other but not in both clipping regions.
    #CombineModeExclude     ; 4 - Specifies that the existing clipping region is replaced by the portion of itself that is outside of the new clipping region.
    #CombineModeComplement  ; 5 (Exclude From)
                            ;   - Specifies that the existing clipping region is replaced by the portion of the new clipping region that is outside of the existing clipping region. 
EndEnumeration

#PB_2DDrawing_Path = %10000000000000000000

#gNOCOLOR = $1FFFFFFFF

;-------- function prototypes

Prototype.l GdiplusStartup      (*token.Long, *input.GdiplusStartupInput, *output.GdiplusStartupOutput)
Prototype.l GdiplusShutdown     (token.l)

Prototype.l GdipCreateFromHDC   (*hDC, *graphics)
Prototype.l GdipDeleteGraphics  (*graphics)

Prototype.l GdipBeginContainer2 (*graphics, *state)
Prototype.l GdipEndContainer    (*graphics, state)
Prototype.l GdipSaveGraphics    (*graphics, *state)
Prototype.l GdipRestoreGraphics (*graphics, state)

Prototype.l GdipGetDpiX         (*graphics, *dpi.Float)
Prototype.l GdipGetDpiY         (*graphics, *dpi.Float)
Prototype.l GdipSetPageUnit     (*graphics, unit.l)
Prototype.l GdipGetPageUnit     (*graphics, *unit.Long)
Prototype.l GdipSetPageScale    (*graphics, scale.f)
Prototype.l GdipGetPageScale    (*graphics, *scale.Float)

Prototype.l GdipGraphicsClear   (*graphics, color.l)

Prototype.l GdipCreateHatchBrush(hatchstyle.l, forecol.l, backcol.l, *brush)
Prototype.l GdipCreateSolidFill (color.l, *brush)
Prototype.l GdipCreateTexture   (*image, wrapMode.l, *texture)

Prototype.l GdipCreatePen1      (color.l, Width.f, unit.l, *pen)
Prototype.l GdipCreatePen2      (*brush, Width.f, unit.l, *pen)
Prototype.l GdipDeletePen       (*pen)
Prototype.l GdipSetPenWidth     (*pen, width.f)
Prototype.l GdipSetPenMode      (*pen, penAlignmentMode.l)
Prototype.l GdipSetPenDashStyle (*pen, dashStyle.l)
Prototype.l GdipSetPenDashArray (*pen, *dash.Float, count)
Prototype.l GdipSetPenStartCap  (*pen, startCap.l)
Prototype.l GdipSetPenEndCap    (*pen, endCap.l)
Prototype.l GdipSetPenLineJoin  (*pen, lineJoin)
Prototype.l GdipGetPenLineJoin  (*pen, *lineJoin)

Prototype.l GdipCreateCustomLineCap (*fillPath, *strokePath, baseCap.l, baseInset.f, *customCap)
Prototype.l GdipDeleteCustomLineCap (customCap)
Prototype.l GdipGetPenCustomStartCap(*pen, *customCap)
Prototype.l GdipSetPenCustomStartCap(*pen, customCap.i)
Prototype.l GdipSetPenCustomEndCap  (*pen, customCap.i)
Prototype.l GdipSetCustomLineCapWidthScale(customCap.i, widthScale.f)
Prototype.l GdipSetCustomLineCapStrokeJoin(customCap.i, lineJoin.l)
Prototype.l GdipCreateAdjustableArrowCap    (height.f, width.f, isFilled.l, *cap)
Prototype.l GdipSetAdjustableArrowCapHeight (cap, height.f)
Prototype.l GdipSetAdjustableArrowCapWidth  (cap, width.f)

Prototype.l GdipDeleteBrush     (*brush)

Prototype.l GdipCreatePath      (fillMode.l, *path)
Prototype.l GdipDeletePath      (path.i)
Prototype.l GdipResetPath       (path.i)
Prototype.l GdipClonePath       (path.i, *clonePath)
Prototype.l GdipDrawPath        (*graphics, *pen  , path.i)
Prototype.l GdipFillPath        (*graphics, *brush, path.i)
Prototype.l GdipClosePathFigure (path.i)

Prototype.l GdipSetPathFillMode (*path, fillmode.l)
Prototype.l GdipAddPathPath     (*path, addingPath, connect)
Prototype.l GdipAddPathString   (*path, *WString, length.l, *FontFamily, style.l, emSize.f, *layoutRect.RECTF, *stringFormat)
Prototype.l GdipAddPathRectangle(*path, x.f, y.f, width.f, height.f)
Prototype.l GdipAddPathEllipse  (*path, x.f, y.f, width.f, height.f)
Prototype.l GdipAddPathPolygon  (*path, *points.POINTF, count.l)
Prototype.l GdipAddPathLine     (*path, x1.f, y1.f, x2.f, y2.f)
Prototype.l GdipAddPathLine2    (*path, *points.POINTF, count.l)
Prototype.l GdipAddPathPie      (*path, x.f, y.f, width.f, height.f, startAngle.f, sweepAngle.f)
Prototype.l GdipAddPathArc      (*path, x.f, y.f, width.f, height.f, startAngle.f, sweepAngle.f)
Prototype.l GdipAddPathBezier   (*path, x1.f, y1.f, x2.f, y2.f, x3.f, y3.f, x4.f, y4.f)
Prototype.l GdipAddPathCurve2   (*path, *points.POINTF, count.l, tension.f)
Prototype.l GdipAddPathClosedCurve2(*path, *points.POINTF, count.l, tension.f)

Prototype.l GdipGetClipBounds   (*graphics, *rect.RECTF)

Prototype.l GdipDrawRectangle   (*graphics, *pen  , x.f , y.f , width.f, height.f)
Prototype.l GdipFillRectangle   (*graphics, *brush, x.f , y.f , width.f, height.f)
Prototype.l GdipDrawLine        (*graphics, *pen  , x1.f, y1.f, x2.f   , y2.f    )
Prototype.l GdipDrawPie         (*graphics, *pen  , x.f , y.f , width.f, height.f, startAngle.f, sweepAngle.f)
Prototype.l GdipFillPie         (*graphics, *brush, x.f , y.f , width.f, height.f, startAngle.f, sweepAngle.f)
Prototype.l GdipDrawArc         (*graphics, *pen  , x.f , y.f , width.f, height.f, startAngle.f, sweepAngle.f)
Prototype.l GdipDrawEllipse     (*graphics, *pen  , x.f , y.f , width.f, height.f)
Prototype.l GdipFillEllipse     (*graphics, *brush, x.f , y.f , width.f, height.f)
Prototype.l GdipDrawBezier      (*graphics, *pen  , x1.f, y1.f, x2.f   , y2.f    , x3.f, y3.f, x4.f, y4.f)
Prototype.l GdipDrawCurve2      (*graphics, *pen, *points.POINTF, count.l, tension.f)
Prototype.l GdipDrawClosedCurve2(*graphics, *pen, *points.POINTF, count.l, tension.f)
Prototype.l GdipDrawPolygon     (*graphics, *pen  , *points.POINTF, count.l)
Prototype.l GdipFillPolygon2    (*graphics, *brush, *points.POINTF, count.l)
Prototype.l GdipDrawString      (*graphics, *WString, length.l, *font, *layoutRect.RECTF, *stringFormat, *brush)

Prototype.l GdipCreateBitmapFromHBITMAP (*hbm, *hpal, *bitmap)
Prototype.l GdipCreateBitmapFromScan0   (width.l,height.l,stride.l,format.l,*bytes,*bitmap)
Prototype.l GdipBitmapSetPixel          (*bitmap, x.l, y.l, color.l)
Prototype.l GdipImageRotateFlip         (*image, RotateFlipType.l)
Prototype.l GdipDrawImage               (*graphics, *image, x.f, y.f)
Prototype.l GdipDrawImageRect           (*graphics, *image, x.f, y.f, width.f, height.f)
Prototype.l GdipDrawImageRectRect       (*graphics, *image, dstx.f, dsty.f, dstwidth.f, dstheight.f, srcx.f, srcy.f, srcwidth.f, srcheight.f, srcUnit.l, imageAttributes.i, *callback, *callbackData)
Prototype.l GdipDisposeImage            (*image)

Prototype.l GdipCreateImageAttributes           (*imageattr)
Prototype.l GdipDisposeImageAttributes          ( imageattr.i)
Prototype.l GdipSetImageAttributesColorMatrix   ( imageattr.i, ColorAdjustType.l, enableFlag.l, *colorMatrix.ColorMatrix, *grayMatrix.ColorMatrix, ColorMatrixFlags.l)

Prototype.l GdipCreateFontFamilyFromName(*WName,*fontCollection,*fontFamily)
Prototype.l GdipDeleteFontFamily        (*fontFamily)
Prototype.l GdipCreateFont              (*fontFamily, emSize.f, style.l, unit.l, *font)
Prototype.l GdipDeleteFont              (*font)
Prototype.l GdipGetFamily               (*font, *fontFamily)
Prototype.l GdipGetFontStyle            (*font, *style)
Prototype.l GdipGetFontSize             (*font, *size)
Prototype.l GdipGetFontHeight           (*font, *graphics, *height.Float)
Prototype.l GdipMeasureString           (*graphics,*WString,length.l,*font,*layoutRect.RECTF,*stringFormat,*boundingBox.RECTF,*codepointsFitted.Long,*linesFilled.Long)
Prototype.l GdipGetGenericFontFamilySansSerif   (*fontFamily)
Prototype.l GdipGetGenericFontFamilySerif       (*fontFamily)
Prototype.l GdipGetGenericFontFamilyMonospace   (*nativeFamily)

Prototype.l GdipSetSmoothingMode        (*graphics, smoothingMode.l)
Prototype.l GdipSetCompositingMode      (*graphics, compositingMode.l)
Prototype.l GdipSetCompositingQuality   (*graphics, compositingQuality.l)
Prototype.l GdipSetInterpolationMode    (*graphics, interpolationMode.l)
Prototype.l GdipSetPixelOffsetMode      (*graphics, pixelOffsetMode.l)
Prototype.l GdipSetTextRenderingHint    (*graphics, TextRenderingHint.l)

Prototype.l GdipResetTextureTransform       (*texture)
Prototype.l GdipTranslateTextureTransform   (*texture,x.f, y.f, order)
Prototype.l GdipScaleTextureTransform       (*texture,x.f, y.f, order)
Prototype.l GdipRotateTextureTransform      (*texture,angle.f , order)

Prototype.l GdipResetWorldTransform         (*graphics)
Prototype.l GdipTranslateWorldTransform     (*graphics,x.f, y.f, order)
Prototype.l GdipScaleWorldTransform         (*graphics,x.f, y.f, order)
Prototype.l GdipRotateWorldTransform        (*graphics,angle.f , order)
Prototype.l GdipCreateMatrix                (*matrix)
Prototype.l GdipDeleteMatrix                (matrix)
Prototype.l GdipSetMatrixElements           (matrix, m11.f, m12.f, m21.f, m22.f, dx.f, dy.f)
Prototype.l GdipCloneMatrix                 (matrix, *cloneMatrix)
Prototype.l GdipScaleMatrix                 (matrix, scaleX.f , scaleY.f , order)
Prototype.l GdipRotateMatrix                (matrix, angle.f  , order)
Prototype.l GdipTranslateMatrix             (matrix, offsetX.f, offsetY.f, order)
Prototype.l GdipShearMatrix                 (matrix, shearX.f , shearY.f , order)
Prototype.l GdipSetWorldTransform           (*graphics, matrix)
Prototype.l GdipGetWorldTransform           (*graphics, *matrix)

Prototype.l GdipResetClip                   (*graphics)
Prototype.l GdipSetClipPath                 (*graphics, path.i, combineMode.l)
Prototype.l GdipSetClipRect                 (*graphics, x.f, y.f, width.f, height.f, combineMode.l)

;-------- internal macros

Macro DoubleQuote
    "
EndMacro

Macro setFunc(_name_)
    Global _name_#_._name_
    _name_#_ = GetFunction(__dll,DoubleQuote#_name_#DoubleQuote)
    CompilerIf #PB_Compiler_Debugger
        If _name_#_ = 0
            Debug "ERROR gDrawing setFunc: "+DoubleQuote#_name_#DoubleQuote+" = 0"
        EndIf
    CompilerEndIf
EndMacro

Macro toARGB(color)
    ( (color & $FF00FF00) | ( (color & $FF) << 16 ) | ((color >> 16) & $FF) ) 
EndMacro

Macro gCheckInit(procedureName)
    If Not __initialized
        CompilerIf #PB_Compiler_Debugger
            Debug procedureName + "(): call gInit() before using any gDrawing commands and check the return value"
        CompilerEndIf
        ProcedureReturn 0
    EndIf
EndMacro

Global __dll.i,__initialized,__gdiplusToken.l,__drawingMode.l,__graphics.i, __currentDC.i
Global __lineCapStart,__lineCapEnd, __lineCapStartScale.f, __lineCapEndScale.f
Global __currentPen.i, __currentBrush.i, __currentPenColor.l, __currentPenColor2.l
Global __currentPenPattern.l, __currentPenSize.f, __currentPenAlignment, __currentPenBrushStyle, __currentPenStyle
Global __currentPenImage.i, __currentPenImageWrapMode
Global __currentPath.i
Global __currentFont.i, __currentTextAntialiasingMode.l
Global Dim __currentPenStyleData.f(0)

Structure __transformStack
    state.i
    matrix.i
EndStructure

Structure __gImage
    image.i
    width.l
    height.l
EndStructure

Global __transformMatrix.i
NewList __gRotationStackInternal.__transformStack()
Global NewList __gImages.__gImage()
Global NewList __gPaths.i()

Declare.i gBufferImage(*ImageID)
Declare   gFreeImage(gImage.i)

;-------- init & end functions


Procedure gInit()
    __dll = OpenLibrary(#PB_Any, "gdiplus.dll")
    If Not __dll : ProcedureReturn 0 : EndIf
   
    setFunc(GdiplusStartup)                     : setFunc(GdiplusShutdown)
    setFunc(GdipCreateFromHDC)                  : setFunc(GdipDeleteGraphics)
    SetFunc(GdipBeginContainer2)                : setFunc(GdipEndContainer)
    setFunc(GdipSaveGraphics)                   : setFunc(GdipRestoreGraphics)
    setFunc(GdipGetDpiX)                        : setFunc(GdipGetDpiY)
    setFunc(GdipSetPageUnit)                    : setFunc(GdipGetPageUnit)
    setFunc(GdipSetPageScale)                   : setFunc(GdipGetPageScale)
    setFunc(GdipGraphicsClear)                  : setFunc(GdipGetClipBounds)
    setFunc(GdipSetSmoothingMode)               : SetFunc(GdipSetTextRenderingHint)
    setFunc(GdipSetCompositingMode)             : setFunc(GdipSetCompositingQuality)
    setFunc(GdipSetInterpolationMode)           : setFunc(GdipSetPixelOffsetMode)
    setFunc(GdipCreatePen1)                     : setFunc(GdipCreatePen2)
    setFunc(GdipDeletePen)                      : setFunc(GdipDeleteBrush)
    setFunc(GdipSetPenWidth)                    : setFunc(GdipSetPenMode)
    setFunc(GdipSetPenDashStyle)                : setFunc(GdipSetPenDashArray)
    setFunc(GdipSetPenStartCap)                 : setFunc(GdipSetPenEndCap)
    setFunc(GdipSetPenLineJoin)                 : setFunc(GdipGetPenLineJoin)
    setFunc(GdipCreateCustomLineCap)            : setFunc(GdipDeleteCustomLineCap)
    setFunc(GdipSetCustomLineCapWidthScale)     : setFunc(GdipSetPenCustomStartCap)
    setFunc(GdipSetPenCustomEndCap)             : setFunc(GdipGetPenCustomStartCap)
    setFunc(GdipSetCustomLineCapStrokeJoin)     : setFunc(GdipCreateAdjustableArrowCap)
    setFunc(GdipSetAdjustableArrowCapWidth)     : setFunc(GdipSetAdjustableArrowCapHeight)
    SetFunc(GdipCreateHatchBrush)               : setFunc(GdipCreateSolidFill)
    setFunc(GdipDrawRectangle)                  : setFunc(GdipFillRectangle)
    setFunc(GdipDrawLine)                       : setFunc(GdipDrawPie)
    SetFunc(GdipFillPie)                        : setFunc(GdipDrawArc)
    setFunc(GdipDrawEllipse)                    : SetFunc(GdipFillEllipse)
    SetFunc(GdipDrawBezier)                     : setFunc(GdipDrawCurve2)
    setFunc(GdipDrawClosedCurve2)               : SetFunc(GdipDrawPolygon)
    SetFunc(GdipFillPolygon2)                   : SetFunc(GdipDrawString)
    SetFunc(GdipCreateTexture)                  : SetFunc(GdipDisposeImage)
    SetFunc(GdipCreatePath)                     : SetFunc(GdipDeletePath)
    SetFunc(GdipCreateBitmapFromHBITMAP)        : setFunc(GdipCreateBitmapFromScan0)
    setFunc(GdipDrawImage)                      : setFunc(GdipDrawImageRect)
    setFunc(GdipDrawImageRectRect)              : setFunc(GdipImageRotateFlip)
    setFunc(GdipBitmapSetPixel)                 : SetFunc(GdipAddPathString)                  
    SetFunc(GdipDrawPath)                       : setFunc(GdipFillPath)
    setFunc(GdipClosePathFigure)                : setFunc(GdipResetClip)
    setFunc(GdipSetClipRect)                    : setFunc(GdipSetClipPath)
    setFunc(GdipAddPathPath)
    setFunc(GdipResetPath)                      : setFunc(GdipClonePath)
    setFunc(GdipAddPathRectangle)               : setFunc(GdipAddPathEllipse)
    setFunc(GdipAddPathPolygon)                 : setFunc(GdipAddPathLine2)
    setFunc(GdipAddPathCurve2)                  : setFunc(GdipAddPathClosedCurve2)
    setFunc(GdipAddPathLine)                    : setFunc(GdipAddPathBezier)
    setFunc(GdipAddPathPie)                     : setFunc(GdipAddPathArc)
    SetFunc(GdipResetTextureTransform)          : SetFunc(GdipTranslateTextureTransform)
    SetFunc(GdipScaleTextureTransform)          : SetFunc(GdipRotateTextureTransform)
    SetFunc(GdipResetWorldTransform)            : SetFunc(GdipTranslateWorldTransform)
    SetFunc(GdipScaleWorldTransform)            : SetFunc(GdipRotateWorldTransform)
    setFunc(GdipCreateMatrix)                   : setFunc(GdipDeleteMatrix)
    setFunc(GdipScaleMatrix)                    : setFunc(GdipRotateMatrix)
    setFunc(GdipTranslateMatrix)                : setFunc(GdipShearMatrix)
    setFunc(GdipSetMatrixElements)              : setFunc(GdipCloneMatrix)
    setFunc(GdipSetWorldTransform)              : setFunc(GdipGetWorldTransform)
    SetFunc(GdipCreateFontFamilyFromName)       : SetFunc(GdipDeleteFontFamily)
    SetFunc(GdipCreateFont)                     : SetFunc(GdipDeleteFont)
    SetFunc(GdipGetFamily)                      : SetFunc(GdipGetFontStyle)
    SetFunc(GdipGetFontSize)                    : SetFunc(GdipGetFontHeight)
    setFunc(GdipMeasureString)                  : setFunc(GdipGetGenericFontFamilySansSerif)
    setFunc(GdipGetGenericFontFamilySerif)      : setFunc(GdipGetGenericFontFamilyMonospace)
    setFunc(GdipCreateImageAttributes)          : setFunc(GdipDisposeImageAttributes)
    setFunc(GdipSetImageAttributesColorMatrix)
    
    ; Initialize GDI+.
    
    Protected gdiplusStartupInput.GdiplusStartupInput
    
    gdiplusStartupInput\GdiplusVersion              = 1
    gdiplusStartupInput\DebugEventCallback          = #Null
    gdiplusStartupInput\SuppressBackgroundThread    = #False
    gdiplusStartupInput\SuppressExternalCodecs      = #True
    
    If Not GdiplusStartup_(@__gdiplusToken, @gdiplusStartupInput, #Null)
        __initialized = #True
        ProcedureReturn #True
    EndIf
    CloseLibrary(__dll)
    ProcedureReturn #False
EndProcedure

Procedure gEnd()
    ForEach __gImages()
        GdipDisposeImage_( __gImages()\image )
    Next
    ForEach __gPaths()
        GdipDeletePath_( __gPaths() )
    Next

    GdiplusShutdown_(__gdiplusToken)
    If __dll
        CloseLibrary(__dll)
    EndIf
    __initialized = #False
EndProcedure

;-------- internal functions
Procedure __setPenDashStyleInternal(*pen=0)
    If *pen=0   : *pen = __currentPen    : EndIf
    If *pen
        If __currentPenStyle = #PenStyleCustom
            GdipSetPenDashArray_(*pen,@__currentPenStyleData(),ArraySize(__currentPenStyleData()))
        Else
            GdipSetPenDashStyle_(*pen,__currentPenStyle)
        EndIf
    EndIf
EndProcedure

Procedure __createCapInternal(type,*pen)
    Protected cap.i, path.i, style.l, scale.f, closedArrow.l

    If type = 0 : style = __lineCapStart : scale = __lineCapStartScale
    Else        : style = __lineCapEnd   : scale = __lineCapEndScale
    EndIf
    
    If *pen=0   : *pen = __currentPen    : EndIf

    GdipCreatePath_(1,@path)
    Select style
        Case #LineCapSquare, #LineCapSquareAnchor
            GdipAddPathRectangle_(path,-0.5,-0.5,1,1)
        Case #LineCapRound,  #LineCapRoundAnchor
            GdipAddPathEllipse_(path,-0.5,-0.5,1,1)
        Case #LineCapTriangle, #LineCapDiamondAnchor
            Dim pt.POINTF(4)
            pt(0)\X = -0.5 : pt(0)\Y =  0
            pt(1)\X =  0   : pt(1)\Y = -0.5
            pt(2)\X =  0.5 : pt(2)\Y =  0
            pt(3)\X =  0   : pt(3)\Y =  0.5
            GdipAddPathLine2_(path,@pt(),4)
            ;GdipAddPathPolygon_(path,@triangle(),4)
    EndSelect
   
    If style = $14 Or style = $15
        If style = $14 : closedArrow = #True : EndIf
        GdipCreateAdjustableArrowCap_(1, 1, closedArrow, @cap)
    Else
        GdipCreateCustomLineCap_(path,0,0,0,@cap)
    EndIf
    If style >=$11 And style <=$13
        GdipSetCustomLineCapWidthScale_(cap,scale)
    ElseIf style = $14 Or style = $15
        GdipSetAdjustableArrowCapWidth_ (cap,scale)
        GdipSetAdjustableArrowCapHeight_(cap,scale)
    EndIf

    If type=0
        GdipSetPenCustomStartCap_(*pen,cap)
    Else
        GdipSetPenCustomEndCap_(*pen,cap)
    EndIf
    GdipDeleteCustomLineCap_(cap)
    GdipDeletePath_(path)
EndProcedure

Procedure __createCapsInternal(*pen=0)
    __createCapInternal(0,*pen)
    __createCapInternal(1,*pen)
EndProcedure

Procedure __getImageInternal(*gImage.Integer)
    ForEach __gImages()
        If __gImages()\image = *gImage\i
            ProcedureReturn 1
        EndIf
    Next
    If GetObjectType_(*gImage\i)=#OBJ_BITMAP
        *gImage\i = gBufferImage(*gImage\i)
        If *gImage\i : ProcedureReturn 2 : EndIf
    ElseIf IsImage(*gImage\i)
        *gImage\i = gBufferImage(ImageID(*gImage\i))
        If *gImage\i : ProcedureReturn 2 : EndIf
    EndIf
EndProcedure

Procedure __getPenInternal(color.q)
    Protected *pen
    If color = #gNOCOLOR
        ProcedureReturn __currentPen
    EndIf
    GdipCreatePen1_(toARGB(color),__currentPenSize,#UnitWorld,@*pen)
    GdipSetPenMode_    (*pen,__currentPenAlignment)
    __createCapsInternal(*pen)
    __setPenDashStyleInternal(*pen)
    ProcedureReturn *pen
EndProcedure

Procedure __getBrushInternal(color.q)
    Protected *brush
    If color = #gNOCOLOR
        ProcedureReturn __currentBrush
    EndIf
    GdipCreateSolidFill_(toARGB(color),@*brush)
    ProcedureReturn *brush
EndProcedure

Procedure __updatePenInternal()
    If __currentPen
        GdipDeletePen_(__currentPen)
    EndIf
    GdipCreatePen2_(__currentBrush,__currentPenSize,#UnitWorld,@__currentPen)
    GdipSetPenMode_    (__currentPen,__currentPenAlignment)
    __createCapsInternal()
    __setPenDashStyleInternal()
EndProcedure

Procedure __createPenInternal()
    If __graphics
        If __currentBrush
            GdipDeleteBrush_(__currentBrush)
        EndIf
        If __currentPenBrushStyle = 0
            GdipCreateSolidFill_(toARGB(__currentPenColor),@__currentBrush)
        ElseIf __currentPenBrushStyle = 1
            GdipCreateHatchBrush_(__currentPenPattern,toARGB(__currentPenColor),toARGB(__currentPenColor2),@__currentBrush)
        ElseIf __currentPenBrushStyle = 2
            GdipCreateTexture_(__currentPenImage,__currentPenImageWrapMode, @__currentBrush)
        EndIf
        __updatePenInternal()
    EndIf
EndProcedure


;-------- drawing options

Procedure gSetAntialiasMode( newMode.l )
    If __graphics
        GdipSetSmoothingMode_(__graphics,newMode)
    EndIf
EndProcedure

Procedure gSetTextAntialiasMode( newMode.l )
    If __graphics
        __currentTextAntialiasingMode = newMode
    EndIf
EndProcedure


Procedure gSetPixelOffsetMode( newMode.l )
    If __graphics
        GdipSetPixelOffsetMode_(__graphics,newMode)
    EndIf
EndProcedure

Procedure gSetInterpolationMode( newMode.l )
    If __graphics
        GdipSetInterpolationMode_(__graphics,newMode)
    EndIf
EndProcedure

Procedure gSetCompositingMode( newMode.l )
    If __graphics
        GdipSetCompositingMode_(__graphics,newMode)
    EndIf
EndProcedure

Procedure gSetCompositingQuality( newQuality.l )
    If __graphics
        GdipSetCompositingQuality_(__graphics,newQuality)
    EndIf
EndProcedure

Procedure gSetUnit( unit.l, scale.f=1.0 )
    If __graphics
        GdipSetPageUnit_(__graphics,unit)
        GdipSetPageScale_(__graphics,scale)
    EndIf
EndProcedure


Procedure gDrawingMode( newMode.l )
    __drawingMode = newMode
EndProcedure

;-------- get drawing options

Procedure gGetDpiX()
    Protected dpiX.f
    If __graphics
        GdipGetDpiX_(__graphics,@dpiX)
        ProcedureReturn dpiX
    EndIf
EndProcedure

Procedure gGetDpiY()
    Protected dpiY.f
    If __graphics
        GdipGetDpiY_(__graphics,@dpiY)
        ProcedureReturn dpiY
    EndIf
EndProcedure

;-------- Pen functions

Procedure gSetPen(color.l,size.f)
    __currentPenColor       = color
    __currentPenSize        = size
    __currentPenBrushStyle  = 0
    __createPenInternal()
EndProcedure

Procedure gSetPenColor(color.l)
    __currentPenColor       = color
    __currentPenBrushStyle  = 0
    __createPenInternal()
EndProcedure

Procedure gSetPenPattern(penPattern.l, foregroundColor.l, backgroundColor.l)
    If penPattern < #PenPatternMin : penPattern = #PenPatternMin : EndIf
    If penPattern > #PenPatternMax : penPattern = #PenPatternMax : EndIf
    __currentPenPattern     = penPattern
    __currentPenColor       = foregroundColor
    __currentPenColor2      = backgroundColor
    __currentPenBrushStyle  = 1
    __createPenInternal()
EndProcedure

Procedure gSetPenImage(gImage.i, wrapMode.l = #WrapModeTile)
    Protected found
    If __graphics And gImage
        found = __getImageInternal(@gImage)
        If found
            __currentPenImage         = gImage
            __currentPenImageWrapMode = wrapMode
            __currentPenBrushStyle    = 2
            __createPenInternal()
            If found = 2
                gFreeImage(gImage)
            EndIf
        CompilerIf #PB_Compiler_Debugger
        Else
            Debug "ERROR: gSetPenImage() with invalid gImage called."
        CompilerEndIf
        EndIf
    EndIf
EndProcedure

Procedure gSetPenSize(size.f)
    __currentPenSize = size
    If __graphics And __currentPen
        GdipSetPenWidth_(__currentPen,size)
    EndIf
EndProcedure

Procedure gSetPenStyle(penStyle.l,*values.Float=0, count.l=0)
    Protected i.l
    If __graphics And __currentPen
        __currentPenStyle = penStyle
        If penStyle = #PenStyleCustom
            If *values And count
                Dim __currentPenStyleData(count)
                For i = 0 To count-1
                    __currentPenStyleData(i) = *values\f
                    *values + SizeOf(Float)
                Next i
            Else
                penStyle = #PenStyleSolid
            EndIf
        EndIf
        __setPenDashStyleInternal()
    EndIf
EndProcedure

Procedure gSetPenAlignment(penAlignment.l)
    If __graphics And __currentPen
        If penAlignment >= 0 And penAlignment <= 1
            __currentPenAlignment = penAlignment
            GdipSetPenMode_(__currentPen,penAlignment)
        EndIf
    EndIf
EndProcedure

Procedure gSetPenCapsScale( StartCapScaleFactor.f, EndCapScaleFactor.f )
    __lineCapStartScale = StartCapScaleFactor
    __lineCapEndScale   = EndCapScaleFactor
    If __graphics And __currentPen
        __createCapsInternal()
    EndIf
EndProcedure

Procedure gSetPenCaps( lineCapStart.l, lineCapEnd.l )
    __lineCapStart = lineCapStart
    __lineCapEnd   = lineCapEnd
    If __graphics And __currentPen
        __createCapsInternal()
    EndIf
EndProcedure

;-------- pen image transformations

Procedure gSetPenTransform(originX.f, originY.f, rotationAngle.f=0.0, scaleX.f=1.0, scaleY.f=1.0)
    If __currentPenBrushStyle = 2 And __currentBrush
        GdipScaleTextureTransform_ (__currentBrush,scaleX,scaleY,1)
        GdipRotateTextureTransform_(__currentBrush,rotationAngle,1)
        GdipTranslateTextureTransform_(__currentBrush,originX,originY,1)
        __updatePenInternal()
    EndIf
EndProcedure

Procedure gResetPenTransform()
    If __currentPenBrushStyle = 2 And __currentBrush
        GdipResetTextureTransform_(__currentBrush)
        __updatePenInternal()
    EndIf
EndProcedure

Procedure gSetPenOrigin(x.f, y.f)
    If __currentPenBrushStyle = 2 And __currentBrush
        GdipTranslateTextureTransform_(__currentBrush,x,y,0)
        __updatePenInternal()
    EndIf
EndProcedure

Procedure gSetPenScale(x.f, y.f)
    If __currentPenBrushStyle = 2 And __currentBrush
        GdipScaleTextureTransform_(__currentBrush,x,y,0)
        __updatePenInternal()
    EndIf
EndProcedure

Procedure gSetPenRotation(angle.f)
    If __currentPenBrushStyle = 2 And __currentBrush
        GdipRotateTextureTransform_(__currentBrush,angle,0)
        __updatePenInternal()
    EndIf
EndProcedure

;-------- graphics transformations

Procedure gStartTransform()
    Shared __gRotationStackInternal.__transformStack()
    If __graphics
        If AddElement( __gRotationStackInternal() )
            GdipSaveGraphics_(__graphics,@__gRotationStackInternal()\state)
            If __transformMatrix
                GdipCloneMatrix_(__transformMatrix,@__gRotationStackInternal()\matrix)
            Else
                GdipCreateMatrix_(@__gRotationStackInternal()\matrix)
            EndIf
        EndIf
    EndIf
EndProcedure

Procedure gStopTransform()
    Shared __gRotationStackInternal.__transformStack()
    If __graphics
        If LastElement( __gRotationStackInternal() )
            GdipRestoreGraphics_(__graphics,__gRotationStackInternal()\state)
            GdipDeleteMatrix_(__gRotationStackInternal()\matrix)
            DeleteElement( __gRotationStackInternal() )
        EndIf
    EndIf
EndProcedure

Procedure gRotate(angle.f)
    Shared __gRotationStackInternal.__transformStack()
    Protected matrix.i
    If __graphics
        If LastElement( __gRotationStackInternal() )
            matrix = __gRotationStackInternal()\matrix
        Else : matrix = __transformMatrix : EndIf
        GdipRotateMatrix_     (matrix,angle,0)
        GdipSetWorldTransform_(__graphics,matrix)
    EndIf
EndProcedure

Procedure gRotateAt(x.f,y.f,angle.f)
    Shared __gRotationStackInternal.__transformStack()
    Protected matrix.i
    If __graphics
        If LastElement( __gRotationStackInternal() )
            matrix = __gRotationStackInternal()\matrix
        Else : matrix = __transformMatrix : EndIf
        GdipTranslateMatrix_  (matrix, x, y,0)
        GdipRotateMatrix_     (matrix,angle,0)
        GdipTranslateMatrix_  (matrix,-x,-y,0)
        GdipSetWorldTransform_(__graphics,matrix)
    EndIf
EndProcedure


Procedure gScale(sx.f,sy.f)
    ;If sx = 1.0 And sy = 1.0 : ProcedureReturn : EndIf
    ;If sx = 0.0 Or  sy = 0.0 : ProcedureReturn : EndIf
    Shared __gRotationStackInternal.__transformStack()
    Protected matrix.i
    If __graphics
        If LastElement( __gRotationStackInternal() )
            matrix = __gRotationStackInternal()\matrix
        Else : matrix = __transformMatrix : EndIf
        GdipScaleMatrix_(matrix,sx,sy,0)
        GdipSetWorldTransform_(__graphics,matrix)
    EndIf
EndProcedure

Procedure gScaleAt(x.f,y.f,scaleX.f,scaleY.f)
    ;If sx = 1.0 And sy = 1.0 : ProcedureReturn : EndIf
    ;If sx = 0.0 Or  sy = 0.0 : ProcedureReturn : EndIf
    Shared __gRotationStackInternal.__transformStack()
    Protected matrix.i
    If __graphics
        If LastElement( __gRotationStackInternal() )
            matrix = __gRotationStackInternal()\matrix
        Else : matrix = __transformMatrix : EndIf
        GdipTranslateMatrix_  (matrix, x, y,0)
        GdipScaleMatrix_      (matrix,scaleX,scaleY,0)
        GdipTranslateMatrix_  (matrix,-x,-y,0)
        GdipSetWorldTransform_(__graphics,matrix)
    EndIf
EndProcedure

Procedure gShear(shearX.f,shearY.f)
    Shared __gRotationStackInternal.__transformStack()
    Protected matrix.i
    If __graphics
        If LastElement( __gRotationStackInternal() )
            matrix = __gRotationStackInternal()\matrix
        Else : matrix = __transformMatrix : EndIf
        GdipShearMatrix_(matrix,shearX,shearY,0)
        GdipSetWorldTransform_(__graphics,matrix)
    EndIf
EndProcedure

Procedure gShearAt(x.f,y.f,shearX.f,shearY.f)
    Shared __gRotationStackInternal.__transformStack()
    Protected matrix.i
    If __graphics
        If LastElement( __gRotationStackInternal() )
            matrix = __gRotationStackInternal()\matrix
        Else : matrix = __transformMatrix : EndIf
        GdipTranslateMatrix_  (matrix, x, y,0)
        GdipShearMatrix_      (matrix,shearX,shearY,0)
        GdipTranslateMatrix_  (matrix,-x,-y,0)
        GdipSetWorldTransform_(__graphics,matrix)
    EndIf
EndProcedure

Procedure gSetOrigin(x.f,y.f)
    Shared __gRotationStackInternal.__transformStack()
    Protected matrix.i
    If __graphics
        If LastElement( __gRotationStackInternal() )
            matrix = __gRotationStackInternal()\matrix
        Else : matrix = __transformMatrix : EndIf
        GdipTranslateMatrix_  (matrix, x, y,0)
        GdipSetWorldTransform_(__graphics,matrix)
    EndIf
EndProcedure


Procedure gResetTransform()
    Shared __gRotationStackInternal.__transformStack()
    Protected matrix.i
    If __graphics
        If LastElement( __gRotationStackInternal() )
            matrix = __gRotationStackInternal()\matrix
            If __transformMatrix
                GdipCloneMatrix_(__transformMatrix,@__gRotationStackInternal()\matrix)
                If __gRotationStackInternal()\matrix : ProcedureReturn : EndIf
            EndIf
        Else : matrix = __transformMatrix : EndIf
        GdipSetMatrixElements_(matrix,1.0,0.0,0.0,1.0,0.0,0.0)
        GdipSetWorldTransform_(__graphics,matrix)
    EndIf
EndProcedure

;-------- Font

Procedure gSetFont( FontName$="Arial", FontSize.f=12, FontStyle.l = 0)
    Protected fs, *fontFamily, *font, *fontName, *hdc

    gCheckInit("gSetFont")

    If FontStyle = #PB_Font_Default   : FontStyle = 0: EndIf
    If FontStyle & #PB_Font_Bold      : fs | 1 : EndIf
    If FontStyle & #PB_Font_Italic    : fs | 2 : EndIf
    If FontStyle & #PB_Font_Underline : fs | 4 : EndIf
    If FontStyle & #PB_Font_StrikeOut : fs | 8 : EndIf

    CompilerIf #PB_Compiler_Unicode = 0
        Protected len  = Len(FontName$)
        Protected tmp$ = Space(len*2+2)
        PokeS(@tmp$,FontName$,-1,#PB_Unicode)
        *fontName = @tmp$
    CompilerElse
        *fontName = @FontName$
    CompilerEndIf

    If GdipCreateFontFamilyFromName_(*fontName,0, @*fontFamily)
        CompilerIf #PB_Compiler_Debugger
            Debug "ERROR: gSetFont() with FontName$ '"+FontName$+"' failed"
        CompilerEndIf
        If GdipGetGenericFontFamilySansSerif_(@*fontFamily)
           ProcedureReturn
        EndIf
    EndIf

    If Not GdipCreateFont_(*fontFamily,FontSize,fs,#UnitWorld,@*font)
        If __currentFont : GdipDeleteFont_(__currentFont) : EndIf
        __currentFont = *font
        GdipDeleteFontFamily_(*fontFamily)
    EndIf
EndProcedure

Procedure.f gTextHeight(Text$="")
    Protected height.f
    If __graphics And __currentFont
        GdipGetFontHeight_(__currentFont,__graphics,@height)
        ProcedureReturn height
    EndIf
EndProcedure

Procedure.f gTextWidth(Text$)
    Protected *text, *state, r.RECTF, result.RECTF
    If __graphics And __currentFont
        CompilerIf #PB_Compiler_Unicode = 0
            Protected len  = Len(Text$)
            Protected tmp$ = Space(len*2+2)
            PokeS(@tmp$,Text$,len,#PB_Unicode)
            *text = @tmp$
        CompilerElse
            *text = @Text$
        CompilerEndIf

        GdipSaveGraphics_       (__graphics,@*state) ; save graphics state, reset all world transformations
        GdipResetWorldTransform_(__graphics)         ; required because GdipMeasureString_() returns wrong
                                                     ; values after transformations!
            r\Height = gTextHeight()
            r\Width  = 0
            GdipMeasureString_(__graphics,*text,-1,__currentFont,@r,#Null,@result,0,0)

        GdipRestoreGraphics_(__graphics,*state)      ; restore graphics state
        ProcedureReturn result\Width
    EndIf
EndProcedure


;-------- gImage functions

Procedure.i gBufferImage(*ImageID)
    Protected *bitmap, bmp.BITMAP, pixelformat

    gCheckInit("gBufferImage")

    If IsImage(*ImageID) : *ImageID = ImageID(*ImageID) : EndIf
    If GetObject_(*ImageID,SizeOf(BITMAP),@bmp)
        If bmp\bmBitsPixel = 24
            pixelformat = (8 | (24 << 8) | $00020000)                           ; PixelFormat24bppRGB
        ElseIf bmp\bmBitsPixel = 32
            pixelformat = (10 | (32 << 8) | $00040000 | $00020000 | $00200000)  ; PixelFormat32bppARGB
        CompilerIf #PB_Compiler_Debugger
        Else
            Debug "gBufferImage(): only 24- and 32-bit images are supported."
        CompilerEndIf
        EndIf
        GdipCreateBitmapFromScan0_(bmp\bmWidth,bmp\bmHeight,bmp\bmWidthBytes,pixelformat,bmp\bmBits,@*bitmap)
        If *bitmap
            GdipImageRotateFlip_(*bitmap,6)
            If AddElement( __gImages() )
                __gImages()\image  = *bitmap
                __gImages()\width  = bmp\bmWidth
                __gImages()\height = bmp\bmHeight
                ProcedureReturn *bitmap
            EndIf
        EndIf
    EndIf
EndProcedure

Procedure gFreeImage(gImage.i)
    gCheckInit("gFreeImage")
    If gImage
        ForEach __gImages()
            If __gImages()\image = gImage
                GdipDisposeImage_(gImage)
                DeleteElement( __gImages() )
                Break
            EndIf
        Next
    EndIf
EndProcedure

;-------- drawing start & stop

Procedure.i gStartDrawing( out )
    Protected *hDC

    gCheckInit("gStartDrawing")

    *hDC = StartDrawing(out)
    If Not *hDC : ProcedureReturn 0 : EndIf
    
    If Not __initialized
    EndIf
    
    GdipCreateFromHDC_(*hDC ,@__graphics)
    If Not __graphics
        StopDrawing()
        ProcedureReturn 0
    EndIf

    __currentDC             = *hDC
    __drawingMode           = #PB_2DDrawing_Default
    __lineCapStart          = #LineCapFlat
    __lineCapEnd            = #LineCapFlat
    __lineCapStartScale     = 2.0
    __lineCapEndScale       = 2.0
    __currentPenAlignment   = #PenAlignmentCenter
    __currentPenStyle       = #PenStyleSolid
    __currentTextAntialiasingMode = #TextAntialiasMode_Antialias
    GdipSetPageUnit_(__graphics,#UnitPixel) ; outlined fonts dont work with #UnitWorld
    GdipSetPageScale_(__graphics,1.0)
    gSetPen(RGBA($FF,$FF,$FF,$FF),1.0)
    gSetFont()
    GdipCreateMatrix_(@__transformMatrix)
    GdipCreatePath_(1,@__currentPath)
    GdipSetSmoothingMode_     (__graphics,#SmoothingModeAntiAlias)
    GdipSetCompositingMode_   (__graphics,#CompositingModeSourceOver)
    GdipSetCompositingQuality_(__graphics,#CompositingQualityGammaCorrected)
    GdipSetInterpolationMode_ (__graphics,#InterpolationModeHighQualityBicubic)
    GdipSetPixelOffsetMode_   (__graphics,#PixelOffsetModeNone)
    ProcedureReturn *hDC
EndProcedure

Procedure gStopDrawing()
    If __graphics        : GdipDeleteGraphics_( __graphics      ) : __graphics        = 0 : EndIf
    If __currentPen      : GdipDeletePen_     ( __currentPen    ) : __currentPen      = 0 : EndIf
    If __currentBrush    : GdipDeleteBrush_   ( __currentBrush  ) : __currentBrush    = 0 : EndIf
    If __currentFont     : GdipDeleteFont_    ( __currentFont   ) : __currentFont     = 0 : EndIf
    If __transformMatrix : GdipDeleteMatrix_  (__transformMatrix) : __transformMatrix = 0 : EndIf
    If __currentPath     : GdipDeletePath_    (__currentPath    ) : __currentPath     = 0 : EndIf
    __currentDC = 0
    StopDrawing()
EndProcedure

;-------- clipping functions

Procedure gClipBox(x.f,y.f,width.f,height.f,combineMode.l=#CombineModeReplace)
    If __graphics
        GdipSetClipRect_(__graphics, x,y,width,height,combineMode)
    EndIf
EndProcedure

Procedure gClipPath(path.i=#PB_Default,combineMode.l=#CombineModeReplace)
    If __graphics
        If path=#PB_Default : path = __currentPath : EndIf
        GdipSetClipPath_(__graphics, path, combineMode);
    EndIf
EndProcedure

Procedure gResetClip()
    If __graphics
        GdipResetClip_(__graphics)
    EndIf
EndProcedure

;-------- path functions

Procedure gClosePath(path.i=#PB_Default)
    If path=#PB_Default : path = __currentPath : EndIf
    GdipClosePathFigure_(path)
EndProcedure

Procedure gClearPath(path.i=#PB_Default)
    If path=#PB_Default : path = __currentPath : EndIf
    GdipResetPath_(path)
EndProcedure

Procedure gFreePath(path.i)
    If path
        ForEach __gPaths()
            If __gPaths() = path
                GdipDeletePath_(path)
                Break
            EndIf
        Next
    EndIf
EndProcedure

Procedure.i gGetPath()
    Protected path.i
    If __currentPath
        GdipClonePath_(__currentPath,@path)
        If path
            If AddElement( __gPaths() )
                __gPaths() = path
            EndIf
        EndIf
    EndIf
    ProcedureReturn path
EndProcedure

Procedure gDrawPath(path.i=#PB_Default,color.q=#gNOCOLOR)
    If __graphics
        If path=#PB_Default : path = __currentPath : EndIf
        If __DrawingMode & #PB_2DDrawing_Path
            GdipAddPathPath_(__currentPath,path,#True)
        EndIf
        If __drawingMode & #PB_2DDrawing_Outlined
            Protected *pen = __getPenInternal(color)
            GdipDrawPath_(__graphics,*pen,path)
            If Not color=#gNOCOLOR : GdipDeletePen_(*pen) : EndIf
        EndIf
        If __drawingMode = #PB_2DDrawing_Default
            Protected *brush = __getBrushInternal(color)
            GdipFillPath_(__graphics,*brush,path)
            If Not color=#gNOCOLOR : GdipDeleteBrush_(*brush) : EndIf
        EndIf
    EndIf
EndProcedure


;-------- drawing functions

Procedure gClear(color.l)
    If __graphics
        GdipGraphicsClear_(__graphics, toARGB(color))
    EndIf
EndProcedure

Procedure gPlot(x.f, y.f, color.q=#gNOCOLOR)
    If __graphics
        If __DrawingMode & #PB_2DDrawing_Path
            GdipAddPathLine_(__currentPath,x,y,x,y)
        Else
            Protected *brush = __getBrushInternal(color)
            GdipFillEllipse_(__graphics,*brush,x-__currentPenSize*0.5,y-__currentPenSize*0.5,__currentPenSize,__currentPenSize)
            If Not color=#gNOCOLOR : GdipDeleteBrush_(*brush) : EndIf
        EndIf
    EndIf
EndProcedure

Procedure gBox(x.f, y.f, width.f, height.f, color.q=#gNOCOLOR)
    If __graphics
        If __DrawingMode & #PB_2DDrawing_Path
            GdipAddPathRectangle_(__currentPath,x,y,width,height)
        EndIf
        If __drawingMode & #PB_2DDrawing_Outlined
            Protected *pen = __getPenInternal(color)
            GdipDrawRectangle_(__graphics,*pen,x,y,width,height)
            If Not color=#gNOCOLOR : GdipDeletePen_(*pen) : EndIf
        EndIf
        If __drawingMode = #PB_2DDrawing_Default
            Protected *brush = __getBrushInternal(color)
            GdipFillRectangle_(__graphics,*brush,x,y,width,height)
            If Not color=#gNOCOLOR : GdipDeleteBrush_(*brush) : EndIf
        EndIf
    EndIf
EndProcedure

Procedure gRoundBox(x.f, y.f, width.f, height.f, roundX.f, roundY.f, color.q=#gNOCOLOR)
    Protected path.i, alignoff.f, pensize

    If __graphics

        If roundX = 0            : roundX = 0.0001     : EndIf
        If roundX < 0            : roundX = 0.0001     : EndIf
        If roundY = 0            : roundY = 0.0001     : EndIf
        If roundY < 0            : roundY = 0.0001     : EndIf
        If roundX > (width *0.5) : roundX = width *0.5 : EndIf
        If roundY > (height*0.5) : roundY = height*0.5 : EndIf

        pensize = __currentPenSize

        If __currentPenAlignment = #PenAlignmentInset And __drawingMode & #PB_2DDrawing_Outlined
            alignoff  = __currentPenSize * 0.5
            If __currentPenSize > (width *0.5) : alignoff = width *0.25 : pensize = width*0.5: EndIf
            If __currentPenSize > (height*0.5) : alignoff = height*0.25 : pensize = height*0.5: EndIf
        EndIf

        GdipCreatePath_(1,@path)
        GdipAddPathArc_(path,alignoff+x               ,alignoff+y                ,roundX*2,roundY*2, 180,90) ; top left
        GdipAddPathArc_(path,x+width-roundX*2-alignoff,alignoff+y                ,roundX*2,roundY*2, 270,90) ; top right
        GdipAddPathArc_(path,x+width-roundX*2-alignoff,y+height-roundY*2-alignoff,roundX*2,roundY*2,   0,90) ; bottom right
        GdipAddPathArc_(path,alignoff+x               ,y+height-roundY*2-alignoff,roundX*2,roundY*2,  90,90) ; bottom left
        GdipClosePathFigure_(path)

        If __DrawingMode & #PB_2DDrawing_Path
            GdipAddPathPath_(__currentPath,path,#True)
        EndIf
        If __drawingMode & #PB_2DDrawing_Outlined
            Protected *pen = __getPenInternal(color)
            GdipSetPenMode_ (*pen,#PenAlignmentCenter)
            GdipSetPenWidth_(*pen,pensize)
            GdipDrawPath_   (__graphics,*pen,path)
            If Not color=#gNOCOLOR
                GdipDeletePen_(*pen)
            Else
                GdipSetPenWidth_(*pen,__currentPenSize)
                GdipSetPenMode_ (*pen,__currentPenAlignment)
            EndIf
        EndIf
        If __drawingMode = #PB_2DDrawing_Default
            Protected *brush = __getBrushInternal(color)
            GdipFillPath_(__graphics,*brush,path)
            If Not color=#gNOCOLOR : GdipDeleteBrush_(*brush) : EndIf
        EndIf

        GdipDeletePath_(path)
    EndIf
EndProcedure

Procedure gLineXY(x1.f, y1.f, x2.f, y2.f, color.q=#gNOCOLOR)
    If __graphics
        If __DrawingMode & #PB_2DDrawing_Path
            GdipAddPathLine_(__currentPath,x1,y1,x2,y2)
        Else
            Protected *pen = __getPenInternal(color)
            GdipDrawLine_(__graphics,*pen,x1,y1,x2,y2)
            If Not color=#gNOCOLOR : GdipDeletePen_(*pen) : EndIf
        EndIf
    EndIf
EndProcedure

Procedure gLine(x.f, y.f, width.f, height.f, color.q=#gNOCOLOR)
    gLineXY(x,y,x+width,y+height,color)
EndProcedure

Procedure gPie(x.f, y.f, radiusX.f, radiusY.f, startAngle.f, sweepAngle.f, color.q=#gNOCOLOR)
    If __graphics
        If __DrawingMode & #PB_2DDrawing_Path
            GdipAddPathPie_(__currentPath,x-radiusX,y-radiusY,radiusX*2,radiusY*2,startAngle,sweepAngle)
        EndIf
        If __drawingMode & #PB_2DDrawing_Outlined
            Protected *pen = __getPenInternal(color)
            GdipDrawPie_(__graphics,*pen,x-radiusX,y-radiusY,radiusX*2,radiusY*2,startAngle,sweepAngle)
            If Not color=#gNOCOLOR : GdipDeletePen_(*pen) : EndIf
        EndIf
        If __drawingMode = #PB_2DDrawing_Default
            Protected *brush = __getBrushInternal(color)
            GdipFillPie_(__graphics,*brush,x-radiusX,y-radiusY,radiusX*2,radiusY*2,startAngle,sweepAngle)
            If Not color=#gNOCOLOR : GdipDeleteBrush_(*brush) : EndIf
        EndIf
    EndIf
EndProcedure

Procedure gPieXY(x.f, y.f, width.f, height.f, startAngle.f, sweepAngle.f, color.q=#gNOCOLOR)
    gPie(x+width*0.5,y+height*0.5,width*0.5,height*0.5,startAngle,sweepAngle,color)
EndProcedure

Procedure gArc(x.f, y.f, radiusX.f, radiusY.f, startAngle.f, sweepAngle.f, color.q=#gNOCOLOR)
    If __graphics
        If __DrawingMode & #PB_2DDrawing_Path
            GdipAddPathArc_(__currentPath,x-radiusX,y-radiusY,radiusX*2,radiusY*2,startAngle,sweepAngle)
        Else
            Protected *pen = __getPenInternal(color)
            GdipDrawArc_(__graphics,*pen,x-radiusX,y-radiusY,radiusX*2,radiusY*2,startAngle,sweepAngle)
            If Not color=#gNOCOLOR : GdipDeletePen_(*pen) : EndIf
        EndIf
    EndIf
EndProcedure

Procedure gArcXY(x.f, y.f, width.f, height.f, startAngle.f, sweepAngle.f, color.q=#gNOCOLOR)
    gArc(x+width*0.5,y+height*0.5,width*0.5,height*0.5,startAngle,sweepAngle,color)
EndProcedure


Procedure gEllipse(x.f, y.f, radiusX.f, radiusY.f, color.q=#gNOCOLOR)
    If __graphics
        If __DrawingMode & #PB_2DDrawing_Path
            GdipAddPathEllipse_(__currentPath,x-radiusX,y-radiusY,radiusX*2,radiusY*2)
        EndIf
        If __drawingMode & #PB_2DDrawing_Outlined
            Protected *pen = __getPenInternal(color)
            GdipDrawEllipse_(__graphics,*pen,x-radiusX,y-radiusY,radiusX*2,radiusY*2)
            If Not color=#gNOCOLOR : GdipDeletePen_(*pen) : EndIf
        EndIf
        If __drawingMode = #PB_2DDrawing_Default
            Protected *brush = __getBrushInternal(color)
            GdipFillEllipse_(__graphics,*brush,x-radiusX,y-radiusY,radiusX*2,radiusY*2)
            If Not color=#gNOCOLOR : GdipDeleteBrush_(*brush) : EndIf
        EndIf
    EndIf
EndProcedure

Procedure gEllipseXY(x.f, y.f, width.f, height.f, color.q=#gNOCOLOR)
    gEllipse(x+width*0.5,y+height*0.5,width*0.5,height*0.5,color)
EndProcedure

Procedure gCircle(x.f, y.f, radius.f, color.q=#gNOCOLOR)
    gEllipse(x,y,radius,radius,color)
EndProcedure

Procedure gCircleXY(x.f, y.f, radius.f, color.q=#gNOCOLOR)
    gEllipse(x+radius*0.5,y+radius*0.5,radius*0.5,radius*0.5,color)
EndProcedure

Procedure gBezier(x1.f, y1.f, x2.f, y2.f, x3.f, y3.f, x4.f, y4.f, color.q=#gNOCOLOR)
    If __graphics
        If __DrawingMode & #PB_2DDrawing_Path
            GdipAddPathBezier_(__currentPath,x1,y1,x2,y2,x3,y3,x4,y4)
        Else
            Protected *pen = __getPenInternal(color)
            GdipDrawBezier_(__graphics,*pen,x1,y1,x2,y2,x3,y3,x4,y4)
            If Not color=#gNOCOLOR : GdipDeletePen_(*pen) : EndIf
        EndIf
    EndIf
EndProcedure

Procedure gCurve(x1.f, y1.f, x2.f, y2.f, x3.f, y3.f, tension.f, color.q=#gNOCOLOR)
    If __graphics
        Dim points.POINTF(3)
        points(0)\x = x1 : points(0)\y = y1
        points(1)\x = x2 : points(1)\y = y2
        points(2)\x = x3 : points(2)\y = y3
        If __DrawingMode & #PB_2DDrawing_Path
            GdipAddPathCurve2_(__currentPath,@points(),3,tension)
        EndIf
        If __drawingMode & #PB_2DDrawing_Outlined
            Protected *pen = __getPenInternal(color)
            GdipDrawCurve2_(__graphics,*pen,@points(),3,tension)
            If Not color=#gNOCOLOR : GdipDeletePen_(*pen) : EndIf
        EndIf
        If __drawingMode = #PB_2DDrawing_Default
            Protected *brush = __getBrushInternal(color)
            Protected path.i
            GdipCreatePath_(1,@path)
            GdipAddPathCurve2_(path,@points(),3,tension)
            GdipFillPath_(__graphics,*brush,path)
            GdipDeletePath_(path)
            If Not color=#gNOCOLOR : GdipDeleteBrush_(*brush) : EndIf
        EndIf
    EndIf
EndProcedure

Procedure gClosedCurve(x1.f, y1.f, x2.f, y2.f, x3.f, y3.f, tension.f, color.q=#gNOCOLOR)
    If __graphics
        Dim points.POINTF(3)
        points(0)\x = x1 : points(0)\y = y1
        points(1)\x = x2 : points(1)\y = y2
        points(2)\x = x3 : points(2)\y = y3
        If __DrawingMode & #PB_2DDrawing_Path
            GdipAddPathClosedCurve2_(__currentPath,@points(),3,tension)
        EndIf
        If __drawingMode & #PB_2DDrawing_Outlined
            Protected *pen = __getPenInternal(color)
            GdipDrawClosedCurve2_(__graphics,*pen,@points(),3,tension)
            If Not color=#gNOCOLOR : GdipDeletePen_(*pen) : EndIf
        EndIf
        If __drawingMode = #PB_2DDrawing_Default
            Protected *brush = __getBrushInternal(color)
            Protected path.i
            GdipCreatePath_(1,@path)
            GdipAddPathClosedCurve2_(path,@points(),3,tension)
            GdipFillPath_(__graphics,*brush,path)
            GdipDeletePath_(path)
            If Not color=#gNOCOLOR : GdipDeleteBrush_(*brush) : EndIf
        EndIf
    EndIf
EndProcedure


Procedure gTriangle(x1.f, y1.f, x2.f, y2.f, x3.f, y3.f, color.q=#gNOCOLOR)
    If __graphics
        Dim points.POINTF(3)
        points(0)\x = x1 : points(0)\y = y1
        points(1)\x = x2 : points(1)\y = y2
        points(2)\x = x3 : points(2)\y = y3
        If __DrawingMode & #PB_2DDrawing_Path
            GdipAddPathPolygon_(__currentPath,@points(),3)
        EndIf
        If __drawingMode & #PB_2DDrawing_Outlined
            Protected *pen = __getPenInternal(color)
            GdipDrawPolygon_(__graphics,*pen,@points(),3)
            If Not color=#gNOCOLOR : GdipDeletePen_(*pen) : EndIf
        EndIf
        If __drawingMode = #PB_2DDrawing_Default
            Protected *brush = __getBrushInternal(color)
            GdipFillPolygon2_(__graphics,*brush,@points(),3)
            If Not color=#gNOCOLOR : GdipDeleteBrush_(*brush) : EndIf
        EndIf
    EndIf
EndProcedure

Procedure gPoly(Array points.POINTF(1),color.q=#gNOCOLOR)
    If __graphics
        If __DrawingMode & #PB_2DDrawing_Path
            GdipAddPathPolygon_(__currentPath,@points(),ArraySize(points())+1)
        EndIf
        If __drawingMode & #PB_2DDrawing_Outlined
            Protected *pen = __getPenInternal(color)
            GdipDrawPolygon_(__graphics,*pen,@points(),ArraySize(points())+1)
            If Not color=#gNOCOLOR : GdipDeletePen_(*pen) : EndIf
        EndIf
        If __drawingMode = #PB_2DDrawing_Default
            Protected *brush = __getBrushInternal(color)
            GdipFillPolygon2_(__graphics,*brush,@points(),ArraySize(points())+1)
            If Not color=#gNOCOLOR : GdipDeleteBrush_(*brush) : EndIf
        EndIf
    EndIf
EndProcedure

Procedure gDrawImage(gImage.i, x.f,y.f, width.f=-1,height.f=-1)
    Protected found
    If __graphics And gImage
        found = __getImageInternal(@gImage)
        If found
            If width=-1 And height=-1
                GdipDrawImage_(__graphics,__gImages()\image,x,y)
            Else
                If width  = -1 : width  = __gImages()\width  : EndIf
                If height = -1 : height = __gImages()\height : EndIf
                GdipDrawImageRect_(__graphics,__gImages()\image,x,y,width,height)
            EndIf
            If found = 2
                gFreeImage(gImage)
            EndIf
        CompilerIf #PB_Compiler_Debugger
        Else
            Debug "ERROR: gDrawImage() with invalid gImage called."
        CompilerEndIf
        EndIf
    EndIf
EndProcedure

Procedure gDrawAlphaImage(gImage.i, x.f,y.f, width.f=-1, height.f=-1, Alpha.f=1.0)
    Protected found, imageattributes.i, cmatrix.ColorMatrix
    If __graphics And gImage
        found = __getImageInternal(@gImage)
        If found
            cmatrix\m0[0] = 1.0
            cmatrix\m1[1] = 1.0
            cmatrix\m2[2] = 1.0
            cmatrix\m3[3] = Alpha
            cmatrix\m4[4] = 1.0
            If Alpha <> 1.0
                GdipCreateImageAttributes_(@imageattributes)
                GdipSetImageAttributesColorMatrix_(imageattributes,1,#True,@cmatrix,#Null,0)
            EndIf
            If width  = -1 : width  = __gImages()\width  : EndIf
            If height = -1 : height = __gImages()\height : EndIf
            GdipDrawImageRectRect_(__graphics,__gImages()\image,x,y,width,height,0,0,__gImages()\width,__gImages()\height,#UnitPixel,imageattributes,#Null,#Null)
            If Alpha <> 1.0
                GdipDisposeImageAttributes_(imageattributes)
            EndIf
            If found = 2
                gFreeImage(gImage)
            EndIf
        CompilerIf #PB_Compiler_Debugger
        Else
            Debug "ERROR: gDrawAlphaImage() with invalid gImage called."
        CompilerEndIf
        EndIf
    EndIf
EndProcedure

Procedure gDrawClippedImage(gImage.i, x.f,y.f, width.f, height.f, clipX.f, clipY.f, clipWidth.f, clipHeight.f, Alpha.f=1.0)
    Protected found, imageattributes.i, cmatrix.ColorMatrix
    If __graphics And gImage
        found = __getImageInternal(@gImage)
        If found
            cmatrix\m0[0] = 1.0
            cmatrix\m1[1] = 1.0
            cmatrix\m2[2] = 1.0
            cmatrix\m3[3] = Alpha
            cmatrix\m4[4] = 1.0
            If Alpha <> 1.0
                GdipCreateImageAttributes_(@imageattributes)
                GdipSetImageAttributesColorMatrix_(imageattributes,1,#True,@cmatrix,#Null,0)
            EndIf
            If width  = -1 : width  = clipWidth  : EndIf
            If height = -1 : height = clipHeight : EndIf
            GdipDrawImageRectRect_(__graphics,__gImages()\image,x,y,width,height,clipX,clipY,clipWidth,clipHeight,#UnitPixel,imageattributes,#Null,#Null)
            If Alpha <> 1.0
                GdipDisposeImageAttributes_(imageattributes)
            EndIf
            If found = 2
                gFreeImage(gImage)
            EndIf
        CompilerIf #PB_Compiler_Debugger
        Else
            Debug "ERROR: gDrawAlphaImage() with invalid gImage called."
        CompilerEndIf
        EndIf
    EndIf
EndProcedure


Procedure gDrawText(x.f, y.f, Text$, color.q=#gNOCOLOR)
    If __graphics
        Protected r.RECTF, *text
        r\X = x : r\Width  = 0.0
        r\Y = y : r\Height = 0.0
        GdipSetTextRenderingHint_(__graphics,__currentTextAntialiasingMode)

        CompilerIf #PB_Compiler_Unicode = 0
            Protected len  = Len(Text$)
            Protected tmp$ = Space(len*2+2)
            PokeS(@tmp$,Text$,len,#PB_Unicode)
            *text = @tmp$
        CompilerElse
            *text = @Text$
        CompilerEndIf

        If __drawingMode & #PB_2DDrawing_Outlined Or __drawingMode & #PB_2DDrawing_Path
            Protected *pen = __getPenInternal(color)
            
            ; outlined fonts dont work with #UnitWorld?
            Protected *fontFamily, *path, *style, size.f
            GdipGetFamily_   (__currentFont,@*fontFamily)
            GdipGetFontSize_ (__currentFont,@size)
            GdipGetFontStyle_(__currentFont,@*style)
            If __drawingMode & #PB_2DDrawing_Path
                GdipAddPathString_(__currentPath,*text,-1,*fontFamily,*style,size,@r,#Null)
            EndIf
            If __drawingMode & #PB_2DDrawing_Outlined
                GdipCreatePath_(1,@*path)
                GdipAddPathString_(*path,*text,-1,*fontFamily,*style,size,@r,#Null)
                GdipDrawPath_(__graphics,*pen,*path)
                GdipDeletePath_(*path)
            EndIf
            If Not color=#gNOCOLOR : GdipDeletePen_(*pen) : EndIf
        EndIf
        If __drawingMode = #PB_2DDrawing_Default
            Protected *brush = __getBrushInternal(color)
            GdipDrawString_(__graphics,*text,-1,__currentFont,@r,#Null,*brush)
            If Not color=#gNOCOLOR : GdipDeleteBrush_(*brush) : EndIf
        EndIf
    EndIf
EndProcedure

Procedure gDrawRotatedText(x.f, y.f, Text$, angle.f, color.q=#gNOCOLOR)
    Protected state
    gStartTransform()
        gRotateAt(x,y,angle)
        gDrawText(x,y,Text$,color)
    gStopTransform()
EndProcedure

;>----- END INCLUDE -----------------------------------------

; IDE Options = PureBasic 4.51 (Windows - x86)
; CursorPosition = 268
; FirstLine = 215
; Folding = ---------------
; EnableXP
; Executable = Beispiel3.exe
; CPU = 5