﻿EnableExplicit

XIncludeFile "gDrawing.pbi"

Global img
Global mainWin, imgWin, modeWin
Global i.l, j.l, k.l
Global pbLogo, bufferedPbLogo, pbBackground, pbAlphaChannel
Global Background, bufferedBackground, welcomeLogo.i
Global penRotation.f=0, penScale.f=1.0
Global penOriginX.f=0, penOriginY.f=0
Global globalRotation.f = 0.0, globalScale.f = 1.0, globalShearX.f, globalShearY.f

Global Dim colors.l(100)

Prototype demoProc()
Dim demoProcedures.i(20)

Procedure initpicture()
    gSetPenImage(bufferedPbLogo,#WrapModeTile)
    gSetPenTransform(penOriginX+400,penOriginY+400,penRotation,penScale,penScale)
    gBox(0,0,800,800)
    
    gDrawImage(welcomeLogo,100,50)

    gSetPenCaps(#LineCapRound, #LineCapArrowAnchor)
    gSetPen($80000000,5)
    gLineXY(185,310,05,150)
    gSetPenColor($DDFFFF00)
    gLineXY(190,300,10,140)
    gSetPenColor($80000000)
    gLineXY(565,340,795,130)
    gSetPenColor($DDFF00FF)
    gLineXY(560,330,790,120)
EndProcedure

Procedure demo_gPlot()
    gSetPenColor(RGBA($00,$00,$00,$FF))
    gDrawText(5,5,"plot points at different sizes",$FF000000)
    j=0
    For i = 1 To 30
        j + i + 5
        gSetPenSize(i)
        gPlot(j,45)
    Next i
    j=0
    gDrawText(5,65,"...with different colors",$FF000000)
    For i = 1 To 30
        j + i + 5
        gSetPen(colors(i),i)
        gPlot(j,105)
    Next i
    j=0
    gDrawText(5,125,"...with patterns",$FF000000)
    For i = 1 To 30
        j + i + 5
        gSetPenSize(i)
        gSetPenPattern(i,$FFFFFFFF,$FF000000)
        gPlot(j,165)
    Next i
    j=0
    gSetPenImage(bufferedBackground)
    gDrawText(5,185,"...with image texture",$FF000000)
    For i = 1 To 30
        j + i + 5
        gSetPenSize(i)
        gPlot(j,225)
    Next i
    RandomSeed(0)
    For i = 0 To 100
        j = Random(800)
        k = Random(250)
        gSetPenSize(1+Random(20))
        gSetPenTransform(penOriginX+j,penOriginY+k+345,penRotation,penScale,penScale)
        gPlot(j,k+345)
        gResetPenTransform()
    Next i
EndProcedure

Procedure demo_gBox()
    ;gStartRotationAround(0,0,globalRotation)

    gSetPenColor(RGBA($00,$00,$00,$FF))
    gDrawText(5,5,"draw boxes at different sizes",$FF000000)
    j=0
    For i = 1 To 30
        j + i + 5
        gBox(j,45-i*0.5,i,i)
    Next i
    j=0
    gDrawText(5,65,"...with different colors",$FF000000)
    For i = 1 To 30
        j + i + 5
        gSetPenColor(colors(i))
        gBox(j,105-i*0.5,i,i)
    Next i
    j=0
    gDrawText(5,125,"...with patterns",$FF000000)
    For i = 1 To 30
        j + i + 5
        gSetPenPattern(i,$FFFFFFFF,$FF000000)
        gBox(j,165-i*0.5,i,i)
    Next i
    j=0
    gSetPenImage(bufferedBackground)
    gDrawText(5,185,"...with image texture",$FF000000)
    For i = 1 To 30
        j + i + 5
        gSetPenOrigin(j,225)
        gBox(j,225-i*0.5,i,i)
        gResetPenTransform()
    Next i
    j=0
    gDrawText(5,245,"...outlined",$FF000000)
    gDrawingMode(#PB_2DDrawing_Outlined)
    gSetPenSize(2)
    For i = 1 To 30
        j + i + 5
        gSetPenColor(colors(i))
        gBox(j,285-i*0.5,i,i)
    Next i

    j=0
    gDrawingMode(#PB_2DDrawing_Default)
    gDrawText(5,305,"...rotated",$FF000000)
    gDrawingMode(#PB_2DDrawing_Outlined)
    gSetPenSize(2)
    gStartTransform()
    For i = 1 To 30
        j + i + 5
        gSetPenColor(colors(i))
        gSetOrigin(j+i*0.5,345)
        gRotate(i*12)
        gBox(-i*0.5,-i*0.5,i,i)
        gResetTransform()
    Next i
    gStopTransform()

    gSetPenColor($FF000000)
    gStartTransform()
    For i = 0 To 2
            gBox(200,420,70,70)
            gRotateAt(200,420,20)
    Next i
    gStopTransform()

    gStartTransform()
    For i = 0 To 2
            gBox(400,420,70,70)
            gRotateAt(435,455,20)
    Next i
    gStopTransform()

    
    gDrawingMode(#PB_2DDrawing_Default)
    ;gDrawingMode(#PB_2DDrawing_Outlined)
    ;gSetPenSize(40)
    gSetPenImage(bufferedPbLogo,#WrapModeTileFlipXY)
    gSetPenTransform(penOriginX+400,penOriginY+545+(800-565)*0.5,penRotation,penScale,penScale)
    gBox(20,545,760,800-565)
    ;gStopRotation()
EndProcedure

Procedure demo_gEllipse()
    gSetPenColor(RGBA($00,$00,$00,$FF))
    gDrawText(5,5,"draw ellipses at different sizes",$FF000000)
    j=0
    For i = 1 To 30
        j + i + 5
        gEllipse(j,45,i*0.5,i)
    Next i
    j=0
    gDrawText(5,65,"...with different colors",$FF000000)
    For i = 1 To 30
        j + i + 5
        gSetPenColor(colors(i))
        gEllipse(j,105,i*0.5,i)
    Next i
    j=0
    gDrawText(5,125,"...with patterns",$FF000000)
    For i = 1 To 30
        j + i + 5
        gSetPenPattern(i,$FFFFFFFF,$FF000000)
        gEllipse(j,165,i*0.5,i)
    Next i
    j=0
    gSetPenImage(bufferedBackground)
    gDrawText(5,185,"...with image texture",$FF000000)
    For i = 1 To 30
        j + i + 5
        gEllipse(j,225,i*0.5,i)
    Next i
    j=0
    gDrawText(5,245,"...outlined",$FF000000)
    gDrawingMode(#PB_2DDrawing_Outlined)
    For i = 1 To 30
        j + i + 5
        gSetPenColor(colors(i))
        gEllipse(j,285,i*0.5,i)
    Next i

    j=0
    gDrawingMode(#PB_2DDrawing_Default)
    gDrawText(5,305,"...rotated",$FF000000)
    gDrawingMode(#PB_2DDrawing_Outlined)

    gStartTransform()
        For i = 1 To 30
            j + i + 5
            gSetPenColor(colors(i))
            gRotateAt(j,345,i*12)
            gEllipse(j,345,i*0.5,i)
            gResetTransform()
        Next i
    gStopTransform()


    gSetPenImage(bufferedBackground)
    gDrawingMode(#PB_2DDrawing_Default)
    gSetPenTransform(penOriginX+200,penOriginY+470,penRotation,penScale,penScale)
    gEllipse(200,470,100,50)
    gResetPenTransform()
    gDrawingMode(#PB_2DDrawing_Outlined)
    gSetPenSize(10)
    gSetPenTransform(penOriginX+450,penOriginY+470,penRotation,penScale,penScale)
    gEllipse(450,470,75,25)
    gResetPenTransform()
    gSetPen($FF000000,2)

    gStartTransform()
        For i = 1 To 30
            gRotateAt(200,670,i*12)
            gEllipse(200,670,100,50)
            gResetTransform()
        Next i
    gStopTransform()

    gStartTransform()
        For i = 1 To 3
            gRotateAt(450,670,i*20)
            gEllipse(450,670,100,50)
            gResetTransform()
        Next i
    gStopTransform()

    gStartTransform()
        For i = 1 To 3
            gRotateAt(700,670,i*20)
            gEllipse(700,670,100,50)
        Next i
    gStopTransform()
EndProcedure

Procedure demo_gCircle()
    gSetPenColor(RGBA($00,$00,$00,$FF))
    gDrawText(5,5,"draw circles at different sizes",$FF000000)
    j=0
    For i = 1 To 30
        j + i + 5
        gCircle(j,45,i*0.5)
    Next i
    j=0
    gDrawText(5,65,"...with different colors",$FF000000)
    For i = 1 To 30
        j + i + 5
        gSetPenColor(colors(i))
        gCircle(j,105,i*0.5)
    Next i
    j=0
    gDrawText(5,125,"...with patterns",$FF000000)
    For i = 1 To 30
        j + i + 5
        gSetPenPattern(i,$FFFFFFFF,$FF000000)
        gCircle(j,165,i*0.5)
    Next i
    j=0
    gSetPenImage(bufferedBackground)
    gDrawText(5,185,"...with image texture",$FF000000)
    For i = 1 To 30
        j + i + 5
        gCircle(j,225,i*0.5)
    Next i
    j=0
    gDrawText(5,245,"...outlined",$FF000000)
    gDrawingMode(#PB_2DDrawing_Outlined)
    For i = 1 To 30
        j + i + 5
        gSetPenColor(colors(i))
        gCircle(j,285,i*0.5)
    Next i

    gSetPenImage(bufferedBackground)
    gDrawingMode(#PB_2DDrawing_Default)
    gSetPenTransform(penOriginX+200,penOriginY+470,penRotation,penScale,penScale)
    gCircle(200,470,100)
    gResetPenTransform()
    gDrawingMode(#PB_2DDrawing_Outlined)
    gSetPenSize(50)
    gSetPenTransform(penOriginX+450,penOriginY+470,penRotation,penScale,penScale)
    gCircle(450,470,75)
EndProcedure

Procedure demo_gPie()
    gSetPenColor(RGBA($00,$00,$00,$FF))
    gDrawText(5,5,"draw pie's at different sizes",$FF000000)
    j=0
    For i = 1 To 30
        j + i + 5
        gPie(j,45,i*0.5,i*0.5,-90,270)
    Next i
    j=0
    gDrawText(5,65,"...with different colors",$FF000000)
    For i = 1 To 30
        j + i + 5
        gSetPenColor(colors(i))
        gPie(j,105,i*0.5,i*0.5,-90,270)
    Next i
    j=0
    gDrawText(5,125,"...with patterns",$FF000000)
    For i = 1 To 30
        j + i + 5
        gSetPenPattern(i,$FFFFFFFF,$FF000000)
        gPie(j,165,i*0.5,i*0.5,-90,270)
    Next i
    j=0
    gSetPenImage(bufferedBackground)
    gDrawText(5,185,"...with image texture",$FF000000)
    For i = 1 To 30
        j + i + 5
        gPie(j,225,i*0.5,i*0.5,-90,270)
    Next i
    j=0
    gDrawText(5,245,"...outlined",$FF000000)
    gDrawingMode(#PB_2DDrawing_Outlined)
    For i = 1 To 30
        j + i + 5
        gSetPenColor(colors(i))
        gPie(j,285,i*0.5,i*0.5,-90,270)
    Next i

    gSetPenImage(bufferedBackground)
    gDrawingMode(#PB_2DDrawing_Default)
    gSetPenTransform(penOriginX+200,penOriginY+470,penRotation,penScale,penScale)
    gPie(200,470,100,100,-90,270)
    gResetPenTransform()
    gDrawingMode(#PB_2DDrawing_Outlined)
    gSetPenSize(20)
    gSetPenTransform(penOriginX+450,penOriginY+470,penRotation,penScale,penScale)
    gPie(450,470,90,90,-90,270)
EndProcedure

Procedure demo_gArc()
    gSetPenColor(RGBA($00,$00,$00,$FF))
    gDrawText(5,5,"draw arc's at different sizes",$FF000000)
    j=0
    For i = 1 To 30
        j + i + 5
        gArc(j,45,i*0.5,i*0.5,-90,270)
    Next i
    j=0
    gDrawText(5,65,"...with different colors",$FF000000)
    For i = 1 To 30
        j + i + 5
        gSetPenColor(colors(i))
        gArc(j,105,i*0.5,i*0.5,-90,270)
    Next i
    j=0
    gDrawText(5,125,"...with patterns",$FF000000)
    For i = 1 To 30
        j + i + 5
        gSetPenPattern(i,$FFFFFFFF,$FF000000)
        gArc(j,165,i*0.5,i*0.5,-90,270)
    Next i
    j=0
    gSetPenImage(bufferedBackground)
    gDrawText(5,185,"...with image texture",$FF000000)
    For i = 1 To 30
        j + i + 5
        gArc(j,225,i*0.5,i*0.5,-90,270)
    Next i

    gSetPenImage(bufferedBackground)
    gSetPenTransform(penOriginX+200,penOriginY+470,penRotation,penScale,penScale)
    
    For i = 10 To 100 Step 5
    gArc(200,470,i,i,-180,180)
    Next i
    gResetPenTransform()
    
    gSetPenSize(20)
    gSetPenTransform(penOriginX+450,penOriginY+470,penRotation,penScale,penScale)
    gArc(450,470,90,90,-90,270)
    gArc(450,470,70,70,-180,45)
    gArc(450,470,110,110,-135,45)
EndProcedure

Procedure demo_gSetPenPattern()
    Protected patternCount.l = #PenPatternMax
    gDrawText(5,5,"use "+Str(patternCount+1)+" (0-"+Str(patternCount)+") different pen patterns",$FF000000)
    k = 0
    For i = 0 To 7
        For j = 0 To 6
            gSetPenPattern(k,$FFFFFFFF,$FF000000)
            If j&1
                gBox(i*100,40+j*75,90,60)
            ElseIf i&1
                gEllipse(45+i*100,70+j*75,45,30)
            Else
                gPie(45+i*100,70+j*75,45,30,0,315)
            EndIf
            gDrawText(i*100,25+j*75,Str(k),$FF000000)
            If k=#PenPatternMax : Break 2 : EndIf
            k+1
        Next j
    Next i
EndProcedure

Procedure demo_gSetPenStyle()
    gDrawText(5,5,"set different pen line styles",$FF000000)
    gDrawingMode(#PB_2DDrawing_Outlined)
    gSetFont("Arial",53)
    gSetPen($FF000000,2)
    
    Dim myStyle.f(5)
    mystyle(0)=5    ; length of line
    mystyle(1)=2    ; length of space
    mystyle(2)=15   ; length of line
    mystyle(3)=2    ; length of space
    mystyle(4)=25   ; length of line
    mystyle(5)=2    ; length of space

    k = 0
    For i = 0 To 5
        gSetPenStyle(i,@myStyle(),6)
        gLine(10,100+i*80,150,00)
        gBox(180,75+i*80,50,50)
        gCircle(280,100+i*80,25)
        gEllipse(380,100+i*80,50,25)
        gDrawText(450,60+i*80,"Text")
    Next i
EndProcedure

Procedure demo_gDrawText()
    gSetPenColor(RGBA($00,$00,$00,$FF))
    gDrawText(5,5,"draw text at different sizes",$FF000000)
    j=0
    For i = 1 To 30
        j + i + 5
        gSetFont("Arial",i*1.5,#PB_Font_Bold)
        gDrawText(j*1.2,45-i,"A")
    Next i
    j=0 : gSetFont()
    gDrawText(5,65,"...with different colors",$FF000000)
    For i = 1 To 30
        j + i + 5
        gSetPenColor(colors(i))
        gSetFont("Arial",i*1.5,#PB_Font_Bold)
        gDrawText(j*1.2,105-i,"B")
    Next i
    j=0 : gSetFont()
    gDrawText(5,125,"...with patterns",$FF000000)
    For i = 1 To 30
        j + i + 5
        gSetPenPattern(i,$FFFFFFFF,$FF000000)
        gSetFont("Arial",i*1.5,#PB_Font_Bold)
        gDrawText(j*1.2,165-i,"C")
    Next i
    j=0 : gSetFont()
    gSetPenImage(bufferedBackground)
    gDrawText(5,185,"...with image texture",$FF000000)
    For i = 1 To 30
        j + i + 5
        gSetFont("Arial",i*1.5,#PB_Font_Bold)
        gDrawText(j*1.2,225-i,"D")
    Next i
    j=0 : gSetFont()
    gDrawText(5,245,"...outlined",$FF000000)
    gDrawingMode(#PB_2DDrawing_Outlined)
    For i = 1 To 30
        j + i + 5
        gSetPenColor(colors(i))
        gSetFont("Arial",i*1.5,#PB_Font_Bold)
        gDrawText(j*1.2,285-i,"E")
    Next i

    j = 300
    gSetPenImage(bufferedBackground)
    gDrawingMode(#PB_2DDrawing_Default)
    gSetPenTransform(penOriginX+400,penOriginY+470,penRotation,penScale,penScale)
    gSetFont("Arial",40,#PB_Font_Default)   : gDrawText(50,j,"Normal")      : j + gTextHeight()
    gSetFont("Arial",40,#PB_Font_Bold)      : gDrawText(50,j,"Bold")        : j + gTextHeight()
    gSetFont("Arial",40,#PB_Font_Italic)    : gDrawText(50,j,"Italic")      : j + gTextHeight()
    gSetFont("Arial",40,#PB_Font_Underline) : gDrawText(50,j,"Underlined")  : j + gTextHeight()
    gSetFont("Arial",40,#PB_Font_StrikeOut) : gDrawText(50,j,"StrikeOut")   : j + gTextHeight()
    gSetFont("Arial",40,#PB_Font_Bold|#PB_Font_Italic|#PB_Font_Underline|#PB_Font_StrikeOut)
    gDrawText(50,300+gTextHeight()*5,"All Styles")
    gDrawingMode(#PB_2DDrawing_Outlined)
    gSetPenSize(5)
    j=300
    gSetFont("Arial",130,#PB_Font_Default)   : gDrawText(250,j,"Outlined")  : j + gTextHeight()
    gDrawingMode(#PB_2DDrawing_Default)
    gSetFont("Arial",130,#PB_Font_Default)   : gDrawText(250,j,"Outlined",RGBA($FF,$FF,$FF,$FF))
    gDrawingMode(#PB_2DDrawing_Outlined)
    gSetFont("Arial",130,#PB_Font_Default)   : gDrawText(250,j,"Outlined")
EndProcedure

Procedure demo_gDrawRotatedText()
    gSetFont("Courier New",60,#PB_Font_Bold)
    gSetPenSize(3)
    For i = 50 To 0 Step -10
         gDrawingMode(#PB_2DDrawing_Default)
         gDrawRotatedText(10,10,"Rotated Text",i,RGBA($00,$00,$00,$FF-i*5))
         gSetPenPattern(8,RGBA(0,0,0,$FF-i*5),0);RGBA($FF,$FF,$FF,$FF-i*5))
         gDrawRotatedText(350,330,"PatternText",i-20)
         gDrawingMode(#PB_2DDrawing_Outlined)
         gDrawRotatedText(10,700,"Rotated Text",-i,RGBA($00,$00,$00,$FF-i*5))
    Next i
EndProcedure

Procedure demo_gLine()
EndProcedure

Procedure demo_gBezier()
EndProcedure

Procedure demo_gTriangle()
EndProcedure

Procedure demo_gPoly()
EndProcedure


For i = 0 To 100
    colors(i) = RGBA(Random($FF),Random($FF),Random($FF),$FF)
Next i



pbLogo = LoadImage(#PB_Any,#PB_Compiler_Home+"Examples\Sources\Data\PureBasicLogo.bmp")
If Not pbLogo : MessageRequester("ERROR","Unable to load PureBasic logo!") : End : EndIf

Background = CreateImage(#PB_Any,10,10,32|#PB_Image_Transparent)
If StartDrawing(ImageOutput(Background))
    DrawingMode(#PB_2DDrawing_Gradient|#PB_2DDrawing_AllChannels)
    BackColor($FF00FFFF)
    FrontColor($FFFF0000)
    CircularGradient(5, 5, 5)
    Circle(5,5,5)
    ;Box(0,0,10,10)
    StopDrawing()
EndIf

Procedure.i createWelcomeLogo()
    Protected img
    img = CreateImage(#PB_Any,600,400,32|#PB_Image_Transparent)
    If gStartDrawing(ImageOutput(img))
        gBox(0,0,600,400,RGBA($20,$20,$20,$EE))
        gSetFont("Courier New",20,#PB_Font_Bold)
        Define A$ = "Welcome to the world of"
        i  = 300 - gTextWidth(A$)*0.5
        gDrawText(i,10,A$,RGBA($FF,$FF,$00,$FF))
        gDrawingMode(#PB_2DDrawing_Outlined)
        gSetPenSize(2)
        gSetFont("Courier New",100,#PB_Font_Bold|#PB_Font_Italic)
        A$ = "gDrawing!"
        i  = 300 - gTextWidth(A$)*0.5
        gDrawText(i-2,28,A$,RGBA($00,$00,$FF,$FF))
        gDrawText(i+2,32,A$,RGBA($00,$00,$FF,$FF))
        gDrawText(i  ,30,A$,RGBA($FF,$FF,$FF,$FF))
    
        gSetFont()
        gDrawingMode(#PB_2DDrawing_Default)
        gDrawText(105,255,"Please choose a command on the left side.",$FFFFFFFF)
        gDrawText(105,280,"Then play with the trackbars on the right side.",$FFFFFFFF)
        gStopDrawing()
    EndIf
    ProcedureReturn gBufferImage(ImageID(img))
EndProcedure



If gInit()
    img = CreateImage(#PB_Any,800,800,24)
    
    welcomeLogo        = createWelcomeLogo()
    bufferedBackground = gBufferImage(ImageID(Background))
    bufferedPbLogo     = gBufferImage(ImageID(pbLogo))
    
    mainWin = OpenWindow(#PB_Any,0,0,1100,800,"gDrawing feature demo",#PB_Window_SystemMenu|#PB_Window_ScreenCentered)
    
    modeWin = ListViewGadget(#PB_Any,0,0,150,800)
    AddGadgetItem(modeWin,-1,"Welcome")             : demoProcedures(00) = @initpicture()
    AddGadgetItem(modeWin,-1,"gBox()")              : demoProcedures(01) = @demo_gBox()
    AddGadgetItem(modeWin,-1,"gLine() / gLineXY()") : demoProcedures(02) = @demo_gLine()
    AddGadgetItem(modeWin,-1,"gEllipse()")          : demoProcedures(03) = @demo_gEllipse()
    AddGadgetItem(modeWin,-1,"gCircle()")           : demoProcedures(04) = @demo_gCircle()
    AddGadgetItem(modeWin,-1,"gPlot()")             : demoProcedures(05) = @demo_gPlot()
    AddGadgetItem(modeWin,-1,"gDrawText()")         : demoProcedures(06) = @demo_gDrawText()
    AddGadgetItem(modeWin,-1,"gDrawRotatedText()")  : demoProcedures(07) = @demo_gDrawRotatedText()
    AddGadgetItem(modeWin,-1,"gPie()")              : demoProcedures(08) = @demo_gPie()
    AddGadgetItem(modeWin,-1,"gArc()")              : demoProcedures(09) = @demo_gArc()
    AddGadgetItem(modeWin,-1,"gBezier()")           : demoProcedures(10) = @demo_gBezier()
    AddGadgetItem(modeWin,-1,"gTriangle()")         : demoProcedures(11) = @demo_gTriangle()
    AddGadgetItem(modeWin,-1,"gPoly()")             : demoProcedures(12) = @demo_gPoly()
    AddGadgetItem(modeWin,-1,"gSetPenPattern()")    : demoProcedures(13) = @demo_gSetPenPattern()
    AddGadgetItem(modeWin,-1,"gSetPenStyle()")      : demoProcedures(14) = @demo_gSetPenStyle()
    SetGadgetState(modeWin,0)
    
                                    TextGadget(#PB_Any,960,20,130,20,"Pen Rotation")
    Define slider_penRotation     = TrackBarGadget(#PB_Any,960,40,130,20,0,360)
                                    TextGadget(#PB_Any,960,60,130,20,"Pen Scale")
    Define slider_penScale        = TrackBarGadget(#PB_Any,960,80,130,20,10,100) : SetGadgetState(slider_penScale,20)
                                    TextGadget(#PB_Any,960,100,130,20,"Pen Origin X")
    Define slider_penOriginX      = TrackBarGadget(#PB_Any,960,120,130,20,0,100)
                                    TextGadget(#PB_Any,960,140,130,20,"Pen Origin Y")
    Define slider_penOriginY      = TrackBarGadget(#PB_Any,960,160,130,20,0,100)
                                    TextGadget(#PB_Any,960,220,130,20,"Global Rotation")
    Define slider_globalRotation  = TrackBarGadget(#PB_Any,960,240,130,20,0,7200) : SetGadgetState(slider_globalRotation,3600)
                                    TextGadget(#PB_Any,960,260,130,20,"Global Scale (Zoom)")
    Define slider_globalScale     = TrackBarGadget(#PB_Any,960,280,130,20,0,100) : SetGadgetState(slider_globalScale,10)
                                    TextGadget(#PB_Any,960,300,130,20,"Global Shear X")
    Define slider_globalShearX    = TrackBarGadget(#PB_Any,960,320,130,20,0,100) : SetGadgetState(slider_globalShearX,50)
                                    TextGadget(#PB_Any,960,340,130,20,"Global Shear Y")
    Define slider_globalShearY    = TrackBarGadget(#PB_Any,960,360,130,20,0,100) : SetGadgetState(slider_globalShearY,50)

    If gStartDrawing( ImageOutput(img) )
        ;gClear( RGBA($AA,$AA,$AA,$FF) )
        initpicture()
        gStopDrawing()
    EndIf
    
    imgWin  = ImageGadget(#PB_Any,150,0,800,800,ImageID(img))
    Repeat
        Select WaitWindowEvent()
            Case #PB_Event_CloseWindow
                Break
            Case #PB_Event_Gadget
                Define gadget = EventGadget()
                If gadget = slider_penRotation
                    penRotation = GetGadgetState(slider_penRotation)
                    gadget = modeWin
                ElseIf gadget = slider_penScale
                    penScale = GetGadgetState(slider_penScale)*0.05
                    gadget = modeWin
                ElseIf gadget = slider_penOriginX
                    penOriginX = GetGadgetState(slider_penOriginX)
                    gadget = modeWin
                ElseIf gadget = slider_penOriginY
                    penOriginY = GetGadgetState(slider_penOriginY)
                    gadget = modeWin
                ElseIf gadget = slider_globalRotation
                    globalRotation = GetGadgetState(slider_globalRotation)*0.1 - 360.0
                    gadget = modeWin
                ElseIf gadget = slider_globalScale
                    globalScale = GetGadgetState(slider_globalScale)*0.1+0.1
                    gadget = modeWin
                ElseIf gadget = slider_globalShearX
                    globalShearX = GetGadgetState(slider_globalShearX) / 50 - 1.1
                    gadget = modeWin
                ElseIf gadget = slider_globalShearY
                    globalShearY = GetGadgetState(slider_globalShearY) / 50 - 1.1
                    gadget = modeWin
                EndIf
                If gadget = modeWin
                    Define item.l = GetGadgetState(modeWin)
                    If item >= 0 And item <= CountGadgetItems(modeWin)
                        Define demo.demoProc = demoProcedures(item)
                        If demo
                            If gStartDrawing( ImageOutput(img) )
                                gShearAt(400,400,globalShearX,globalShearY)
                                gScaleAt(400,400,globalScale,globalScale)
                                gRotateAt(400,400,globalRotation)
                                    gClear( RGBA($AA,$AA,$AA,$FF) )
                                    demo()
                                gResetTransform()
                                gStopDrawing()
                                SetGadgetState(imgWin,ImageID(img))
                            EndIf
                        EndIf
                    EndIf
                EndIf
        EndSelect
    ForEver

    gEnd()
EndIf

; IDE Options = PureBasic 4.51 (Windows - x86)
; CursorPosition = 554
; FirstLine = 540
; Folding = ---
; EnableXP
; Executable = gdiplus.exe
; CPU = 5