; Comtois le 01/12/08 - PB 4.30
; gui.pb

XIncludeFile "gui.pbi"

If OpenWindow(#WinPrincipale, 0, 0, 400, 300, "Mes livres", #WinOption)

  If CreateMenu(#MENU, WindowID(#WinPrincipale))
    MenuTitle("Fichier")
      MenuItem(#MENU_Nouveau, "Nouveau")
      MenuItem(#MENU_Ouvrir, "Ouvrir...")
      MenuBar()
      MenuItem(#MENU_Quitter, "Quitter")      
    MenuTitle("Fentres")
      MenuItem(#MENU_TileV, "Verticales")
      MenuItem(#MENU_TileH, "Horizontales")
      MenuItem(#MENU_Cascade, "Cascade")
      MenuItem(#MENU_Previous, "Prcdente")
      MenuItem(#MENU_Next, "Suivante")
      
      ; MDI subwindows will get added here
  EndIf
  
  AddKeyboardShortcut(#WinPrincipale, #PB_Shortcut_Return, #ToucheReturn)    
  
  MDIGadget(0, 0, 0, 0, 0, 1, #MENU_FirstMDI, #PB_MDI_AutoSize)

EndIf


;- *** PROCEDURES **********

Procedure OpenMDIFilles()
  AddGadgetItem(0, #WinLivres, "Livres",0, #PB_Window_BorderLess)
    ListIconGadget(#ListeLivres,0,0,400,250,"Titre", 395, #Option)
    SetGadgetColor(#ListeLivres, #PB_Gadget_BackColor  , RGB(248,248,248))
    SetGadgetColor(#ListeLivres, #PB_Gadget_LineColor , RGB(228,228,228))
    ListIconGadget(#ListeAuteursLivre, 0, 302, 199, 200, "Auteurs", 195,  #Option) 
    ListIconGadget(#ListeEditeursLivre, 201, 302, 199, 200, "Editeurs", 195, #Option) 
    StringGadget(#StringTitre,5,255,350,20,"")
    ImageGadget(#ImagePoubelleLivres,358,255,36,35, ImageID(0),#PB_Image_Border)
  AddGadgetItem(0, #WinAuteurs, "Auteurs",0,#PB_Window_BorderLess)
    ListIconGadget(#ListeAuteurs, 0, 0, 400,250,"Nom",197, #Option)
      AddGadgetColumn(#ListeAuteurs,1,"Prnom",197)
    ListIconGadget(#ListeLivresAuteur, 0, 302, 400, 200, "Livres", 395, #Option)  
    StringGadget(#StringNomAuteur,5,255,350,20,"")
    StringGadget(#StringPrenomAuteur,5,280,350,20,"")
    ImageGadget(#ImagePoubelleAuteurs,358,255,36,35, ImageID(0),#PB_Image_Border)
  AddGadgetItem(0, #WinEditeurs, "Editeurs",0,#PB_Window_BorderLess)
    ListIconGadget(#ListeEditeurs,0,0,400,250,"Nom", 395, #Option)
    ListIconGadget(#ListeLivresEditeur, 0, 302, 400, 200, "Livres", 395, #Option) 
    StringGadget(#StringNomEditeur,5,255,350,20,"")
    ImageGadget(#ImagePoubelleEditeurs,358,255,36,35, ImageID(0),#PB_Image_Border)
      
  ResizeWindow(#WinLivres, #PB_Ignore, #PB_Ignore, 402, 505) 
  ResizeWindow(#WinAuteurs, #PB_Ignore, #PB_Ignore, 402, 505) 
  ResizeWindow(#WinEditeurs, #PB_Ignore, #PB_Ignore, 402, 505) 
    
  EnableGadgetDrop(#ListeAuteursLivre,  #PB_Drop_Text, #PB_Drag_Copy)
  EnableGadgetDrop(#ListeEditeursLivre, #PB_Drop_Text, #PB_Drag_Copy)
  EnableGadgetDrop(#ListeLivresAuteur, #PB_Drop_Text, #PB_Drag_Copy)
  EnableGadgetDrop(#ListeLivresEditeur, #PB_Drop_Text, #PB_Drag_Copy)
  EnableGadgetDrop(#ImagePoubelleLivres, #PB_Drop_Text, #PB_Drag_Copy)
  EnableGadgetDrop(#ImagePoubelleAuteurs, #PB_Drop_Text, #PB_Drag_Copy)
  EnableGadgetDrop(#ImagePoubelleEditeurs, #PB_Drop_Text, #PB_Drag_Copy)  
EndProcedure

Procedure CloseMDIFilles()
  If IsWindow(#WinLivres)
    CloseWindow(#WinLivres)
  EndIf 
  If IsWindow(#WinAuteurs)
    CloseWindow(#WinAuteurs)
  EndIf 
  If IsWindow(#WinEditeurs)
    CloseWindow(#WinEditeurs)
  EndIf
EndProcedure

Procedure NouveauFichier()
  Define FichierParDefaut.s, Filtre.s, Fichier.s, Message.s
  Define IndexFiltre.i, Reponse.i
  
  FichierParDefaut = GetCurrentDirectory()+"\Nouveau.sqlite"  
  Filtre = "Bibliothque (*.sqlite)|*.sqlite;|Tous les fichiers (*.*)|*.*"
  IndexFiltre = 0  
  Fichier = SaveFileRequester("Choisissez le nom de votre bibliothque", FichierParDefaut, Filtre, IndexFiltre)

  If Fichier
  
    ;Test si le fichier existe 
    If FileSize(Fichier)>0
      Message = "Ce fichier existe dj , vous allez le supprimer, voulez vous vraiment continuer ?"
      Reponse=MessageRequester("Nouveau fichier", Message, #PB_MessageRequester_YesNo)
      If Reponse <> #PB_MessageRequester_Yes  
        ProcedureReturn #False
      EndIf  
    EndIf
    
       
     ;Ajoute l'extension si elle n'existe pas    
    If LCase(GetExtensionPart(Fichier))<>"sqlite"
      Fichier + ".sqlite"

    EndIf     
    
    Debug fichier
      
    ;Cration du fichier  
    If CreateFile(0,Fichier)
      Debug "ci"
      CloseFile(0)
      
      ;Cration de la base de donnes
      If NouvelleBase(Fichier)
        ProcedureReturn #True

      EndIf  
      
    Else
      Debug "Impossible de crer le fichier !"

    EndIf

  EndIf
EndProcedure

Procedure RaccourciToucheReturn()
  If GetGadgetState(#MDI)=#WinLivres
    AjoutLivre(GetGadgetText(#StringTitre))
    AfficheLivres()
    SetGadgetText(#StringTitre,"")
  ElseIf GetGadgetState(#MDI)=#WinAuteurs 
    AjoutAuteur(GetGadgetText(#StringNomAuteur),GetGadgetText(#StringPrenomAuteur))
    AfficheAuteurs()
    SetGadgetText(#StringNomAuteur,"")
    SetGadgetText(#StringPrenomAuteur,"")
  ElseIf GetGadgetState(#MDI)=#WinEditeurs          
    AjoutEditeur(GetGadgetText(#StringNomEditeur))
    AfficheEditeurs()
    SetGadgetText(#StringNomEditeur,"")
  EndIf
EndProcedure

Procedure OuvrirFichier()
  Define FichierParDefaut.s, Filtre.s, Fichier.s, Message.s
  Define IndexFiltre.i, Reponse.i
  
  FichierParDefaut = GetCurrentDirectory()+"\MaBiliotheque.sqlite"   
  Filtre = "Bibliothque (*.sqlite)|*.sqlite;|Tous les fichiers (*.*)|*.*"
  IndexFiltre = 0 
  Fichier = OpenFileRequester("Choisissez le nom de votre bibliothque", FichierParDefaut, Filtre, IndexFiltre)
  If Fichier
    
    CloseMDIFilles()
    If OpenDatabase(0, Fichier, "", "")

       ProcedureReturn #True
                             
    Else
      Debug "Can't open database !"
    EndIf
  
  EndIf
EndProcedure

Procedure ListeLivres()
  Define Texte.s, Livre.s, Modif.s
  Define IDLivre
  
  IDLivre = GET_ID_LIVRE
  
  If IDLivre>0 
    AfficheAuteursLivre(IDLivre)
    AfficheEditeursLivre(IDLivre)
  
    If EventType() = #PB_EventType_DragStart 
      Livre = "LL" + Str(IDLivre)
      DragText(Livre)
    ElseIf EventType() = #PB_EventType_LeftDoubleClick 
      Texte = "Modifiez le titre et validez"
      Modif=InputRequester("Modification titre", Texte, GetGadgetItemText(#ListeLivres,GetGadgetState(#ListeLivres)))
      If Modif >""
        ModifieLivre(IDLivre, Modif)
        AfficheLivres()
      EndIf
    EndIf 
  EndIf
EndProcedure

Procedure ListeAuteursLivre()
  Define Auteur.s
  
  If EventType() = #PB_EventType_DragStart And GET_ID_LIVRE>0
    Auteur = "LA"+Str(GetGadgetItemData(#ListeAuteursLivre,GetGadgetState(#ListeAuteursLivre)))
    DragText(Auteur)
  EndIf  
EndProcedure   

Procedure ListeEditeursLivre()
  Define Editeur.s
  If EventType() = #PB_EventType_DragStart And GET_ID_LIVRE>0
    Editeur = "LE"+Str(GetGadgetItemData(#ListeEditeursLivre,GetGadgetState(#ListeEditeursLivre)))
    DragText(Editeur)
  EndIf 
EndProcedure                     

Procedure ListeAuteurs()
  Define Texte.s, Auteur.s, Modif.s
  Define IDAuteur
  
  IDAuteur = GET_ID_AUTEUR
  
  If IDAuteur>0
    AfficheLivresAuteur(IDAuteur)
    If EventType() = #PB_EventType_DragStart 
      Auteur = "AA" + Str(IDAuteur)
      DragText(Auteur)
    ElseIf EventType() = #PB_EventType_LeftDoubleClick 
      Texte = "Modifiez le nom et validez"
      Modif=InputRequester("Modification nom", Texte, GetGadgetItemText(#ListeAuteurs,GetGadgetState(#ListeAuteurs)))
      If Modif >""
        ModifieAuteur(IDAuteur, Modif)
        AfficheAuteurs()
      EndIf
    EndIf
  EndIf 
EndProcedure

Procedure ListeLivresAuteur()
  Define Livre.s
  Define IDLivre
  
  IDLivre = GetGadgetItemData(#ListeLivresAuteur, GetGadgetState(#ListeLivresAuteur))
  If EventType() = #PB_EventType_DragStart And IDLivre>0
    Livre = "AL"+Str(IDLivre)
    DragText(Livre)
  EndIf 
EndProcedure

Procedure ListeEditeurs()
  Define Texte.s, Editeur.s, Modif.s
  Define IDEditeur
  
  IDEditeur = GET_ID_EDITEUR
  
  If IDEditeur>0
    AfficheLivresEditeur(IDEditeur)    
    If EventType() = #PB_EventType_DragStart 
      Editeur = "EE" + Str(IDEditeur)
      DragText(Editeur)
    ElseIf EventType() = #PB_EventType_LeftDoubleClick 
      Texte = "Modifiez le nom et validez"
      Modif=InputRequester("Modification nom", Texte, GetGadgetItemText(#ListeEditeurs,GetGadgetState(#ListeEditeurs)))
      If Modif >""
        ModifieEditeur(IDEditeur, Modif)
        AfficheEditeurs()
      EndIf
    EndIf 
  EndIf
EndProcedure

Procedure ListeLivresEditeur()
  Define Livre.s
  Define IDLivre
  
  IDLivre = GetGadgetItemData(#ListeLivresEditeur, GetGadgetState(#ListeLivresEditeur))
  If EventType() = #PB_EventType_DragStart And IDLivre>0
    Livre = "EL"+Str(IDLivre)
    DragText(Livre)
  EndIf 
EndProcedure

Procedure ImagePoubelleLivreDrop()
  Define Texte.s
  Define IDLivre, IDAuteur, IDEditeur
  
  IDLivre = GET_ID_LIVRE
  If IDLivre>0
    Texte=EventDropText()
    If Left(Texte,2)="LA"
      IDAuteur=Val(Mid(Texte,3))
      SupprimeAuteurLivre(IDLivre, IDAuteur)
      AfficheAuteursLivre(IDLivre)
    ElseIf Left(Texte,2)="LE"
      IDEditeur=Val(Mid(Texte,3))
      SupprimeEditeurLivre(IDLivre, IDEditeur)
      AfficheEditeursLivre(IDLivre)
    ElseIf Left(Texte,2)="LL"
      IDLivre=Val(Mid(Texte,3))
      SupprimeLivre(IDLivre)
      AfficheLivres()          
    EndIf  
  EndIf 
EndProcedure

Procedure ImagePoubelleAuteurDrop()
  Define Texte.s
  Define IDLivre, IDAuteur
   
  Texte=EventDropText()
  If Left(Texte,2)="AA"
    IDAuteur=Val(Mid(Texte,3))
    SupprimeAuteur(IDAuteur)
    AfficheAuteurs()
    
  ElseIf Left(Texte,2)="AL"
    IDAuteur = GET_ID_AUTEUR
    If IDAuteur>0 
      IDLivre=Val(Mid(Texte,3))
      SupprimeAuteurLivre(IDLivre, IDAuteur)
      AfficheLivresAuteur(IDAuteur)  
    EndIf  
  EndIf 
EndProcedure

Procedure ImagePoubelleEditeurDrop()
  Define Texte.s
  Define IDLivre, IDEditeur
     
  Texte=EventDropText()
  
  If Left(Texte,2)="EE"
    IDEditeur=Val(Mid(Texte,3))
    SupprimeEditeur(IDEditeur)
    AfficheEditeurs()
   
  ElseIf Left(Texte,2)="EL" 
    IDEditeur = GET_ID_EDITEUR
    If IDEditeur>0 
      IDLivre=Val(Mid(Texte,3))
      SupprimeEditeurLivre(IDLivre, IDEditeur)
      AfficheLivresEditeur(IDEditeur)   
    EndIf  
  EndIf
EndProcedure

Procedure ListeAuteursLivreDrop()
  Define Texte.s
  Define IDLivre, IDAuteur
  
  IDLivre=GET_ID_LIVRE
  
  If IDLivre>0
    Texte=EventDropText()
    If Left(Texte,2)="AA" 
      IDAuteur=Val(Mid(Texte,3))
      AjoutLivreAuteur(IDLivre, IDAuteur)
      AfficheAuteursLivre(IDLivre)
    EndIf
  EndIf
EndProcedure

Procedure ListeEditeursLivreDrop()
  Define Texte.s
  Define IDLivre, IDEditeur
  
  IDLivre=GET_ID_LIVRE
  
  If IDLivre>0
    Texte=EventDropText()
    If Left(Texte,2)="EE" 
      IDEditeur=Val(Mid(Texte,3))
      AjoutLivreEditeur(IDLivre, IDEditeur)
      AfficheEditeursLivre(IDLivre)            
    EndIf
  EndIf
EndProcedure

Procedure ListeLivresAuteurDrop()
  Define Texte.s
  Define IDLivre, IDAuteur
  
  IDAuteur=GET_ID_AUTEUR
  
  If IDAuteur>0
    Texte=EventDropText()
    If Left(Texte,2)="LL" 
      IDLivre=Val(Mid(Texte,3))
      AjoutLivreAuteur(IDLivre, IDAuteur)
      AfficheLivresAuteur(IDAuteur)            
    EndIf
  EndIf
EndProcedure 

Procedure ListeLivresEditeurDrop()
  Define Texte.s
  Define IDLivre, IDEditeur
  
  IDEditeur=GET_ID_EDITEUR
  
  If IDEditeur>0
    Texte=EventDropText()
    If Left(Texte,2)="LL" 
      IDLivre=Val(Mid(Texte,3))
      AjoutLivreEditeur(IDLivre, IDEditeur)
      AfficheLivresEditeur(IDEditeur)            
    EndIf
  EndIf
EndProcedure 

; IDE Options = PureBasic 4.30 Beta 4 (Windows - x86)
; CursorPosition = 99
; FirstLine = 79
; Folding = ----
; EnableXP