; Comtois le 01/12/08 - PB 4.30
; sqlite.pb 

XIncludeFile "sqlite.pbi"

Procedure NouvelleBase(Fichier.s)
  Define Table.s, Trigger.s
  
  If OpenDatabase(0, Fichier, "", "")
    
    CheckDatabaseUpdate(0,"BEGIN")

    Table = "CREATE TABLE livres  (id INTEGER PRIMARY KEY,"
    Table +                       "titre TEXT NOT NULL COLLATE NOCASE,"
    Table +                       "UNIQUE(titre))"
    CheckDatabaseUpdate(0, Table)

    Table = "CREATE TABLE auteurs (id INTEGER PRIMARY KEY,"
    Table +                       "nom TEXT NOT NULL COLLATE NOCASE,"
    Table +                       "prenom TEXT COLLATE NOCASE," 
    Table +                       "UNIQUE(nom, prenom))"
    CheckDatabaseUpdate(0, Table)          

    Table = "CREATE TABLE editeurs(id INTEGER PRIMARY KEY,"
    Table +                       "nom TEXT NOT NULL,"
    Table +                       "UNIQUE(nom))"
    CheckDatabaseUpdate(0, Table)  

    Table = "CREATE TABLE livres_auteurs (id_livre INTEGER,"
    Table +                              "id_auteur INTEGER,"
    Table +                              "UNIQUE(id_livre,id_auteur))"
    CheckDatabaseUpdate(0, Table)  

    Table = "CREATE TABLE livres_editeurs(id_livre INTEGER,"
    Table +                              "id_editeur INTEGER,"
    Table +                              "UNIQUE(id_livre,id_editeur))"
    CheckDatabaseUpdate(0, Table)           

    ;Trigger
    Trigger = "CREATE TRIGGER livre_insert_trg "
    Trigger + "BEFORE INSERT ON livres "
    Trigger + "BEGIN "
    Trigger + "  SELECT CASE "
    Trigger + "    WHEN (SELECT titre FROM livres WHERE LENGTH(NEW.titre)<=0) > 0 "
    Trigger + "    THEN RAISE(ABORT, 'le titre de ce livre est erron') "
    Trigger + "  END; "
    Trigger + "END; "   
    CheckDatabaseUpdate(0, Trigger)

    Trigger = "CREATE TRIGGER auteur_insert_trg "
    Trigger + "BEFORE INSERT ON auteurs "
    Trigger + "BEGIN "
    Trigger + "  SELECT CASE "
    Trigger + "    WHEN (SELECT nom FROM auteurs WHERE LENGTH(NEW.nom)<=0) > 0 "
    Trigger + "    THEN RAISE(ABORT, 'le nom de cet auteur est erron') "
    Trigger + "  END; "
    Trigger + "END; "   
    CheckDatabaseUpdate(0, Trigger)

    Trigger = "CREATE TRIGGER editeur_insert_trg "
    Trigger + "BEFORE INSERT ON editeurs "
    Trigger + "BEGIN "
    Trigger + "  SELECT CASE "
    Trigger + "    WHEN (SELECT nom FROM editeurs WHERE LENGTH(NEW.nom)<=0) > 0 "
    Trigger + "    THEN RAISE(ABORT, 'le nom de cet diteur est erron') "
    Trigger + "  END; "
    Trigger + "END; "   
    CheckDatabaseUpdate(0, Trigger)
          
    Trigger = "CREATE TRIGGER auteur_delete_trg "
    Trigger + "BEFORE DELETE ON auteurs "
    Trigger + "BEGIN "
    Trigger + "  SELECT CASE "
    Trigger + "    WHEN (SELECT COUNT(id_auteur) FROM livres_auteurs WHERE id_auteur=OLD.id) > 0 "
    Trigger + "    THEN RAISE(ABORT, 'cet auteur est utilis dans une table, supprimez ou modifiez les fiches livres qui s''y rfrent') "
    Trigger + "  END; "
    Trigger + "END; "   
    CheckDatabaseUpdate(0, Trigger)
    
    Trigger = "CREATE TRIGGER editeur_delete_trg "
    Trigger + "BEFORE DELETE ON editeurs "
    Trigger + "BEGIN "
    Trigger + "  SELECT CASE "
    Trigger + "    WHEN (SELECT COUNT(id_editeur) FROM livres_editeurs WHERE id_editeur=OLD.id) > 0 "
    Trigger + "    THEN RAISE(ABORT, 'cet diteur est utilis dans une table, supprimez ou modifiez les fiches livres qui s''y rfrent') "
    Trigger + "  END; "
    Trigger + "END; "   
    CheckDatabaseUpdate(0, Trigger)
  
    CheckDatabaseUpdate(0,"COMMIT") 

    ProcedureReturn #True
                           
  Else
    Debug "Can't open database !"
  EndIf
EndProcedure        
;- Check ------------------------------ 

Procedure CheckDatabaseUpdate(Database, Query$)
   Define Resultat
   Resultat = DatabaseUpdate(Database, Query$)
   If Resultat = 0
      MessageRequester("Erreur", DatabaseError(),0)
   EndIf
   
   ProcedureReturn Resultat
EndProcedure

Procedure CheckDatabaseQuery(Database, Query$)
   Define Resultat
   Resultat = DatabaseQuery(Database, Query$)
   If Resultat = 0
      MessageRequester("Erreur", DatabaseError(),0)
   EndIf
   
   ProcedureReturn Resultat
EndProcedure

;- Ajout ------------------------------

Procedure AjoutLivre(titre.s)
  Define Sql.s
  Sql = "INSERT INTO livres (titre) "
  Sql + "VALUES (" + Chr(34) + titre + Chr(34) + ")"
  CheckDatabaseUpdate(0, Sql)
EndProcedure

Procedure AjoutAuteur(nom.s, prenom.s)
  Define Sql.s
  Sql = "INSERT INTO auteurs (nom, prenom) " 
  Sql + " VALUES (" + Chr(34) + nom + Chr(34) + "," + Chr(34) + prenom + Chr(34) + ")" 
  CheckDatabaseUpdate(0, Sql)
EndProcedure

Procedure AjoutLivreAuteur(id_livre, id_auteur)
  Define Sql.s
  Sql = "INSERT INTO livres_auteurs (id_livre, id_auteur) "
  Sql + "VALUES (" + Chr(34) + Str(id_livre) + Chr(34)+"," + Chr(34) + Str(id_auteur) + Chr(34) + ")"
  CheckDatabaseUpdate(0, Sql)
EndProcedure

Procedure AjoutLivreEditeur(id_livre, id_editeur)
  Define Sql.s
  Sql = "INSERT INTO livres_editeurs (id_livre, id_editeur) "
  Sql + "VALUES (" + Chr(34) + Str(id_livre) + Chr(34)+"," + Chr(34) + Str(id_editeur) + Chr(34) + ")"
  CheckDatabaseUpdate(0, Sql)
EndProcedure

Procedure AjoutEditeur(nom.s)
  Define Sql.s
  Sql = "INSERT INTO editeurs (nom) " 
  Sql + "VALUES (" + Chr(34) + nom + Chr(34) + ")" 
  CheckDatabaseUpdate(0, Sql)
EndProcedure

;- Modifie ----------------------------

Procedure ModifieLivre(id_livre, livre.s)
  Define Query.s
  Query = "UPDATE livres "
  Query + "SET titre="+ Chr(34) + livre + Chr(34)
  Query + "WHERE id=" + Chr(34)+Str(id_livre)+Chr(34)
  CheckDatabaseUpdate(0,"BEGIN")
  If CheckDatabaseQuery(0, Query)
    While NextDatabaseRow(0)
  
    Wend
    FinishDatabaseQuery(0)
  EndIf
  CheckDatabaseUpdate(0,"COMMIT")   
EndProcedure

Procedure ModifieAuteur(id_auteur, auteur.s)
  Define Query.s
  Query = "UPDATE auteurs "
  Query + "SET nom="+ Chr(34) + auteur + Chr(34)
  Query + "WHERE id=" + Chr(34)+Str(id_auteur)+Chr(34)
  CheckDatabaseUpdate(0,"BEGIN")
  If CheckDatabaseQuery(0, Query)
    While NextDatabaseRow(0)
  
    Wend
    FinishDatabaseQuery(0)
  EndIf
  CheckDatabaseUpdate(0,"COMMIT")   
EndProcedure

Procedure ModifieEditeur(id_editeur, editeur.s)
  Define Query.s
  Query = "UPDATE editeurs "
  Query + "SET nom="+ Chr(34) + editeur + Chr(34)
  Query + "WHERE id=" + Chr(34)+Str(id_editeur)+Chr(34)
  CheckDatabaseUpdate(0,"BEGIN")
  If CheckDatabaseQuery(0, Query)
    While NextDatabaseRow(0)
  
    Wend
    FinishDatabaseQuery(0)
  EndIf
  CheckDatabaseUpdate(0,"COMMIT")     
EndProcedure

;- Affiche ----------------------------

Procedure AfficheLivres()
  Define Query.s
  Query = "SELECT * FROM livres ORDER BY titre "
  ClearGadgetItems(#ListeLivres)
  ClearGadgetItems(#ListeAuteursLivre)
  ClearGadgetItems(#ListeEditeursLivre)  
  CheckDatabaseUpdate(0,"BEGIN")
  If CheckDatabaseQuery(0, Query)
    While NextDatabaseRow(0)
      AddGadgetItem(#ListeLivres, -1, GetDatabaseString(0, 1))
      SetGadgetItemData(#ListeLivres,CountGadgetItems(#ListeLivres)-1, Val(GetDatabaseString(0, 0)))      
    Wend
    FinishDatabaseQuery(0)
  EndIf
  CheckDatabaseUpdate(0,"COMMIT")  
EndProcedure

Procedure AfficheAuteurs()
  Define Query.s
  Query = "SELECT * FROM auteurs ORDER BY nom"
  ClearGadgetItems(#ListeAuteurs)
  ClearGadgetItems(#ListeLivresAuteur)
  CheckDatabaseUpdate(0,"BEGIN")
  If CheckDatabaseQuery(0, Query)
    While NextDatabaseRow(0)
      AddGadgetItem(#ListeAuteurs, -1, GetDatabaseString(0, 1)+Chr(10)+ GetDatabaseString(0, 2))
      SetGadgetItemData(#ListeAuteurs,CountGadgetItems(#ListeAuteurs)-1, Val(GetDatabaseString(0, 0)))
    Wend
    FinishDatabaseQuery(0)
  EndIf
  CheckDatabaseUpdate(0,"COMMIT") 
EndProcedure

Procedure AfficheEditeurs()
  Define Query.s
  Query = "SELECT * FROM editeurs ORDER BY nom"
  ClearGadgetItems(#ListeEditeurs)
  ClearGadgetItems(#ListeLivresEditeur)
  CheckDatabaseUpdate(0,"BEGIN")
  If CheckDatabaseQuery(0, Query)
    While NextDatabaseRow(0)
      AddGadgetItem(#ListeEditeurs, -1,GetDatabaseString(0, 1))
      SetGadgetItemData(#ListeEditeurs,CountGadgetItems(#ListeEditeurs)-1, Val(GetDatabaseString(0, 0)))
    Wend
    FinishDatabaseQuery(0)
  EndIf
  CheckDatabaseUpdate(0,"COMMIT") 
EndProcedure

Procedure AfficheAuteursLivre(id_livre)
  Define Query.s
  Query = "SELECT nom, prenom, id "
  Query + "FROM livres_auteurs "
  Query + "JOIN auteurs "
  Query + "ON auteurs.id=livres_auteurs.id_auteur AND id_livre="+Chr(34)+Str(id_livre)+Chr(34) + "ORDER BY nom " 
  ClearGadgetItems(#ListeAuteursLivre)
  CheckDatabaseUpdate(0,"BEGIN")
  If CheckDatabaseQuery(0, Query)
    While NextDatabaseRow(0) 
      AddGadgetItem(#ListeAuteursLivre,-1,GetDatabaseString(0, 0) + " " + GetDatabaseString(0, 1))
      SetGadgetItemData(#ListeAuteursLivre,CountGadgetItems(#ListeAuteursLivre)-1, Val(GetDatabaseString(0, 2)))  
    Wend
    FinishDatabaseQuery(0)
  EndIf
  CheckDatabaseUpdate(0,"COMMIT") 
EndProcedure

Procedure AfficheEditeursLivre(id_livre)
  Define Query.s
  Query = "SELECT nom, id "
  Query + "FROM livres_editeurs "
  Query + "JOIN editeurs "
  Query + "ON editeurs.id=livres_editeurs.id_editeur AND id_livre="+Chr(34)+Str(id_livre)+Chr(34) + "ORDER BY nom " 
  ClearGadgetItems(#ListeEditeursLivre)
  CheckDatabaseUpdate(0,"BEGIN")
  If CheckDatabaseQuery(0, Query)
    While NextDatabaseRow(0)
      AddGadgetItem(#ListeEditeursLivre,-1,GetDatabaseString(0, 0))
      SetGadgetItemData(#ListeEditeursLivre,CountGadgetItems(#ListeEditeursLivre)-1, Val(GetDatabaseString(0, 1))) 
    Wend
    FinishDatabaseQuery(0)
  EndIf
  CheckDatabaseUpdate(0,"COMMIT") 
EndProcedure

Procedure AfficheLivresAuteur(id_auteur)
  Define Query.s
  Query = "SELECT titre, id "
  Query + "FROM livres, livres_auteurs "
  Query + "WHERE livres.id=livres_auteurs.id_livre AND id_auteur="+Chr(34)+Str(id_auteur)+Chr(34) + "ORDER BY titre "
  ClearGadgetItems(#ListeLivresAuteur)
  CheckDatabaseUpdate(0,"BEGIN")
  If CheckDatabaseQuery(0, Query)
    While NextDatabaseRow(0) 
      AddGadgetItem(#ListeLivresAuteur,-1,GetDatabaseString(0, 0))
      SetGadgetItemData(#ListeLivresAuteur,CountGadgetItems(#ListeLivresAuteur)-1, Val(GetDatabaseString(0, 1))) 
    Wend
    FinishDatabaseQuery(0)
  EndIf
  CheckDatabaseUpdate(0,"COMMIT") 
EndProcedure

Procedure AfficheLivresEditeur(id_editeur)
  Define Query.s
  Query = "SELECT titre, id "
  Query + "FROM livres, livres_editeurs "
  Query + "WHERE livres.id=livres_editeurs.id_livre AND id_editeur="+Chr(34)+Str(id_editeur)+Chr(34) + "ORDER BY titre "
  ClearGadgetItems(#ListeLivresEditeur)
  CheckDatabaseUpdate(0,"BEGIN")
  If CheckDatabaseQuery(0, Query)
    While NextDatabaseRow(0)
      AddGadgetItem(#ListeLivresEditeur,-1,GetDatabaseString(0, 0))
      SetGadgetItemData(#ListeLivresEditeur,CountGadgetItems(#ListeLivresEditeur)-1, Val(GetDatabaseString(0, 1))) 
    Wend
    FinishDatabaseQuery(0)
  EndIf
  CheckDatabaseUpdate(0,"COMMIT") 
EndProcedure

;- Supprime ---------------------------

Procedure SupprimeLivre(id_livre)
  Define Query.s
  ;Supprime les auteurs du livre
  Query = "DELETE FROM livres_auteurs "
  Query + "WHERE id_livre=" + Chr(34) + Str(id_livre) + Chr(34) 
  CheckDatabaseUpdate(0,"BEGIN")
  If CheckDatabaseUpdate(0, Query)
    FinishDatabaseQuery(0)
  EndIf
  ;Supprime les diteurs du livre
  Query = "DELETE FROM livres_editeurs "
  Query + "WHERE id_livre=" + Chr(34) + Str(id_livre) + Chr(34) 
  If CheckDatabaseUpdate(0, Query)
    FinishDatabaseQuery(0)
  EndIf
  ;Supprime le livre
  Query = "DELETE FROM livres "
  Query + "WHERE id=" + Chr(34) + Str(id_livre) + Chr(34) 
  If CheckDatabaseUpdate(0, Query)
    FinishDatabaseQuery(0)
  EndIf
  CheckDatabaseUpdate(0,"COMMIT") 
EndProcedure

Procedure SupprimeAuteurLivre(id_livre, id_auteur)
  Define Query.s
  Query = "DELETE FROM livres_auteurs "
  Query + "WHERE id_livre=" + Chr(34) + Str(id_livre) + Chr(34) + "AND id_auteur=" + Chr(34) + Str(id_auteur) + Chr(34)
  CheckDatabaseUpdate(0,"BEGIN")
  If CheckDatabaseUpdate(0, Query)
    FinishDatabaseQuery(0)
  EndIf
  CheckDatabaseUpdate(0,"COMMIT") 
EndProcedure

Procedure SupprimeEditeurLivre(id_livre, id_editeur)
  Define Query.s
  Query = "DELETE FROM livres_editeurs "
  Query + "WHERE id_livre=" + Chr(34) + Str(id_livre) + Chr(34) + "AND id_editeur=" + Chr(34) + Str(id_editeur) + Chr(34)
  CheckDatabaseUpdate(0,"BEGIN")
  If CheckDatabaseUpdate(0, Query)
    FinishDatabaseQuery(0)
  EndIf
  CheckDatabaseUpdate(0,"COMMIT") 
EndProcedure

Procedure SupprimeAuteur(id_auteur)
  Define Query.s
  Query = "DELETE FROM auteurs "
  Query + "WHERE id=" + Chr(34) + Str(id_auteur) + Chr(34) 
  CheckDatabaseUpdate(0,"BEGIN")
  If CheckDatabaseUpdate(0, Query)
    FinishDatabaseQuery(0)
  EndIf
  CheckDatabaseUpdate(0,"COMMIT") 
EndProcedure

Procedure SupprimeEditeur(id_editeur)
  Define Query.s
  Query = "DELETE FROM editeurs "
  Query + "WHERE id=" + Chr(34) + Str(id_editeur) + Chr(34) 
  CheckDatabaseUpdate(0,"BEGIN")
  If CheckDatabaseUpdate(0, Query)
    FinishDatabaseQuery(0)
  EndIf
  CheckDatabaseUpdate(0,"COMMIT") 
EndProcedure
; IDE Options = PureBasic 4.30 Beta 4 (Windows - x86)
; Folding = ----
; EnableXP