;TVD (Tiny Visual Designer) - Version 0.94
;falsam 28/03/2011

EnableExplicit

Enumeration 40 Step 1
  #MainForm ;Fenetre en cours de cration
  #PopUpMenu ;Menu PopUp associ
  #GadgetCopy; Menu Popup : Copier un gadget 
  #GadgetCut ;Menu Popup : Supprimer un gadget
  #GadgetPaste ;Menu Popup : Coller un gadget
  #CodeCreate ;Menu Popup : Generation du code pure basic
    
  ;Inspecteur de gadget
  #InspectorForm
  #LGadgets ;Liste des gadgets
  #Panel 
  
  ;Onglet Standard
  #IdGadget ;Handle gadget en cours de cration (Lecture seul)
  #Enum 
  #Left
  #Top
  #Width
  #Height
  #LP0 ; Aide 1 er parametre (Exemple Texte)
  #P0 ; Paramertre 1
  
  ;Onglet Options
  #Options 
  
  ;Onglet Extra
  #Help ; Aide affect au gadget
  #Code ;Code affect au gadget
  
  ;Onglet Items
  #LItems ;List des items
  #ItemText ;Libell d'un item
  #ItemWidth ;Largeur d'un item
  #ItemUpdate ;Update d'un item (Ajout ou mise  jour d'une colonne)
  #ItemDel ;Suppression d'un item
  
  #SBar ;StatusBar
EndEnumeration

;Points d'ancrage d'un gadget selectionn
Enumeration 80 Step 1
  #AnchorN ;Nord
  #AnchorE ;Est
  #AnchorS ;Sud
  #AnchorW ; Ouest
  #AnchorSize ;Taille de chaque point d'ancrage
EndEnumeration

;Touche de raccourcis 
Enumeration  90 Step 1
  ;Menu PopUp
  #Kbd_MenuPopUp
  
  ;Deplacement (Ctrl + une touche de direction)
  #Kbd_CtrlUp ; Dplacement du gadget vers le haut
  #Kbd_CtrlDown ; Dplacement du gadget vers le bas
  #Kbd_CtrlRight ; Dplacement du gadget vers la droite
  #Kbd_CtrlLeft ;Dplacement du gadget vers la gauche
  
  ;Redimentionnemet du gadget (Alt + une touche de directtion)
  #Kbd_AltUp ; Hauteur en tirant par le haut 
  #Kbd_AltDown ;Hauteur en tirant par le bas 
  #Kbd_AltRight ; Largeur en tirant par la droite 
  #Kbd_AltLeft ; Largeur en tirant par la gauche
EndEnumeration

Define.l Event, EventWindow, EventGadget, EventType, EventMenu, RMouseState

;Un gadget est il survol ?
Macro GadgetHoverCheck(x, y, Gadget)
  (((Not x<GadgetX(Gadget)) & (Not y<GadgetY(Gadget))) &(Not x>=(GadgetX(Gadget)+GadgetWidth(Gadget))) & (Not y>=(GadgetY(Gadget)+GadgetHeight(gadget))))
EndMacro

;Structure modele de fenetre
Structure MWindowProperty
  Model.s           ;OpenWindow par defaut
  Enum.s            ;Enumeration
  Width.i            ;Largeur par defaut
  Height.i           ;Hauteur par defaut
  LP0.s               ;Libell pour l'inspecteur de gadget (Text, 
  Options.s         ;Options possibles (Exemple : "#PB_Text_Center,#PB_Text_Right,#PB_Text_Border"
EndStructure
Global Dim MWindow.MWindowProperty(1)

;Structure d'un modele de gadget
;Chaque gadget est dcrit dans la Data Section en fin de programme
Structure MGadgetProperty
  Model.s           ;Famille de gadget (Buttongadget, TextGadget ........)
  Enum.s            ;Enumeration
  PbAny.b          ;#Pb_Any par defaut Oui ou Non 
  AddItem.i        ;Ajout d'un item possible Oui ou Non
  Help.b             ;Aide Oui ou Non
  Width.i            ;Largeur par defaut
  Height.i           ;Hauteur par defaut
  LP0.s               ;Libell pour l'inspecteur de gadget (Text, 
  Options.s         ;Options possibles (Exemple : "#PB_Text_Center,#PB_Text_Right,#PB_Text_Border"
  CountGadget.i ;Compteur de gadget par type de gadget
EndStructure
Global Dim  MGadget.MGadgetProperty(11)

;Structure d'un gadget et Tableau des gadgets (L'indice 0 sera rserv  la fenetre)
;Le tableau de structure s'incrmente  chaque cration de gadget.
;Un gadget dtruit sera check Actif Oui ou Non
Structure StructureGadget
  Idgadget.i        ;Identifiant gadget lors de la cration
  IdLGadgets.i     ;Position dans la combo liste gadget
  IdModel.i         ;Identifiant model de gadget
  Actif.i               ;gadget actif #True ou #False
  ColCount.i        ;Nombre de colonnes si il s'agit d'un ListIcongadget par exemple
  Enum.s             ;Enumeration
  P0.s                 ;Texte ou contenu d'un gadget
  Options.s         ;Options possibles (Exemple : "#PB_Text_Center,#PB_Text_Right,#PB_Text_Border"
  Help.s              ;Aide 
EndStructure
Global Dim Gadgets.StructureGadget(1), IdPos.i,  IdGadget.i, CountGadgets.i

;Structure d'une copie de gadget (Copier/Coller un gadget dans le menu PopUp
Structure StructureMemGadget
  IdModel.i 
  Width.i
  Height.i
  P0.s
EndStructure
Global CopyGadget.StructureMemGadget

;Coordonnes X,Y de cration d'un gadget
Global X.i, Y.i, X1.i, Y1.i, Width.i, Height.i, Width1.i, Height1.i, DeltaX.i, DeltaY.i

;;Les Poignes : Couleur, Taille, Caches (Oui/Non), actif (Aucune=0,  N=1, E=2, S=3, W=4)
Global AnchorColor.i=$0000ff, AnchorSize.i=7, AnchorHide=#True, AnchorActif.i

;
Global GadgetCheck.b, GadgetDraw.b, ColCount.i, i.i, j.i

;Evenement Souris (0: Rien, 1 :Clique Gauche, 2 : Clique Droit, 3 : Clique Milieu
Procedure EventMouse()
     CompilerIf #PB_Compiler_OS = #PB_OS_Linux
      Protected gdkWnd.l, x.l, y.l, mask.l, Wnd, *Window.GTKWindow
      Wnd=WindowID(GetActiveWindow())
      *Window.GTKWindow = Wnd
      gdkWnd = *Window\bin\child\window
      gdk_window_get_pointer_(gdkWnd, @x, @y, @mask)
      
      If (mask & #GDK_BUTTON1_MASK)
        ProcedureReturn 1
          
      ElseIf (mask & #GDK_BUTTON3_MASK)
       ProcedureReturn 3
        
      ElseIf (mask & #GDK_BUTTON2_MASK)
        ProcedureReturn 2
          
      EndIf  
    CompilerEndIf
      
    CompilerIf #PB_Compiler_OS = #PB_OS_Windows
      ProcedureReturn Abs(GetAsyncKeyState_(#VK_LBUTTON) + GetAsyncKeyState_(#VK_RBUTTON)*3 + GetAsyncKeyState_(#VK_MBUTTON)*2)/$8000   
    CompilerEndIf      
   
    CompilerIf #PB_Compiler_OS = #PB_OS_MacOS
       ;
       ;
    CompilerEndIf    
EndProcedure

;Initialisation des raccourcis claviers
Procedure InitShortCut(Window.i)
  ;Menu Popup(En attendant de trouver une solution pour le clic droit sous Linux)
  AddKeyboardShortcut(#MainForm, #PB_Shortcut_Insert, #Kbd_MenuPopUp)
  
  ;Positionnement des gadgets (Ctrl + Up, Down, Right ou Left)
  AddKeyboardShortcut(Window, #PB_Shortcut_Up|#PB_Shortcut_Control, #Kbd_CtrlUp)
  AddKeyboardShortcut(Window, #PB_Shortcut_Down|#PB_Shortcut_Control, #Kbd_CtrlDown)
  AddKeyboardShortcut(Window, #PB_Shortcut_Right|#PB_Shortcut_Control, #Kbd_CtrlRight)
  AddKeyboardShortcut(Window, #PB_Shortcut_Left|#PB_Shortcut_Control, #Kbd_CtrlLeft)
  
  ;Redimensionnement des gadgets (Alt + Up, Down, Right ou Left)
  AddKeyboardShortcut(Window, #PB_Shortcut_Up|#PB_Shortcut_Alt, #Kbd_AltUp)
  AddKeyboardShortcut(Window, #PB_Shortcut_Down|#PB_Shortcut_Alt, #Kbd_AltDown)
  AddKeyboardShortcut(Window, #PB_Shortcut_Right|#PB_Shortcut_Alt, #Kbd_AltRight)
  AddKeyboardShortcut(Window, #PB_Shortcut_Left|#PB_Shortcut_Alt, #Kbd_AltLeft)  
EndProcedure

;Initialisation du modele de fenetre. Lecture depuis la Data Section
Procedure InitModelWindow()
  Protected Buffer.s, i.i
  Restore ModelWindow 
    For i=1 To 6
      Read.s Buffer
      Select i
        Case 1 : MWindow(0)\Model=Buffer
        Case 2 : MWindow(0)\Width =Val(Buffer)
        Case 3 : MWindow(0)\Height=Val(Buffer)
        Case 4 : MWindow(0)\LP0=Buffer
        Case 5 : MWindow(0)\Enum=Buffer
        Case 6 : MWindow(0)\Options=Buffer
      EndSelect
    Next
EndProcedure


;Initialisation des modeles de gadgets.Lecture depuis la Data Section
;Le menu popup s'enrichit des modeles de gadgets
Procedure InitModelgadget()
  Protected Buffer.s, i.i, j.i
  Restore ModelGadgets 
  For i=1 To 10
    For j=1 To 9
      Read.s Buffer
      Select j
        Case 1 : MGadget(i)\Model=Buffer
        Case 2 : MGadget(i)\Width=Val(Buffer)
        Case 3 : MGadget(i)\Height=Val(Buffer)
        Case 4 : MGadget(i)\LP0=Buffer
        Case 5 : MGadget(i)\Enum=Buffer
        Case 6 : MGadget(i)\PbAny=Val(Buffer)
        Case 7 : MGadget(i)\AddItem=Val(Buffer)
        Case 8 : MGadget(i)\Help=Val(Buffer)
        Case 9 : MGadget(i)\Options=Buffer
      EndSelect
    Next  
    
    ;Mise  jour du menu popup
    MenuItem((i), MGadget(i)\Model)
  Next  
  
  ;Ajout des items de Copier/Couper/Coller un gadget
  MenuBar()
  MenuItem(#GadgetCopy,"Copier") 
  MenuItem(#GadgetCut,"Couper") 
  MenuItem(#GadgetPaste,"Coller") 
  
  ;Ajout de l'item gnration du code
  MenuBar()
  MenuItem(#CodeCreate,"Gnration du code")
EndProcedure

;Desactiver l'inspecteur de gadget
Procedure InspectorDisable(Value.i)
  DisableGadget(#Enum, Value)
  DisableGadget(#Left, Value)
  DisableGadget(#Top, Value)
  DisableGadget(#Width, Value)
  DisableGadget(#Height, Value)
  HideGadget(#P0, Value)
EndProcedure

;Mise  jour de l'inspecteur de gadget (Si Idgadget=0, il s'agit de la fenetre)
Procedure InspectorUpdate(IdGadget.i)
  Protected i.i, j.i,  Buffer.s
  If IdGadget=0 ;Lecture des information de la fenetre en cours de cration
    SetGadgetText(#Enum, Gadgets(0)\Enum)
    SetGadgetText(#Left, Str(WindowX(#MainForm)))
    SetGadgetText(#Top, Str(WindowY(#Mainform)))
    SetGadgetText(#Width, Str(WindowWidth(#MainForm)))
    SetGadgetText(#Height, Str(WindowHeight(#Mainform)))
    DisableGadget(#P0,#False)
    SetGadgetText(#LP0, MWindow(0)\LP0)
    SetGadgetText(#P0, Gadgets(0)\P0)
    SetGadgetText(#Help, Gadgets(0)\Help)
    
    ;Quels sont les options possibles pour la fenetre ?
    Buffer=MWindow(0)\Options
    ClearGadgetItems(#Options)
    For i=1 To CountString(Buffer,",")+1
      If Trim(StringField(Buffer,i,","))<>""
        AddGadgetItem(#Options, -1, StringField(Buffer,i,","))
      EndIf
    Next
    
    ;Quels sont les options utilises pour la fentre ?
    Buffer=Gadgets(0)\Options
    For i=1 To CountString(Buffer,"|")+1
      For j=0 To CountGadgetItems(#Options)-1
        If GetGadgetItemText(#Options,j)=StringField(Buffer,i,"|")
          SetGadgetItemState(#Options, j, #PB_ListIcon_Checked)
        EndIf
      Next
    Next  
    
    ClearGadgetItems(#LItems)
    DisableGadget(#ItemText, #True)
    DisableGadget(#ItemWidth, #True)
    DisableGadget(#ItemUpdate, #True)
    DisableGadget(#ItemDel, #True)
    
  Else ;Lecture des informations du gadget en cours de cration ou de modification
    
    For i=1 To CountGadgetItems(#LGadgets)
      If GetGadgetItemData(#LGadgets, i)=IdGadget
        SetGadgetState(#LGadgets,i)
      EndIf
    Next
    
    SetGadgetText(#Left, Str(GadgetX(IdGadget)))
    SetGadgetText(#Top, Str(GadgetY(IdGadget)))
    SetGadgetText(#Width, Str(GadgetWidth(IdGadget)))
    SetGadgetText(#Height, Str(GadgetHeight(IdGadget)))
  EndIf
  
  ;Si le gadget est en cours de dplacement 
  ;Il est inutiles de raffraichir les informations 
  If GadgetDraw=#False And IdGadget<>0
    SetGadgetText(#IdGadget, Str(IdGadget))
    SetGadgetText(#Enum, Gadgets(GetGadgetData(IdGadget))\Enum)
    
    ;Un libell est il  renseigner pour ce gadget ? (On teste P0)
    If MGadget(Gadgets(GetGadgetData(IdGadget))\IdModel)\LP0<>""
      DisableGadget(#P0,#False)
      DisableGadget(#LP0,#False)
      SetGadgetText(#LP0, MGadget(Gadgets(GetGadgetData(IdGadget))\IdModel)\LP0)
      SetGadgetText(#P0, Gadgets(GetGadgetData(IdGadget))\P0)  
    Else
      DisableGadget(#P0, #True)
      DisableGadget(#LP0, #True)
      SetGadgetText(#P0, "")
    EndIf
    
    ;Quels sont les options possibles pour le  gadget slectionn ?
    Buffer=MGadget(Gadgets(GetGadgetData(IdGadget))\IdModel)\Options
    ClearGadgetItems(#Options)
    For i=1 To CountString(Buffer,",")+1
      If Trim(StringField(Buffer,i,","))<>""
        AddGadgetItem(#Options, -1, StringField(Buffer,i,","))
      EndIf
    Next
    
    ;Quels sont les options utilises pour le gadget selectionn ?
    Buffer=Gadgets(GetGadgetData(IdGadget))\Options
    For i=1 To CountString(Buffer,"|")+1
      For j=0 To CountGadgetItems(#Options)-1
        If GetGadgetItemText(#Options,j)=StringField(Buffer,i,"|")
          SetGadgetItemState(#Options, j, #PB_ListIcon_Checked)
        EndIf
      Next
    Next
    
    ;Un ListIconGadget est il survoll
    If Gadgets(GetGadgetData(IdGadget))\IdModel=6
      ClearGadgetItems(#LItems)
      ColCount=Gadgets(GetGadgetData(IdGadget))\ColCount
      For i=0 To (ColCount)
        AddGadgetItem(#Litems, -1, GetGadgetItemText(Idgadget, -1, i)+Chr(10)+Str(GetGadgetItemAttribute(IdGadget, 0, #PB_ListIcon_ColumnWidth,i )))
      Next
      
      DisableGadget(#ItemUpdate, #False)
      DisableGadget(#ItemDel, #False)
      DisableGadget(#ItemText, #False)
      DisableGadget(#ItemWidth,#False)      
    Else
      ClearGadgetItems(#LItems)
      DisableGadget(#ItemUpdate, #True)
      DisableGadget(#ItemDel, #True)
      DisableGadget(#ItemText, #True)
      DisableGadget(#ItemWidth,#True)    
    EndIf
    
    ;Une aide est t'il possible pour ce modele de gadget
    If MGadget(Gadgets(GetGadgetData(IdGadget))\IdModel)\Help=1
      DisableGadget(#Help,#False)
      SetGadgetText(#Help, Gadgets(GetGadgetData(IdGadget))\Help)
    Else
      DisableGadget(#Help, #True)
      SetGadgetText(#Help, "")
    EndIf
  EndIf
EndProcedure

;RAZ de l'inspecteur de gadget
Procedure InspectorClear()
  SetGadgetText(#IdGadget, "") 
  SetGadgetText(#Enum, "") 
  SetGadgetText(#Left, "") 
  SetGadgetText(#Top, "") 
  SetGadgetText(#Width, "")
  SetGadgetText(#Height,"")
  SetGadgetText(#Help,"")
  SetGadgetText(#ItemText,"")
  SetGadgetText(#ItemWidth,"")
  ClearGadgetItems(#LGadgets)
  ClearGadgetItems(#Options)
  ClearGadgetItems(#LItems)
  InspectorDisable(#True)
EndProcedure

;Cration des points d'ancrage
Procedure AnchorCreate()
  TextGadget(#AnchorN, 0, 0, AnchorSize, AnchorSize,"") 
  TextGadget(#AnchorE, 0, 0, AnchorSize, AnchorSize,"")
  TextGadget(#AnchorS, 0, 0, AnchorSize, AnchorSize,"")
  TextGadget(#AnchorW, 0, 0, AnchorSize, AnchorSize,"")
    
  SetGadgetColor(#AnchorN, #PB_Gadget_BackColor, AnchorColor)
  SetGadgetColor(#AnchorE, #PB_Gadget_BackColor, AnchorColor)
  SetGadgetColor(#AnchorS, #PB_Gadget_BackColor, AnchorColor)
  SetGadgetColor(#AnchorW, #PB_Gadget_BackColor, AnchorColor)
EndProcedure

;Cache les points d'ancrage
Procedure AnchorHide(Value.b)
  HideGadget(#AnchorN, Value)
  HideGadget(#AnchorE, Value)
  HideGadget(#AnchorS, Value) 
  HideGadget(#AnchorW, Value)
  AnchorHide=Value
EndProcedure

;Positionne les point d'ancrage
Procedure AnchorMove(IdGadget)
  Protected Left.i, Top.i, Width.i, Height.i
  Left=GadgetX(IdGadget)
  Top=GadgetY(IdGadget)
  Width=GadgetWidth(IdGadget)
  Height=GadgetHeight(IdGadget)
  If AnchorHide=#True
    AnchorHide(#False)
  EndIf
    
  ResizeGadget(#AnchorN, (Left+Width/2), Top-AnchorSize, AnchorSize, AnchorSize)
  ResizeGadget(#AnchorS, Left+Width/2, Top+Height+AnchorSize/4, AnchorSize,AnchorSize)
  ResizeGadget(#AnchorE, Left+AnchorSize/2+Width, Top+(Height-AnchorSize)/2, AnchorSize, AnchorSize)
  ResizeGadget(#AnchorW, Left-AnchorSize, Top+(Height-AnchorSize)/2, AnchorSize, AnchorSize)
EndProcedure

;Quel est le point d'ancrage actif
Procedure GetAnchorCheck()
  If GadgetDraw=#False
    AnchorActif=#False

    If GadgetHoverCheck(x,y,#AnchorN)
     AnchorActif=1
    EndIf
  
    If GadgetHoverCheck(x,y,#AnchorS)
      AnchorActif=2
    EndIf  
  
    If GadgetHoverCheck(x,y,#AnchorE)
      AnchorActif=3
    EndIf
  
    If GadgetHoverCheck(x,y,#AnchorW)
      AnchorActif=4
    EndIf 
  
    ProcedureReturn AnchorActif
  EndIf
EndProcedure

;Modification de la taille des points d'ancrages
Procedure AnchorResize()
  AnchorSize=Val(GetGadgetText(#AnchorSize))
  If IdGadget<>0
    AnchorMove(IdGadget)  
  EndIf          
EndProcedure

;Mise  jour de la liste des gadget (Combo #LGadgets)
Procedure LGadgetsUpdate()
  Protected i.i
  ClearGadgetItems(#LGadgets)
  For i=0 To CountGadgets
    If Gadgets(i)\Actif=#True
      Gadgets(i)\IdLGadgets=i
      AddGadgetItem(#LGadgets, -1, Gadgets(i)\Enum+" ("+MGadget(Gadgets(i)\IdModel)\Model+")")
      SetGadgetItemData(#LGadgets, CountGadgetItems(#LGadgets)-1, Gadgets(i)\Idgadget)
    EndIf
  Next 
EndProcedure

;Repositionne le gadget 
Procedure GadgetDraw(KbdValue.i, Idgadget.i)
  
  ;Un gadget est il toujours selectionn ?
  If IdGadget<>0
    Width=GadgetWidth(Idgadget) 
    Height=GadgetHeight(IdGadget)
    
    If AnchorActif>0
      DeltaX=0 : DeltaY=0
      Select AnchorActif
        Case 1 ;Nord
          X=GadgetX(IdGadget)
          Height=Height+(GadgetY(IdGadget)-Y)
          
        Case 2 ;Sud
          X=GadgetX(IdGadget)
          Height=Y-GadgetY(IdGadget)
          Y=GadgetY(IdGadget)
          
        Case 3 ;Est
          Y=GadgetY(IdGadget)
          Width=X-GadgetX(IdGadget)
          X=GadgetX(IdGadget)
          
        Case 4 ;Ouest
          Y=GadgetY(IdGadget)
          Width=Width+(GadgetX(IdGadget)-X)

      EndSelect  
    EndIf

    ;S'agit il d'un redimentionnement avec les touches du clavier
    If KbdValue<>0
      DeltaX=0 : DeltaY=0
      X=GadgetX(IdGadget)
      Y=GadgetY(IdGadget)
      Select KbdValue
          ;Dplacement d'un gadget  avec la combinaison de touches Ctrl + Fleches
          Case #Kbd_CtrlUp : Y=GadgetY(IdGadget)-1
          Case #Kbd_CtrlDown : Y=GadgetY(IdGadget)+1
          Case #Kbd_CtrlRight :  X=GadgetX(IdGadget)+1
          Case #Kbd_CtrlLeft : X=GadgetX(IdGadget)-1
          
          ;Redimensionnement d'un gadget avec la combinaison de touches Alt + Fleches
         Case #Kbd_AltUp :  Height=GadgetHeight(IdGadget)-1
         Case #Kbd_AltDown : Height=GadgetHeight(IdGadget)+1
         Case #Kbd_AltLeft : Width=GadgetWidth(Idgadget)-1
         Case #Kbd_AltRight : Width=GadgetWidth(Idgadget)+1    
       EndSelect  
       ResizeGadget(Idgadget, X, Y, Width, Height)
       AnchorMove(Idgadget)
       InspectorUpdate(Idgadget)  
    Else
       ;Quelques chose est il modifi dans les dimensions ?
       If (X1<>X) Or (Y1<>Y) Or (Width1<>Width) Or (Height1<>Height) ;And AnchorActif=0
         ResizeGadget(Idgadget, X-DeltaX, Y-DeltaY, Width, Height) 
         AnchorMove(Idgadget)
       EndIf    
       X1=X : Y1=Y : Width1=Width : Height1=Height  
    EndIf
  EndIf
EndProcedure

;Redimentionne le gadget (A intgrer  la procedure GadgetDraw)
Procedure GadgetResize(IdGadget.i)
  If IdGadget=0
    ;Changement de la postion et redimensionnement de la fenetre 
    ResizeWindow(#MainForm, Val(GetGadgetText(#Left)), Val(GetGadgetText(#Top)), Val(GetGadgetText(#Width)), Val(GetGadgetText(#Height)))   
  Else
    ;Changement de la position et redimentionnement d'un gadget
    ResizeGadget(IdGadget, Val(GetGadgetText(#Left)), Val(GetGadgetText(#Top)), Val(GetGadgetText(#Width)), Val(GetGadgetText(#Height)))
    AnchorMove(IdGadget)  
  EndIf
EndProcedure

;Selectionner un gadget  modifier depuis la comboliste des gadgets (#LGadgets)
Procedure GadgetSelect()
  ;If GetGadgetItemText(#LGadgets, GetGadgetState(#LGadgets))<>""
    IdGadget=GetGadgetItemData(#LGadgets, GetGadgetState(#LGadgets))
    If Idgadget<>0 ;Different de la fenetre en cours de creation
      AnchorMove(IdGadget)  
    Else
      AnchorHide(#True)  
    EndIf
    GadgetCheck=#True
    InspectorUpdate(Idgadget)
    InspectorDisable(#False)
  ;EndIf
EndProcedure

;Cration d'un gadget en fonction de l'item selectionn depuis le menu contextuel (PopUp)
Procedure GadgetCreate(IdModel.i, Copy.b)
  Protected Width.i, Height.i, P0.s
   
  ;Mise  jour du compteur de gadget associ au model de gadget
  MGadget(IdModel)\CountGadget=MGadget(IdModel)\CountGadget+1
  
  ;Incrmentation du compteurs de gadget Global
  CountGadgets=CountGadgets+1
  
  ;Redimentionnement du tableau de gadgets
  ReDim Gadgets(CountGadgets)
  
  ;Rcupration des valeurs par defaut depuis le tableau des models de gadget
  Width=MGadget(IdModel)\Width
  Height=MGadget(IdModel)\Height
  P0=MGadget(IdModel)\Enum+Str(MGadget(IdModel)\CountGadget)
  
  ;S'agit il d'une copie d'un gadget?
  If Copy=#True
    Width=CopyGadget\Width
    Height=CopyGadget\Height
    P0=CopyGadget\P0
  EndIf
    
  ;Quel est le gadget  crer
  Select IdModel
    Case 1 : IdGadget=ButtonGadget(#PB_Any, X, Y, Width, Height, P0)   
    Case 2 : IdGadget=CheckBoxGadget(#PB_Any, X, Y, Width, Height, P0)
    Case 3
      IdGadget=ComboBoxGadget(#PB_Any, X, Y, Width, Height, #PB_ComboBox_Editable) 
      AddGadgetItem(Idgadget,-1,"")
      
    Case 4 : IdGadget=EditorGadget(#PB_Any, X, Y, Width, Height, #PB_Editor_ReadOnly)
    Case 5 : IdGadget=Frame3DGadget(#PB_Any, X, Y, Width, Height, P0)
    Case 6 : IdGadget=ListIconGadget(#PB_Any, X, Y, Width, Height, P0,100)    
    Case 7 : IdGadget=ListViewGadget(#PB_Any, X, Y, Width, Height)
    Case 8 : IdGadget=OptionGadget(#PB_Any, X, Y, Width, Height, P0)
    Case 9 : IdGadget=StringGadget(#PB_Any, X, Y, Width, Height, P0)
    Case 10 : IdGadget=TextGadget(#PB_Any, X, Y, Width, Height, P0)
  EndSelect
  
  ;On affecte le compteur de gadget global  ce nouveau gadget
  SetGadgetData(IdGadget, CountGadgets)
  
  ;Enregistrement du gadget dans le tableau des gadgets
  ;Il est inutile d'enregitrer les proprites X,Y, Width et Height du gadget 
  ;On utilisera les fonctions GadgetX,  GadgetY, GadgetWidth et GadgetHeight
  ;A la cration du gadget , Enum sera egale  P0
  Gadgets(CountGadgets)\IdGadget=Idgadget
  Gadgets(CountGadgets)\IdModel=IdModel  
  
  If MGadget(IdModel)\PbAny=#True
    Gadgets(CountGadgets)\Enum="#Pb_Any"
  Else
    Gadgets(CountGadgets)\Enum="#"+MGadget(IdModel)\Enum+Str(MGadget(IdModel)\CountGadget)
  EndIf
  
  Gadgets(CountGadgets)\P0=P0
  Gadgets(CountGadgets)\Actif=#True
  
  ;Mise  jour de l'inspecteur de gadget
  If CountGadgets>0
    InspectorDisable(#False)
  EndIf
  
  ;Mise  jour du combo liste des gadget (#LGadgets)
  ;Chaque item reoit le handle du gadget (IdGadget)
  AddGadgetItem(#LGadgets, -1, Gadgets(CountGadgets)\Enum+" ("+MGadget(Gadgets(CountGadgets)\IdModel)\Model+")")
  SetGadgetState(#LGadgets, CountGadgetItems(#LGadgets)-1)
  SetGadgetItemData(#LGadgets, CountGadgetItems(#LGadgets)-1, IdGadget)
  
  AnchorMove(IdGadget)
  
  InspectorUpdate(IdGadget)
EndProcedure

;Modifie le nom du gadget ou de la fenetre
Procedure GadgetUpdateEnum(IdGadget.i)
  ;Le caractre # doit exister
  If Mid(GetGadgetText(#Enum),1,1)<>"#"
    SetGadgetText(#Enum,"#"+GetGadgetText(#Enum))
  EndIf
                     
  If IdGadget=0  
    ;Changement de l'num de la fenetre
    Gadgets(0)\Enum=GetGadgetText(#Enum)
    LGadgetsUpdate()
    SetGadgetState(#LGadgets, 0)
  Else
    ;Changement de l'num du gadget
    Gadgets(GetGadgetData(IdGadget))\Enum=GetGadgetText(#Enum)
    LGadgetsUpdate()
    SetGadgetState(#LGadgets, Gadgets(GetGadgetData(IdGadget))\IdLGadgets)
  EndIf
EndProcedure

;Un gadget peut posseder plusieurs parametres (Texte, Minimum, maximum, etc .....)
Procedure GadgetUpdatePX(IdGadget)
  If IdGadget=0
    ;Changement du titre de la fenetre
    SetWindowTitle(#Mainform, GetGadgetText(#P0))
    Gadgets(0)\P0=GetGadgetText(#P0)
  Else
    ;Changement du texte du gadget concern
    SetGadgetText(IdGadget, GetGadgetText(#P0))
    Gadgets(GetGadgetData(IdGadget))\P0=GetGadgetText(#P0)  
  EndIf
EndProcedure

;Associe un texte flottant au gadget spcifi (GadgetToolTip)
Procedure GadgetSetHelp(IdGadget.i)
  If IdGadget=0 
    Gadgets(0)\Help=GetGadgetText(#Help)
  Else
    Gadgets(GetGadgetData(IdGadget))\Help=GetGadgetText(#Help)
  EndIf
EndProcedure

;Ajoute une option  un gadget ou .......  la fenetre.
Procedure GadgetAddOption(IdGadget.i)
  If IdGadget=0
    ;Fenetre en cours de cration
     IdPos=0   
  Else
    ;Gadget en cours de cration : Rcupration de la position 
     IdPos=GetGadgetData(IdGadget)
  EndIf
  Gadgets(IdPos)\Options=""
   j=0
   For i=0 To CountGadgetItems(#Options)-1
     If GetGadgetItemState(#Options,i)=#PB_ListIcon_Checked
       If j>0
         Gadgets(IdPos)\Options=Gadgets(IdPos)\Options+"|"  
       EndIf
       j=j+1
       Gadgets(IdPos)\Options=Gadgets(IdPos)\Options+GetGadgetItemText(#Options,i)  
     EndIf  
   Next 
EndProcedure

;Ajoute ou modifie un lment  un gadget (Colonne, Onglet, ...)
Procedure GadgetUpdateElement(IdGadget)
  If Trim(GetGadgetText(#ItemText))<>""
    If GetGadgetData(#ItemUpdate)=0
      ;Ajout d'un element 
      AddGadgetColumn(IdGadget, CountGadgetItems(#LItems), GetGadgetText(#ItemText), Val(GetGadgetText(#ItemWidth)))
      ColCount=ColCount+1 : Gadgets(GetGadgetData(IdGadget))\ColCount=Colcount
      InspectorUpdate(IdGadget)
    
    Else
    
      ;Modification d'un lement (Titre / Largeur)
      SetGadgetItemText(Idgadget, -1, GetGadgetText(#ItemText), GetGadgetState(#LItems))
      SetGadgetItemAttribute(Idgadget, 0, #PB_ListIcon_ColumnWidth, Val(GetGadgetText(#ItemWidth)), GetGadgetState(#LItems))
      InspectorUpdate(Idgadget)
      SetGadgetData(#ItemUpdate, 0)  
    EndIf
    SetGadgetText(#ItemText, "")
    SetGadgetText(#ItemWidth, "100")
 EndIf
EndProcedure

;Enleve un element  un gadget (Colonne, Onglet, ...)
Procedure GadgetDelElement(IdGadget.i)
  If CountGadgetItems(#LItems)>1
    RemoveGadgetColumn(IdGadget, GetGadgetState(#LItems))
    ColCount=ColCount-1 : Gadgets(GetGadgetData(IdGadget))\ColCount=Colcount
    RemoveGadgetItem(#LItems, GetGadgetState(#LItems))
    InspectorUpdate(Idgadget)
  Else
    MessageRequester("Info","Vous devez laisser au moins une colonne")
EndIf
EndProcedure

;Copy d'un gadget depuis l'emplacement de la souris 
Procedure GadgetCopy(IdGadget.i)
  CopyGadget\IdModel=Gadgets(GetGadgetData(IdGadget))\IdModel
  CopyGadget\Width=GadgetWidth(IdGadget)
  CopyGadget\Height=GadgetHeight(IdGadget)
  CopyGadget\P0=Gadgets(GetGadgetData(IdGadget))\P0
EndProcedure

;Annulation d'un gadget (Recupration du numro de compteur affect au gadget)
Procedure GadgetCut(IdGadget.i)
  Protected i.i
  Gadgets(GetGadgetData(IdGadget))\Actif=#False
  AnchorHide(#True)
  HideGadget(IdGadget, #True)
  LGadgetsUpdate() ;Mise  jour de la comboliste des gadgets
  SetGadgetState(#LGadgets, 0)
  GadgetSelect()
EndProcedure

;Copie du gadget  l'emplacement de la souris
Procedure GadgetPaste()
  GadgetCreate(CopyGadget\IdModel, #True)
EndProcedure

;Gnration du code qui sera copi dans le presse papier
Procedure CodeCreate()
  Protected i.i, j.i, Code.s, Model.s, Enum.s, X.s, Y.s, Width.s, Height.s, P0.s
  
  ;Enumration
  Code=Code+"Enumeration"+#CRLF$
  For i=0 To (CountGadgets)
    If Gadgets(i)\Actif=#True
      If Gadgets(i)\Enum<>"#Pb_Any"
        Code=Code+#TAB$+Gadgets(i)\Enum+#CRLF$
      EndIf
    EndIf
  Next
  Code=Code+"EndEnumeration"+#CRLF$+#CRLF$
  
  Code=Code+"Define.l Event, EventWindow, EventGadget, EventType, EventMenu"+#CRLF$+#CRLF$
  
  ;Fenetre en cours de cration
  Enum=Gadgets(0)\Enum
  X=Str(WindowX(#MainForm))
  Y=Str(WindowY(#MainForm))
  Width=Str(WindowWidth(#MainForm))
  Height=Str(WindowHeight(#MainForm))
  P0=Gadgets(0)\P0
  
  Code=Code+"Procedure Open_"+Mid(Enum,2,Len(Enum)-1)+"()"+#CRLF$
  Code=Code+#TAB$+"If OpenWindow("+Enum+","+X+","+Y+","+Width+","+Height+","+Chr(34)+P0+Chr(34)
  
  ;Existe t'il des options pour la fenetre
  If Gadgets(0)\Options<>""
    Code=Code+","+Gadgets(0)\Options  
  EndIf
      
  ;Fin du codage de la fenetre
  Code=Code+")"+#CRLF$
      
  For i=1 To (CountGadgets)
    If Gadgets(i)\Actif=#True
      IdGadget=Gadgets(i)\IdGadget
      Model=MGadget(Gadgets(i)\IdModel)\Model
      Enum=Gadgets(i)\Enum
      X=Str(GadgetX(IdGadget))
      Y=Str(GadgetY(IdGadget))
      Width=Str(GadgetWidth(IdGadget))
      Height=Str(GadgetHeight(IdGadget))
      P0=Gadgets(i)\P0
    
      ;Partie commune (Enumeration, X, Y, Width, Height, Texte )
      Code=Code+#TAB$+#TAB$+Model+"("+Enum+","+X+","+Y+","+Width+","+Height
      
      ;Il y a t'il un texte ?
      If MGadget(Gadgets(GetGadgetData(IdGadget))\IdModel)\LP0<>""
        Code=Code+","+Chr(34)+P0+Chr(34)
      EndIf
      
      ;S'agit il d'un ListIconGadget
      If Gadgets(i)\IdModel=6
        Code=Code+","+Chr(34)+GetGadgetItemText(Idgadget, -1, 0)+Chr(34)+","+Str(GetGadgetItemAttribute(IdGadget, 0, #PB_ListIcon_ColumnWidth,0 ))
      EndIf
                
      ;Existe t'il des options pour le gadget
      If Gadgets(i)\Options<>""
        Code=Code+","+Gadgets(i)\Options
      EndIf
      
      ;Fin du codage du gadget
      Code=Code+")"+#CRLF$
      
      ;Gadgets Items - Ajouts des colonnes
      If Gadgets(i)\IdModel=6
        For j=1 To Gadgets(i)\ColCount
          Code=Code+#TAB$+#TAB$+"AddGadgetColumn("+Enum+","+Str(j)+", "+Chr(34)+GetGadgetItemText(Idgadget, -1, j)+Chr(34)+","
          Code=Code+Str(GetGadgetItemAttribute(IdGadget, 0, #PB_ListIcon_ColumnWidth,j))+")"+#CRLF$
        Next
      EndIf
      
      ;Existe t'il une aide pour ce gadget
      If Trim(Gadgets(i)\Help)<>""
        Code=Code+#TAB$+#TAB$+"GadgetToolTip("+Enum+","+Chr(34)+Gadgets(i)\Help+Chr(34)+")"+#CRLF$
      EndIf
      
    EndIf
  Next
  
  Code=Code+#TAB$+"EndIf"+#CRLF$
  Code=Code+"EndProcedure"+#CRLF$+#CRLF$
  
  Enum=Gadgets(0)\Enum
  Code=Code+"Open_"+Mid(Enum, 2, Len(Enum)-1)+"()"+#CRLF$+#CRLF$
  
  Code=Code+"Repeat"+#CRLF$
  
  ;Boucle evenementiel
  Code=Code+#TAB$+"Event = WaitWindowEvent()"+#CRLF$
  
  Code=Code+#TAB$+"Select Event"+#CRLF$
  Code=Code+#TAB$+#TAB$+"Case #PB_Event_Menu"+#CRLF$+#CRLF$
  Code=Code+#TAB$+#TAB$+"Case #PB_Event_Gadget"+#CRLF$+#CRLF$
  Code=Code+#TAB$+#TAB$+"Case #PB_Event_CloseWindow"+#CRLF$
  Code=Code+#TAB$+#TAB$+#TAB$+"End"+#CRLF$+#CRLF$
  Code=Code+#TAB$+"EndSelect"+#CRLF$
  
  Code=Code+"ForEver"+#CRLF$
  
  ;Le code est dans le presse papier
  SetClipboardText(Code)
    MessageRequester("Information", "Le code est copi dans le presse-papier")
EndProcedure

;Un gadget est il selectionn
Procedure GetGadgetCheck()
  Protected i.i
  If GadgetDraw=#False
    GadgetCheck=#False   
    For i=1 To CountGadgets      
      If GadgetHoverCheck(X, Y, Gadgets(i)\Idgadget) And Gadgets(i)\Actif=#True
        IdGadget=Gadgets(i)\Idgadget
 
        ;Delta entre la position de la souris et les bords haut/gauche du gadget     
        DeltaX=X-GadgetX(IdGadget)
        DeltaY=Y-GadgetY(Idgadget)
        GadgetCheck=#True
        InspectorUpdate(Idgadget)
      EndIf  
    Next
  EndIf
  ProcedureReturn GadgetCheck
EndProcedure

;Fenetre en cours de cration
Procedure MainFormShow()
  OpenWindow(#MainForm,320,100,500,400,"Nouvelle Fenetre",#PB_Window_SizeGadget | #PB_Window_SystemMenu, WindowID(#InspectorForm))
  CreatePopupMenu(#PopUpMenu)
EndProcedure

;Affichage du menu contextuel (PopUp), Mise  jour du ou des items valide
Procedure MenuPopUpShow()
  ;Mmorisation des coordonnes de la souris avant la creation du gadget 
  X=WindowMouseX(#MainForm)
  Y=WindowMouseY(#Mainform)
  
  ;Un gadget est il survol : Si Oui possibilit de le supprimer
  If GetGadgetCheck()
    DisableMenuItem(#PopUpMenu, #GadgetCopy, #False)
    DisableMenuItem(#PopUpMenu, #GadgetCut, #False)
  Else
    DisableMenuItem(#PopUpMenu, #GadgetCopy, #True)
    DisableMenuItem(#PopUpMenu, #GadgetCut, #True)
  EndIf
  
  ;Un gadget est il copier en mmoire
  If CopyGadget\IdModel<>0
    DisableMenuItem(#PopUpMenu, #GadgetPaste, #False)
  Else
    DisableMenuItem(#PopUpMenu, #GadgetPaste, #True)
  EndIf
     
  ;Affichage du menu contextuel
  DisplayPopupMenu(#PopUpMenu,WindowID(#MainForm)) 
EndProcedure

;Inspecteur de gadget
Procedure InspectorFormShow()
  OpenWindow(#InspectorForm, 100, 100, 200, 400, "Tiny Visual Designer",#PB_Window_SystemMenu)
  ComboBoxGadget(#LGadgets, 10 ,25, 170, 19)
    
  PanelGadget(#Panel, 5, 50, 193, 300)
  
  ;Valeurs standard d'un gadget
  AddGadgetItem (#Panel, -1, "Standard")
  TextGadget(#PB_Any, 5, 10,60,20,"Handle")
  TextGadget(#Idgadget, 80, 10, 100, 20,"")
  TextGadget(#PB_Any, 5, 35, 60, 20, "Enumeration")
  StringGadget(#Enum, 80, 35, 100, 20, "")
  TextGadget(#PB_Any, 5, 60, 60, 20, "Left")
  StringGadget(#Left, 80, 60, 100, 20, "")
  TextGadget(#PB_Any, 5, 85, 60, 20, "Top")
  StringGadget(#Top, 80, 85, 100, 20, "")
  TextGadget(#PB_Any, 5, 110, 60, 20, "Width")
  StringGadget(#Width, 80, 110, 100, 20, "")
  TextGadget(#PB_Any, 5, 135, 60, 20, "Height")
  StringGadget(#Height, 80, 135, 100, 20, "")
  TextGadget(#LP0, 5, 160, 60, 20, "")
  StringGadget(#P0, 80, 160, 100, 20, "")
  
  ;Options
  AddGadgetItem (#Panel, -1, "Options")
  ListIconGadget(#Options,5,5,175,255,"Flags",170, #PB_ListIcon_CheckBoxes)
  
  ;Extras (Aide, Couleurs, etc ....)
  AddGadgetItem (#Panel, -1, "Extra")
  TextGadget(#PB_Any, 5, 10, 80, 20, "Tool Tip")
  StringGadget(#Help, 5, 30, 170, 20, " ")
  
  ;Items (Ajout, Suppression, Mise  jour)
  AddGadgetItem (#Panel, -1, "Items")
  ListIconGadget(#LItems, 5, 10, 175, 150, "Item(s)",98, #PB_ListIcon_FullRowSelect|#PB_ListIcon_AlwaysShowSelection)
  AddGadgetColumn(#LItems, 1, "Longueur", 73)
  StringGadget(#ItemText, 5, 170, 90, 20,"")
  SpinGadget(#ItemWidth, 100, 170, 40, 20,  0, 1000, #PB_Spin_Numeric)
  SetGadgetState(#ItemWidth, 100)
  ButtonGadget(#ItemUpdate, 140, 170, 20, 20,"+")
  ButtonGadget(#ItemDel, 160, 170, 20, 20,"-")
  CloseGadgetList()
  
  TextGadget(#PB_Any, 5, 355, 75, 20, "Anchor Size")
  SpinGadget(#AnchorSize, 80, 350, 30, 20, 5, 20,#PB_Spin_ReadOnly|#PB_Spin_Numeric)
  SetGadgetState (#AnchorSize, AnchorSize)
  
  CreateStatusBar(#SBar, WindowID(#InspectorForm))
  AddStatusBarField(100)
EndProcedure

;Start
Procedure Start()
  ;Affichage de l'inspecteur de gadget
  InspectorFormShow()
  
  ;Affichage de la fenetre en cours de cration
  MainFormShow()
  
  ;Initialisation du model de fenetre
  InitModelWindow()
  
  ;Initialisation des modeles de gadgets 
  InitModelgadget()
  
  ;Initialisation des touches de racourrcis
  InitShortCut(#MainForm)
  InitShortCut(#InspectorForm)
  
  ;Initialisation des points d'ancrage 
  AnchorCreate()
  AnchorHide(#True)
    
  Gadgets(0)\Enum="#"+MWindow(0)\Enum
  Gadgets(0)\P0="New Window"
  Gadgets(0)\IdModel=0
  Gadgets(0)\Actif=#True
  
  AddGadgetItem(#LGadgets, -1, Gadgets(0)\Enum+" ("+MGadget(Gadgets(0)\IdModel)\Model+")")
  SetGadgetState(#LGadgets, CountGadgetItems(#LGadgets)-1)
  SetGadgetItemData(#LGadgets, CountGadgetItems(#LGadgets)-1, 0)
  InspectorUpdate(0)
  InspectorDisable(#False)
EndProcedure

Start()

;-Boucle evenementielle
Repeat 
  Event=WaitWindowEvent() 
  If GetActiveWindow()=#MainForm
  Select EventMouse()
        Case 0
          If RMouseState=1 
            RMouseState=2
          Else
            RMouseState=0
            If GadgetDraw=#True
              InspectorDisable(#False)
              InspectorUpdate(Idgadget)
              GadgetDraw=#False ;Le gadget n'est plus en cours de dplacement
              AnchorActif=#False ;Les point d'ancrages ne sont plus actifs (Mais restent visibles)
            EndIf
          EndIf
               
        Case 1
          RMouseState=0
          ;Quels sont les coordonnes de la souris ?
          X=WindowMouseX(#MainForm)
          Y=WindowMouseY(#Mainform)
          
          ;Un gadget ou un point d'ancrage est il selectionn ?
          If GetAnchorCheck()>0 Or GetGadgetCheck() Or AnchorActif>0
            GadgetDraw=#True ; Le gadget selectionn est susceptible d'etre dplacer            
            GadGetDraw(0, IdGadget)
          EndIf  
          
        Case 2
          RMouseState=0
          
        Case 3
          If RMouseState=0
            RMouseState=1
          EndIf
  EndSelect   
  EndIf
      
  If RMouseState=2
     MenuPopUpShow()
     RMouseState=0
  EndIf    
  
  Select Event
    Case #PB_Event_Menu
      Select EventMenu()
        Case 1 To 10 ;Cration d'un gadget
          GadgetCreate(EventMenu(), #False)
          
        Case #Kbd_MenuPopUp
          MenuPopUpShow()
          
        Case #GadgetCopy ;Copie d'un gadget
          GadgetCopy(IdGadget)
          
        Case #GadgetCut ;Enlever un gadget
          GadgetCopy(IdGadget)
          GadgetCut(Idgadget) 
         
        Case #GadgetPaste ;Inserer un gadget copier   
          GadgetPaste()
          
        Case #CodeCreate ;Gnration du code
          CodeCreate()
          
        Default ;Resize gadget avec les touches du clavier
          GadgetDraw(EventMenu(), IdGadget)
          
      EndSelect
                  
    Case  #PB_Event_Gadget
      If IsWindow(#MainForm) ;La fenetre en cours de cration doit etre prsente
        If EventWindow()=#InspectorForm ; Les vnements viennent bien de l'inspecteur de gadget
          ;-Gadgets : Inspecteur        
          Select EventGadget()  
            Case #LGadgets
              GadgetSelect()
                    
            Case #Enum
              GadgetUpdateEnum(IdGadget)

            Case #P0
              GadgetUpdatePX(Idgadget)
             
            Case #Left, #Top, #Width, #Height
              GadgetResize(IdGadget)
                     
            Case #Options ;Ajoute une option  un gadget ou  la fenetre
              GadgetAddOption(IdGadget)
          
            Case #LItems ; ListIconGadget()
              SetGadgetText(#ItemText, GetGadgetItemText(#Litems, GetGadgetState(#LItems), 0))
              SetGadgetText(#ItemWidth, GetGadgetItemText(#Litems, GetGadgetState(#LItems), 1))
              SetGadgetData(#ItemUpdate, 1) ; On indique qu'il s'agit d'une eventuelle modification
                 
            Case #ItemUpdate ;Ajoute ou modifie un lment  un gadget (Colonne, Onglet, ...)
              GadgetUpdateElement(Idgadget)     
              
            Case #ItemText
              If Trim(GetGadgetText(#ItemText))=""
                DisableGadget(#ItemUpdate, #True)
                DisableGadget(#ItemDel, #True)
              Else
                DisableGadget(#ItemUpdate, #False)
                DisableGadget(#ItemDel, #False)                
              EndIf
          
            Case #ItemDel ;Suppression d'un lment (Colonne, Onglet, ...)
              GadgetDelElement(Idgadget)
          
            Case #Help ;Associe un texte flottant au gadget spcifi (GadgetToolTip)
              GadgetSetHelp(Idgadget)
      
            Case #AnchorSize ;Modification de la taille des points d'ancrages
             AnchorResize()
          
         EndSelect  
       EndIf  
     EndIf
    
    Case #PB_Event_MoveWindow; #PB_Event_SizeWindow
      If GetGadgetState(#LGadgets)=0
        SetGadgetText(#Left, Str(WindowX(#Mainform)))
        SetGadgetText(#Top, Str(WindowY(#Mainform)))
        SetGadgetText(#Width, Str(WindowWidth(#Mainform)))
        SetGadgetText(#Height, Str(WindowHeight(#Mainform)))
      EndIf
            
    Case #PB_Event_CloseWindow ;-Fermeture d'une fenetre      
        End
  EndSelect
ForEver

;-Data Section : Modeles gadget (10 Actuellement dans la liste)
;Structure de la ligne pour chaque modele de gadget
;Modele de gadget, Largeur par defaut, hauteur par defaut, Texte ou rien (si pas de texte), Prefixe Enumeration, #PB_Any (Oui/Non, Colonne (Oui/Non), Help (Oui/Non), Flags
DataSection
  ModelWindow:
  Data.s "OpenWindow","500","400","Text","Window_0","#PB_Window_SystemMenu,#PB_Window_MinimizeGadget,#PB_Window_MaximizeGadget,#PB_Window_SizeGadget,#PB_Window_Invisible,#PB_Window_TitleBar,#PB_Window_BorderLess,#PB_Window_Tool,#PB_Window_ScreenCentered,#PB_Window_WindowCentered,#PB_Window_Maximize,#PB_Window_Minimize,#PB_Window_NoGadgets"
  
  ModelGadgets: 
  Data.s "ButtonGadget","80","20","Text","Button_","0","0","1","#PB_Button_Right,#PB_Button_Left,#PB_Button_Default,#PB_Button_MultiLine,#PB_Button_Toggle"
  Data.s "CheckBoxGadget","80","20","Text","CheckBox_","0","0","1","#PB_CheckBox_Right,#PB_CheckBox_Center,#PB_CheckBox_ThreeState"
  Data.s "ComboBoxGadget","100","20","","Combo_","0","0","1","#PB_ComboBox_Editable,#PB_ComboBox_LowerCase,#PB_ComboBox_UpperCase,#PB_ComboBox_Image"
  Data.s "EditorGadget","150","200","","Editor_","0","0","1","#PB_Editor_ReadOnly"
  Data.s "Frame3DGadget","180","150","Texte","Frame_","1","0","1","#PB_Frame3D_Single,#PB_Frame3D_Double,#PB_Frame3D_Flat"
  Data.s "ListIconGadget","180","180","","ListIcon_","0","1","1","#PB_ListIcon_CheckBoxes,#PB_ListIcon_MultiSelect,#PB_ListIcon_GridLines,#PB_ListIcon_FullRowSelect,#PB_ListIcon_HeaderDragDrop,#PB_ListIcon_AlwaysShowSelection"
  Data.s "ListViewGadget","150","150","","ListView_","0","0","1","#PB_ListView_Multiselect,#PB_ListView_ClickSelect"
  Data.s "OptionGadget","80","20","Texte","Option_","0","0","1",""
  Data.s "StringGadget","80","20","Text","String_","0","0","1","#PB_String_Password,#PB_String_ReadOnly,#PB_String_Numeric,#PB_String_LowerCase,#PB_String_UpperCase,#PB_String_BorderLess"
  Data.s "TextGadget","80","20","Text","Text_","1","0","0","#PB_Text_Center,#PB_Text_Right,#PB_Text_Border"
EndDataSection
; IDE Options = PureBasic 4.51 (Windows - x86)
; CursorPosition = 1152
; FirstLine = 1130
; Folding = ------------------
; Markers = 768
; EnableXP
; UseIcon = logo.ico
; Executable = ..\..\..\Desktop\TVD.exe
; Compiler = PureBasic 4.51 (Windows - x86)