﻿;/////////////////////////////////////////////////////////////////////////////////
;An OOP class for implementing a menu color picker.

;By Stephen Rodriguez.
;February 2009.

;Header file.
;/////////////////////////////////////////////////////////////////////////////////


;/////////////////////////////////////////////////////////////////////////////////
;-Class interfaces.

  ;The following interface contains the base class methods.
    Interface MenuColorPickerObject
      Destroy()
      AddColors()                               ;Can only be used once and NOT in a submenu.
                                                ;Returns 0 if an error.
      DisplayColorPicker.q(hWnd, x=-1, y=-1)
                                                ;Returns -1 if the menu was cancelled or the selected color.
                                                ;If one of the other menu items was selected then the menuitemID will be placed in the upper 32-bits and the lower 32-bits will be zero.
      SetDefaultColor(color)                    ;Only used if the 'More colors...' option is selected.
                                                ;Note that this color is not automatically set between invokes of DisplayColorPicker().
      SetUserCallback.i(address)                ;Set address = 0 to remove existing callback. 
                                                ;Returns the old callback address.
    EndInterface
;/////////////////////////////////////////////////////////////////////////////////


; IDE Options = PureBasic 4.30 (Windows - x86)
; CursorPosition = 24
; Folding = -