; PB 4.30 03 mai 2009 - Comtois
;English rules : http://www.morpionsolitaire.com/English/Rules.htm
;J'ai repris le code source ici : http://www.dlegland.fr/games/morsol/morsol.html


XIncludeFile "main.pbi"
XIncludeFile "jeu.pbi"

Procedure Min(a, b)
  If a < b
    ProcedureReturn a
  Else
    ProcedureReturn b
  EndIf    
EndProcedure

Procedure Max(a, b)
  If a > b
    ProcedureReturn a
  Else
    ProcedureReturn b
  EndIf    
EndProcedure

Procedure initJeu(*This.s_Jeu)
	Define i, x0, y0, x, y

  ;Init les checkBox  	
  *This\voirCoups 	= #False
  *This\voirNumeros = #False
  *This\RondCroix   = #False
  SetGadgetState(#viewPlaysCheckbox  , *This\voirCoups)
  SetGadgetState(#voirNumerosCheckbox, *This\voirNumeros)
	SetGadgetState(#optionCheckbox     , *This\RondCroix)
	
  ;Init les listes chaines	
	ClearList(lignes())
	ClearList(croixJouees())
	ClearList(lignesAnnulees())
	ClearList(croixAnnulees())
		
	;Efface le tableau de jeu
	For y = 0 To #YMAX - 1
		For x = 0 To #XMAX - 1
			croix(y, x) = #False
		Next x
	Next y		
	
	;Init pour l'animation de la slection
	*This\anime = 2
	*This\pas   = 1
	*This\temps = ElapsedMilliseconds()
	
	;Trace une croix grecque
	x0 = #MARGE
	y0 = #MARGE
	For i=0 To 3
		croix(y0  ,x0+3+i) = #True
		croix(y0+3,x0+i  ) = #True
		croix(y0+3,x0+6+i) = #True
		croix(y0+6,x0+i  ) = #True
		croix(y0+6,x0+6+i) = #True
		croix(y0+9,x0+3+i) = #True
		
		croix(y0+3+i,x0  ) = #True
		croix(y0+i  ,x0+3) = #True
		croix(y0+6+i,x0+3) = #True
		croix(y0+i  ,x0+6) = #True
		croix(y0+6+i,x0+6) = #True
		croix(y0+3+i,x0+9) = #True		
	Next i	
	
	;Init la slection
  *This\x0=-1
  *This\y0=-1
  *This\xs=-1
  *This\ys=-1

EndProcedure
	
Procedure annuleDernierCoup(*This.s_Jeu)
	Define point.point

	If ListSize(croixJouees()) = 0 : ProcedureReturn : EndIf
	
	;Rcupre la dernire croix joue
	LastElement(croixJouees())
	point\x = croixJouees()\x
	point\y = croixJouees()\y
	;Supprime cette croix dans le tableau de jeu
	croix(point\y, point\x) = #False
	;Supprime cette croix dans la liste 
	DeleteElement(croixJouees())
	;Et on ajoute cette croix dans la liste des croix annules
	AddElement(croixAnnulees())
	croixAnnulees()\x = point\x
	croixAnnulees()\y = point\y
  
  ;Rcupre la dernire ligne forme par la croix supprime prcdemment 
  LastElement(lignes())
  ;Et on ajoute cette ligne dans la liste des lignes annules
  AddElement(lignesAnnulees())
  lignesAnnulees()\x1 = lignes()\x1
  lignesAnnulees()\y1 = lignes()\y1
  lignesAnnulees()\x2 = lignes()\x2
  lignesAnnulees()\y2 = lignes()\y2
  ;Supprime cette ligne
  DeleteElement(lignes())
EndProcedure
	
Procedure rejoueDernierCoup(*This.s_Jeu)
  Define point.POINT
  
	If ListSize(croixAnnulees()) = 0 : ProcedureReturn : EndIf
  ;Rcupre la dernire ligne annule
  LastElement(lignesAnnulees())
  ;Et on ajoute cette ligne dans la liste des lignes joues
  AddElement(lignes())
  lignes()\x1 = lignesAnnulees()\x1
  lignes()\y1 = lignesAnnulees()\y1
  lignes()\x2 = lignesAnnulees()\x2
  lignes()\y2 = lignesAnnulees()\y2
  ;Supprime la dernire ligne annule
  DeleteElement(lignesAnnulees())

  ;Rcupre la dernire croix annule
  LastElement(croixAnnulees())
	point\x = croixAnnulees()\x
	point\y = croixAnnulees()\y
	;Et on ajoute cette croix dans le tableau de jeu
	croix(point\y, point\x) = #True
	;Supprime la croix annule
	DeleteElement(croixAnnulees())
	;Et on ajoute cette croix dans la liste des croix annules
	AddElement(croixJouees())
	croixJouees()\x = point\x
	croixJouees()\y = point\y
EndProcedure

;Dessine le jeu
Procedure paint(*This.s_Jeu)
  Define x, y
  
  If StartDrawing(ScreenOutput())

   
	  dessineLignes()
 	  dessineCroix(*This)
 	
  	If *This\voirNumeros
  	  dessineNumeros()
  	EndIf
 	  
 	  ;Pour l'animation de la slection
    If ElapsedMilliseconds() - *This\temps > 1200
      *This\temps = ElapsedMilliseconds()
    EndIf
    
    *This\anime + *This\pas
    If *This\anime > 10 Or *This\anime < 3
      *This\pas = -*This\pas
    EndIf
      
  	; dessine le coup courant
  	DrawingMode(#PB_2DDrawing_Outlined)
  	
  	If *This\x0<>-1
  	  Circle(*This\x0 * #TAILLE + #CENTRE, *This\y0  *#TAILLE + #CENTRE, *This\anime, #Red)
  	EndIf
  	
  	If *This\xs<>-1
  	  LineXY(*This\x0 * #TAILLE + #CENTRE, *This\y0 * #TAILLE + #CENTRE, *This\xs, *This\ys, #Blue)
  	  Circle(*This\xs, *This\ys, *This\anime, #Red)
  	EndIf  			

  	If *This\voirCoups
  	  dessineCoupsPossibles(*This)
  	EndIf
  	 
	  StopDrawing()
  
  EndIf

  ;Pour vrifier la position dans le jeu et l'affiche dans le titre de la fentre
	x = WindowMouseX(0) / #TAILLE
	y = WindowMouseY(0) / #TAILLE  
  SetWindowTitle(0, "Morpion solitaire V1.0 (" + Str(x) + " / " + Str(y) + ")")  
EndProcedure

Procedure dessineLignes()
	DrawingMode(#PB_2DDrawing_Outlined)
	ForEach lignes()
		LineXY(lignes()\x1 * #TAILLE + #CENTRE, lignes()\y1 * #TAILLE + #CENTRE, lignes()\x2 * #TAILLE + #CENTRE, lignes()\y2 * #TAILLE + #CENTRE, #Blue)
	Next	
EndProcedure

Procedure litScore()
  ProcedureReturn ListSize(lignes())
EndProcedure

Procedure voirCoups(*This.s_Jeu, b)
  *This\voirCoups = b
EndProcedure
	
Procedure voirNumeros(*This.s_jeu , b)
  *This\voirNumeros = b
EndProcedure

Procedure RondCroix(*This.s_jeu , b)
  *This\RondCroix = b
EndProcedure

Procedure dessineCroix(*This.s_Jeu)
  Define x, y, t = 5
	DrawingMode(#PB_2DDrawing_Outlined)
	For y = 0 To #YMAX - 1
		For x = 0 To #XMAX - 1
			Circle(x * #TAILLE + #CENTRE, y * #TAILLE + #CENTRE, 2, $EEEEEE)	
			If croix(y, x) 
				If *This\RondCroix
					Line(x * #TAILLE + #CENTRE, y * #TAILLE + #CENTRE,  t, t, #Black)
					Line(x * #TAILLE + #CENTRE, y * #TAILLE + #CENTRE, -t,-t, #Black)
					Line(x * #TAILLE + #CENTRE, y * #TAILLE + #CENTRE,  t,-t, #Black)
					Line(x * #TAILLE + #CENTRE, y * #TAILLE + #CENTRE, -t, t, #Black)					
				Else
				  Circle(x * #TAILLE + #CENTRE, y * #TAILLE + #CENTRE, 4, #Black)
				EndIf
			EndIf	
		Next x
	Next y		
EndProcedure

Procedure dessineNumeros()
	Define x, y, i = 1
	DrawingFont(FontID(0))
	DrawingMode(#PB_2DDrawing_Transparent)

	ForEach croixJouees()
		x = croixJouees()\x * #TAILLE + #CENTRE + 6
		y = croixJouees()\y * #TAILLE + #CENTRE - 12
		DrawText( x, y, Str(i), #Red)
		i + 1
  Next 

EndProcedure

Procedure dessineCoupsPossibles(*This.s_Jeu)
	Define i, x, y, pos
	Define x0, y0, lig, p
	Define t1, t2, t3, t4, t5
	Define dx, dy			; valent 0, -1, ou +1.
	Define lineState = 0
	
	; tableau d'etat, valeur de 0 a 15
	Dim state(#YMAX, #XMAX)
			
	;initialise le tableau des etats
	For y = 0 To #YMAX - 1
		For x = 0 To #XMAX - 1
			state(y, x) = 0
		Next x
	Next y		

	; Pour une direction donnee (horiz, vert, diag mont, diag desc),
	; il y a 5 configurations possibles pour lesquelles on peut ajouter une croix :
	; . . O X X X X . .
	; . . X O X X X . .
	; . . X X O X X . .
	; . . X X X O X . .
	; . . X X X X O . .

	; affecte des valeurs positives quand une ligne passe dans une Case.
	ForEach lignes()
		dx = (lignes()\x2 - lignes()\x1) / 4
		dy = (lignes()\y2 - lignes()\y1) / 4

		lineState = 0
		If dx =   0 : lineState 	= #VERT  : EndIf 
		If dy =   0 : lineState 	= #HORIZ : EndIf 
		If dx =  dy : lineState 	= #DIAG1 : EndIf 
		If dx = -dy : lineState	  = #DIAG2 : EndIf 

		For i = 0 To 3
			x = lignes()\x1 + i * dx + Min(0, dx)
			y = lignes()\y1 + i * dy + Min(0, dy)
			state(y, x) = state(y, x) | lineState
		Next i
	Next
	
	; le voisinage d'un point : 4 croix dans chaque sens, plus la croix.
	Dim voisin(9) 
	; le voisinage des lignes : 4 psb dans chaque direction
	Dim ligneVide(8)
	

	; direction 1 : horizontale
	For y = 0 To #YMAX - 1

		; initialise le tableau des voisins avec le voisinage du Point (y, x-1).
		For pos = 0 To 4
			voisin(pos) = #False
			ligneVide(pos) = #True
		Next pos
		
		For pos = 5 To 8 : voisin(pos) = croix(y,pos-4) : Next pos
		For pos = 5 To 7 
		  If (state(y,pos - 4) & #HORIZ) = 0
		    ligneVide(pos) = #True
		  Else
		    ligneVide(pos) = #False
		  EndIf
		Next pos
		
		For x = 0 To #XMAX - 1
			
			;decale le tableau de voisinage
			For pos = 0 To 7 : voisin(pos)    = voisin(pos + 1)    : Next pos
			For pos = 0 To 6 : ligneVide(pos) = ligneVide(pos + 1) : Next pos
			
			;determine le voisinage du Point (y,x+4)
			If x < (#XMAX - 4)
				voisin(8) = croix(y, x + 4)
				If (state(y, x + 3) & #HORIZ) = 0
				  ligneVide(7) = #True
				Else
				  ligneVide(7) = #False
				EndIf
				
			Else 
				voisin(8) = #False
				ligneVide(7) = #True
			EndIf
			
			; pas la peine de tester si il y a deja une croix.
			If croix(y, x) : Continue : EndIf
			t1 = voisin(0) And voisin(1) And voisin(2) And voisin(3) And ligneVide(0) And ligneVide(1) And ligneVide(2)
			t2 = voisin(1) And voisin(2) And voisin(3) And voisin(5) And ligneVide(1) And ligneVide(2)
			t3 = voisin(2) And voisin(3) And voisin(5) And voisin(6) And ligneVide(2) And ligneVide(5)
			t4 = voisin(3) And voisin(5) And voisin(6) And voisin(7) And ligneVide(5) And ligneVide(6)
			t5 = voisin(5) And voisin(6) And voisin(7) And voisin(8) And ligneVide(5) And ligneVide(6) And ligneVide(7)
			If  t1 Or	t2  Or	t3 Or	t4 Or	t5 
					Circle(x * #TAILLE + #CENTRE, y * #TAILLE + #CENTRE, 4, #Green)
			EndIf		
		Next x
	Next y
	

	; direction 3 : verticale
	For x = 0 To #XMAX - 1
		; initialise le tableau des voisins avec le voisinage du Point (y, x-1).
		For pos = 0 To 4
			voisin(pos) = #False
			ligneVide(pos) = #True
		Next pos

		For pos = 5 To 8 : voisin(pos) = croix(pos - 4, x) : Next pos
		For pos = 5 To 7
		  If (state(pos - 4, x) & #VERT) = 0
		  ligneVide(pos) = #True
		  Else
		  ligneVide(pos) = #False
		  EndIf
		Next pos  
		For y = 0 To #YMAX - 1
			;// decale le tableau de voisinage
			For pos = 0 To 7   : voisin(pos)    = voisin(pos + 1)    : Next pos
				For pos = 0 To 6 : ligneVide(pos) = ligneVide(pos + 1) : Next pos
			
			; determine le voisinage du Point (y,x+4)
			If y < (#YMAX - 4)
				voisin(8) = croix(y + 4, x)
				If (state(y + 3, x) & #VERT) = 0
				  ligneVide(7) = #True
				Else
				  ligneVide(7) = #False
				EndIf					
			Else 
				voisin(8) = #False
				ligneVide(7) = #True
			EndIf

			; pas la peine de tester si il y a deja une croix.
			If croix(y,x) : Continue : EndIf
			t1 = voisin(0) And voisin(1) And voisin(2) And voisin(3) And ligneVide(0) And ligneVide(1) And ligneVide(2)
			t2 = voisin(1) And voisin(2) And voisin(3) And voisin(5) And ligneVide(1) And ligneVide(2)
			t3 = voisin(2) And voisin(3) And voisin(5) And voisin(6) And ligneVide(2) And ligneVide(5)
			t4 = voisin(3) And voisin(5) And voisin(6) And voisin(7) And ligneVide(5) And ligneVide(6)
			t5 = voisin(5) And voisin(6) And voisin(7) And voisin(8) And ligneVide(5) And ligneVide(6) And ligneVide(7) 
			If t1 Or t2 Or	t3  Or	t4  Or	t5
					Circle(x * #TAILLE + #CENTRE, y * #TAILLE + #CENTRE, 4, #Green)
		  EndIf
		Next y
	Next x
  
	; de bas-gauche vers haut-droite (diag2)
	For lig = 4 To #XMAX + #YMAX - 4 - 1

		x0 = Max(0, lig - #YMAX + 1)
		y0 = Min(lig, #YMAX - 1)

		; initialise le tableau des voisins avec le voisinage du Point (y, x-1).
		For pos = 0 To 4
			voisin(pos) = #False
			ligneVide(pos) = #True
		Next pos

		For pos = 5 To 8 : voisin(pos) = croix(y0 - pos + 5, x0 + pos - 5) : Next pos
		For pos  =5 To 7 
		  If (state(y0 - pos + 5, x0 + pos - 5) & #DIAG2) = 0
		    ligneVide(pos) = #True
		  Else
		    ligneVide(pos) = #False
		  EndIf
    Next pos
				
		For  p = 0 To Min(lig, #XMAX + #YMAX - 2 - lig)
			x = x0 + p
			y = y0 - p
		    
			; decale le tableau de voisinage
			For pos = 0 To 7 : voisin(pos)    = voisin(pos + 1)    : Next pos
			For pos = 0 To 6 : ligneVide(pos) = ligneVide(pos + 1) : Next pos
			
			; determine le voisinage du Point (y,x+4)
			If y > 5 And x < #XMAX - 4
				voisin(8) = croix(y - 4, x + 4)
			  If (state(y - 4, x + 3) & #DIAG2) = 0
			    ligneVide(7) = #True
			  Else
			    ligneVide(7) = #False
			  EndIf					
			Else
				voisin(8) = #False
				ligneVide(7) = #True
			EndIf
				
			; pas la peine de tester si il y a deja une croix.
			If croix(y, x) :  Continue : EndIf
			
			t1 = voisin(0) And voisin(1) And voisin(2) And voisin(3) And ligneVide(0) And ligneVide(1) And ligneVide(2)
			t2 = voisin(1) And voisin(2) And voisin(3) And voisin(5) And ligneVide(1) And ligneVide(2)
			t3 = voisin(2) And voisin(3) And voisin(5) And voisin(6) And ligneVide(2) And ligneVide(5)
			t4 = voisin(3) And voisin(5) And voisin(6) And voisin(7) And ligneVide(5) And ligneVide(6)
			t5 = voisin(5) And voisin(6) And voisin(7) And voisin(8) And ligneVide(5) And ligneVide(6) And ligneVide(7) 
			If t1 Or	t2  Or	t3  Or	t4  Or	t5 
					Circle(x * #TAILLE + #CENTRE, y * #TAILLE + #CENTRE, 4, #Green)
			EndIf		
		Next p
	Next lig


	; de haut-gauche vers bas-droite (diag1)
	For lig = 4 To #XMAX + #YMAX - 4 - 1

		x0 = Max(0, #XMAX - lig - 1)
		y0 = Max(0, lig - #YMAX + 1)

		; initialise le tableau des voisins avec le voisinage du Point (y, x-1).
		For pos = 0 To 4
			voisin(pos) = #False
			ligneVide(pos) = #True
		Next pos
		For pos = 5 To 8 : voisin(pos) = croix(y0 + pos - 5, x0 + pos - 5) : Next pos
		For pos = 5 To 7  
		  If (state(y0 + pos - 5, x0 + pos - 5) & #DIAG1) = 0
		    ligneVide(pos) = #True
		  Else
		    ligneVide(pos) = #False
		  EndIf					
    Next pos
			
		For p = 0 To Min(lig, #XMAX + #YMAX - 2 - lig)
			x = x0 + p
			y = y0 + p
		    
			; decale le tableau de voisinage
			For pos = 0 To 7 : voisin(pos)    = voisin(pos + 1)    : Next pos
			For pos = 0 To 6 : ligneVide(pos) = ligneVide(pos + 1) : Next pos
			
			; determine le voisinage du Point (y,x+4)
			If y < (#YMAX - 4) And x < (#XMAX - 4)
				voisin(8) = croix(y + 4, x + 4)
			  If (state(y + 3, x + 3) & #DIAG1) = 0
			    ligneVide(7) = #True
			  Else
			    ligneVide(7) = #False
			  EndIf	

			Else 
				voisin(8) = #False
				ligneVide(7) = #True
			EndIf
				
			; pas la peine de tester si il y a deja une croix.
			If croix(y, x) : Continue : EndIf
			
			t1 = voisin(0) And voisin(1) And voisin(2) And voisin(3) And ligneVide(0) And ligneVide(1) And ligneVide(2)
			t2 = voisin(1) And voisin(2) And voisin(3) And voisin(5) And ligneVide(1) And ligneVide(2) 
			t3 = voisin(2) And voisin(3) And voisin(5) And voisin(6) And ligneVide(2) And ligneVide(5)
			t4 = voisin(3) And voisin(5) And voisin(6) And voisin(7) And ligneVide(5) And ligneVide(6)
			t5 = voisin(5) And voisin(6) And voisin(7) And voisin(8) And ligneVide(5) And ligneVide(6) And ligneVide(7) 
			If t1 Or t2 Or	t3 Or	t4 Or	t5
					Circle(x * #TAILLE + #CENTRE, y * #TAILLE + #CENTRE, 4, #Green)
		  EndIf
		Next p
	Next lig
EndProcedure
	
	
;- ***** gestion souris
	
Procedure mousePressed(*This.s_Jeu)
	*This\x0 = WindowMouseX(0) / #TAILLE
	*This\y0 = WindowMouseY(0) / #TAILLE
	*This\xs = -1
	*This\ys = -1
EndProcedure
	
Procedure mouseReleased(*This.s_Jeu)
	Define i, x, y
	Define dx, dy
	Define nbTrous
	Define xt, yt, xl, yl

	x = WindowMouseX(0) / #TAILLE
	y = WindowMouseY(0) / #TAILLE

	*This\xs = -1 
	*This\ys = -1
	
	dx = x - *This\x0
	dy = y - *This\y0
	
	If (dx = 0 And Abs(dy) = 4) Or (Abs(dx) = 4 And dy = 0) Or	 (Abs(dx) = 4 And Abs(dy) = 4)

		;on met dx et dy  1 ou -1 selon le sens
		If Abs(dx)>0 :  dx / Abs(dx) : EndIf
		If Abs(dy)>0 :  dy / Abs(dy) : EndIf
		
		nbTrous = 0
		xt = 0
		yt = 0
		
		xl = *This\x0
		yl = *This\y0
		
		For  i = 0 To 4
			If croix(yl, xl) = #False
				nbTrous + 1
				; garde les coordonnees du trou
				xt = xl
				yt = yl
			EndIf
			xl + dx
			yl + dy
		Next i
		

		If nbTrous = 1
			Define dx2, dy2
			Define ok = #True
			
			; verifie qu'il n'y a pas de ligne qui contienne deux croix de la nouvelle ligne
			ForEach lignes()
				dx2 = lignes()\x2 - lignes()\x1
				dy2 = lignes()\y2 - lignes()\y1
				
				; evacue les cas ou les deux lignes ne sont pas du meme type
				If dx  = 0 And dx2 <> 0 : Continue : EndIf
				If dy  = 0 And dy2 <> 0 : Continue : EndIf 
				If dx <> 0 And dx2  = 0 : Continue : EndIf
			  If dy <> 0 And dy2  = 0 : Continue : EndIf 
				
				; compare deux lignes verticales
				If dx = 0 And dx2 = 0
					If x <> lignes()\x1 : Continue : EndIf
					If Abs(Min(*This\y0, y) - Min(lignes()\y1, lignes()\y2)) < 4
						ok = #False
						Break
					EndIf
					Continue
				EndIf
				; compare deux lignes horizontales
				If dy = 0 And dy2 = 0
					If y <> lignes()\y1 : Continue : EndIf
					If Abs(Min(*This\x0, x) - Min(lignes()\x1, lignes()\x2)) < 4
						ok = #False
						Break;
					EndIf
					Continue;
				EndIf

				
				; compare lignes diagonales
				dx2 / Abs(dx2)
				dy2 / Abs(dy2)
				
				; lignes dans des directions perpendiculaires
				If dx2 <> dx And dy2 =  dy : Continue : EndIf
				If dx2  = dx And dy2 <> dy : Continue : EndIf
				
				; lignes paralleles mais pas sur la meme droite
				If (x * dy / dx - y) <> (lignes()\x1 * dy2 / dx2 - lignes()\y1)
					Continue;
				EndIf

				If Abs(Min(x, *This\x0) - Min(lignes()\x1, lignes()\x2)) < 4
					ok = #False
					Break
				EndIf
			Next 
			
			If ok
				; ajoute une croix et la ligne correspondante
				croix(yt, xt) = #True
				AddElement(croixJouees())
				croixJouees()\x = xt
				croixJouees()\y = yt
				AddElement(lignes())
				lignes()\x1 = *This\x0
				lignes()\y1 = *This\y0
				lignes()\x2 = x
				lignes()\y2 = y		
				ClearList(lignesAnnulees())
				ClearList(croixAnnulees())
				SetGadgetText(#StringScore, Str(litScore()))
			EndIf
		EndIf			
	EndIf
	*This\x0 = -1
	*This\y0 = -1			
EndProcedure

Procedure mouseDragged(*This.s_Jeu)
	*This\xs = WindowMouseX(0)
	*This\ys = WindowMouseY(0)
EndProcedure
	
;- Gestion fichiers

Procedure sauveJeu(*This.s_Jeu)
  Define FichierParDefaut$, Filtre$, Fichier$
  Define Filtre
  
  FichierParDefaut$ = GetCurrentDirectory() ; Rpertoire et fichier par dfaut qui seront affichs
  ;  Avec la chane suivante nous allons dfinir les filtres ("|" comme sparateur) pour l'affichage de fichier :
  ;  1er  : "Texte (*.txt)" comme nom, ".txt" et ".bat" comme extension autorise
  ;  2me : "Tous les fichiers (*.*)" comme nom, "*.*" comme extension autorise, valide pour tous les fichiers
  Filtre$ = "Jeu (*.hde)|*.hde;|Tous les fichiers (*.*)|*.*"
  Filtre = 0    ; utiliser  par dfaut le premier des trois filtres possibles
  Fichier$ = SaveFileRequester("Choisissez un fichier  sauvegarder", FichierParDefaut$, Filtre$, Filtre)
  
  If Fichier$
    
    If GetExtensionPart(fichier$)<>"hde"
      Fichier$ + ".hde"
    EndIf
    If CreateFile(0, fichier$) 
      WriteData(0, *This, SizeOf(s_Jeu))
      WriteData(0, croix(), SizeOf(Integer) * (#YMAX + 1) * (#XMAX + 1))
      WriteInteger(0, ListSize(croixJouees()))
      ForEach croixJouees()
        WriteInteger(0, croixJouees()\x)
        WriteInteger(0, croixJouees()\y)
      Next   
      WriteInteger(0, ListSize(croixAnnulees()))
      ForEach croixAnnulees()
        WriteInteger(0, croixAnnulees()\x)
        WriteInteger(0, croixAnnulees()\y)
      Next 
      WriteInteger(0, ListSize(lignes()))
      ForEach lignes()
        WriteInteger(0, lignes()\x1)
        WriteInteger(0, lignes()\y1)
        WriteInteger(0, lignes()\x2)
        WriteInteger(0, lignes()\y2)
      Next   
      WriteInteger(0, ListSize(lignesAnnulees()))
      ForEach lignesAnnulees()
        WriteInteger(0, lignesAnnulees()\x1)
        WriteInteger(0, lignesAnnulees()\y1)
        WriteInteger(0, lignesAnnulees()\x2)
        WriteInteger(0, lignesAnnulees()\y2)
      Next 
      CloseFile(0)
      ProcedureReturn #True 
    EndIf 
  EndIf
  MessageRequester("Erreur", "la sauvegarde n'a pas pu s'effectuer", #PB_MessageRequester_Ok)
  ProcedureReturn #False
EndProcedure

Procedure chargeJeu(*This.s_Jeu)
  Define FichierParDefaut$, Filtre$, Fichier$
  Define i, Filtre, SizeLignes, SizeCroix 
  
  FichierParDefaut$ = GetCurrentDirectory() ; Rpertoire et fichier par dfaut qui seront affichs
  ;  Avec la chane suivante nous allons dfinir les filtres ("|" comme sparateur) pour l'affichage de fichier :
  ;  1er  : "Texte (*.txt)" comme nom, ".txt" et ".bat" comme extension autorise
  ;  2me : "Tous les fichiers (*.*)" comme nom, "*.*" comme extension autorise, valide pour tous les fichiers
  Filtre$ = "Jeu (*.hde)|*.hde;|Tous les fichiers (*.*)|*.*"
  Filtre = 0    ; utiliser  par dfaut le premier des trois filtres possibles
  Fichier$ = OpenFileRequester("Choisissez un fichier  sauvegarder", FichierParDefaut$, Filtre$, Filtre)
  
  If Fichier$

    If ReadFile(0, fichier$) 
      initJeu(*This)
      ReadData(0, *This, SizeOf(s_Jeu))
      ReadData(0, croix(), SizeOf(Integer) * (#YMAX + 1) * (#XMAX + 1))
      SizeCroix = ReadInteger(0)
      For i = 1 To SizeCroix
        AddElement(croixJouees())
        croixJouees()\x = ReadInteger(0)
        croixJouees()\y = ReadInteger(0)
      Next   
      SizeCroix = ReadInteger(0)
      For i = 1 To SizeCroix
        AddElement(croixAnnulees())
        croixAnnulees()\x = ReadInteger(0)
        croixAnnulees()\y = ReadInteger(0)
      Next
      SizeLignes = ReadInteger(0)
      For i = 1 To Sizelignes
        AddElement(lignes())
        lignes()\x1 = ReadInteger(0)
        lignes()\y1 = ReadInteger(0)
        lignes()\x2 = ReadInteger(0)
        lignes()\y2 = ReadInteger(0)
      Next   
      SizeLignes = ReadInteger(0)
      For i = 1 To Sizelignes
        AddElement(lignesAnnulees())
        lignesAnnulees()\x1 = ReadInteger(0)
        lignesAnnulees()\y1 = ReadInteger(0)
        lignesAnnulees()\x2 = ReadInteger(0)
        lignesAnnulees()\y2 = ReadInteger(0)
      Next 
      CloseFile(0)
      SetGadgetState(#viewPlaysCheckbox  ,  *This\voirCoups)
      SetGadgetState(#voirNumerosCheckbox,  *This\voirNumeros)
	    SetGadgetState(#optionCheckbox     ,  *This\RondCroix)
      SetGadgetText(#StringScore         , Str(litScore()))
      ProcedureReturn #True 
    EndIf 
  EndIf
  MessageRequester("Erreur", "le chargement n'a pas pu s'effectuer", #PB_MessageRequester_Ok)
  ProcedureReturn #False
EndProcedure

; IDE Options = PureBasic 4.30 (Windows - x86)
; CursorPosition = 4
; Folding = ----
; EnableXP