; PB 4.30 03 mai 2009 - Comtois
;English rules : http://www.morpionsolitaire.com/English/Rules.htm
;J'ai repris le code source ici : http://www.dlegland.fr/games/morsol/morsol.html

;Nouveau = New
;Annuler = Undo
;Rejouer = Redo
;Sauver  = Save
;Charger = Load 
 
EnableExplicit

XIncludeFile "Main.pbi"
XIncludeFile "jeu.pb"

init()
main()

End

Procedure main()

  Define MouseDown, event, done = 0
  Define *Jeu.s_Jeu
  
  *Jeu = AllocateMemory(SizeOf(s_Jeu))
  If *Jeu = 0
    MessageRequester("Erreur", "Pas assez de mmoire", #PB_MessageRequester_Ok)
    End
  EndIf   

  Initjeu(*Jeu)
  
  ;Boucle generale
  While done=0

    ;Traiter les vnements
    
    Repeat
      
      Event = WindowEvent()
        
      Select event
      

          
        Case #PB_Event_Gadget
          
          Select EventGadget()
            Case #boutonAnnule
              annuleDernierCoup(*Jeu)
              SetGadgetText(#StringScore, Str(litScore()))
            Case #boutonInit
              initJeu(*Jeu)
              SetGadgetText(#StringScore, Str(0))
            Case #boutonRejoue
              rejoueDernierCoup(*Jeu)
              SetGadgetText(#StringScore, Str(litScore()))
            Case #boutonSauve
              sauveJeu(*Jeu)
            Case #boutonCharge
              chargeJeu(*Jeu)
            Case #viewPlaysCheckbox
              voirCoups(*Jeu, GetGadgetState(#viewPlaysCheckbox))
            Case #voirNumerosCheckbox
              MouseDown = #False
              voirNumeros(*Jeu, GetGadgetState(#voirNumerosCheckbox))
            Case #optionCheckbox
              MouseDown = #False
              RondCroix(*Jeu, GetGadgetState(#optionCheckbox))
          EndSelect  
          
        ;Si on veut quitter, done=1 suffira
        Case #PB_Event_CloseWindow
          done=1
        Case #WM_LBUTTONUP 
        MouseDown = #False
        mouseReleased(*jeu)
        Case #WM_LBUTTONDOWN
        MouseDown = #True
        mousePressed(*jeu)
        Case #WM_MOUSEMOVE
          If WindowMouseY(0) > #HEIGHT-21
            MouseDown = #False
          EndIf  
          If MouseDown
          mouseDragged(*jeu)
          EndIf
      EndSelect
  
    Until Event=0         
  
    ClearScreen($FFFFFF)

    paint(*Jeu)
      
    FlipBuffers()
    
    Delay(20)
        
  Wend

EndProcedure



Procedure init()

  ;Initialisation 
  If InitSprite()=0 Or InitSprite3D()=0 Or InitKeyboard()=0 
    MessageRequester("Erreur", "Probleme pour initialiser directx", #PB_MessageRequester_Ok)
    End
  EndIf


  ;Ouvrerture d'une surface pour l'affichage de la fentre
  If OpenWindow(0, 0, 0, #WIDTH, #HEIGHT, "Morpion Version 1.0")=0
    MessageRequester("Erreur", "Erreur  l'ouverture d'une fentre", #PB_MessageRequester_Ok)
    End
  EndIf
  
  If OpenWindowedScreen(WindowID(0),0, 0, #WIDTH, #HEIGHT-20, 0, 0, 0) = 0
    MessageRequester("Erreur", "Erreur  l'ouverture d'un cran", #PB_MessageRequester_Ok)
    End  
  EndIf

 KeyboardMode(#PB_Keyboard_International) 

  ButtonGadget(#boutonInit,   10, #HEIGHT-20, 55, 20, "Nouveau") 
	GadgetToolTip(#boutonInit, "Nouvelle partie") 
  ButtonGadget(#boutonAnnule, 65, #HEIGHT-20, 55, 20, "Annuler")  
	GadgetToolTip(#boutonAnnule, "Annule le dernier coup")   
	ButtonGadget(#boutonRejoue,120, #HEIGHT-20, 55, 20, "Rejouer")
	GadgetToolTip(#boutonRejoue, "Rejoue le dernier coup annul") 	
	ButtonGadget(#boutonSauve, 175, #HEIGHT-20, 55, 20, "Sauver")
	GadgetToolTip(#boutonSauve, "Sauve la partie en cours") 	
	ButtonGadget(#boutonCharge,230, #HEIGHT-20, 55, 20, "Charger")
	GadgetToolTip(#boutonCharge, "Charge une partie") 	
	CheckBoxGadget(#viewPlaysCheckbox  , 295, #HEIGHT-20, 50, 20, "coups")
	GadgetToolTip(#viewPlaysCheckbox, "Voir les coups possibles")
	CheckBoxGadget(#voirNumerosCheckbox, 350, #HEIGHT-20, 60, 20, "numros")
	GadgetToolTip(#voirNumerosCheckbox, "Voir les numros")
	CheckBoxGadget(#optionCheckbox, 420, #HEIGHT-20, 20, 20, "")
	GadgetToolTip(#optionCheckbox, "rond ou croix")	
	TextGadget(#textScore         , 450, #HEIGHT-17, 50, 20, "Score")
	StringGadget(#StringScore     , 490, #HEIGHT-20, 25, 20, "000", #PB_String_ReadOnly)
EndProcedure
	
; IDE Options = PureBasic 4.30 (Windows - x86)
; Folding = -
; EnableXP
; Executable = morpionsolitaire.exe
; DisableDebugger