
;Lionel Brits & NeHe's 3D World Tutorial (Lesson 10)
;http://nehe.gamedev.net
;Credits: Nico Gruener, Dreglor, traumatic
;Author: hagibaba
;Date: 7 Jan 2007
;Note: up-to-date with PB v4.02 (Windows)
;Note: requires a bitmap in path "Data/Mud.bmp"
;Note: requires a vertex data text file in path "Data/World.txt"

;Section for standard constants, structures, macros and declarations

XIncludeFile "OpenGL.pbi" ;include the gl.h constants

;wingdi.h constants
#DM_BITSPERPEL=$40000
#DM_PELSWIDTH=$80000
#DM_PELSHEIGHT=$100000

;winuser.h constants
#CDS_FULLSCREEN=4
#DISP_CHANGE_SUCCESSFUL=0
#SC_MONITORPOWER=$F170

Structure AUX_RGBImageRec ;glaux.h structure
 sizeX.l : sizeY.l
 Data.l
EndStructure

Procedure.w LoWord(value.l) ;windef.h macro
 ProcedureReturn (value & $FFFF)
EndProcedure

Procedure.w HiWord(value.l) ;windef.h macro
 ProcedureReturn ((value >> 16) & $FFFF)
EndProcedure

;glaux.lib symbols
!public ___ftoll
!___ftoll dw 0
!public __imp__wsprintfA
!__imp__wsprintfA dw 0

Import "glaux.lib"
 auxDIBImageLoad.l(filename.s) As "_auxDIBImageLoadA@4" ;loads a 24-bit Windows DIB
EndImport

Import "glu32.lib"
 gluPerspective(fovy.d,aspect.d,zNear.d,zFar.d) ;sets up a perspective projection matrix
EndImport

Import "opengl32.lib"
 glClearDepth(depth.d) ;specifies the clear value for the depth buffer
EndImport

;Start of Lesson 10

Global hDC.l ;Private GDI Device Context
Global hRC.l ;Permanent Rendering Context
Global hWnd.l ;Holds Our Window Handle
Global hInstance.l ;Holds The Instance Of The Application

Global Dim keys.b(256) ;Array Used For The Keyboard Routine
Global active.b=#True ;Window Active Flag Set To TRUE By Default
Global fullscreen.b=#True ;Fullscreen Flag Set To Fullscreen Mode By Default

Global blend.b ;Blending ON/OFF
Global bp.b ;B Pressed?
Global fp.b ;F Pressed?

#PIOVER180=0.0174532925 ;constant for sin/cos

Global heading.f ;Y rotation
Global xpos.f ;position
Global zpos.f

Global yrot.f ;Y Rotation
Global walkbias.f=0 ;walk bounce
Global walkbiasangle.f=0
Global lookupdown.f=0 ;tilt

Global filter.l ;Which Filter To Use
Global Dim texture.l(3) ;Storage For 3 Textures

Structure VERTEX ;Build Our Vertex Structure
 x.f : y.f : z.f ;3D Coordinates
 u.f : v.f ;Texture Coordinates
EndStructure

Structure TRIANGLE ;Build Our Triangle Structure
 vertex.VERTEX[3] ;Array Of Three Vertices
EndStructure

Global Dim numtriangles.l(1) ;Number Of Triangles In Sector
Global Dim sector1.TRIANGLE(1) ;Array Of Triangles, Our Model Goes Here

Declare.l WndProc(hWnd.l,uMsg.l,wParam.l,lParam.l) ;Declaration For WndProc

Procedure.s readstr(f.l) ;Read In A String

 Protected string.s
 While Left(string,1)="/" Or Left(string,1)="" ;See If It Is Worthy Of Processing
  string=ReadString(f) ;Read One Line
 Wend
 ProcedureReturn string ;return the line
 
EndProcedure

Procedure.b SetupWorld(Filename.s) ;Setup Our World

 Protected filein.l ;File To Work With
 Protected oneline.s,char.s ;Strings To Store Data In
 Protected triloop.l,vertloop.l,pos.l,count.l
 
 filein=ReadFile(#PB_Any,Filename) ;Open Our File
 
 If filein=0 ;file can't be opened
  ProcedureReturn #False
 EndIf
 
 oneline=readstr(filein) ;Get Single Line Of Data, 1st line is numtriangles
 
 For pos=1 To Len(oneline) ;parse the line, instead of sscanf()
  If Asc(Mid(oneline,pos,1))>48 And Asc(Mid(oneline,pos,1))<58 ;numeric char
   char=Mid(oneline,pos,Len(oneline)-pos+1)
   numtriangles(0)=Val(char) ;Read In Number Of Triangles
   Break ;exit loop
  EndIf
 Next
 
 ReDim sector1.TRIANGLE(numtriangles(0)) ;Allocate Memory For Sector
 
 For triloop=0 To numtriangles(0)-1 ;Loop Through All The Triangles
  For vertloop=0 To 2 ;Loop Through All The Vertices
   oneline=readstr(filein) ;Read String To Work With
   
   count=0 : char="" ;reset for each line
   For pos=1 To Len(oneline) ;parse the line, instead of sscanf()
    If Mid(oneline,pos,1)<>" " ;if not space
     char=char+Mid(oneline,pos,1) ;add char
    EndIf
    If Len(char)>0 And (Mid(oneline,pos,1)=" " Or pos=Len(oneline)) ;if char and space or end-of-line
     Select count ;Store Values Into Respective Vertices
      Case 0 : sector1(triloop)\vertex[vertloop]\x=ValF(char)
      Case 1 : sector1(triloop)\vertex[vertloop]\y=ValF(char)
      Case 2 : sector1(triloop)\vertex[vertloop]\z=ValF(char)
      Case 3 : sector1(triloop)\vertex[vertloop]\u=ValF(char)
      Case 4 : sector1(triloop)\vertex[vertloop]\v=ValF(char)
     EndSelect
     count=count+1 ;next VERTEX member
     char="" ;reset for next
    EndIf
   Next
   
  Next
 Next
 
 CloseFile(filein) ;Close Our File
 
 ProcedureReturn #True ;Jump Back
 
EndProcedure

Procedure.l LoadBMP(Filename.s) ;Loads A Bitmap Image

 Protected File.l=#Null ;File Handle
 
 If Filename="" ;Make Sure A Filename Was Given
  ProcedureReturn #Null ;If Not Return NULL
 EndIf
 
 File=ReadFile(#PB_Any,Filename) ;Check To See If The File Exists
 
 If File ;Does The File Exist?
  CloseFile(File) ;Close The Handle
  ProcedureReturn auxDIBImageLoad(Filename) ;Load The Bitmap And Return A Pointer
 EndIf
 
 ProcedureReturn #Null ;If Load Failed Return NULL
 
EndProcedure

Procedure.l LoadGLTextures() ;Load Bitmaps And Convert To Textures

 Protected Status.l=#False ;Status Indicator
 Protected Dim *TextureImage.AUX_RGBImageRec(1) ;Create Storage Space For The Texture
 
 ;Load The Bitmap, Check For Errors, If Bitmap's Not Found Quit
 *TextureImage(0)=LoadBMP("Data/Mud.bmp")
 If *TextureImage(0)
  Status=#True ;Set The Status To TRUE
 
  glGenTextures_(3,@texture(0)) ;Create Three Textures
 
  ;Create Nearest Filtered Texture
  glBindTexture_(#GL_TEXTURE_2D,texture(0))
  glTexParameteri_(#GL_TEXTURE_2D,#GL_TEXTURE_MAG_FILTER,#GL_NEAREST)
  glTexParameteri_(#GL_TEXTURE_2D,#GL_TEXTURE_MIN_FILTER,#GL_NEAREST)
  glTexImage2D_(#GL_TEXTURE_2D,0,3,*TextureImage(0)\sizeX,*TextureImage(0)\sizeY,0,#GL_RGB,#GL_UNSIGNED_BYTE,*TextureImage(0)\Data)
 
  ;Create Linear Filtered Texture
  glBindTexture_(#GL_TEXTURE_2D,texture(1))
  glTexParameteri_(#GL_TEXTURE_2D,#GL_TEXTURE_MAG_FILTER,#GL_LINEAR)
  glTexParameteri_(#GL_TEXTURE_2D,#GL_TEXTURE_MIN_FILTER,#GL_LINEAR)
  glTexImage2D_(#GL_TEXTURE_2D,0,3,*TextureImage(0)\sizeX,*TextureImage(0)\sizeY,0,#GL_RGB,#GL_UNSIGNED_BYTE,*TextureImage(0)\Data)
 
  ;Create MipMapped Texture
  glBindTexture_(#GL_TEXTURE_2D,texture(2))
  glTexParameteri_(#GL_TEXTURE_2D,#GL_TEXTURE_MAG_FILTER,#GL_LINEAR)
  glTexParameteri_(#GL_TEXTURE_2D,#GL_TEXTURE_MIN_FILTER,#GL_LINEAR_MIPMAP_NEAREST)
  gluBuild2DMipmaps_(#GL_TEXTURE_2D,3,*TextureImage(0)\sizeX,*TextureImage(0)\sizeY,#GL_RGB,#GL_UNSIGNED_BYTE,*TextureImage(0)\Data)
 EndIf
 
 If *TextureImage(0) ;If Texture Exists
  If *TextureImage(0)\Data ;If Texture Image Exists
   FreeMemory(*TextureImage(0)\Data) ;Free The Texture Image Memory
  EndIf
  FreeMemory(*TextureImage(0)) ;Free The Image Structure
 EndIf
 
 ProcedureReturn Status ;Return The Status
 
EndProcedure

Procedure ReSizeGLScene(width.l,height.l) ;Resize And Initialize The GL Window

 If height=0 : height=1 : EndIf ;Prevent A Divide By Zero Error
 
 glViewport_(0,0,width,height) ;Reset The Current Viewport
 
 glMatrixMode_(#GL_PROJECTION) ;Select The Projection Matrix
 glLoadIdentity_() ;Reset The Projection Matrix
 
 gluPerspective(45.0,Abs(width/height),0.1,100.0) ;Calculate The Aspect Ratio Of The Window
 
 glMatrixMode_(#GL_MODELVIEW) ;Select The Modelview Matrix
 glLoadIdentity_() ;Reset The Modelview Matrix
 
EndProcedure

Procedure.l InitGL() ;All Setup For OpenGL Goes Here

 If LoadGLTextures()=0 ;Jump To Texture Loading Routine
  ProcedureReturn #False ;If Texture Didn't Load Return FALSE
 EndIf
 
 glEnable_(#GL_TEXTURE_2D) ;Enable Texture Mapping
 glBlendFunc_(#GL_SRC_ALPHA,#GL_ONE) ;Set The Blending Function For Translucency
 glClearColor_(0.0,0.0,0.0,0.0) ;This Will Clear The Background Color To Black
 glClearDepth(1.0) ;Enables Clearing Of The Depth Buffer
 glDepthFunc_(#GL_LESS) ;The Type Of Depth Test To Do
 glEnable_(#GL_DEPTH_TEST) ;Enables Depth Testing
 glShadeModel_(#GL_SMOOTH) ;Enables Smooth Color Shading
 glHint_(#GL_PERSPECTIVE_CORRECTION_HINT,#GL_NICEST) ;Really Nice Perspective Calculations
 
 SetupWorld("Data/World.txt") ;File To Load World Data From
 
 ProcedureReturn #True ;Initialization Went OK
 
EndProcedure

Procedure.l DrawGLScene() ;Here's Where We Do All The Drawing

 Protected x_m.f,y_m.f,z_m.f,u_m.f,v_m.f ;Floating Point For Temp X, Y, Z, U And V Vertices
 Protected xtrans.f=-xpos ;Used For Player Translation On The X Axis
 Protected ztrans.f=-zpos ;Used For Player Translation On The Z Axis
 Protected ytrans.f=-walkbias-0.25 ;Used For Bouncing Motion Up And Down
 Protected sceneroty.f=360.0-yrot ;360 Degree Angle For Player Direction
 Protected loop_m.l
 
 glClear_(#GL_COLOR_BUFFER_BIT | #GL_DEPTH_BUFFER_BIT) ;Clear The Screen And The Depth Buffer
 glLoadIdentity_() ;Reset The View
 
 glRotatef_(lookupdown,1.0,0,0) ;Rotate Up And Down To Look Up And Down
 glRotatef_(sceneroty,0,1.0,0) ;Rotate Depending On Direction Player Is Facing
 
 glTranslatef_(xtrans,ytrans-0.25,ztrans) ;Translate The Scene Based On Player Position
 glBindTexture_(#GL_TEXTURE_2D,texture(filter)) ;Select A Texture Based On filter
 
 ;Process Each Triangle
 For loop_m=0 To numtriangles(0)-1 ;Loop Through All The Triangles
  glBegin_(#GL_TRIANGLES) ;Start Drawing Triangles
   glNormal3f_( 0.0, 0.0, 1.0) ;Normal Pointing Forward
   x_m=sector1(loop_m)\vertex[0]\x ;X Vertex Of 1st Point
   y_m=sector1(loop_m)\vertex[0]\y ;Y Vertex Of 1st Point
   z_m=sector1(loop_m)\vertex[0]\z ;Z Vertex Of 1st Point
   u_m=sector1(loop_m)\vertex[0]\u ;U Texture Coord Of 1st Point
   v_m=sector1(loop_m)\vertex[0]\v ;V Texture Coord Of 1st Point
   glTexCoord2f_(u_m,v_m) : glVertex3f_(x_m,y_m,z_m) ;Set The TexCoord And Vertice
   
   x_m=sector1(loop_m)\vertex[1]\x ;X Vertex Of 2nd Point
   y_m=sector1(loop_m)\vertex[1]\y ;Y Vertex Of 2nd Point
   z_m=sector1(loop_m)\vertex[1]\z ;Z Vertex Of 2nd Point
   u_m=sector1(loop_m)\vertex[1]\u ;U Texture Coord Of 2nd Point
   v_m=sector1(loop_m)\vertex[1]\v ;V Texture Coord Of 2nd Point
   glTexCoord2f_(u_m,v_m) : glVertex3f_(x_m,y_m,z_m) ;Set The TexCoord And Vertice
   
   x_m=sector1(loop_m)\vertex[2]\x ;X Vertex Of 3rd Point
   y_m=sector1(loop_m)\vertex[2]\y ;Y Vertex Of 3rd Point
   z_m=sector1(loop_m)\vertex[2]\z ;Z Vertex Of 3rd Point
   u_m=sector1(loop_m)\vertex[2]\u ;U Texture Coord Of 3rd Point
   v_m=sector1(loop_m)\vertex[2]\v ;V Texture Coord Of 3rd Point
   glTexCoord2f_(u_m,v_m) : glVertex3f_(x_m,y_m,z_m) ;Set The TexCoord And Vertice
  glEnd_() ;Done Drawing Triangles
 Next
 
 ProcedureReturn #True ;Everything Went OK
 
EndProcedure

Procedure KillGLWindow() ;Properly Kill The Window

 If fullscreen ;Are We In Fullscreen Mode?
  ChangeDisplaySettings_(#Null,0) ;If So Switch Back To The Desktop
  ShowCursor_(#True) ;Show Mouse Pointer
 EndIf

 If hRC ;Do We Have A Rendering Context?
  If wglMakeCurrent_(#Null,#Null)=0 ;Are We Able To Release The DC And RC Contexts?
   MessageBox_(#Null,"Release Of DC And RC Failed.","SHUTDOWN ERROR",#MB_OK | #MB_ICONINFORMATION)
  EndIf
  If wglDeleteContext_(hRC)=0 ;Are We Able To Delete The RC?
   MessageBox_(#Null,"Release Rendering Context Failed.","SHUTDOWN ERROR",#MB_OK | #MB_ICONINFORMATION)
  EndIf
  hRC=#Null ;Set RC To NULL
 EndIf
 
 If hDC And ReleaseDC_(hWnd,hDC)=0 ;Are We Able To Release The DC
  MessageBox_(#Null,"Release Device Context Failed.","SHUTDOWN ERROR",#MB_OK | #MB_ICONINFORMATION)
  hDC=#Null ;Set DC To NULL
 EndIf
 
 If hWnd And DestroyWindow_(hWnd)=0 ;Are We Able To Destroy The Window?
   MessageBox_(#Null,"Could Not Release hWnd.","SHUTDOWN ERROR",#MB_OK | #MB_ICONINFORMATION)
   hWnd=#Null ;Set hWnd To NULL
 EndIf
 
 If UnregisterClass_("OpenGL",hInstance)=0 ;Are We Able To Unregister Class
  MessageBox_(#Null,"Could Not Unregister Class.","SHUTDOWN ERROR",#MB_OK | #MB_ICONINFORMATION)
  hInstance=#Null ;Set hInstance To NULL
 EndIf
 
EndProcedure

;This Code Creates Our OpenGL Window. Parameters Are:
;title - Title To Appear At The Top Of The Window
;width - Width Of The GL Window Or Fullscreen Mode
;height - Height Of The GL Window Or Fullscreen Mode
;bits - Number Of Bits To Use For Color (8/16/24/32)
;fullscreenflag - Use Fullscreen Mode (TRUE) Or Windowed Mode (FALSE)

Procedure.b CreateGLWindow(title.s,width.l,height.l,bits.l,fullscreenflag.b)

 Protected PixelFormat.l ;Holds The Results After Searching For A Match
 Protected wc.WNDCLASS ;Windows Class Structure
 Protected dwExStyle.l ;Window Extended Style
 Protected dwStyle.l ;Window Style
 Protected WindowRect.RECT ;Grabs Rectangle Upper Left / Lower Right Values
 Protected wpos.POINT ;Window position
 
 WindowRect\left=0 ;Set Left Value To 0
 WindowRect\right=width ;Set Right Value To Requested Width
 WindowRect\top=0 ;Set Top Value To 0
 WindowRect\bottom=height ;Set Bottom Value To Requested Height

 fullscreen=fullscreenflag ;Set The Global Fullscreen Flag

 hInstance=GetModuleHandle_(#Null) ;Grab An Instance For Our Window
 
 wc\style=#CS_HREDRAW | #CS_VREDRAW | #CS_OWNDC ;Redraw On Size, And Own DC For Window
 wc\lpfnWndProc=@WndProc() ;WndProc Handles Messages
 wc\cbClsExtra=0 ;No Extra Window Data
 wc\cbWndExtra=0 ;No Extra Window Data
 wc\hInstance=hInstance ;Set The Instance
 wc\hIcon=LoadIcon_(#Null,#IDI_WINLOGO) ;Load The Default Icon
 wc\hCursor=LoadCursor_(#Null,#IDC_ARROW) ;Load The Arrow Pointer
 wc\hbrBackground=#Null ;No Background Required For GL
 wc\lpszMenuName=#Null ;We Don't Want A Menu
 wc\lpszClassName=@"OpenGL" ;Set The Class Name 

 If RegisterClass_(wc)=0 ;Attempt To Register The Window Class
  MessageBox_(#Null,"Failed To Register The Window Class.","ERROR",#MB_OK | #MB_ICONEXCLAMATION)
  ProcedureReturn #False
 EndIf

 If fullscreen ;Attempt Fullscreen Mode?
 
  Protected dmScreenSettings.DEVMODE ;Device Mode
  dmScreenSettings\dmSize=SizeOf(DEVMODE) ;Size Of The Devmode Structure
  dmScreenSettings\dmFields=#DM_BITSPERPEL | #DM_PELSWIDTH | #DM_PELSHEIGHT ;bit flags to specify the members of DEVMODE that were initialized
  dmScreenSettings\dmBitsPerPel=bits ;Selected Bits Per Pixel
  dmScreenSettings\dmPelsWidth=width ;Selected Screen Width in pixels
  dmScreenSettings\dmPelsHeight=height ;Selected Screen Height in pixels

  ;Try To Set Selected Mode And Get Results. Note: CDS_FULLSCREEN Gets Rid Of Start Bar
  If ChangeDisplaySettings_(dmScreenSettings,#CDS_FULLSCREEN)<>#DISP_CHANGE_SUCCESSFUL
   ;If The Mode Fails, Offer Two Options. Quit Or Use Windowed Mode
   If MessageBox_(#Null,"The Requested Fullscreen Mode Is Not Supported By"+Chr(10)+"Your Video Card. Use Windowed Mode Instead?","NeHe GL",#MB_YESNO | #MB_ICONEXCLAMATION)=#IDYES
    fullscreen=#False ;Windowed Mode Selected.  Fullscreen = FALSE
   Else
    ;Pop Up A Message Box Letting User Know The Program Is Closing
    MessageBox_(#Null,"Program Will Now Close.","ERROR",#MB_OK | #MB_ICONSTOP)
    ProcedureReturn #False
   EndIf
  EndIf
 
 EndIf
 
 If fullscreen ;Are We Still In Fullscreen Mode?
  dwExStyle=#WS_EX_APPWINDOW ;Window Extended Style
  dwStyle=#WS_POPUP ;Windows Style
  ShowCursor_(#False) ;Hide Mouse Pointer
 Else
  dwExStyle=#WS_EX_APPWINDOW | #WS_EX_WINDOWEDGE ;Window Extended Style
  dwStyle=#WS_OVERLAPPEDWINDOW ;Windows Style
 EndIf
 
 AdjustWindowRectEx_(WindowRect,dwStyle,#False,dwExStyle) ;Adjust Window To True Requested Size
 
 If fullscreen=0 ;if not fullscreen mode calculate screen centered window
  wpos\x=(GetSystemMetrics_(#SM_CXSCREEN)/2)-((WindowRect\right-WindowRect\left)/2)
  wpos\y=(GetSystemMetrics_(#SM_CYSCREEN)/2)-((WindowRect\bottom-WindowRect\top)/2)
 EndIf
 
 ;CreateWindowEx_(Extended Window Style, Class Name, Window Title, Window Style, Window X Position, Window Y Position, Width, Height, No Parent Window, No Menu, Instance, No Creation Data)
 hWnd=CreateWindowEx_(dwExStyle,"OpenGL",title,dwStyle | #WS_CLIPSIBLINGS | #WS_CLIPCHILDREN,wpos\x,wpos\y,WindowRect\right-WindowRect\left,WindowRect\bottom-WindowRect\top,#Null,#Null,hInstance,#Null)
 If hWnd=0
  KillGLWindow() ;Reset The Display
  MessageBox_(#Null,"Window Creation Error.","ERROR",#MB_OK | #MB_ICONEXCLAMATION)
  ProcedureReturn #False
 EndIf

 Protected pfd.PIXELFORMATDESCRIPTOR ;pfd Tells Windows How We Want Things To Be
 pfd\nSize=SizeOf(PIXELFORMATDESCRIPTOR) ;Size Of This Structure
 pfd\nVersion=1 ;Version Number
 pfd\dwFlags=#PFD_SUPPORT_OPENGL | #PFD_DOUBLEBUFFER | #PFD_DRAW_TO_WINDOW ;Format Must Support Window, OpenGL, Double Buffering
 pfd\iPixelType=#PFD_TYPE_RGBA ;Request An RGBA Format
 pfd\cColorBits=bits ;Select Our Color Depth
 pfd\cRedBits=0 ;Color Bits Ignored
 pfd\cRedShift=0
 pfd\cGreenBits=0
 pfd\cGreenShift=0
 pfd\cBlueBits=0
 pfd\cBlueShift=0
 pfd\cAlphaBits=0 ;No Alpha Buffer
 pfd\cAlphaShift=0 ;Shift Bit Ignored
 pfd\cAccumBits=0 ;No Accumulation Buffer
 pfd\cAccumRedBits=0 ;Accumulation Bits Ignored
 pfd\cAccumGreenBits=0
 pfd\cAccumBlueBits=0
 pfd\cAccumAlphaBits=0
 pfd\cDepthBits=16 ;16Bit Z-Buffer (Depth Buffer)
 pfd\cStencilBits=0 ;No Stencil Buffer
 pfd\cAuxBuffers=0 ;No Auxiliary Buffer
 pfd\iLayerType=#PFD_MAIN_PLANE ;Main Drawing Layer
 pfd\bReserved=0 ;Reserved
 pfd\dwLayerMask=0 ;Layer Masks Ignored
 pfd\dwVisibleMask=0
 pfd\dwDamageMask=0

 hDC=GetDC_(hWnd)
 If hDC=0 ;Did We Get A Device Context?
  KillGLWindow() ;Reset The Display
  MessageBox_(#Null,"Can't Create A GL Device Context.","ERROR",#MB_OK | #MB_ICONEXCLAMATION)
  ProcedureReturn #False
 EndIf
 
 PixelFormat=ChoosePixelFormat_(hDC,pfd)
 If PixelFormat=0 ;Did Windows Find A Matching Pixel Format?
  KillGLWindow() ;Reset The Display
  MessageBox_(#Null,"Can't Find A Suitable PixelFormat.","ERROR",#MB_OK | #MB_ICONEXCLAMATION)
  ProcedureReturn #False
 EndIf

 If SetPixelFormat_(hDC,PixelFormat,pfd)=0 ;Are We Able To Set The Pixel Format?
  KillGLWindow() ;Reset The Display
  MessageBox_(#Null,"Can't Set The PixelFormat.","ERROR",#MB_OK | #MB_ICONEXCLAMATION)
  ProcedureReturn #False
 EndIf

 hRC=wglCreateContext_(hDC)
 If hRC=0 ;Are We Able To Get A Rendering Context?
  KillGLWindow() ;Reset The Display
  MessageBox_(#Null,"Can't Create A GL Rendering Context.","ERROR",#MB_OK | #MB_ICONEXCLAMATION)
  ProcedureReturn #False
 EndIf
 
 If wglMakeCurrent_(hDC,hRC)=0 ;Try To Activate The Rendering Context
  KillGLWindow() ;Reset The Display
  MessageBox_(#Null,"Can't Activate The GL Rendering Context.","ERROR",#MB_OK | #MB_ICONEXCLAMATION)
  ProcedureReturn #False
 EndIf

 ShowWindow_(hWnd,#SW_SHOW) ;Show The Window
 SetForegroundWindow_(hWnd) ;Slightly Higher Priority
 SetFocus_(hWnd) ;Sets Keyboard Focus To The Window
 ReSizeGLScene(width,height) ;Set Up Our Perspective GL Screen

 If InitGL()=0 ;Initialize Our Newly Created GL Window
  KillGLWindow() ;Reset The Display
  MessageBox_(#Null,"Initialization Failed.","ERROR",#MB_OK | #MB_ICONEXCLAMATION)
  ProcedureReturn #False
 EndIf

 ProcedureReturn #True ;Success

EndProcedure

Procedure.l WndProc(hWnd.l,uMsg.l,wParam.l,lParam.l)

 Select uMsg ;Check For Windows Messages

  Case #WM_ACTIVATE ;Watch For Window Activate Message
   If HiWord(wParam)=0 ;Check Minimization State
    active=#True ;Program Is Active
   Else
    active=#False ;Program Is No Longer Active
   EndIf
   ProcedureReturn 0 ;Return To The Message Loop

  Case #WM_SYSCOMMAND ;Intercept System Commands
   Select wParam ;Check System Calls
    Case #SC_SCREENSAVE ;Screensaver Trying To Start?
     ProcedureReturn 0 ;Prevent From Happening
    Case #SC_MONITORPOWER ;Monitor Trying To Enter Powersave?
     ProcedureReturn 0 ;Prevent From Happening
   EndSelect

  Case #WM_CLOSE ;Did We Receive A Close Message?
   PostQuitMessage_(0) ;Send A Quit Message
   ProcedureReturn 0 ;Jump Back

  Case #WM_KEYDOWN ;Is A Key Being Held Down?
   keys(wParam)=#True ;If So, Mark It As TRUE
   ProcedureReturn 0 ;Jump Back

  Case #WM_KEYUP ;Has A Key Been Released?
   keys(wParam)=#False ;If So, Mark It As FALSE
   ProcedureReturn 0 ;Jump Back

  Case #WM_SIZE ;Resize The OpenGL Window
   ReSizeGLScene(LoWord(lParam),HiWord(lParam)) ;LoWord=Width, HiWord=Height
   ProcedureReturn 0 ;Jump Back
   
 EndSelect
 
 ;Pass All Unhandled Messages To DefWindowProc
 ProcedureReturn DefWindowProc_(hWnd,uMsg,wParam,lParam)
 
EndProcedure

Procedure.l WinMain() ;Main Program

 Protected msg.MSG ;Windows Message Structure
 Protected done.b ;Bool Variable To Exit Loop
 
 ;Ask The User Which Screen Mode They Prefer
 If MessageBox_(#Null,"Would You Like To Run In Fullscreen Mode?","Start FullScreen?",#MB_YESNO | #MB_ICONQUESTION)=#IDNO
  fullscreen=#False ;Windowed Mode
 EndIf
 
 If CreateGLWindow("Lionel Brits & NeHe's 3D World Tutorial",640,480,16,fullscreen)=0 ;Create The Window
  ProcedureReturn 0 ;Quit If Window Was Not Created
 EndIf
 
 While done=#False ;Loop That Runs While done=FALSE
 
  If PeekMessage_(msg,#Null,0,0,#PM_REMOVE) ;Is There A Message Waiting?
 
   If msg\message=#WM_QUIT ;Have We Received A Quit Message?
    done=#True ;If So done=TRUE
   Else ;If Not, Deal With Window Messages
    TranslateMessage_(msg) ;Translate The Message
    DispatchMessage_(msg) ;Dispatch The Message
   EndIf
   
  Else ;If There Are No Messages
 
   ;Draw The Scene. Watch For ESC Key And Quit Messages From DrawGLScene()
   If (active And DrawGLScene()=0) Or keys(#VK_ESCAPE) ;Active? Was There A Quit Received?
   
    done=#True ;ESC or DrawGLScene Signalled A Quit
   
   Else ;Not Time To Quit, Update Screen
   
    SwapBuffers_(hDC) ;Swap Buffers (Double Buffering)
   
    If keys(#VK_B) And bp=0 ;Is B Key Pressed And bp FALSE?
     bp=#True ;If So, bp Becomes TRUE
     blend=~blend & 1 ;Toggle blend TRUE / FALSE
     If blend=0 ;Is blend FALSE?
      glDisable_(#GL_BLEND) ;Turn Blending Off
      glEnable_(#GL_DEPTH_TEST) ;Turn Depth Testing On
     Else
      glEnable_(#GL_BLEND) ;Turn Blending On
      glDisable_(#GL_DEPTH_TEST) ;Turn Depth Testing Off
     EndIf
    EndIf
    If keys(#VK_B)=0 ;Has B Key Been Released?
     bp=#False ;If So, bp Becomes FALSE
    EndIf
   
    If keys(#VK_F) And fp=0 ;Is F Key Being Pressed?
     fp=#True ;fp Becomes TRUE
     filter+1 ;filter Value Increases By One
     If filter>2 ;Is Value Greater Than 2?
      filter=0 ;If So, Set filter To 0
     EndIf
    EndIf
    If keys(#VK_F)=0 ;Has F Key Been Released?
     fp=#False ;If So, fp Becomes FALSE
    EndIf
   
    If keys(#VK_UP) ;Is The Up Arrow Being Pressed?
     xpos-Sin(heading*#PIOVER180)*0.006 ;Move On The X-Plane Based On Player Direction
     zpos-Cos(heading*#PIOVER180)*0.006 ;Move On The Z-Plane Based On Player Direction
     If walkbiasangle>=359.0 ;Is walkbiasangle>=359?
      walkbiasangle=0.0 ;Make walkbiasangle Equal 0
     Else ;Otherwise
      walkbiasangle+2 ;If walkbiasangle<359 Increase It
     EndIf
     walkbias=Sin(walkbiasangle*#PIOVER180)/40.0 ;Causes The Player To Bounce
    EndIf
    If keys(#VK_DOWN) ;Is The Down Arrow Being Pressed?
     xpos+Sin(heading*#PIOVER180)*0.004 ;Move On The X-Plane Based On Player Direction
     zpos+Cos(heading*#PIOVER180)*0.004 ;Move On The Z-Plane Based On Player Direction
     If walkbiasangle<=1.0 ;Is walkbiasangle<=1?
      walkbiasangle=359.0 ;Make walkbiasangle Equal 359
     Else ;Otherwise
      walkbiasangle-2 ;If walkbiasangle>1 Decrease It
     EndIf
     walkbias=Sin(walkbiasangle*#PIOVER180)/40.0 ;Causes The Player To Bounce
    EndIf
   
    If keys(#VK_RIGHT) ;Is The Right Arrow Being Pressed?
     heading-0.32 ;Rotate The Scene To The Left
     yrot=heading
    EndIf
    If keys(#VK_LEFT) ;Is The Left Arrow Being Pressed?
     heading+0.32 ;Rotate The Scene To The Right
     yrot=heading
    EndIf
   
    If keys(#VK_PRIOR) ;Is Page Up Being Pressed?
     lookupdown-0.16 ;Tilt The Scene Up
    EndIf
    If keys(#VK_NEXT) ;Is Page Down Being Pressed?
     lookupdown+0.16 ;Tilt The Scene Down
    EndIf
   
   EndIf
   
   If keys(#VK_F1) ;Is F1 Being Pressed?
    keys(#VK_F1)=#False ;If So Make Key FALSE
    KillGLWindow() ;Kill Our Current Window
    fullscreen=~fullscreen & 1 ;Toggle Fullscreen / Windowed Mode
    ;Recreate Our OpenGL Window
    If CreateGLWindow("Lionel Brits & NeHe's 3D World Tutorial",640,480,16,fullscreen)=0
     ProcedureReturn 0 ;Quit If Window Was Not Created
    EndIf
   EndIf
   
  EndIf
 
 Wend
 
 ;Shutdown
 KillGLWindow() ;Kill The Window
 End ;Exit The Program
 
EndProcedure

WinMain() ;run the main program


; IDE Options = PureBasic 4.20 Beta 2 (Windows - x86)
; CursorPosition = 674
; FirstLine = 629
; Folding = ----