
;Banu Octavian & NeHe's Stencil & Reflection Tutorial (Lesson 26)
;http://nehe.gamedev.net
;Credits: Nico Gruener, Dreglor, traumatic
;Author: hagibaba
;Date: 10 Jan 2007
;Note: up-to-date with PB v4.02 (Windows)
;Note: requires bitmaps in paths "Data/EnvWall.bmp", "Data/Ball.bmp",
;"Data/EnvRoll.bmp"

;Section for standard constants, structures, macros and declarations

XIncludeFile "OpenGL.pbi" ;include the gl.h constants

;wingdi.h constants
#DM_BITSPERPEL=$40000
#DM_PELSWIDTH=$80000
#DM_PELSHEIGHT=$100000

;winuser.h constants
#CDS_FULLSCREEN=4
#DISP_CHANGE_SUCCESSFUL=0
#SC_MONITORPOWER=$F170

Structure AUX_RGBImageRec ;glaux.h structure
 sizeX.l : sizeY.l
 Data.l
EndStructure

Procedure.w LoWord(value.l) ;windef.h macro
 ProcedureReturn (value & $FFFF)
EndProcedure

Procedure.w HiWord(value.l) ;windef.h macro
 ProcedureReturn ((value >> 16) & $FFFF)
EndProcedure

;glaux.lib symbols
!public ___ftoll
!___ftoll dw 0
!public __imp__wsprintfA
!__imp__wsprintfA dw 0

Import "glaux.lib"
 auxDIBImageLoad.l(filename.s) As "_auxDIBImageLoadA@4" ;loads a 24-bit Windows DIB
EndImport

Import "glu32.lib"
 gluPerspective(fovy.d,aspect.d,zNear.d,zFar.d) ;sets up a perspective projection matrix
 gluSphere(*qobj,radius.d,slices.l,stacks.l) ;draws a sphere
EndImport

Import "opengl32.lib"
 glClearDepth(depth.d) ;specifies the clear value for the depth buffer
EndImport

;Start of Lesson 26

Global hDC.l ;Private GDI Device Context
Global hRC.l ;Permanent Rendering Context
Global hWnd.l ;Holds Our Window Handle
Global hInstance.l ;Holds The Instance Of The Application

Global Dim keys.b(256) ;Array Used For The Keyboard Routine
Global active.b=#True ;Window Active Flag Set To TRUE By Default
Global fullscreen.b=#True ;Fullscreen Flag Set To Fullscreen Mode By Default

;Light Parameters
Global Dim LightAmb.f(4) ;Ambient Light
 LightAmb(0)=0.7 : LightAmb(1)=0.7 : LightAmb(2)=0.7 : LightAmb(3)=1.0
Global Dim LightDif.f(4) ;Diffuse Light
 LightDif(0)=1.0 : LightDif(1)=1.0 : LightDif(2)=1.0 : LightDif(3)=1.0
Global Dim LightPos.f(4) ;Light Position
 LightPos(0)=4.0 : LightPos(1)=4.0 : LightPos(2)=6.0 : LightPos(3)=1.0
 
Global q.l ;Quadratic For Drawing A Sphere

Global xrot.f=0.0 ;X Rotation
Global yrot.f=0.0 ;Y Rotation
Global xrotspeed.f=0.0 ;X Rotation Speed
Global yrotspeed.f=0.0 ;Y Rotation Speed
Global zoom.f=-7.0 ;Depth Into The Screen
Global height.f=0.5 ;Height Of Ball From Floor

Global Dim texture.l(3) ;3 Textures

Declare.l WndProc(hWnd.l,uMsg.l,wParam.l,lParam.l) ;Declaration For WndProc

Procedure.l LoadBMP(Filename.s) ;Loads A Bitmap Image

 Protected File.l=#Null ;File Handle
 
 If Filename="" ;Make Sure A Filename Was Given
  ProcedureReturn #Null ;If Not Return NULL
 EndIf
 
 File=ReadFile(#PB_Any,Filename) ;Check To See If The File Exists
 
 If File ;Does The File Exist?
  CloseFile(File) ;Close The Handle
  ProcedureReturn auxDIBImageLoad(Filename) ;Load The Bitmap And Return A Pointer
 EndIf
 
 ProcedureReturn #Null ;If Load Failed Return NULL
 
EndProcedure

Procedure.l LoadGLTextures() ;Load Bitmaps And Convert To Textures

 Protected Status.l=#False ;Status Indicator
 Protected Dim *TextureImage.AUX_RGBImageRec(3) ;Create Storage Space For The Textures
 Protected loop.l
 
 *TextureImage(0)=LoadBMP("Data/EnvWall.bmp") ;Load The Floor Texture
 *TextureImage(1)=LoadBMP("Data/Ball.bmp") ;Load the Light Texture
 *TextureImage(2)=LoadBMP("Data/EnvRoll.bmp") ;Load the Wall Texture
 If *TextureImage(0) And *TextureImage(1) And *TextureImage(2)
  Status=#True ;Set The Status To TRUE
 
  glGenTextures_(3,@texture(0)) ;Create The Texture
 
  For loop=0 To 3-1 ;Loop Through 5 Textures
   glBindTexture_(#GL_TEXTURE_2D,texture(loop))
   glTexParameteri_(#GL_TEXTURE_2D,#GL_TEXTURE_MIN_FILTER,#GL_LINEAR)
   glTexParameteri_(#GL_TEXTURE_2D,#GL_TEXTURE_MAG_FILTER,#GL_LINEAR)
   glTexImage2D_(#GL_TEXTURE_2D,0,3,*TextureImage(loop)\sizeX,*TextureImage(loop)\sizeY,0,#GL_RGB,#GL_UNSIGNED_BYTE,*TextureImage(loop)\Data)
  Next
 EndIf
 
 For loop=0 To 3-1 ;Loop Through 5 Textures
  If *TextureImage(loop) ;If Texture Exists
   If *TextureImage(loop)\Data ;If Texture Image Exists
    FreeMemory(*TextureImage(loop)\Data) ;Free The Texture Image Memory
   EndIf
   FreeMemory(*TextureImage(loop)) ;Free The Image Structure
  EndIf
 Next
 
 ProcedureReturn Status ;Return The Status
 
EndProcedure

Procedure ReSizeGLScene(width.l,height.l) ;Resize And Initialize The GL Window
 
 If height=0 : height=1 : EndIf ;Prevent A Divide By Zero Error
 
 glViewport_(0,0,width,height) ;Reset The Current Viewport
 
 glMatrixMode_(#GL_PROJECTION) ;Select The Projection Matrix
 glLoadIdentity_() ;Reset The Projection Matrix
 
 gluPerspective(45.0,Abs(width/height),0.1,100.0) ;Calculate The Aspect Ratio Of The Window
 
 glMatrixMode_(#GL_MODELVIEW) ;Select The Modelview Matrix
 glLoadIdentity_() ;Reset The Modelview Matrix
 
EndProcedure

Procedure.l InitGL() ;All Setup For OpenGL Goes Here

 If LoadGLTextures()=0 ;If Loading The Textures Failed
  ProcedureReturn #False ;Return False
 EndIf
 
 glShadeModel_(#GL_SMOOTH) ;Enable Smooth Shading
 glClearColor_(0.2,0.5,1.0,1.0) ;Background
 glClearDepth(1.0) ;Depth Buffer Setup
 glClearStencil_(0) ;Clear The Stencil Buffer To 0
 glEnable_(#GL_DEPTH_TEST) ;Enables Depth Testing
 glDepthFunc_(#GL_LEQUAL) ;The Type Of Depth Testing To Do
 glHint_(#GL_PERSPECTIVE_CORRECTION_HINT,#GL_NICEST) ;Really Nice Perspective Calculations
 glEnable_(#GL_TEXTURE_2D) ;Enable 2D Texture Mapping
 
 glLightfv_(#GL_LIGHT0,#GL_AMBIENT,LightAmb()) ;Set The Ambient Lighting For Light0
 glLightfv_(#GL_LIGHT0,#GL_DIFFUSE,LightDif()) ;Set The Diffuse Lighting For Light0
 glLightfv_(#GL_LIGHT0,#GL_POSITION,LightPos()) ;Set The Position For Light0
 
 glEnable_(#GL_LIGHT0) ;Enable Light 0
 glEnable_(#GL_LIGHTING) ;Enable Lighting
 
 q=gluNewQuadric_() ;Create A New Quadratic
 gluQuadricNormals_(q,#GL_SMOOTH) ;Generate Smooth Normals For The Quad
 gluQuadricTexture_(q,#GL_TRUE) ;Enable Texture Coords For The Quad
 
 glTexGeni_(#GL_S,#GL_TEXTURE_GEN_MODE,#GL_SPHERE_MAP) ;Set Up Sphere Mapping
 glTexGeni_(#GL_T,#GL_TEXTURE_GEN_MODE,#GL_SPHERE_MAP) ;Set Up Sphere Mapping
 
 ProcedureReturn #True ;Initialization Went OK
 
EndProcedure

Procedure DrawObject() ;Draw Our Ball

 glColor3f_(1.0,1.0,1.0) ;Set Color To White
 glBindTexture_(#GL_TEXTURE_2D,texture(1)) ;Select Texture 2 (Ball.bmp)
 gluSphere(q,0.35,32,16) ;Draw First Sphere
 
 glBindTexture_(#GL_TEXTURE_2D,texture(2)) ;Select Texture 3 (EnvRoll.bmp)
 glColor4f_(1.0,1.0,1.0,0.4) ;Set Color To White With 40% Alpha
 glEnable_(#GL_BLEND) ;Enable Blending
 glBlendFunc_(#GL_SRC_ALPHA,#GL_ONE) ;Set Blending Mode To Mix Based On SRC Alpha
 glEnable_(#GL_TEXTURE_GEN_S) ;Enable Sphere Mapping
 glEnable_(#GL_TEXTURE_GEN_T) ;Enable Sphere Mapping
 
 gluSphere(q,0.35,32,16) ;Draw Another Sphere Using New Texture
 ;Textures Will Mix Creating A MultiTexture Effect (Reflection)
 glDisable_(#GL_TEXTURE_GEN_S) ;Disable Sphere Mapping
 glDisable_(#GL_TEXTURE_GEN_T) ;Disable Sphere Mapping
 glDisable_(#GL_BLEND) ;Disable Blending
 
EndProcedure

Procedure DrawFloor() ;Draws The Floor

 glBindTexture_(#GL_TEXTURE_2D,texture(0)) ;Select Texture 1 (EnvWall.bmp)
 glBegin_(#GL_QUADS) ;Begin Drawing A Quad
  glNormal3f_(0.0, 1.0, 0.0) ;Normal Pointing Up
   glTexCoord2f_(0.0, 1.0) ;Top Left Of Texture
   glVertex3f_(-2.0, 0.0, 2.0) ;Top Left Corner Of Floor
   
   glTexCoord2f_(0.0, 0.0) ;Bottom Left Of Texture
   glVertex3f_(-2.0, 0.0,-2.0) ;Bottom Left Corner Of Floor
   
   glTexCoord2f_(1.0, 0.0) ;Bottom Right Of Texture
   glVertex3f_( 2.0, 0.0,-2.0) ;Bottom Right Corner Of Floor
   
   glTexCoord2f_(1.0, 1.0) ;Top Right Of Texture
   glVertex3f_( 2.0, 0.0, 2.0) ;Top Right Corner Of Floor
 glEnd_() ;Done Drawing The Quad
 
EndProcedure

Procedure.l DrawGLScene() ;Here's Where We Do All The Drawing

 ;Clear Screen, Depth Buffer & Stencil Buffer
 glClear_(#GL_COLOR_BUFFER_BIT | #GL_DEPTH_BUFFER_BIT | #GL_STENCIL_BUFFER_BIT)
 
 ;Clip Plane Equations
 Protected Dim eqr.d(4) ;Plane Equation To Use For The Reflected Objects
  eqr(0)=0.0 : eqr(1)=-1.0 : eqr(2)=0.0 : eqr(3)=0.0
 
 glLoadIdentity_() ;Reset The Modelview Matrix
 glTranslatef_( 0.0,-0.6, zoom) ;Zoom And Raise Camera Above The Floor (Up 0.6 Units)
 glColorMask_(0,0,0,0) ;Set Color Mask
 
 glEnable_(#GL_STENCIL_TEST) ;Enable Stencil Buffer For "marking" The Floor
 glStencilFunc_(#GL_ALWAYS,1,1) ;Always Passes, 1 Bit Plane, 1 As Mask (We Set The Stencil Buffer To 1 Where We Draw Any Polygon)
 glStencilOp_(#GL_KEEP,#GL_KEEP,#GL_REPLACE) ;Keep If Test Fails, Keep If Test Passes But Buffer Test Fails, Replace If Test Passes
 glDisable_(#GL_DEPTH_TEST) ;Disable Depth Testing
 DrawFloor() ;Draw The Floor (Draws To The Stencil Buffer) We Only Want To Mark It In The Stencil Buffer
 
 glEnable_(#GL_DEPTH_TEST) ;Enable Depth Testing
 glColorMask_(1,1,1,1) ;Set Color Mask to TRUE, TRUE, TRUE, TRUE
 glStencilFunc_(#GL_EQUAL,1,1) ;We Draw Only Where The Stencil Is 1 (I.E. Where The Floor Was Drawn)
 glStencilOp_(#GL_KEEP,#GL_KEEP,#GL_KEEP) ;Don't Change The Stencil Buffer
 
 glEnable_(#GL_CLIP_PLANE0) ;Enable Clip Plane For Removing Artifacts (When The Object Crosses The Floor)
 glClipPlane_(#GL_CLIP_PLANE0,eqr()) ;Equation For Reflected Objects
 glPushMatrix_() ;Push The Matrix Onto The Stack
  glScalef_( 1.0,-1.0, 1.0) ;Mirror Y Axis
  glLightfv_(#GL_LIGHT0,#GL_POSITION,LightPos()) ;Set Up Light0
  glTranslatef_( 0.0, height, 0.0) ;Position The Object
  glRotatef_(xrot,1.0,0.0,0.0) ;Rotate Local Coordinate System On X Axis
  glRotatef_(yrot,0.0,1.0,0.0) ;Rotate Local Coordinate System On Y Axis
  DrawObject() ;Draw The Sphere (Reflection)
 glPopMatrix_() ;Pop The Matrix Off The Stack
 glDisable_(#GL_CLIP_PLANE0) ;Disable Clip Plane For Drawing The Floor
 glDisable_(#GL_STENCIL_TEST) ;We Don't Need The Stencil Buffer Any More (Disable)
 
 glLightfv_(#GL_LIGHT0,#GL_POSITION,LightPos()) ;Set Up Light0 Position
 glEnable_(#GL_BLEND) ;Enable Blending (Otherwise The Reflected Object Wont Show)
 glDisable_(#GL_LIGHTING) ;Since We Use Blending, We Disable Lighting
 glColor4f_(1.0,1.0,1.0,0.8) ;Set Color To White With 80% Alpha
 glBlendFunc_(#GL_SRC_ALPHA,#GL_ONE_MINUS_SRC_ALPHA) ;Blending Based On Source Alpha And 1 Minus Dest Alpha
 DrawFloor() ;Draw The Floor To The Screen
 
 glEnable_(#GL_LIGHTING) ;Enable Lighting
 glDisable_(#GL_BLEND) ;Disable Blending
 glTranslatef_( 0.0, height, 0.0) ;Position The Ball At Proper Height
 glRotatef_(xrot,1.0,0.0,0.0) ;Rotate On The X Axis
 glRotatef_(yrot,0.0,1.0,0.0) ;Rotate On The Y Axis
 DrawObject() ;Draw The Ball
 
 xrot+xrotspeed ;Update X Rotation Angle By xrotspeed
 yrot+yrotspeed ;Update Y Rotation Angle By yrotspeed
 glFlush_() ;Flush The GL Pipeline
 
 ProcedureReturn #True ;Everything Went OK
 
EndProcedure

Procedure ProcessKeyboard() ;Process Keyboard Results

 If keys(#VK_RIGHT) And yrotspeed<2.5 ;Right Arrow Pressed
  yrotspeed+0.08 ;Increase yrotspeed
 EndIf
 If keys(#VK_LEFT) And yrotspeed>-2.5 ;Left Arrow Pressed
  yrotspeed-0.08 ;Decrease yrotspeed
 EndIf
 If keys(#VK_DOWN) And xrotspeed<2.5 ;Down Arrow Pressed
  xrotspeed+0.08 ;Increase xrotspeed
 EndIf
 If keys(#VK_UP) And xrotspeed>-2.5 ;Up Arrow Pressed
  xrotspeed-0.08 ;Decrease xrotspeed
 EndIf
 
 If keys(#VK_A) ;'A' Key Pressed
  zoom+0.05 ;Zoom In
 EndIf
 If keys(#VK_Z) ;'Z' Key Pressed
  zoom-0.05 ;Zoom Out
 EndIf
 
 If keys(#VK_PRIOR) ;Page Up Key Pressed
  height+0.03 ;Move Ball Up
 EndIf
 If keys(#VK_NEXT) ;Page Down Key Pressed
  height-0.03 ;Move Ball Down
 EndIf
 
EndProcedure

Procedure KillGLWindow() ;Properly Kill The Window

 gluDeleteQuadric_(q) ;Delete The Quadratic
 
 If fullscreen ;Are We In Fullscreen Mode?
  ChangeDisplaySettings_(#Null,0) ;If So Switch Back To The Desktop
  ShowCursor_(#True) ;Show Mouse Pointer
 EndIf
 
 If hRC ;Do We Have A Rendering Context?
  If wglMakeCurrent_(#Null,#Null)=0 ;Are We Able To Release The DC And RC Contexts?
   MessageBox_(#Null,"Release Of DC And RC Failed.","SHUTDOWN ERROR",#MB_OK | #MB_ICONINFORMATION)
  EndIf
  If wglDeleteContext_(hRC)=0 ;Are We Able To Delete The RC?
   MessageBox_(#Null,"Release Rendering Context Failed.","SHUTDOWN ERROR",#MB_OK | #MB_ICONINFORMATION)
  EndIf
  hRC=#Null ;Set RC To NULL
 EndIf
 
 If hDC And ReleaseDC_(hWnd,hDC)=0 ;Are We Able To Release The DC
  MessageBox_(#Null,"Release Device Context Failed.","SHUTDOWN ERROR",#MB_OK | #MB_ICONINFORMATION)
  hDC=#Null ;Set DC To NULL
 EndIf
 
 If hWnd And DestroyWindow_(hWnd)=0 ;Are We Able To Destroy The Window?
   MessageBox_(#Null,"Could Not Release hWnd.","SHUTDOWN ERROR",#MB_OK | #MB_ICONINFORMATION)
   hWnd=#Null ;Set hWnd To NULL
 EndIf
 
 If UnregisterClass_("OpenGL",hInstance)=0 ;Are We Able To Unregister Class
  MessageBox_(#Null,"Could Not Unregister Class.","SHUTDOWN ERROR",#MB_OK | #MB_ICONINFORMATION)
  hInstance=#Null ;Set hInstance To NULL
 EndIf
 
EndProcedure

;This Code Creates Our OpenGL Window. Parameters Are:
;title - Title To Appear At The Top Of The Window
;width - Width Of The GL Window Or Fullscreen Mode
;height - Height Of The GL Window Or Fullscreen Mode
;bits - Number Of Bits To Use For Color (8/16/24/32)
;fullscreenflag - Use Fullscreen Mode (TRUE) Or Windowed Mode (FALSE)

Procedure.b CreateGLWindow(title.s,width.l,height.l,bits.l,fullscreenflag.b)

 Protected PixelFormat.l ;Holds The Results After Searching For A Match
 Protected wc.WNDCLASS ;Windows Class Structure
 Protected dwExStyle.l ;Window Extended Style
 Protected dwStyle.l ;Window Style
 Protected WindowRect.RECT ;Grabs Rectangle Upper Left / Lower Right Values
 Protected wpos.POINT ;Window position
 
 WindowRect\left=0 ;Set Left Value To 0
 WindowRect\right=width ;Set Right Value To Requested Width
 WindowRect\top=0 ;Set Top Value To 0
 WindowRect\bottom=height ;Set Bottom Value To Requested Height
 
 fullscreen=fullscreenflag ;Set The Global Fullscreen Flag
 
 hInstance=GetModuleHandle_(#Null) ;Grab An Instance For Our Window
 
 wc\style=#CS_HREDRAW | #CS_VREDRAW | #CS_OWNDC ;Redraw On Size, And Own DC For Window
 wc\lpfnWndProc=@WndProc() ;WndProc Handles Messages
 wc\cbClsExtra=0 ;No Extra Window Data
 wc\cbWndExtra=0 ;No Extra Window Data
 wc\hInstance=hInstance ;Set The Instance
 wc\hIcon=LoadIcon_(#Null,#IDI_WINLOGO) ;Load The Default Icon
 wc\hCursor=LoadCursor_(#Null,#IDC_ARROW) ;Load The Arrow Pointer
 wc\hbrBackground=#Null ;No Background Required For GL
 wc\lpszMenuName=#Null ;We Don't Want A Menu
 wc\lpszClassName=@"OpenGL" ;Set The Class Name 
 
 If RegisterClass_(wc)=0 ;Attempt To Register The Window Class
  MessageBox_(#Null,"Failed To Register The Window Class.","ERROR",#MB_OK | #MB_ICONEXCLAMATION)
  ProcedureReturn #False
 EndIf
 
 If fullscreen ;Attempt Fullscreen Mode?
 
  Protected dmScreenSettings.DEVMODE ;Device Mode
  dmScreenSettings\dmSize=SizeOf(DEVMODE) ;Size Of The Devmode Structure
  dmScreenSettings\dmFields=#DM_BITSPERPEL | #DM_PELSWIDTH | #DM_PELSHEIGHT ;bit flags to specify the members of DEVMODE that were initialized
  dmScreenSettings\dmBitsPerPel=bits ;Selected Bits Per Pixel
  dmScreenSettings\dmPelsWidth=width ;Selected Screen Width in pixels
  dmScreenSettings\dmPelsHeight=height ;Selected Screen Height in pixels
 
  ;Try To Set Selected Mode And Get Results. Note: CDS_FULLSCREEN Gets Rid Of Start Bar
  If ChangeDisplaySettings_(dmScreenSettings,#CDS_FULLSCREEN)<>#DISP_CHANGE_SUCCESSFUL
   ;If The Mode Fails, Offer Two Options. Quit Or Use Windowed Mode
   If MessageBox_(#Null,"The Requested Fullscreen Mode Is Not Supported By"+Chr(10)+"Your Video Card. Use Windowed Mode Instead?","NeHe GL",#MB_YESNO | #MB_ICONEXCLAMATION)=#IDYES
    fullscreen=#False ;Windowed Mode Selected.  Fullscreen = FALSE
   Else
    ;Pop Up A Message Box Letting User Know The Program Is Closing
    MessageBox_(#Null,"Program Will Now Close.","ERROR",#MB_OK | #MB_ICONSTOP)
    ProcedureReturn #False
   EndIf
  EndIf
 
 EndIf
 
 If fullscreen ;Are We Still In Fullscreen Mode?
  dwExStyle=#WS_EX_APPWINDOW ;Window Extended Style
  dwStyle=#WS_POPUP ;Windows Style
  ShowCursor_(#False) ;Hide Mouse Pointer
 Else
  dwExStyle=#WS_EX_APPWINDOW | #WS_EX_WINDOWEDGE ;Window Extended Style
  dwStyle=#WS_OVERLAPPEDWINDOW ;Windows Style
 EndIf
 
 AdjustWindowRectEx_(WindowRect,dwStyle,#False,dwExStyle) ;Adjust Window To True Requested Size
 
 If fullscreen=0 ;if not fullscreen mode calculate screen centered window
  wpos\x=(GetSystemMetrics_(#SM_CXSCREEN)/2)-((WindowRect\right-WindowRect\left)/2)
  wpos\y=(GetSystemMetrics_(#SM_CYSCREEN)/2)-((WindowRect\bottom-WindowRect\top)/2)
 EndIf
 
 ;CreateWindowEx_(Extended Window Style, Class Name, Window Title, Window Style, Window X Position, Window Y Position, Width, Height, No Parent Window, No Menu, Instance, No Creation Data)
 hWnd=CreateWindowEx_(dwExStyle,"OpenGL",title,dwStyle | #WS_CLIPSIBLINGS | #WS_CLIPCHILDREN,wpos\x,wpos\y,WindowRect\right-WindowRect\left,WindowRect\bottom-WindowRect\top,#Null,#Null,hInstance,#Null)
 If hWnd=0
  KillGLWindow() ;Reset The Display
  MessageBox_(#Null,"Window Creation Error.","ERROR",#MB_OK | #MB_ICONEXCLAMATION)
  ProcedureReturn #False
 EndIf
 
 Protected pfd.PIXELFORMATDESCRIPTOR ;pfd Tells Windows How We Want Things To Be
 pfd\nSize=SizeOf(PIXELFORMATDESCRIPTOR) ;Size Of This Structure
 pfd\nVersion=1 ;Version Number
 pfd\dwFlags=#PFD_SUPPORT_OPENGL | #PFD_DOUBLEBUFFER | #PFD_DRAW_TO_WINDOW ;Format Must Support Window, OpenGL, Double Buffering
 pfd\iPixelType=#PFD_TYPE_RGBA ;Request An RGBA Format
 pfd\cColorBits=bits ;Select Our Color Depth
 pfd\cRedBits=0 ;Color Bits Ignored
 pfd\cRedShift=0
 pfd\cGreenBits=0
 pfd\cGreenShift=0
 pfd\cBlueBits=0
 pfd\cBlueShift=0
 pfd\cAlphaBits=0 ;No Alpha Buffer
 pfd\cAlphaShift=0 ;Shift Bit Ignored
 pfd\cAccumBits=0 ;No Accumulation Buffer
 pfd\cAccumRedBits=0 ;Accumulation Bits Ignored
 pfd\cAccumGreenBits=0
 pfd\cAccumBlueBits=0
 pfd\cAccumAlphaBits=0
 pfd\cDepthBits=16 ;16Bit Z-Buffer (Depth Buffer)
 pfd\cStencilBits=1 ;Use Stencil Buffer ( * Important * )
 pfd\cAuxBuffers=0 ;No Auxiliary Buffer
 pfd\iLayerType=#PFD_MAIN_PLANE ;Main Drawing Layer
 pfd\bReserved=0 ;Reserved
 pfd\dwLayerMask=0 ;Layer Masks Ignored
 pfd\dwVisibleMask=0
 pfd\dwDamageMask=0
 
 hDC=GetDC_(hWnd)
 If hDC=0 ;Did We Get A Device Context?
  KillGLWindow() ;Reset The Display
  MessageBox_(#Null,"Can't Create A GL Device Context.","ERROR",#MB_OK | #MB_ICONEXCLAMATION)
  ProcedureReturn #False
 EndIf
 
 PixelFormat=ChoosePixelFormat_(hDC,pfd)
 If PixelFormat=0 ;Did Windows Find A Matching Pixel Format?
  KillGLWindow() ;Reset The Display
  MessageBox_(#Null,"Can't Find A Suitable PixelFormat.","ERROR",#MB_OK | #MB_ICONEXCLAMATION)
  ProcedureReturn #False
 EndIf
 
 If SetPixelFormat_(hDC,PixelFormat,pfd)=0 ;Are We Able To Set The Pixel Format?
  KillGLWindow() ;Reset The Display
  MessageBox_(#Null,"Can't Set The PixelFormat.","ERROR",#MB_OK | #MB_ICONEXCLAMATION)
  ProcedureReturn #False
 EndIf
 
 hRC=wglCreateContext_(hDC)
 If hRC=0 ;Are We Able To Get A Rendering Context?
  KillGLWindow() ;Reset The Display
  MessageBox_(#Null,"Can't Create A GL Rendering Context.","ERROR",#MB_OK | #MB_ICONEXCLAMATION)
  ProcedureReturn #False
 EndIf
 
 If wglMakeCurrent_(hDC,hRC)=0 ;Try To Activate The Rendering Context
  KillGLWindow() ;Reset The Display
  MessageBox_(#Null,"Can't Activate The GL Rendering Context.","ERROR",#MB_OK | #MB_ICONEXCLAMATION)
  ProcedureReturn #False
 EndIf
 
 ShowWindow_(hWnd,#SW_SHOW) ;Show The Window
 SetForegroundWindow_(hWnd) ;Slightly Higher Priority
 SetFocus_(hWnd) ;Sets Keyboard Focus To The Window
 ReSizeGLScene(width,height) ;Set Up Our Perspective GL Screen
 
 If InitGL()=0 ;Initialize Our Newly Created GL Window
  KillGLWindow() ;Reset The Display
  MessageBox_(#Null,"Initialization Failed.","ERROR",#MB_OK | #MB_ICONEXCLAMATION)
  ProcedureReturn #False
 EndIf
 
 ProcedureReturn #True ;Success
 
EndProcedure

Procedure.l WndProc(hWnd.l,uMsg.l,wParam.l,lParam.l)

 Select uMsg ;Check For Windows Messages
 
  Case #WM_ACTIVATE ;Watch For Window Activate Message
   If HiWord(wParam)=0 ;Check Minimization State
    active=#True ;Program Is Active
   Else
    active=#False ;Program Is No Longer Active
   EndIf
   ProcedureReturn 0 ;Return To The Message Loop
   
  Case #WM_SYSCOMMAND ;Intercept System Commands
   Select wParam ;Check System Calls
    Case #SC_SCREENSAVE ;Screensaver Trying To Start?
     ProcedureReturn 0 ;Prevent From Happening
    Case #SC_MONITORPOWER ;Monitor Trying To Enter Powersave?
     ProcedureReturn 0 ;Prevent From Happening
   EndSelect
   
  Case #WM_CLOSE ;Did We Receive A Close Message?
   PostQuitMessage_(0) ;Send A Quit Message
   ProcedureReturn 0 ;Jump Back
   
  Case #WM_KEYDOWN ;Is A Key Being Held Down?
   keys(wParam)=#True ;If So, Mark It As TRUE
   ProcedureReturn 0 ;Jump Back
   
  Case #WM_KEYUP ;Has A Key Been Released?
   keys(wParam)=#False ;If So, Mark It As FALSE
   ProcedureReturn 0 ;Jump Back
   
  Case #WM_SIZE ;Resize The OpenGL Window
   ReSizeGLScene(LoWord(lParam),HiWord(lParam)) ;LoWord=Width, HiWord=Height
   ProcedureReturn 0 ;Jump Back
   
 EndSelect
 
 ;Pass All Unhandled Messages To DefWindowProc
 ProcedureReturn DefWindowProc_(hWnd,uMsg,wParam,lParam)
 
EndProcedure

Procedure.l WinMain() ;Main Program

 Protected msg.MSG ;Windows Message Structure
 Protected done.b ;Bool Variable To Exit Loop
 
 ;Ask The User Which Screen Mode They Prefer
 If MessageBox_(#Null,"Would You Like To Run In Fullscreen Mode?","Start FullScreen?",#MB_YESNO | #MB_ICONQUESTION)=#IDNO
  fullscreen=#False ;Windowed Mode
 EndIf
 
 If CreateGLWindow("Banu Octavian & NeHe's Stencil & Reflection Tutorial",640,480,32,fullscreen)=0 ;Create The Window
  ProcedureReturn 0 ;Quit If Window Was Not Created
 EndIf
 
 While done=#False ;Loop That Runs While done=FALSE
 
  If PeekMessage_(msg,#Null,0,0,#PM_REMOVE) ;Is There A Message Waiting?
 
   If msg\message=#WM_QUIT ;Have We Received A Quit Message?
    done=#True ;If So done=TRUE
   Else ;If Not, Deal With Window Messages
    TranslateMessage_(msg) ;Translate The Message
    DispatchMessage_(msg) ;Dispatch The Message
   EndIf
   
  Else ;If There Are No Messages
 
   ;Draw The Scene. Watch For ESC Key And Quit Messages From DrawGLScene()
   If (active And DrawGLScene()=0) Or keys(#VK_ESCAPE) ;Active? Was There A Quit Received?
   
    done=#True ;ESC or DrawGLScene Signalled A Quit
   
   Else ;Not Time To Quit, Update Screen
   
    SwapBuffers_(hDC) ;Swap Buffers (Double Buffering)
   
    ProcessKeyboard() ;Processed Keyboard Presses
   
   EndIf
   
   If keys(#VK_F1) ;Is F1 Being Pressed?
    keys(#VK_F1)=#False ;If So Make Key FALSE
    KillGLWindow() ;Kill Our Current Window
    fullscreen=~fullscreen & 1 ;Toggle Fullscreen / Windowed Mode
    ;Recreate Our OpenGL Window
    If CreateGLWindow("Banu Octavian & NeHe's Stencil & Reflection Tutorial",640,480,32,fullscreen)=0
     ProcedureReturn 0 ;Quit If Window Was Not Created
    EndIf
   EndIf
   
  EndIf
 
 Wend
 
 ;Shutdown
 KillGLWindow() ;Kill The Window
 End ;Exit The Program
 
EndProcedure

WinMain() ;run the main program


; IDE Options = PureBasic 4.20 Beta 2 (Windows - x86)
; CursorPosition = 627
; FirstLine = 582
; Folding = ----
; DisableDebugger