;Geomod, logiciel de mapping pour M2TW
;Ncessite l'activation du support Unicode (options de compilateur)

;OUTILS
;////////////////////
;BINEDITOR
;DEBOGUEUR
;GENERATEUR DE CARTES
;Religions (*nombre de religions)
;Agriculture
;Nombre d'habitants
;Rebelles
;Mercenaires
;Faction cratrice/par dfaut
;Faction actuelle

;-Initializations

;{-Dmarrage

;Macros
XIncludeFile "include\macro.pbi"

;Constantes
XIncludeFile "include\const.pbi"

;Instruction pour le debogueur
EnableExplicit

;Utilisation des dcodeurs d'images TGA et PNG
UseTGAImageDecoder()
UsePNGImageDecoder()

;Fonctions de mapgen.pbi
Declare MapGen()

;Fonctions de traitement de l'image maps.pbi
Declare.l SubColor(X.l,Y.l) ;Renvoie la couleur suppose de la rgion de la ville ou du port aux coordonnes (x;y)
Declare.l ChangeColor(Color.l) ;Change la couleur d'une rgion sur la carte
Declare LoadGrid() ;Cre les deux sprites pour afficher les grilles
Declare SaveTGA(Image.l,File$,Starting.b,Ending.b) ;Sauvegarde d'un fichier au format TGA
Declare ResizeWorld() ;Zoome, dzoome, et transforme les images en sprites
Declare.l DisplayMap(X.l,Y.l,Option.l) ;Affichage de la carte et de la grille
Declare DisplayScreen() ;Affichage de l'cran

;Fonctions de gestion des commandes cmd.pbi
Declare Keyboard() ;Gestion du clavier et de la 'camra'
Declare Mouse(Event.l) ;Gestion de la souris, dans (Option=1) ou en-dehors de l'cran (Option=0)

;Fonctions de gestion des rgions region.pbi
Declare.b SelectRegion(*Address) ;Slection d'une rgion, mise  jour des gadgets
Declare.b UpdateRegion(Option.b) ;Suppression, mise  jour ou rajout d'une rgion

;Fonctions de gestion des factions faction.pbi
Declare.b SelectFaction(*Address) ;Slection d'une rgion, mise  jour des gadgets
Declare.b UpdateFaction() ;Mise  jour des donnes d'une faction

;Fonctions de gestion des options de campagne campaign.pbi
Declare.b SelectCampaign() ;Chargement des options de campagne
Declare.b UpdateCampaign() ;Mise  jour des options de campagne

;Fonctions pour la gnration de cartes rcapitulatives mapgen.pbi
Declare MapGen() ;Gnration et sauvegarde des cartes rcapitulatives

;Fonctions de sauvegarde save.pbi
Declare SaveRegion() ;Sauvegarde le fichier descr_regions.txt  partir des donnes sauvegardes

;Fonctions fentres win.pbi, contient aussi la fentre principale
Declare About() ;Procdure de l' propos
Declare Progress(Text$) ;Procdure de la fentre de progression (sauvegardes, chargements, etc.)
Declare Error(Text$) ;Envoie un message d'erreur
Declare FatalError(Text$) ;Envoie un message d'erreur et termine le programme
Declare AddBuilding(Text$) ;Fentre pour l'ajout d'un btiment valide
Declare CreateCursor() ;Chargement des images pour le curseur
Declare.b UpdateDrawingFeatures(Map.b) ;Mise  jour de la liste des lments de dessin
Declare UpdateStatus(Event.l)

;Fonctions courantes
Declare.q Ticks() ;Chronomtre

;Environnement gnral
If Not InitKeyboard() Or Not InitMouse() Or Not InitSprite() : FatalError("Impossible d'initialiser le programme.") : EndIf

;}

;{-Variables et listes

;Structures
XIncludeFile "include\struct.pbi"

;Variables
Define Event.l,EventGadget.l,EventMenu.l
Define Total.b,Text$,Music$,Faction$,Castle.b,Level.b,Color.l,Item.l
Define *First,*Second,*Address
Define *Faction,*Region
Define Blue.l,Green.l,Red.l,X.l,Y.l,bmp.BITMAP
Define String$,Com.l,Length.w,Type.w,Number.w,Error.b
Define Coord.POINT
;Compteurs
Define i.l,j.l
;Variables globales
Global OriClimate.BITMAP,OriGroundType.BITMAP,OriHeight.BITMAP,OriRegion.BITMAP
Global OriFeature.BITMAP,OriCity.BITMAP,OriResource.BITMAP,OriArmy.BITMAP
Global OriSelected.BITMAP,OriGeneric.BITMAP
Global Path$,Gen$,SelectedRegion.l,DrawColor.l,BackColor.l
Global Cam.POINT,Mouse.POINT,WinMouse.POINT,Position.POINT,Vertex.POINT
Global Scale.b,Cursor.b,Map.l,Grid.b,InScreen.b
Global Campaign.campaign ;Caractristiques de la campagne
;Listes
Global Dim Files.s(#Files-1)
Global Dim NonColor.l(6)
Global Dim Climate.map(9)
Global Dim Ground.map(14)
Global Dim Standings.b(0,0)
Global Dim Relationships.b(0,0)
;Listes chanes
Global NewList Regions.region() ;Toutes les donnes des rgions
Global NewList Resources.resource() ;L'emplacement des ressources
Global NewList Religions.name() ;Liste des religions
Global NewList RebelFactions.name() ;Liste des rebelles
Global NewList Factions.faction() ;Liste des factions
Global NewList Mercenaries.mercenary() ;Liste des pools de mercenaires avec les units correspondantes
Global NewList Buildings.building() ;Liste de tous les btiments possibles
Global NewList Characters.char() ; Liste de tous les personnages
NewList Names.name() ;Liste temporaire, n'est utile qu' l'ouverture des fichiers, cf. open.pbi

;Valeurs initiales
SelectedRegion=-1
Cursor=#MouseArrow
Map=#Region
Scale=2
Cam\X=0
Cam\Y=0
BackColor=$404040
Gen$=GetCurrentDirectory()

;}

;{-Listes

;Choix du mod
Path$=PathRequester("Choisissez le rpertoire d'un mod pour le modifier :",Gen$)
If Path$="" : FatalError("Vous n'avez choisi aucun mod.") : EndIf


;Fichiers

Files(#MapClimates)="data\world\maps\base\map_climates.tga"
Files(#MapGroundTypes)="data\world\maps\base\map_ground_types.tga"
Files(#MapHeights)="data\world\maps\base\map_heights.tga"
Files(#MapRegions)="data\world\maps\base\map_regions.tga"
Files(#MapFeatures)="data\world\maps\base\map_features.tga"
Files(#DescrRegions)="data\world\maps\base\descr_regions.txt"
Files(#DescrSoundsMusicTypes)="data\world\maps\base\descr_sounds_music_types.txt"
Files(#DescrStrat)="data\world\maps\campaign\imperial_campaign\descr_strat.txt"
Files(#DescrMercenaries)="data\world\maps\campaign\imperial_campaign\descr_mercenaries.txt"
Files(#DescrWinConditions)="data\world\maps\campaign\imperial_campaign\descr_win_conditions.txt"
Files(#RebelFactions)="data\text\rebel_faction_descr.txt.strings.bin"
Files(#Religions)="data\text\religions.txt.strings.bin"
Files(#Regions)="data\text\imperial_campaign_regions_and_settlement_names.txt.strings.bin"
Files(#Expanded)="data\text\expanded.txt.strings.bin"
Files(#DescrSmFactions)="data\descr_sm_factions.txt"
Files(#DescrRebelFactions)="data\descr_rebel_factions.txt"
Files(#DescrReligions)="data\descr_religions.txt"
Files(#EDB)="data\export_descr_buildings.txt"

;Vrification de la prsence des fichiers
For i=0 To #Files-1
  If FileSize(Path$+Files(i))<0
    Text$+#CRLF$+Files(i)+" "
    Total+1
  EndIf
Next i
If Total=1
  FatalError("Le fichier suivant est introuvable :"+Text$)
ElseIf Total>1
  FatalError("Les fichiers suivants sont introuvables :"+Text$)
EndIf

;Couleurs interdites
NonColor(0)=-1
NonColor(1)=#Black
NonColor(2)=#White
NonColor(3)=#Sea
NonColor(4)=#Lake
NonColor(5)=#Caspian
NonColor(6)=#Erythrea

;Climats
Climate(0)\Color=#Alpine : Climate(0)\Name$="Alpin"
Climate(1)\Color=#Highland : Climate(1)\Name$="Montagnard"
Climate(2)\Color=#Mediterr : Climate(2)\Name$="Mditerranen"
Climate(3)\Color=#Rocky : Climate(3)\Name$="Dsert rocheux"
Climate(4)\Color=#Sandy : Climate(4)\Name$="Dsert de sable"
Climate(5)\Color=#SemiArid : Climate(5)\Name$="Semi-aride"
Climate(6)\Color=#Steppe : Climate(6)\Name$="Steppe"
Climate(7)\Color=#TempCold : Climate(7)\Name$="Tempr - fort de conifres"
Climate(8)\Color=#TempWarm : Climate(8)\Name$="Tempr - fort d'arbres  feuilles caduques"
Climate(9)\Color=#Tropical : Climate(9)\Name$="Tropical"

Ground(0)\Color=#LowFer : Ground(0)\Name$="Fertilit basse"
Ground(1)\Color=#MedFer : Ground(1)\Name$="Fertilit moyenne"
Ground(2)\Color=#HighFer : Ground(2)\Name$="Fertilit haute"
Ground(3)\Color=#Desert : Ground(3)\Name$="Dsert"
Ground(4)\Color=#HighMount : Ground(4)\Name$="Montagnes hautes"
Ground(5)\Color=#LowMount : Ground(5)\Name$="Montagnes basses"
Ground(6)\Color=#Hill : Ground(6)\Name$="Collines"
Ground(7)\Color=#DenseForest : Ground(7)\Name$="Forts denses"
Ground(8)\Color=#SparseForest : Ground(8)\Name$="Forts parses"
Ground(9)\Color=#Wetland : Ground(9)\Name$="Zone humide"
Ground(10)\Color=#Ocean : Ground(10)\Name$="Ocan"
Ground(11)\Color=#DeepSea : Ground(11)\Name$="Mer profonde"
Ground(12)\Color=#CoastSea : Ground(12)\Name$="Mer ctire"
Ground(13)\Color=#Beach : Ground(13)\Name$="Plage"
Ground(14)\Color=#Impassable : Ground(14)\Name$="Infranchissable"

;}

XIncludeFile "include\maps.pbi"
XIncludeFile "include\cmd.pbi"
XIncludeFile "include\region.pbi"
XIncludeFile "include\faction.pbi"
XIncludeFile "include\campaign.pbi"
XIncludeFile "include\mapgen.pbi"
XIncludeFile "include\save.pbi"
XIncludeFile "include\win.pbi" ;Ncessaire pour l'ouverture de la fentre principale
XIncludeFile "include\open.pbi" ;Ouverture des fichiers, lecture des informations, cration des cartes, etc.

;Initialisation des cartes cres
ResizeWorld() : LoadGrid()

;Chargement des donnes de la campagne
SelectCampaign()

;Current procedures
Procedure.q Ticks()
  Static MaxFreq.q
  Protected Time.q
  If MaxFreq=0
    QueryPerformanceFrequency_(@MaxFreq)
    MaxFreq=MaxFreq/1000
  EndIf
  QueryPerformanceCounter_(@Time)
  ProcedureReturn Time/MaxFreq
EndProcedure

;**********************************************************************************************************
;-Main loop
;**********************************************************************************************************

Repeat
  
  ;En attente d'un vnement
  Event=WaitWindowEvent(#TimeOut) ;Un dlai pour mnager le CPU
  
  Select Event
    
    Case 0,#WM_MOUSEMOVE
      
    ;******************************************************************************************************
    ;- > > Gadget events
    
    Case #PB_Event_Gadget
      EventGadget=EventGadget()
      Select EventGadget
        
        ;- > Drawing
        Case #Zoom
          ;Si l'chelle est infrieure  l'chelle maximale on transforme le curseur
          If Scale<16 And Not Cursor=#MouseZoom
            Cursor=#MouseZoom
            SetGadgetState(#CoordCityButton,0)
            SetGadgetState(#CoordPortButton,0)
            SetGadgetState(#DrawButton,0)
            SetGadgetState(#DrawFill,0)
            SetGadgetState(#DrawSample,0)
          Else
            Cursor=#MouseArrow
          EndIf
        Case #UnZoom
          ;Curseur par dfaut
          If Cursor=#MouseZoom : Cursor=#MouseArrow : SetGadgetState(#Zoom,0) : EndIf
          ;Si l'chelle n'est pas minimale on change l'chelle et on recharge les cartes
          If Scale>1
            ;On change l'emplacement de la camra pour garder le centre de l'image au centre de l'cran
            Cam\X-Scale-#Screen2/Scale
            Cam\Y-Scale-#Screen2/Scale
            ;On change l'chelle et on recharge les cartes
            Scale/2
            ResizeWorld()
            ;On recharge les grilles
            LoadGrid()
            ;Si l'chelle prcdente tait maximale on rhabilite le gadget de zoomage
            If Scale=8 : DisableGadget(#Zoom,0) : EndIf
            ;Si l'chelle minimale est atteinte on rforme le gadget de dzoomage
            If Scale=1 : DisableGadget(#UnZoom,1) : EndIf
          EndIf
        Case #OptionVertex
          If Grid%2 : Grid-1 : Else : Grid+1 : EndIf
        Case #OptionPosition
          If Grid<2 : Grid+2 : Else : Grid-2 : EndIf
        Case #Climate To #Region
          Map=EventGadget
        Case #DrawButton
          If GetGadgetState(#DrawButton)
            Cursor=#MousePoint
            SetGadgetState(#CoordCityButton,0)
            SetGadgetState(#CoordPortButton,0)
            SetGadgetState(#Zoom,0)
            SetGadgetState(#DrawFill,0)
            SetGadgetState(#DrawSample,0)
          Else
            Cursor=#MouseArrow
          EndIf
        Case #DrawFill
          If GetGadgetState(#DrawFill)
            Cursor=#MouseColor
            SetGadgetState(#CoordCityButton,0)
            SetGadgetState(#CoordPortButton,0)
            SetGadgetState(#Zoom,0)
            SetGadgetState(#DrawButton,0)
            SetGadgetState(#DrawSample,0)
          Else
            Cursor=#MouseArrow
          EndIf
        Case #DrawSample
          If GetGadgetState(#DrawSample)
            Cursor=#MouseSample
            SetGadgetState(#CoordCityButton,0)
            SetGadgetState(#CoordPortButton,0)
            SetGadgetState(#Zoom,0)
            SetGadgetState(#DrawButton,0)
            SetGadgetState(#DrawFill,0)
          Else
            Cursor=#MouseArrow
          EndIf
        Case #DrawMap
          UpdateDrawingFeatures(GetGadgetState(#DrawMap))
        Case #DrawElement
          DrawColor=GetGadgetItemData(#DrawElement,GetGadgetState(#DrawElement))
          SetGadgetColor(#DrawColor,#PB_Gadget_BackColor,DrawColor)
          SetGadgetText(#DrawRed,Str(Red(DrawColor)))
          SetGadgetText(#DrawGreen,Str(Green(DrawColor)))
          SetGadgetText(#DrawBlue,Str(Blue(DrawColor)))
        Case #DrawTrack
          Item=GetGadgetState(#DrawTrack)
          If Item>99
            Item-100
            DrawColor=RGB(Item,Item,Item)
          Else
            DrawColor=RGB(0,0,255-99+Item)
          EndIf
          SetGadgetColor(#DrawColor,#PB_Gadget_BackColor,DrawColor)
          SetGadgetText(#DrawRed,Str(Red(DrawColor)))
          SetGadgetText(#DrawGreen,Str(Green(DrawColor)))
          SetGadgetText(#DrawBlue,Str(Blue(DrawColor)))
        
        ;- > Regions
        Case #ListRegion
          SelectRegion(GetGadgetItemData(#ListRegion,GetGadgetState(#ListRegion)))
        Case #Unselect : SelectedRegion=-1 : SelectRegion(0)
        Case #New : UpdateRegion(1) : ReleaseMouse(#False) : InScreen=#True : MouseLocate(#Screen2,#Screen2)
        Case #Validate : UpdateRegion(0)
        Case #Suppr : UpdateRegion(-1)
        Case #Up
          Item=GetGadgetState(#ListRegion)
          If Item>0
            Text$=GetGadgetText(#ListRegion)
            *First=GetGadgetItemData(#ListRegion,Item)
            *Second=GetGadgetItemData(#ListRegion,Item-1)
            SetGadgetItemText(#ListRegion,Item,GetGadgetItemText(#ListRegion,Item-1))
            SetGadgetItemText(#ListRegion,Item-1,Text$)
            SetGadgetItemData(#ListRegion,Item-1,*First)
            SetGadgetItemData(#ListRegion,Item,*Second)
            SwapElements(Regions(),*First,*Second)
            SetGadgetState(#ListRegion,Item-1)
          EndIf
        Case #Down
          Item=GetGadgetState(#ListRegion)
          If Item<CountGadgetItems(#ListRegion)-1
            Text$=GetGadgetText(#ListRegion)
            *First=GetGadgetItemData(#ListRegion,Item)
            *Second=GetGadgetItemData(#ListRegion,Item+1)
            SetGadgetItemText(#ListRegion,Item,GetGadgetItemText(#ListRegion,Item+1))
            SetGadgetItemText(#ListRegion,Item+1,Text$)
            SetGadgetItemData(#ListRegion,Item+1,*First)
            SetGadgetItemData(#ListRegion,Item,*Second)
            SwapElements(Regions(),*First,*Second)
            SetGadgetState(#ListRegion,Item+1)
          EndIf
        Case #CoordCityButton
          If SelectedRegion=-1 : SetGadgetState(#CoordCityButton,0)
          Else
            If GetGadgetState(#CoordCityButton)
              Cursor=#MousePoint
              SetGadgetState(#DrawButton,0)
              SetGadgetState(#CoordPortButton,0)
              SetGadgetState(#Zoom,0)
              SetGadgetState(#DrawFill,0)
              SetGadgetState(#DrawSample,0)
            Else
              Cursor=#MouseArrow
            EndIf
          EndIf
        Case #CoordPortButton
          If SelectedRegion=-1 : SetGadgetState(#CoordPortButton,0)
          Else
            If GetGadgetState(#CoordPortButton)
              Cursor=#MousePoint
              SetGadgetState(#DrawButton,0)
              SetGadgetState(#CoordCityButton,0)
              SetGadgetState(#Zoom,0)
              SetGadgetState(#DrawFill,0)
              SetGadgetState(#DrawSample,0)
            Else
              Cursor=#MouseArrow
            EndIf
          EndIf
        Case #SpinRed,#SpinGreen,#SpinBlue
          SetGadgetColor(#ColorContainer,#PB_Gadget_BackColor,RGB(GetGadgetState(#SpinRed),GetGadgetState(#SpinGreen),GetGadgetState(#SpinBlue)))
        Case #AleaColor
          Color=ChangeColor(0) : SetGadgetState(#SpinRed,Red(Color)) : SetGadgetState(#SpinGreen,Green(Color)) : SetGadgetState(#SpinBlue,Blue(Color)) : SetGadgetColor(#ColorContainer,#PB_Gadget_BackColor,Color)
        Case #ChangeColor
          Color=GetGadgetColor(#ColorContainer,#PB_Gadget_BackColor)
          If Color<>0
            Color=ChangeColor(Color)
            If Color=-1 : Error("Cette couleur est interdite.")
            ElseIf Color=-2 : Error("Cette couleur est dj utilise pour une autre rgion.") : EndIf
          Else
            Error("Le noir n'est pas une couleur valide !")
          EndIf
        Case #SpinA,#SpinB,#SpinC,#SpinD,#SpinE,#SpinF,#SpinG,#SpinH,#SpinI,#SpinJ
          Total=0
          For i=0 To CountList(Religions())-1
            Total+Val(GetGadgetText(#SpinA+2*i))
          Next i
          If Total=100 : SetGadgetColor(#TotalReligion,#PB_Gadget_FrontColor,#Black) : Else : SetGadgetColor(#TotalReligion,#PB_Gadget_FrontColor,#Rouge) : EndIf
          SetGadgetText(#TotalReligion,Str(Total))
        Case #Castle
          Text$=GetGadgetText(#Castle)
          If Text$="Ville"
            SetGadgetText(#Castle,"Chteau")
          ElseIf Text$="Chteau"
            SetGadgetText(#Castle,"Ville")
          EndIf
        Case #BuildingsAdd
          ChangeCurrentElement(Regions(),GetGadgetItemData(#ListRegion,GetGadgetState(#ListRegion)))
          AddBuilding(Regions()\City\Out$)
        Case #BuildingsSuppr
          i=GetGadgetState(#ListBuildings)
          If i=-1 : Error("Aucun btiment n'est slectionn !")
          Else : RemoveGadgetItem(#ListBuildings,i) : EndIf
        Case #ResourcesAdd
          Text$=GetGadgetText(#ResourcesRegion)
          If Text$="" : MessageRequester("Erreur !","Aucune ressource  ajouter !")
          Else : AddGadgetItem(#ListResources,-1,Text$) : SetGadgetText(#ResourcesRegion,"") : EndIf
        Case #ResourcesSuppr
          i=GetGadgetState(#ListResources)
          If i=-1 : Error("Aucune ressource n'est slectionne !")
          Else : RemoveGadgetItem(#ListResources,i) : EndIf
        
        ;- > Factions
        Case #ListFaction,#CancelFaction
          SelectFaction(GetGadgetItemData(#ListFaction,GetGadgetState(#ListFaction)))
        Case #UnselectFaction
          SelectFaction(0)
        Case #ValidateFaction
          UpdateFaction()
        Case #SpecialTypeText
          If GetGadgetState(#SpecialTypeText) : DisableGadget(#SpecialType,0) : Else : DisableGadget(#SpecialType,1) : EndIf
        Case #FPrimaryRed To #FPrimaryBlue
          SetGadgetColor(#FPrimaryColor,#PB_Gadget_BackColor,RGB(GetGadgetState(#FPrimaryRed),GetGadgetState(#FPrimaryGreen),GetGadgetState(#FPrimaryBlue)))
        Case #FSecondaryRed To #FSecondaryBlue
          SetGadgetColor(#FSecondaryColor,#PB_Gadget_BackColor,RGB(GetGadgetState(#FSecondaryRed),GetGadgetState(#FSecondaryGreen),GetGadgetState(#FSecondaryBlue)))
        Case #FamilyTree
          If GetGadgetState(#FamilyTree)
            SetGadgetState(#FamilyTreeNormal,1)
            DisableGadget(#FamilyTreeNormal,0)
            DisableGadget(#FamilyTreeTeutonic,0)
          Else
            SetGadgetState(#FamilyTreeNormal,0)
            SetGadgetState(#FamilyTreeTeutonic,0)
            DisableGadget(#FamilyTreeNormal,1)
            DisableGadget(#FamilyTreeTeutonic,1)
          EndIf
        Case #CanDeath
          If GetGadgetState(#CanDeath)
            SetGadgetState(#CanDeathYes,1)
            DisableGadget(#CanDeathYes,0)
            DisableGadget(#CanDeathNo,0)
          Else
            SetGadgetState(#CanDeathYes,0)
            SetGadgetState(#CanDeathNo,0)
            DisableGadget(#CanDeathYes,1)
            DisableGadget(#CanDeathNo,1)
          EndIf
        Case #DisbandPool
          If GetGadgetState(#DisbandPool)
            SetGadgetState(#DisbandPoolYes,1)
            DisableGadget(#DisbandPoolYes,0)
            DisableGadget(#DisbandPoolNo,0)
          Else
            SetGadgetState(#DisbandPoolYes,0)
            SetGadgetState(#DisbandPoolNo,0)
            DisableGadget(#DisbandPoolYes,1)
            DisableGadget(#DisbandPoolNo,1)
          EndIf
        Case #BuildTower
          If GetGadgetState(#BuildTower)
            SetGadgetState(#BuildTowerYes,1)
            DisableGadget(#BuildTowerYes,0)
            DisableGadget(#BuildTowerNo,0)
          Else
            SetGadgetState(#BuildTowerYes,0)
            SetGadgetState(#BuildTowerNo,0)
            DisableGadget(#BuildTowerYes,1)
            DisableGadget(#BuildTowerNo,1)
          EndIf
        Case #CanHordeText
          If GetGadgetState(#CanHordeText)
            DisableGadget(#HordeMinUnits,0) : SetGadgetState(#HordeMinUnits,1) : SetGadgetText(#HordeMinUnits,"1")
            DisableGadget(#HordeMaxUnits,0) : SetGadgetState(#HordeMaxUnits,1) : SetGadgetText(#HordeMaxUnits,"1")
            DisableGadget(#HordeReduction,0) : SetGadgetState(#HordeReduction,1) : SetGadgetText(#HordeReduction,"1")
            DisableGadget(#HordePopulation,0) : SetGadgetState(#HordePopulation,1) : SetGadgetText(#HordePopulation,"1")
            DisableGadget(#HordeCharacter,0) : SetGadgetState(#HordeCharacter,1) : SetGadgetText(#HordeCharacter,"1")
            DisableGadget(#HordeArmy,0) : SetGadgetState(#HordeArmy,0) : SetGadgetText(#HordeArmy,"0")
          Else
            DisableGadget(#HordeMinUnits,1) : SetGadgetText(#HordeMinUnits,"")
            DisableGadget(#HordeMaxUnits,1) : SetGadgetText(#HordeMaxUnits,"")
            DisableGadget(#HordeReduction,1) : SetGadgetText(#HordeReduction,"")
            DisableGadget(#HordePopulation,1) : SetGadgetText(#HordePopulation,"")
            DisableGadget(#HordeCharacter,1) : SetGadgetText(#HordeCharacter,"")
            DisableGadget(#HordeArmy,1) : SetGadgetText(#HordeArmy,"")
          EndIf
        Case #Emerging
          If GetGadgetState(#Emerging)>1 And GetGadgetState(#ListFaction)>-1
            ClearGadgetItemList(#EmergingSecondary)
            ForEach Factions()
              If Factions()\Status\Playable>0
                If GetGadgetItemData(#ListFaction,GetGadgetState(#ListFaction))<>@Factions()
                  AddGadgetItem(#EmergingSecondary,-1,Factions()\Name\Out$)
                  SetGadgetItemData(#EmergingSecondary,CountGadgetItems(#ListFaction)-1,@Factions())
                EndIf
              EndIf
            Next
            If CountGadgetItems(#EmergingSecondary)>10 : ResizeGadget(#EmergingSecondary,#PB_Ignore,#PB_Ignore,#PB_Ignore,200)
            Else : ResizeGadget(#EmergingSecondary,#PB_Ignore,#PB_Ignore,#PB_Ignore,20*CountGadgetItems(#EmergingSecondary)) : EndIf
            SetGadgetState(#EmergingSecondary,0)
            DisableGadget(#EmergingSecondary,0)
          Else
            ClearGadgetItemList(#EmergingSecondary)
            SetGadgetState(#EmergingSecondary,-1)
            DisableGadget(#EmergingSecondary,1)
          EndIf
          
        ;- > Options
        Case #StartDateSeason : If GetGadgetText(#StartDateSeason)="Hiver" : SetGadgetText(#StartDateSeason,"t") : Else : SetGadgetText(#StartDateSeason,"Hiver") : EndIf
        Case #EndDateSeason : If GetGadgetText(#EndDateSeason)="Hiver" : SetGadgetText(#EndDateSeason,"t") : Else : SetGadgetText(#EndDateSeason,"Hiver") : EndIf
        Case #TimeScale
          Type=EventType()
          If Type=1
            If ValF(GetGadgetText(#TimeScale))<99.99
              SetGadgetText(#TimeScale,StrF(ValF(GetGadgetText(#TimeScale))+0.01,2))
            EndIf
          ElseIf Type=-1
            If ValF(GetGadgetText(#TimeScale))>0.01
              SetGadgetText(#TimeScale,StrF(ValF(GetGadgetText(#TimeScale))-0.01,2))
            EndIf
          EndIf
        Case #UpkeepText
          SetGadgetState(#Upkeep,0)
          If GetGadgetState(#UpkeepText)
            SetGadgetText(#Upkeep,"0")
            DisableGadget(#Upkeep,0)
          Else
            SetGadgetText(#Upkeep,"")
            DisableGadget(#Upkeep,1)
          EndIf
        Case #OptionAdd
          Text$=GetGadgetText(#OptionText)
          If Text$="" : Error("Aucune option  ajouter !")
          Else : AddGadgetItem(#ListOption,-1,Text$) : SetGadgetText(#OptionText,"") : EndIf
        Case #OptionSuppr
          i=GetGadgetState(#ListOption)
          If i=-1 : Error("Aucune option n'est slectionne !")
          Else : RemoveGadgetItem(#ListOption,i) : EndIf
        Case #ValidateAll : If UpdateCampaign() : MessageRequester("Information","Mise  jour effectue avec succs !") : EndIf
        Case #CancelAll : SelectCampaign()
      EndSelect
      
    ;******************************************************************************************************
    ;- > > Menu events
    
    Case #PB_Event_Menu
      ;Il faut librer la souris  chaque vnement dans le menu
      ;Pour viter la capture de la souris par l'cran fentr
      EventMenu=EventMenu() : InScreen=0 : ReleaseMouse(#True)
      Select EventMenu
        Case #Renew
          If RunProgram(GetFilePart(ProgramFilename()))
            End
          Else
            Error("Le programme doit tre redmarr manuellement.")
          EndIf
        Case #Save
          SaveRegion()
          MessageRequester("Information","Sauvegarde effectue !")
        Case #Quit
          End
        Case #MapGen
          Gen$=PathRequester("Choisissez le dossier",Gen$)
          If Gen$="" : Gen$=GetCurrentDirectory() : Else : MapGen() : EndIf
        Case #BinEditor
          If Not RunProgram("BinEditor.exe")
            Error("Impossible de trouver de le BinEditor !")
          EndIf
        Case #BackColor
          i=ColorRequester(BackColor) : If i>-1 : BackColor=i : EndIf
        Case #Help
          MessageRequester("Information","Message d'aide !")
        Case #About
          About()
      EndSelect
      
    ;******************************************************************************************************
    ;- > > Other events
    
    Case #PB_Event_CloseWindow
      ;Fermeture du programme
      End
  EndSelect
  
  ;Gestion du clavier
  Keyboard()
  
  ;Gestion de la souris
  If IsScreenActive() : Mouse(Event) : EndIf
  
  ;Affichage de l'cran
  DisplayScreen()
  
  ;Mise  jour de la barre d'tat
  UpdateStatus(Event)
  
  ;Mise  jour de la fentre
  UpdateWindow_(WindowID(#Win))
  
ForEver

;-Data

DataSection

Cursor:

Data.b #MouseArrow
Data.s "media\arrow.png"

Data.b #MouseZoom
Data.s "media\zoom.png"

Data.b #MouseBrush
Data.s "media\brush.png"

Data.b #MouseColor
Data.s "media\color.png"

Data.b #MousePoint
Data.s "media\point.png"

Data.b #MouseSample
Data.s "media\sample.png"

EndDataSection

; IDE Options = PureBasic 4.10 (Windows - x86)
; CursorPosition = 253
; Folding = w
; EnableUnicode
; UseIcon = globe.ico
; Executable = Geomod.exe
; CPU = 1
; EnableBuildCount = 2
; Watchlist = Campaign\Upkeep
; IncludeVersionInfo
; VersionField0 = 0,2,%BUILDCOUNT,0
; VersionField1 = 0,2,%BUILDCOUNT,0
; VersionField2 = Univers Total War
; VersionField3 = Geomod
; VersionField4 = 0.1.%BUILDCOUNT
; VersionField5 = 0.1.%BUILDCOUNT
; VersionField6 = Logiciel de modding pour M2TW
; VersionField7 = Geomod
; VersionField8 = %SOURCE
; VersionField9 = Octavius
; VersionField14 = www.universtotalwar.fr
; VersionField17 = 040c French (Standard)
; VersionField18 = Date de compilation
; VersionField19 = Licence
; VersionField21 = %dd/%mm/%yyyy
; VersionField22 = Logiciel libre