
Procedure.b SelectFaction(*Address)
  Protected i.b,String$
  
  If *Address
    
    ;Slection de la faction dans la liste chane
    ChangeCurrentElement(Factions(),*Address)
    
    ;Type spcial de la faction
    If Factions()\SpecialType$<>""
      DisableGadget(#SpecialType,0)
      SetGadgetState(#SpecialTypeText,1)
      SetGadgetText(#SpecialType,Factions()\SpecialType$)
    Else
      DisableGadget(#SpecialType,1)
      SetGadgetState(#SpecialTypeText,0)
      SetGadgetText(#SpecialType,"")
    EndIf
    
    ;Religion de la faction
    ForEach Religions()
      If Religions()\In$=Factions()\Religion\In$
        SetGadgetState(#FReligion,ListIndex(Religions()))
        Break
      EndIf
    Next
    
    ;Musique de la faction
    If Factions()\Music$=""
      SetGadgetState(#FMusic,-1)
    Else
      For i=0 To CountGadgetItems(#FMusic)-1
        If Factions()\Music$=GetGadgetItemText(#FMusic,i)
          SetGadgetState(#FMusic,i)
          Break
        EndIf
      Next i
    EndIf
    
    ;Couleurs de la faction
    SetGadgetState(#FPrimaryRed,Red(Factions()\Color1))
    SetGadgetState(#FPrimaryGreen,Green(Factions()\Color1))
    SetGadgetState(#FPrimaryBlue,Blue(Factions()\Color1))
    SetGadgetColor(#FPrimaryColor,#PB_Gadget_BackColor,Factions()\Color1)
    SetGadgetState(#FSecondaryRed,Red(Factions()\Color2))
    SetGadgetState(#FSecondaryGreen,Green(Factions()\Color2))
    SetGadgetState(#FSecondaryBlue,Blue(Factions()\Color2))
    SetGadgetColor(#FSecondaryColor,#PB_Gadget_BackColor,Factions()\Color2)
    
    ;Options de la faction
    SetGadgetState(#CustomBattle,Factions()\Custom)
    SetGadgetState(#NavalInvasion,Factions()\Naval)
    SetGadgetState(#HasPrincess,Factions()\Princess)
    If Factions()\Family=0
      SetGadgetState(#FamilyTree,0)
      SetGadgetState(#FamilyTreeNormal,0)
      SetGadgetState(#FamilyTreeTeutonic,0)
      DisableGadget(#FamilyTreeNormal,1)
      DisableGadget(#FamilyTreeTeutonic,1)
    ElseIf Factions()\Family=1
      SetGadgetState(#FamilyTree,1)
      SetGadgetState(#FamilyTreeNormal,1)
      DisableGadget(#FamilyTreeNormal,0)
      DisableGadget(#FamilyTreeTeutonic,0)
    ElseIf Factions()\Family=2
      SetGadgetState(#FamilyTree,1)
      SetGadgetState(#FamilyTreeTeutonic,1)
      DisableGadget(#FamilyTreeNormal,0)
      DisableGadget(#FamilyTreeTeutonic,0)
    EndIf
    
    ;Options avances (Kingdoms seulement)
    If Factions()\Plague>-1
      SetGadgetState(#CanDeath,1)
      DisableGadget(#CanDeathYes,0)
      DisableGadget(#CanDeathNo,0)
      If Factions()\Plague : SetGadgetState(#CanDeathYes,1) : Else : SetGadgetState(#CanDeathNo,1) : EndIf
    Else
      SetGadgetState(#CanDeath,0)
      DisableGadget(#CanDeathYes,1)
      DisableGadget(#CanDeathNo,1)
      SetGadgetState(#CanDeathYes,0)
      SetGadgetState(#CanDeathNo,0)
    EndIf
    If Factions()\Disband>-1
      SetGadgetState(#DisbandPool,1)
      DisableGadget(#DisbandPoolYes,0)
      DisableGadget(#DisbandPoolNo,0)
      If Factions()\Disband : SetGadgetState(#DisbandPoolYes,1) : Else : SetGadgetState(#DisbandPoolNo,1) : EndIf
    Else
      SetGadgetState(#DisbandPool,0)
      DisableGadget(#DisbandPoolYes,1)
      DisableGadget(#DisbandPoolNo,1)
      SetGadgetState(#DisbandPoolYes,0)
      SetGadgetState(#DisbandPoolNo,0)
    EndIf
    If Factions()\Tower>-1
      SetGadgetState(#BuildTower,1)
      DisableGadget(#BuildTowerYes,0)
      DisableGadget(#BuildTowerNo,0)
      If Factions()\Tower : SetGadgetState(#BuildTowerYes,1) : Else : SetGadgetState(#BuildTowerNo,1) : EndIf
    Else
      SetGadgetState(#BuildTower,0)
      DisableGadget(#BuildTowerYes,1)
      DisableGadget(#BuildTowerNo,1)
      SetGadgetState(#BuildTowerYes,0)
      SetGadgetState(#BuildTowerNo,0)
    EndIf
    
    ;Options de campagne
    SetGadgetState(#Playability,Factions()\Status\Playable)
    SetGadgetText(#LabelAI,Factions()\Status\LabelAI$)
    SetGadgetText(#EconomicAI,Factions()\Status\EconomicAI$)
    SetGadgetText(#MilitaryAI,Factions()\Status\MilitaryAI$)
    SetGadgetState(#Money,Factions()\Status\Money)
    SetGadgetState(#KingsPurse,Factions()\Status\KingsPurse)
    
    ;La faction est-elle mergente ou non ?
    SetGadgetState(#Emerging,0)
    If Factions()\Spawned$<>""
      For i=1 To 3
        If GetGadgetItemText(#Emerging,i)=Factions()\Spawned$
          SetGadgetState(#Emerging,i)
          Break
        EndIf
      Next i
    EndIf
    
    ;De quelle faction jumelle dpend-t-elle ?
    If GetGadgetState(#Emerging)>1
      ClearGadgetItemList(#EmergingSecondary) : i=0
      String$=Factions()\Shadow$
      ForEach Factions()
        If Factions()\Status\Playable>0
          If *Address<>@Factions()
            AddGadgetItem(#EmergingSecondary,i,Factions()\Name\Out$)
            SetGadgetItemData(#EmergingSecondary,i,@Factions())
            If Factions()\Name\In$=String$ : SetGadgetState(#EmergingSecondary,i) : EndIf
            i+1
          EndIf
        EndIf
      Next
      If CountGadgetItems(#EmergingSecondary)>10 : ResizeGadget(#EmergingSecondary,#PB_Ignore,#PB_Ignore,#PB_Ignore,200)
      Else : ResizeGadget(#EmergingSecondary,#PB_Ignore,#PB_Ignore,#PB_Ignore,20*CountGadgetItems(#EmergingSecondary)) : EndIf
      DisableGadget(#EmergingSecondary,0)
    Else
      ClearGadgetItemList(#EmergingSecondary)
      SetGadgetState(#EmergingSecondary,-1)
      DisableGadget(#EmergingSecondary,1)
    EndIf
    ChangeCurrentElement(Factions(),*Address)
    
    ;Autres options d'mergence
    SetGadgetState(#Reemergent,Factions()\Status\Reemergent)
    SetGadgetState(#Undiscovered,Factions()\Status\Undiscovered)
    
    DisableGadget(#UnselectFaction,0)
    DisableGadget(#CancelFaction,0)
    DisableGadget(#ValidateFaction,0)
    
  Else
    
    DisableGadget(#SpecialType,1)
    SetGadgetState(#SpecialTypeText,0)
    SetGadgetText(#SpecialType,"")
    SetGadgetState(#FReligion,-1)
    SetGadgetState(#FMusic,-1)
    SetGadgetState(#FPrimaryRed,0)
    SetGadgetState(#FPrimaryGreen,0)
    SetGadgetState(#FPrimaryBlue,0)
    SetGadgetColor(#FPrimaryColor,#PB_Gadget_BackColor,0)
    SetGadgetState(#FSecondaryRed,0)
    SetGadgetState(#FSecondaryGreen,0)
    SetGadgetState(#FSecondaryBlue,0)
    SetGadgetColor(#FSecondaryColor,#PB_Gadget_BackColor,0)
    SetGadgetState(#CustomBattle,0)
    SetGadgetState(#NavalInvasion,0)
    SetGadgetState(#HasPrincess,0)
    SetGadgetState(#FamilyTree,0)
    SetGadgetState(#FamilyTreeNormal,0)
    SetGadgetState(#FamilyTreeTeutonic,0)
    DisableGadget(#FamilyTreeNormal,1)
    DisableGadget(#FamilyTreeTeutonic,1)
    SetGadgetState(#CanDeath,0)
    SetGadgetState(#CanDeathYes,0) : DisableGadget(#CanDeathYes,1)
    SetGadgetState(#CanDeathNo,0) : DisableGadget(#CanDeathNo,1)
    SetGadgetState(#DisbandPool,0)
    SetGadgetState(#DisbandPoolYes,0) : DisableGadget(#DisbandPoolYes,1)
    SetGadgetState(#DisbandPoolNo,0) : DisableGadget(#DisbandPoolNo,1)
    SetGadgetState(#BuildTower,0)
    SetGadgetState(#BuildTowerYes,0) : DisableGadget(#BuildTowerYes,1)
    SetGadgetState(#BuildTowerNo,0) : DisableGadget(#BuildTowerNo,1)
    SetGadgetState(#Playability,-1)
    SetGadgetText(#LabelAI,"")
    SetGadgetText(#EconomicAI,"")
    SetGadgetText(#MilitaryAI,"")
    SetGadgetState(#Money,0) : SetGadgetText(#Money,"")
    SetGadgetState(#KingsPurse,0) : SetGadgetText(#KingsPurse,"")
    
    SetGadgetState(#ListFaction,-1)
    DisableGadget(#UnselectFaction,1)
    DisableGadget(#CancelFaction,1)
    DisableGadget(#ValidateFaction,1)
    
  EndIf
EndProcedure

Procedure.b UpdateFaction()
  Protected *Address
  
  If GetGadgetState(#ListFaction)=-1
    Error("Aucune faction n'est slectionne !")
    ProcedureReturn #False
  Else
    ChangeCurrentElement(Factions(),GetGadgetItemData(#ListFaction,GetGadgetState(#ListFaction)))
  EndIf
  
  ;Type spcial de la faction
  If GetGadgetState(#SpecialTypeText) : Factions()\SpecialType$=GetGadgetText(#SpecialType) : Else : Factions()\SpecialType$="" : EndIf
  
  ;Religion de la faction
  ChangeCurrentElement(Religions(),GetGadgetItemData(#FReligion,GetGadgetState(#FReligion)))
  Factions()\Religion\In$=Religions()\In$
  Factions()\Religion\Out$=Religions()\Out$
  
  ;Musique de la faction
  Factions()\Music$=GetGadgetText(#FMusic)
  
  ;Couleurs de la faction
  Factions()\Color1=GetGadgetColor(#FPrimaryColor,#PB_Gadget_BackColor)
  Factions()\Color2=GetGadgetColor(#FSecondaryColor,#PB_Gadget_BackColor)
  
  ;Options de la faction
  Factions()\Custom=GetGadgetState(#CustomBattle)
  Factions()\Naval=GetGadgetState(#NavalInvasion)
  Factions()\Princess=GetGadgetState(#HasPrincess)
  If GetGadgetState(#FamilyTree)
    If GetGadgetState(#FamilyTreeNormal)
      Factions()\Family=1
    Else
      Factions()\Family=2
    EndIf
  Else
    Factions()\Family=0
  EndIf
  
  ;Options avances (Kingdoms seulement)
  If GetGadgetState(#CanDeath) : If GetGadgetState(#CanDeathYes) : Factions()\Plague=1 : Else : Factions()\Plague=0 : EndIf : Else : Factions()\Plague=-1 : EndIf
  If GetGadgetState(#DisbandPool) : If GetGadgetState(#DisbandPoolYes) : Factions()\Disband=1 : Else : Factions()\Disband=0 : EndIf : Else : Factions()\Disband=-1 : EndIf
  If GetGadgetState(#BuildTower) : If GetGadgetState(#BuildTowerYes) : Factions()\Tower=1 : Else : Factions()\Tower=0 : EndIf : Else : Factions()\Tower=-1 : EndIf
  
  ;Options de campagne
  Factions()\Status\Playable=GetGadgetState(#Playability)
  Factions()\Status\LabelAI$=GetGadgetText(#LabelAI)
  Factions()\Status\EconomicAI$=GetGadgetText(#EconomicAI)
  Factions()\Status\MilitaryAI$=GetGadgetText(#MilitaryAI)
  Factions()\Status\Money=GetGadgetState(#Money)
  Factions()\Status\KingsPurse=GetGadgetState(#KingsPurse)
  
  MessageRequester("Information","Mise  jour effectue avec succs !")
  ProcedureReturn #True
  
EndProcedure

; IDE Options = PureBasic 4.10 (Windows - x86)
; CursorPosition = 155
; FirstLine = 152
; Folding = 0